package com.chenyang.nse.bussiness.controller.core.dataproject;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.vo.TUserProjReqVO;
import com.chenyang.nse.bussiness.service.core.FirstPageDataService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/firstpage"})
public class FirstPageController {
   @Autowired
   private FirstPageDataService firstPageDataService;

   @ResponseBody
   @PostMapping({"/save"})
   public void save(@RequestBody Map<String, String> map, HttpServletRequest request, HttpServletResponse response, Model model) {
      String projectid = (String)map.get("projectid");
      this.firstPageDataService.save(projectid);
   }

   @ResponseBody
   @RequestMapping({"/queryBlood"})
   public Response<Map<String, Object>> queryBlood2(@RequestBody TUserProjReqVO vo) {
      this.firstPageDataService.save(vo.getProjectid());
      Map<String, Object> retMap = this.firstPageDataService.queryBlood(vo.getProjectid());
      return RespHelper.<Map<String, Object>>successResp(retMap);
   }

   @ResponseBody
   @RequestMapping({"/queryFirst"})
   public Map<String, Object> queryFirst(HttpServletRequest request, HttpServletResponse response, Model model) {
      Map<String, Object> retMap = this.firstPageDataService.queryFirst();
      return retMap;
   }

   @ResponseBody
   @RequestMapping({"/queryBlood2"})
   public Response<Map<String, Object>> queryBlood2(@RequestBody Map<String, String> map) {
      String projectid = (String)map.get("projectid");
      String datasystemid = (String)map.get("datasystemid");
      String schemaname = (String)map.get("schemaname");
      String tablename = (String)map.get("tablename");
      Map<String, Object> retMap = this.firstPageDataService.queryBlood2(projectid, datasystemid, schemaname, tablename);
      return RespHelper.<Map<String, Object>>successResp(retMap);
   }

   @ResponseBody
   @RequestMapping({"/queryBlood3"})
   public Map<String, Object> queryBlood3(String duty_id, HttpServletRequest request, HttpServletResponse response, Model model) {
      Map<String, Object> retMap = this.firstPageDataService.queryBlood3(duty_id);
      return retMap;
   }

   @ResponseBody
   @RequestMapping({"/queryBlood4"})
   public Map<String, Object> queryBlood4(String group_id, HttpServletRequest request, HttpServletResponse response, Model model) {
      Map<String, Object> retMap = this.firstPageDataService.queryBlood4(group_id);
      return retMap;
   }
}
