package com.chenyang.nse.bussiness.controller.webApi;

import com.chenyang.nse.bussiness.annot.PassToken;
import com.chenyang.nse.bussiness.ccoresdf.CcoreSDFUtil;
import com.chenyang.nse.bussiness.entity.webApi.ApiCode;
import com.chenyang.nse.bussiness.entity.webApi.DataParams;
import com.chenyang.nse.bussiness.entity.webApi.DataParamsList;
import com.chenyang.nse.bussiness.entity.webApi.Msg;
import com.chenyang.nse.bussiness.service.webApi.WebApiService;
import com.chenyang.nse.bussiness.service.webApi.business.SecretKeyCache;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import java.util.List;
import java.util.Map;
import org.apache.shiro.codec.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/data/api"})
public class ApiController {
   private static final Logger LOGGER = LoggerFactory.getLogger(ApiController.class);
   @Autowired
   private WebApiService service;

   @PassToken
   @RequestMapping(
      value = {"/enc"},
      method = {RequestMethod.POST},
      produces = {"application/json;charset=utf-8"}
   )
   @ResponseBody
   public Msg enc(@RequestBody DataParamsList data) {
      List<DataParams> configs = data.getConfigs();
      if (configs != null && configs.size() != 0) {
         try {
            return this.service.enc(data);
         } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return Msg.error(ApiCode.other, e.getMessage());
         }
      } else {
         return Msg.succed(configs);
      }
   }

   @PassToken
   @RequestMapping(
      value = {"/dec"},
      method = {RequestMethod.POST},
      produces = {"application/json;charset=utf-8"}
   )
   @ResponseBody
   public Msg dec(@RequestBody DataParamsList data) {
      List<DataParams> configs = data.getConfigs();
      if (configs != null && configs.size() != 0) {
         try {
            return this.service.dec(data);
         } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return Msg.error(ApiCode.other, e.getMessage());
         }
      } else {
         return Msg.succed(configs);
      }
   }

   @PassToken
   @RequestMapping(
      value = {"/remote/invoke"},
      method = {RequestMethod.POST},
      produces = {"application/json;charset=utf-8"}
   )
   @ResponseBody
   public String remoteEncDecInvoke(@RequestBody Map<String, String> params) {
      String api = (String)params.get("api");
      String key = (String)params.get("key");
      String content = (String)params.get("content");
      String isLike = (String)params.get("isLike");
      String type = (String)params.get("type");
      String project = (String)params.get("project");
      String mode = (String)params.get("mode");
      String fid = (String)params.get("fid");
      String keepfirst = (String)params.get("keepfirst");
      String encdigit = (String)params.get("encdigit");
      String twoindex = (String)params.get("twoindex");
      if (api != null && api.length() != 0) {
         if (key != null && key.length() != 0) {
            if (content != null && content.length() != 0) {
               if (type != null && type.length() != 0) {
                  if (mode != null && mode.equalsIgnoreCase("CCORESDF")) {
                     if (project == null || project.length() == 0 || fid == null || fid.length() == 0) {
                        return "{{ERR:加密卡加密解密缺少参数project|fid";
                     }

                     key = SecretKeyCache.instance().getPKey(project, fid);
                  }

                  try {
                     if (api.equals("enc")) {
                        return EncProvider.encryptEcb(type, key, content, isLike, keepfirst, encdigit, twoindex);
                     } else {
                        return EncProvider.decryptEcb(type, key, content, isLike, keepfirst, encdigit, twoindex);
                     }
                  } catch (Exception exception) {
                     return "{{ERR:远程调用执行错误," + exception.toString();
                  }
               } else {
                  return "{{ERR:远程调用参数type为空";
               }
            } else {
               return content;
            }
         } else {
            return "{{ERR:远程调用参数key为空";
         }
      } else {
         return "{{ERR:远程调用参数api为空";
      }
   }

   @PassToken
   @RequestMapping(
      value = {"/remote/queryCcoreSDFKey"},
      method = {RequestMethod.POST},
      produces = {"application/json;charset=utf-8"}
   )
   @ResponseBody
   public String queryCcoreSDFKey(@RequestBody Map<String, String> params) {
      String key = (String)params.get("key");
      if (key != null && key.length() != 0) {
         try {
            if (null != key && !"".equals(key)) {
               try {
                  byte[] endData = Hex.decode(key);
                  return CcoreSDFUtil.getDecrypt(endData);
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }

            return "{{ERR:远程调用执行错误,没有解密失败";
         } catch (Exception exception) {
            return "{{ERR:远程调用执行错误," + exception.toString();
         }
      } else {
         return "{{ERR:远程调用参数key为空";
      }
   }
}
