package com.chenyang.nse.bussiness.dao.core;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreFieldSensitive;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreScopeField;
import com.chenyang.nse.bussiness.entity.vo.api.DiscoverApiDirectoryVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.DataScopeVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class DataScopeDao extends BaseDao<Object, String> {
   public List<DataScopeVO> getDataScopeGroup(String edition_id) {
      String sql = XmlTool.getSql("datascope", "dataScopeGroup");
      List<DataScopeVO> vo = this.getSession().createNativeQuery(sql).setParameter("edition_id", edition_id).setResultTransformer(Transformers.aliasToBean(DataScopeVO.class)).getResultList();
      return vo;
   }

   public List<DiscoverApiDirectoryVO> getDataScopeDirectory(String edition_id) {
      String sql = XmlTool.getSql("datascope", "dataScopeDirectory");
      List<DiscoverApiDirectoryVO> vo = this.getSession().createNativeQuery(sql).setParameter("edition_id", edition_id).setResultTransformer(Transformers.aliasToBean(DiscoverApiDirectoryVO.class)).getResultList();
      return vo;
   }

   public List<DataScopeVO> getDataScopeGroupSearch(String editionid, String val, String searchval) {
      String sql = "SELECT id,scope_id as id,scope_name as text,fa_tid,edition_id,scope_level,scope_according,level_principle,create_user,create_date,note FROM t_core_data_scope WHERE edition_id = '" + editionid + "' and " + val + " like '" + searchval + "'";
      List<DataScopeVO> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(DataScopeVO.class)).getResultList();
      return vo;
   }

   public int insertAddFa(DataScopeVO scope) {
      String sql = XmlTool.getSql("datascope", "addfa");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("note", scope.getNote()).setParameter("edition_id", scope.getEdition_id()).setParameter("create_user", scope.getCreate_user()).executeUpdate();
      return i;
   }

   public List<DataScopeVO> ishavebro(DataScopeVO scope) {
      String sql = XmlTool.getSql("datascope", "ishavebro");
      List<DataScopeVO> vo = this.getSession().createNativeQuery(sql).setParameter("fa_tid", scope.getFa_tid()).setParameter("edition_id", scope.getEdition_id()).setResultTransformer(Transformers.aliasToBean(DataScopeVO.class)).getResultList();
      return vo;
   }

   public int havebro(DataScopeVO scope) {
      String sql = XmlTool.getSql("datascope", "havebro");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("fa_tid", scope.getFa_tid()).setParameter("note", scope.getNote()).setParameter("edition_id", scope.getEdition_id()).setParameter("create_user", scope.getCreate_user()).executeUpdate();
      return i;
   }

   public int nothavebro(DataScopeVO scope) {
      String sql = XmlTool.getSql("datascope", "nothavebro");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("fa_tid", scope.getFa_tid()).setParameter("note", scope.getNote()).setParameter("edition_id", scope.getEdition_id()).setParameter("create_user", scope.getCreate_user()).executeUpdate();
      return i;
   }

   public int updateScope(DataScopeVO scope) {
      String sql = XmlTool.getSql("datascope", "updatescope");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("note", scope.getNote()).setParameter("edition_id", scope.getEdition_id()).setParameter("create_user", scope.getCreate_user()).executeUpdate();
      return i;
   }

   public int delselfandson(String scope_id, String edition_id) {
      String sql = XmlTool.getSql("datascope", "delselfandson");
      int i = this.getSession().createNativeQuery(sql).setParameter("scope_id", scope_id).setParameter("edition_id", edition_id).executeUpdate();
      return i;
   }

   public List<DataScopeVO> findbroandhisson(String scope_id, String fa_id, String edition_id) {
      String sql = XmlTool.getSql("datascope", "findbroandhisson");
      List<DataScopeVO> vo = this.getSession().createNativeQuery(sql).setParameter("fa_id", fa_id).setParameter("scope_id", scope_id).setParameter("edition_id", edition_id).setResultTransformer(Transformers.aliasToBean(DataScopeVO.class)).getResultList();
      return vo;
   }

   public int updatebro(String id) {
      String sql = XmlTool.getSql("datascope", "updatebro");
      return this.getSession().createNativeQuery(sql).setParameter("id", id).executeUpdate();
   }

   public int updatebroson(String id, String del_id) {
      String sql = XmlTool.getSql("datascope", "updatebroson");
      int i = this.getSession().createNativeQuery(sql).setParameter("id", id).setParameter("del_id", del_id).executeUpdate();
      return i;
   }

   public int insertAddZero(DataScopeVO scope) {
      String sql = XmlTool.getSql("datascope", "addzero");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("note", scope.getNote()).setParameter("edition_id", scope.getEdition_id()).setParameter("create_user", scope.getCreate_user()).executeUpdate();
      return i;
   }

   public List<Map<String, Object>> selectDataScopeCount(String id, String edition_id) {
      String sql = "SELECT COUNT(b.id) AS s FROM t_pro_edition_scope a, t_core_data_scope b WHERE a.id = b.edition_id AND b.edition_id = '" + edition_id + "' ";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT COUNT(b.id) AS \"s\" FROM t_pro_edition_scope a, t_core_data_scope b WHERE a.id = b.edition_id AND b.edition_id = '" + edition_id + "' ";
      }

      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public int delRelation(DataScopeVO scope) {
      String sql = "DELETE FROM t_type_datafield_relation WHERE id = :id";
      int i = this.getSession().createNativeQuery(sql).setParameter("id", scope.getTid()).executeUpdate();
      return i;
   }

   public int insertRelation(DataScopeVO scope, String rule) {
      String sql = XmlTool.getSql("datascope", "addrelation");
      int i = this.getSession().createNativeQuery(sql).setParameter("id", scope.getTid()).setParameter("edition_id", scope.getEdition_id()).setParameter("rule", rule).setParameter("type", 1).executeUpdate();
      return i;
   }

   public List<Map<String, String>> selectRelation(String id) {
      String sql = "SELECT rule FROM t_type_datafield_relation t  WHERE  t.id = '" + id + "'";
      List<Map<String, String>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<Map<String, String>> selectRelationType(String editionid, String rule, String type) {
      String sql = "SELECT id FROM t_type_datafield_relation t  WHERE  t.edition_id = '" + editionid + "' and rule = '" + rule + "' and type = '" + type + "'";
      List<Map<String, String>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<Map<String, String>> selectRelationGrade(String type, String id, String editionid) {
      String sql = "SELECT rule FROM t_type_datafield_relation t  WHERE  type = '" + type + "' and edition_id = '" + editionid + "' and  id != '" + id + "'";
      List<Map<String, String>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<Map<String, String>> getScopelist(String editionid, String rule) {
      String sql = "select id from t_type_datafield_relation where edition_id = '" + editionid + "' and rule = '" + rule + "' and type = '1'";
      List<Map<String, String>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<Map<String, String>> getScopelevellist(String editionid, String rule) {
      String sql = "select id from t_type_datafield_relation where edition_id = '" + editionid + "' and rule = '" + rule + "' and type = '3'";
      List<Map<String, String>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public Map<String, String> queryScopeById(String id) {
      String sql = "select id,fa_tid,scope_name,edition_id from t_core_data_scope where id = '" + id + "'";
      Map<String, String> vo = (Map)this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList().get(0);
      return vo;
   }

   public Map<String, String> queryScopeByfaid(String id, String editionid) {
      String sql = "select id,fa_tid,scope_name,edition_id from t_core_data_scope where id = '" + id + "' and edition_id = '" + editionid + "'";
      List resultList = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      Map<String, String> vo = (Map<String, String>)(resultList.size() > 0 ? (Map)resultList.get(0) : new HashMap());
      return vo;
   }

   public Map<String, String> queryScopelevelById(String id) {
      Map<String, String> vo = new HashMap();
      String sql = "select sensitive_name from t_core_sensitive_level where id = '" + id + "'";
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      if (vo.size() > 0) {
         vo = (Map)list.get(0);
      }

      return vo;
   }

   public List<TCoreScopeField> queryScopeById(String projectid, String datasystemid, String editionid) {
      String sql = "select scope_id,tablefield_id,datasystem_id,names,tschemas,columnsize,combination_id,edition_id,remarks,typename,projectid from t_core_scope_field where projectid = '" + projectid + "' and datasystem_id = '" + datasystemid + "' and edition_id = '" + editionid + "'";
      List<TCoreScopeField> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreScopeField.class)).getResultList();
      return vo;
   }

   public List<TCoreFieldSensitive> queryScopeLevelById(String projectid, String datasystemid, String editionid) {
      String sql = "select tablefield_id,datasystem_id,names,tschemas,scope_id,columnsize,combination_id,edition_id,remarks,typename,projectid from t_core_field_sensitive where projectid = '" + projectid + "' and datasystem_id = '" + datasystemid + "' and edition_id = '" + editionid + "'";
      List<TCoreFieldSensitive> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreFieldSensitive.class)).getResultList();
      return vo;
   }

   public List<TCoreScopeField> queryScopeBySchema(String datasystemid, String schema) {
      String sql = "select scope_id,tablefield_id,datasystem_id,names,tschemas,columnsize,combination_id,edition_id,remarks,typename,projectid from t_core_scope_field where  datasystem_id = '" + datasystemid + "' and tschemas = '" + schema + "'";
      List<TCoreScopeField> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreScopeField.class)).getResultList();
      return vo;
   }

   public List<TCoreFieldSensitive> querySensitiveLevelBySchema(String datasystemid, String schema) {
      String sql = "select tablefield_id,datasystem_id,names,tschemas,scope_id,columnsize,combination_id,edition_id,remarks,typename,projectid from t_core_field_sensitive where datasystem_id = '" + datasystemid + "' and tschemas = '" + schema + "'";
      List<TCoreFieldSensitive> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreFieldSensitive.class)).getResultList();
      return vo;
   }
}
