package com.chenyang.nse.bussiness.dao.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.custom.CustomColumnMapping;
import com.chenyang.nse.bussiness.entity.orm.custom.CustomTableMapping;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivecolumn;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class MaskingTaskDao extends BaseDao<Object, String> {
   public List<CustomTableMapping> queryTableMapping(String id, String flag) {
      List<CustomTableMapping> list = null;
      if (!"".equals(flag) && flag != null) {
         String sql = XmlTool.getSql("desensitize", "queryTableMapping", "flag");
         list = this.getSession().createNativeQuery(sql).setParameter("id", id).setParameter("flag", flag).setResultTransformer(Transformers.aliasToBean(CustomTableMapping.class)).getResultList();
      } else {
         String sql = XmlTool.getSql("desensitize", "queryTableMapping");
         list = this.getSession().createNativeQuery(sql).setParameter("id", id).setResultTransformer(Transformers.aliasToBean(CustomTableMapping.class)).getResultList();
      }

      return list;
   }

   public List<TCoreSensitivecolumn> querySensitiveColumnsByGroupId(String groupId) {
      List<TCoreSensitivecolumn> list = null;
      String sql = XmlTool.getSql("desensitize", "querySensitiveColumnsByGroupId");
      list = this.getSession().createNativeQuery(sql).setParameter("groupid", groupId).setResultTransformer(Transformers.aliasToBean(CustomTableMapping.class)).getResultList();
      return list;
   }

   public List<CustomColumnMapping> queryColumnMappingByTableMappingId(String mappingid) {
      List<CustomColumnMapping> list = null;
      String sql = XmlTool.getSql("desensitize", "queryColumnMappingByTableMappingId");
      list = this.getSession().createNativeQuery(sql).setParameter("mappingid", mappingid).setResultTransformer(Transformers.aliasToBean(CustomColumnMapping.class)).getResultList();
      return list;
   }
}
