package com.chenyang.nse.bussiness.dao.table.base;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseAppUser;
import com.chenyang.nse.bussiness.entity.orm.table.core.ProxyJarFields;
import com.chenyang.nse.bussiness.entity.orm.table.core.TEncryptionProxyHost;
import com.chenyang.nse.bussiness.jar.db.TCoreClientInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class TBaseAppUserDao extends BaseDao<TBaseAppUser, String> {
   public TBaseAppUser queryByuseridentifier(String useridentifier) {
      Criterion cuseridentifier = Restrictions.eq("useridentifier", useridentifier);
      return (TBaseAppUser)this.queryUnique(new Criterion[]{cuseridentifier});
   }

   public TBaseAppUser queryByappusername(String username) {
      Criterion cusername = Restrictions.eq("username", username);
      return (TBaseAppUser)this.queryUnique(new Criterion[]{cusername});
   }

   public Integer queryGlobalOriginalStatus(String projectId) {
      StringBuilder sql = new StringBuilder();
      sql.append("SELECT global_original_status FROM t_global_encryption_original_config where project_id = '" + projectId + "'");
      List<Integer> resultList = this.getSession().createNativeQuery(sql.toString()).getResultList();
      return (Integer)resultList.get(0);
   }

   public List<String> queryProxyUrlPrefixByProjectId(String projectId) {
      StringBuilder sql = new StringBuilder();
      sql.append("SELECT host_url FROM t_encryption_proxy_host where project_id = '" + projectId + "'");
      List<String> resultList = this.getSession().createNativeQuery(sql.toString()).getResultList();
      return resultList;
   }

   public List<TEncryptionProxyHost> getProxyHosts(String projectId, String url) {
      StringBuilder sql = new StringBuilder();
      sql.append("SELECT id,host_url,project_id FROM t_encryption_proxy_host where project_id = '" + projectId + "' and host_url = '" + url + "'");
      List<TEncryptionProxyHost> resultList = this.getSession().createNativeQuery(sql.toString(), TEncryptionProxyHost.class).getResultList();
      return resultList;
   }

   public List<ProxyJarFields> getProxyJarInfo(String projectId, String appUrl, String appPort) {
      List<ProxyJarFields> result = null;
      StringBuilder sql = new StringBuilder();
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql.append("SELECT id as \"id\",gateway_url as \"gateway_url\",gateway_port as \"gateway_port\",app_url as \"app_url\",app_port as \"app_port\",project_id as \"project_id\",app_project_name as \"app_project_name\" FROM t_core_proxy_jar_info where project_id = '" + projectId + "' ");
      } else {
         sql.append("SELECT id,gateway_url,gateway_port,app_url,app_port,project_id,app_project_name FROM t_core_proxy_jar_info where project_id = '" + projectId + "' ");
      }

      if (StringUtils.isNotEmpty(appUrl)) {
         sql.append("and app_url = '" + appUrl + "' ");
      }

      if (StringUtils.isNotEmpty(appPort)) {
         sql.append("and app_port = '" + appPort + "' ");
      }

      try {
         result = this.getSession().createNativeQuery(sql.toString(), ProxyJarFields.class).getResultList();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return result;
   }

   public Integer saveProxyHosts(String projectId, String proxyHostUrl) {
      TEncryptionProxyHost host = new TEncryptionProxyHost();
      host.setHost_url(proxyHostUrl);
      host.setProject_id(projectId);
      this.getSession().save(host);
      return host.getId();
   }

   public void saveProxyJarInfo(String appUrl, String appPort, String gatewayUrl, String gatewayPort, String projectid, String appProjectName) {
      ProxyJarFields proxyJarInfo = null;
      List<ProxyJarFields> proxyJarInfos = this.getProxyJarInfo(projectid, appUrl, appPort);
      if (proxyJarInfos != null && proxyJarInfos.size() > 0) {
         proxyJarInfo = (ProxyJarFields)proxyJarInfos.get(0);
         this.getSession().delete(proxyJarInfo);
      }

      proxyJarInfo = new ProxyJarFields();

      try {
         proxyJarInfo.setApp_url(appUrl);
         proxyJarInfo.setApp_port(Integer.parseInt(appPort));
      } catch (Exception var10) {
      }

      proxyJarInfo.setGateway_url(gatewayUrl);
      proxyJarInfo.setGateway_port(Integer.parseInt(gatewayPort));
      proxyJarInfo.setProject_id(projectid);
      proxyJarInfo.setApp_project_name(appProjectName);
      this.getSession().save(proxyJarInfo);
   }

   public void deleteProxyJarInfosBatchByProjectId(String projectId) {
      String deleteSQL = "delete from ProxyJarFields where project_id = :projectId";
      this.getSession().createQuery(deleteSQL).setParameter("projectId", projectId).executeUpdate();
   }

   public void updateProxyHosts(TEncryptionProxyHost host) {
      this.getSession().saveOrUpdate(host);
   }

   public void changeGlobalOriginalStatus(Integer status, String projectId) {
      TGlobalEncryptionOriginalConfig vo = new TGlobalEncryptionOriginalConfig();
      vo.setProject_id(projectId);
      vo.setGlobal_original_status(status);
      this.getSession().saveOrUpdate(vo);
   }

   public TCoreClientInfo queryJarClients(String ip, int port) {
      new ArrayList();

      try {
         StringBuilder sql = new StringBuilder();
         sql.append("SELECT client_ip as clientIp,client_port as clientPort,client_status as clientStatus,is_controlled as isControlled,project_id as projecid,last_opt_time as lastOptTime FROM T_CORE_CLIENT_INFO where client_ip = '" + ip + "' and client_port = " + port);
         List<TCoreClientInfo> resultList = this.getSession().createNativeQuery(sql.toString()).getResultList();
         if (resultList != null) {
            return (TCoreClientInfo)resultList.get(0);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return null;
   }
}
