package com.chenyang.nse.bussiness.dao.table.base;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseGroup;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StringType;
import org.springframework.stereotype.Repository;

@Repository
public class TBaseGroupDao extends BaseDao<TBaseGroup, String> {
   public List<TBaseGroup> queryGroupsByUserId(String userId) {
      String sql = "select u.id as id ,u.groupname from  t_base_group u left join t_base_usergroup r on u.id = r.groupid where u.id!=1 and r.userid = :userId order by u.createtime desc ";
      return this.getSession().createNativeQuery(sql).setParameter("userId", userId, StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(TBaseGroup.class)).getResultList();
   }

   public List<TBaseGroup> queryGroupsByUserIdAll(String userId) {
      String sql = "select u.id as id ,u.groupname from  t_base_group u left join t_base_usergroup r on u.id = r.groupid where 1=1 and r.userid = :userId order by u.createtime desc ";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select u.id as \"id\",u.groupname as \"groupname\" from  t_base_group u left join t_base_usergroup r on u.id = r.groupid where 1=1 and r.userid = :userId order by u.createtime desc ";
      }

      return this.getSession().createNativeQuery(sql).setParameter("userId", userId).setResultTransformer(Transformers.aliasToBean(TBaseGroup.class)).getResultList();
   }
}
