package com.chenyang.nse.bussiness.dao.table.base;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsergroup;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class TBaseUsergroupDao extends BaseDao<TBaseUsergroup, String> {
   public List<String> queryUserIdListByGroupId(String groupid) {
      String hql = "select userid from TBaseUsergroup where groupid=:groupid";
      List<String> idlist = this.getSession().createQuery(hql).setParameter("groupid", groupid).getResultList();
      return idlist;
   }

   public void removeUserGroupByUserId(String userid) {
      Criterion cuserid = Restrictions.eq("userid", userid);
      this.remove(new Criterion[]{cuserid});
   }

   @Transactional
   @Modifying
   @Query
   public void removeUsergroup(String userId) {
      String sql = "delete from t_base_usergroup  where userid = :userId";
      this.getSession().createNativeQuery(sql).executeUpdate();
   }
}
