package com.chenyang.nse.bussiness.dao.table.console;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionarytype;
import com.chenyang.nse.bussiness.entity.vo.RegexTypeColorVO;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TConsoleDictionaryDao extends BaseDao<TConsoleDictionary, String> {
   public List<String> queryValueByTypeCode(String... typecode) {
      String sql = "select value from T_CONSOLE_DICTIONARY where typecode in :typecode order by value";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select `value` as \"value\" from T_CONSOLE_DICTIONARY where typecode in :typecode order by `value`";
      }

      List<String> list = this.getSession().createNativeQuery(sql).setParameterList("typecode", typecode).getResultList();
      return list;
   }

   public List<RegexTypeColorVO> queryAllRegexTypeColor() {
      String sql = "select t1.value as regexType, t2.value as color from t_console_dictionary t1, t_console_dictionary t2 where t1.id=t2.parentid and t1.typecode='6' order by t1.value";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(RegexTypeColorVO.class)).getResultList();
   }

   public List<String> queryAllRegexTypes() {
      String sql = "select t.value from t_console_dictionary t where t.typecode='6' and t.parentid is null order by t.value";
      return this.getSession().createNativeQuery(sql).getResultList();
   }

   public List<TConsoleDictionary> querySensitiveTypes() {
      String sql = "SELECT t1.* FROM t_console_dictionary t1 LEFT JOIN t_console_sort t2 ON t2.id = t1.id AND t2.FLAG = '6' WHERE t1.TYPECODE = '6' AND t1.PARENTID IS NULL ORDER BY t2.SORTNUM";
      return this.getSession().createNativeQuery(sql, TConsoleDictionary.class).getResultList();
   }

   public List<String> querySensitiveTypeNames() {
      String sql = "SELECT t1.value FROM t_console_dictionary t1 LEFT JOIN t_console_sort t2 ON t2.id = t1.id AND t2.FLAG = '6' WHERE t1.TYPECODE = '6' AND t1.PARENTID IS NULL ORDER BY t2.SORTNUM";
      return this.getSession().createNativeQuery(sql).getResultList();
   }

   public List<TConsoleDictionary> queryALLDictionary(PageInfo pageInfo) {
      pageInfo.setCount(this.count());
      String sql = "select t1.typename, t2.id as id, t2.typecode, t2.value, t2.name, t2.parentid, t3.value as parentvalue from t_console_dictionarytype t1, t_console_dictionary t2 left join t_console_dictionary t3 on t2.parentid=t3.id where t1.typecode=t2.typecode order by t2.typecode, t2.value";
      return this.getSession().createNativeQuery(sql).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.aliasToBean(TConsoleDictionary.class)).getResultList();
   }

   public List<TConsoleDictionary> queryALLDictionary(String fuzzySearch, String typecode, PageInfo pageInfo) {
      pageInfo.setCount(this.count(new Criterion[]{Restrictions.eq("typecode", typecode)}));
      String like_sql = "";
      if (fuzzySearch != null && !"".equals(fuzzySearch)) {
         like_sql = " and t2.value like '%" + fuzzySearch + "%'";
      }

      String sql = "select t1.typename, t2.id as id, t2.typecode, t2.value, t2.name, t2.parentid, t3.value as parentvalue from t_console_dictionarytype t1, t_console_dictionary t2 left join t_console_dictionary t3 on t2.parentid=t3.id where t1.typecode=t2.typecode and t1.typecode=:typecode " + like_sql + " order by t2.typecode, t2.value";
      return this.getSession().createNativeQuery(sql).setParameter("typecode", typecode).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.aliasToBean(TConsoleDictionary.class)).getResultList();
   }

   public List<TConsoleDictionary> queryALLDictionaryLike(String value, PageInfo pageInfo) {
      pageInfo.setCount(this.count(new Criterion[]{Restrictions.like("value", "%" + value + "%")}));
      String sql = "select t1.typename, t2.id as id, t2.typecode, t2.value, t2.name, t2.parentid, t3.value as parentvalue from t_console_dictionarytype t1, t_console_dictionary t2 left join t_console_dictionary t3 on t2.parentid=t3.id where t1.typecode=t2.typecode and t2.value like :value order by t2.typecode, t2.value";
      return this.getSession().createNativeQuery(sql).setParameter("value", "%" + value + "%").setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.aliasToBean(TConsoleDictionary.class)).getResultList();
   }

   public List<TConsoleDictionary> queryDictionaryLike(String typecode, String value, PageInfo pageInfo) {
      pageInfo.setCount(this.count(new Criterion[]{Restrictions.eq("typecode", typecode), Restrictions.like("value", "%" + value + "%")}));
      String sql = "select t1.typename, t2.id as id, t2.typecode, t2.value, t2.name, t2.parentid, t3.value as parentvalue from t_console_dictionarytype t1, t_console_dictionary t2 left join t_console_dictionary t3 on t2.parentid=t3.id where t1.typecode=t2.typecode and t1.typecode=:typecode and t2.value like :value order by t2.typecode, t2.value";
      return this.getSession().createNativeQuery(sql).setParameter("typecode", typecode).setParameter("value", "%" + value + "%").setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.aliasToBean(TConsoleDictionary.class)).getResultList();
   }

   public List<TConsoleDictionary> queryoneDictionary(String rowid, String typecode) {
      String sql = "select t1.typename,t2.id as id,t2.typecode,t2.value,t2.name from t_console_dictionarytype t1, t_console_dictionary t2 where t1.typecode=t2.typecode and t2.id='" + rowid + "' and t2.typecode='" + typecode + "'";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TConsoleDictionary.class)).getResultList();
   }

   public List<TConsoleDictionary> queryDictionaryFile(String typecode) {
      String sql = null;
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
         sql = "SELECT t1.typename,t1.typecode,t2.`name`,t2.`value`,t2.parentid from t_console_dictionarytype t1,t_console_dictionary t2 WHERE t1.typecode=t2.typecode AND t1.typecode='" + typecode + "'";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
         sql = "SELECT t1.typename,t1.typecode,t2.name,t2.value,t2.parentid from t_console_dictionarytype t1,t_console_dictionary t2 WHERE t1.typecode=t2.typecode AND t1.typecode='" + typecode + "'";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "SELECT t1.typename,t1.typecode,t2.name,t2.value,t2.parentid from t_console_dictionarytype t1,t_console_dictionary t2 WHERE t1.typecode=t2.typecode AND t1.typecode='" + typecode + "'";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT t1.typename as \"typename\",t1.typecode as \"typecode\",t2.name as \"name\",t2.`value` as \"value\",t2.parentid as \"parentid\" from t_console_dictionarytype t1,t_console_dictionary t2 WHERE t1.typecode=t2.typecode AND t1.typecode='" + typecode + "'";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TConsoleDictionary.class)).getResultList();
   }

   public void savetCoreDicField(StringBuilder sql) {
      System.out.println(sql.toString());
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public int deleteByTypecode(String typecode) {
      String sql = "delete from t_console_dictionary where typecode = '" + typecode + "'";
      return this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public List<TConsoleDictionarytype> queryBycode(String typecode) {
      String sql = "SELECT typename from t_console_dictionarytype WHERE typecode='" + typecode + "'";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TConsoleDictionarytype.class)).getResultList();
   }

   public List<Long> queryCountBytype(String typecode, String value) {
      String sql = "SELECT count(*)  from t_console_dictionary WHERE typecode='" + typecode + "' and `value` like '%" + value + "%'";
      return this.getSession().createNativeQuery(sql).getResultList();
   }

   public List<TConsoleDictionary> queryBypage(PageInfo pageInfo, String typecode, String value) {
      String sql = "SELECT id as \"id\",flag as \"flag\",note as \"note\",name as \"name\",parentid as \"parentid\", typecode as \"typecode\", `value` as \"value\",createtime as \"createtime\", updatetime as \"updatetime\", createuser as \"createuser\", updateuser as \"updateuser\", remark as \"remark\", parentvalue as \"parentvalue\", typename as \"typename\" from t_console_dictionary WHERE typecode='" + typecode + "' and `value` like '%" + value + "%' order by createtime desc";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TConsoleDictionary.class)).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).getResultList();
   }
}
