package com.chenyang.nse.bussiness.dao.table.console;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSystemSetting;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TConsoleSystemSettingDao extends BaseDao<TConsoleSystemSetting, String> {
   public List<Map<String, Object>> querySystemSetting(PageInfo pageInfo) {
      String sql = XmlTool.getSql("systemsetting", "querySystemSetting");
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).getResultList();
      return list;
   }

   public List<TConsoleSystemSetting> queryAll() {
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         String sql = " SELECT id as \"id\",`value` as \"value\" ,\tupdatetime as \"updatetime\",\tflag as \"flag\",note as \"note\",\tsysdesc as \"sysdesc\",createtime as \"createtime\",  \tcreateuser as \"createuser\",updateuser as \"updateuser\"         FROM T_CONSOLE_SYSTEMSETTING";
         List<TConsoleSystemSetting> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TConsoleSystemSetting.class)).getResultList();
         return list;
      } else {
         return super.queryAll();
      }
   }

   public String getPathValueByName(String parametername) {
      String sql = XmlTool.getSql("systemsetting", "getPathValueByName");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("parametername", parametername).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return (String)((Map)list.get(0)).get("propertyvalue");
   }
}
