package com.chenyang.nse.bussiness.dao.table.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreComplianceDirectory;
import com.chenyang.nse.bussiness.entity.vo.datascope.ReportCheckboxVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreComplianceDirectoryDao extends BaseDao<TCoreComplianceDirectory, String> {
   public List<Map<String, Object>> getDatacount() {
      String sql = "select directory_id, count(0) as count FROM t_core_field_directory AS a, t_core_table_field AS b WHERE\tb.id = a.tablefield_id   GROUP BY a.directory_id";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public long getDatacountByproject(String table) {
      String sql = " select  count(0) as count FROM t_core_field_directory AS a, (select a.id from t_core_table_field as a," + table + " as b where a.tschemas = b.tschema and a.names = b.tablename and a.fields = b.columnname ) AS b WHERE\tb.id = a.tablefield_id   ";
      BigInteger count = (BigInteger)this.getSession().createNativeQuery(sql).uniqueResult();
      return count.longValue();
   }

   public List<ReportCheckboxVO> queryComplianceDirectoryList() {
      String sql = XmlTool.getSql("datascope", "queryComplianceDirectoryList");
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(ReportCheckboxVO.class)).getResultList();
   }

   public int insert(String project) {
      String sql = "insert into t_view_compliance_directory_project select UUID() as id,'' as flag,'' as note,y.columnid,x.columnname,x.datasystemid,y.directory_name, x.projectid,x.projectname,x.tablename,x.tschema from ( select a.projectname,b.projectid, b.tschema,b.tablename,b.columnname,b.datasystemid from t_core_project_info a LEFT JOIN " + project + " b on a.realprojectname=b.projectid) x, (select c.id,c.directory_name,e.datasystem_id,e.id as columnid,e.tschemas,e.`names`,e.`fields`,e.flag from t_core_compliance_directory c,t_core_field_directory d,t_core_table_field e where c.id=d.directory_id and d.tablefield_id=e.id )y where x.tschema=y.tschemas and x.tablename=y.`names` and x.columnname=y.`fields`";
      int size = this.getSession().createNativeQuery(sql).executeUpdate();
      return size;
   }

   public List<Map<String, Object>> getEachDatacount(String name) {
      String sql = "select projectname, count(0) as count FROM t_view_compliance_directory_project AS a where directory_name = '" + name + "' GROUP BY a.projectname";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, Object>> getmaxdatetid(String edition_id) {
      String sql = "select id from t_core_compliance_directory where edition_id = '" + edition_id + "' order by create_date desc limit 1";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public void saveDataScope(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public void deleteDataScope(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public List<Map<String, Object>> relatedfandson(String directory_id) {
      String sql = "SELECT id FROM t_core_compliance_directory WHERE directory_id LIKE (CONCAT('" + directory_id + "', '%'))";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public void saveExcelData(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }
}
