package com.chenyang.nse.bussiness.dao.table.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSubsettask;
import com.chenyang.nse.bussiness.entity.vo.SubsetTaskEngineVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreSubsettaskDao extends BaseDao<TCoreSubsettask, String> {
   public List<TCoreSubsettask> queryTaskBySubsetId(String subsetId) {
      String sql = XmlTool.getSql("subsettask", "queryTaskBySubsetId");
      return this.getSession().createNativeQuery(sql).setParameter("subsetid", subsetId).setResultTransformer(Transformers.aliasToBean(TCoreSubsettask.class)).getResultList();
   }

   public TCoreSubsettask queryTaskById(String id) {
      String sql = XmlTool.getSql("subsettask", "queryTaskById");
      List<TCoreSubsettask> list = this.getSession().createNativeQuery(sql).setParameter("id", id).setResultTransformer(Transformers.aliasToBean(TCoreSubsettask.class)).getResultList();
      return list != null && list.size() > 0 ? (TCoreSubsettask)list.get(0) : null;
   }

   public List<TCoreSubsettask> queryTaskByEngineId(String engineid, PageInfo pageInfo) {
      pageInfo.setCount(this.count(new Criterion[]{Restrictions.eq("engineid", engineid)}));
      String sql = XmlTool.getSql("subsettask", "queryTaskByEngineId");
      return this.getSession().createNativeQuery(sql).setParameter("engineid", engineid).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.aliasToBean(TCoreSubsettask.class)).getResultList();
   }

   public List<TCoreSubsettask> querySubsetTask(PageInfo pageInfo) {
      pageInfo.setCount(this.count());
      String sql = XmlTool.getSql("subsettask", "querySubsetTask");
      return this.getSession().createNativeQuery(sql).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.aliasToBean(TCoreSubsettask.class)).getResultList();
   }

   public SubsetTaskEngineVO getEngineInfoOfSubsetTask(String subsetTaskId) {
      String sql = XmlTool.getSql("subsettask", "getEngineInfoOfSubsetTask");
      List<SubsetTaskEngineVO> list = this.getSession().createNativeQuery(sql).setParameter("subsetTaskId", subsetTaskId).setResultTransformer(Transformers.aliasToBean(SubsetTaskEngineVO.class)).getResultList();
      return list != null && list.size() > 0 ? (SubsetTaskEngineVO)list.get(0) : null;
   }
}
