package com.chenyang.nse.bussiness.dao.table.core.blobmasking;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.blobmasking.TCoreBlobMaskingTask;
import com.chenyang.nse.bussiness.entity.vo.blobmasking.TCoreBlobMaskingTaskVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreBlobMaskingTaskDao extends BaseDao<TCoreBlobMaskingTask, String> {
   public List<TCoreBlobMaskingTaskVO> queryBlobMaskingTaskVOByID(String taskid) {
      String sql = XmlTool.getSql("blobmaskingtask", "queryBolbMaskingTaskVOByID");
      List<TCoreBlobMaskingTaskVO> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setResultTransformer(Transformers.aliasToBean(TCoreBlobMaskingTaskVO.class)).getResultList();
      return list;
   }
}
