package com.chenyang.nse.bussiness.dao.table.core.dataproject;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataProjectVO;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.transaction.Transactional;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreDataProjectDao extends BaseDao<TCoreDataProject, String> {
   @Transactional
   public void editDataProject(TCoreDataProject obj) {
      Query updateQuery = this.getSession().createSQLQuery("update t_core_data_project set project = '" + obj.getProject() + "',note = '" + obj.getNote() + "',updatetime = '" + (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(obj.getUpdatetime()) + "',updateuser = '" + obj.getUpdateuser() + "' where id = '" + obj.getId() + "'");
      updateQuery.executeUpdate();
   }

   public List<ComboboxVO> queryProjectList(String ids) {
      String sql = "select id as value,project as text from t_core_data_project where id in (" + ids + ")";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(ComboboxVO.class)).getResultList();
   }

   public List<TCoreDataProject> queryMyProject(String userid, String proName, String note) {
      String sql = "select pro.id as \"id\",pro.flag as \"flag\",pro.note as \"note\" ,pro.createtime as  \"createtime\",pro.createuser as \"createuser\",pro.project as \"project\",pro.edition_id as \"edition_id\" from t_core_data_project pro ,t_base_userproject up \r\n\t\twhere pro.id = up.proid and up.userid = :userid \r\n\t\tand pro.project LIKE CONCAT('%',:proName,'%') \r\n\t\tand pro.note LIKE CONCAT('%',:note,'%')\r\n\t\torder by pro.createtime desc";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select pro.id as \"id\",pro.flag as \"flag\",pro.note as \"note\",pro.createtime as \"createtime\",pro.createuser as \"createuser\",pro.project as \"project\",pro.edition_id as \"edition_id\" from t_core_data_project pro ,t_base_userproject up \r\n\t\twhere pro.id = up.proid and up.userid = :userid\r\n\t\tand pro.project LIKE CONCAT('%',:proName,'%') \r\n\t\tand pro.note LIKE CONCAT('%',:note,'%')\r\n\t\torder by \"createtime\" desc";
      }

      return this.getSession().createNativeQuery(sql).setParameter("userid", userid).setParameter("proName", proName).setParameter("note", note).setResultTransformer(Transformers.aliasToBean(TCoreDataProject.class)).getResultList();
   }

   public List<DataProjectVO> queryDataprojectCrudByUserid(List<String> userid) {
      String sql = "SELECT dp.id AS id, dp.project, up2.crud, up2.updateuserid FROM t_core_data_project dp LEFT JOIN ( SELECT * FROM t_base_userproject up WHERE up.userid in :userid )up2 ON dp.id = up2.proid ORDER BY dp.createtime desc";
      return this.getSession().createNativeQuery(sql).setParameter("userid", userid).setResultTransformer(Transformers.aliasToBean(DataProjectVO.class)).getResultList();
   }

   public String queryEdtionIdByProId(String projectid) {
      String sql = "SELECT edition_id  FROM t_core_data_project WHERE id = :id ";
      return this.getSession().createSQLQuery(sql).setParameter("id", projectid).uniqueResult().toString();
   }
}
