package com.chenyang.nse.bussiness.dao.table.core.encryptionmasking;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.EncryptionMasking;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;

@Repository
public class EncryptionMaskingDao extends BaseDao<EncryptionMasking, String> {
   static final String CACHE_NAME = "encryptionmasking";

   public long getExeTaskNum() {
      String sql = "select  count(*) from desensitization_table as a,encryptionmasking as b  where a.taskid = b.id and taskstatus = 1";
      BigInteger count = (BigInteger)this.getSession().createNativeQuery(sql).uniqueResult();
      return count.longValue();
   }

   public long getTableNum(String taskid) {
      String sql = "select count(*) as count from desensitization_table    where taskid = '" + taskid + "'";
      BigInteger count = (BigInteger)this.getSession().createNativeQuery(sql).uniqueResult();
      return count.longValue();
   }

   public long getTableNumByAll(String sqls) {
      String sql = "select count(*) as count from desensitization_table    where taskid  in (" + sqls + ")";
      BigInteger count = (BigInteger)this.getSession().createNativeQuery(sql).uniqueResult();
      return count.longValue();
   }

   @Cacheable(
      cacheNames = {"encryptionmasking"},
      key = "'ENCRYPTIONMASKING_' + #taskid",
      unless = "#result == null"
   )
   public EncryptionMasking getById(String taskid) {
      EncryptionMasking encryptionMasking = (EncryptionMasking)this.queryUnique(new Criterion[]{Restrictions.eq("id", taskid)});
      return encryptionMasking;
   }

   public List<Map<String, Object>> selectMaskingCount(String id) {
      String sql = "SELECT count(1) as s FROM encryptionmasking where projectid ='" + id + "'";
      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<EncryptionMasking> queryTaskAll() {
      String sql = XmlTool.getSql("getalltask", "selectTaskAllList");
      List<EncryptionMasking> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(EncryptionMasking.class)).getResultList();
      return vo;
   }

   public List<EncryptionMasking> queryTaskAllbyprojectid(String projectid) {
      String sql = XmlTool.getSql("getalltask", "selectTaskAllListByProjectid");
      List<EncryptionMasking> vo = this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setResultTransformer(Transformers.aliasToBean(EncryptionMasking.class)).getResultList();
      return vo;
   }
}
