package com.chenyang.nse.bussiness.dao.table.core.masking;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingFilesystem;
import com.chenyang.nse.bussiness.entity.vo.file.TCoreFileStructurecolumnVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TCoreMaskingFilesystemVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreMaskingFilesystemDao extends BaseDao<TCoreMaskingFilesystem, String> {
   public List<TCoreMaskingFilesystemVO> queryMaskingFilesystemVO(String taskid, String datadirection) {
      String sql = XmlTool.getSql("maskingtask", "queryMaskingFilesystemVO");
      List<TCoreMaskingFilesystemVO> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setParameter("datadirection", datadirection).setResultTransformer(Transformers.aliasToBean(TCoreMaskingFilesystemVO.class)).getResultList();
      return list;
   }

   public List<TCoreFileStructurecolumnVO> queryFileStructurecolumnVO(String filesystemid) {
      String sql = XmlTool.getSql("maskingtask", "queryFileStructurecolumnVO");
      List<TCoreFileStructurecolumnVO> list = this.getSession().createNativeQuery(sql).setParameter("filesystemid", filesystemid).setResultTransformer(Transformers.aliasToBean(TCoreFileStructurecolumnVO.class)).getResultList();
      return list;
   }
}
