package com.chenyang.nse.bussiness.engine.infa.basic.webservice;

import com.chenyang.nse.bussiness.commmon.ApplicationConstants;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.Service.Mode;
import org.w3c.dom.Document;

public class MultiGetSessionTimeWebService {
   public static SessionBean returnStatus(String sessionId, InfoProperty engine, String workflowname, String mpname, String fdname) throws Exception {
      String ns = engine.getWebserviceurl();
      String wsdlUrl = engine.getWebserviceserverurl();
      URL url = new URL(wsdlUrl);
      QName sname = new QName(ns, "DataIntegrationService");
      Service service = Service.create(url, sname);
      Dispatch<SOAPMessage> dispatch = service.createDispatch(new QName(ns, "DataIntegration"), SOAPMessage.class, Mode.MESSAGE);
      SOAPMessage msg = MessageFactory.newInstance("SOAP 1.1 Protocol").createMessage();
      SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
      SOAPHeader head = envelope.getHeader();
      QName hename = new QName(ns, "Context", "ns0");
      SOAPHeaderElement hele = head.addHeaderElement(hename);
      hele.addChildElement("SessionId").setValue(sessionId);
      SOAPBody body = envelope.getBody();
      QName ename = new QName(ns, "GetTaskDetails", "ns0");
      SOAPBodyElement ele = body.addBodyElement(ename);
      SOAPElement di = ele.addChildElement("DIServiceInfo");
      di.addChildElement("DomainName").setValue(engine.getDomainname());
      di.addChildElement("ServiceName").setValue(engine.getInteservicename());
      ele.addChildElement("FolderName").setValue(fdname);
      ele.addChildElement("WorkflowName").setValue(workflowname);
      ele.addChildElement("TaskInstancePath").setValue("s_M_" + mpname);
      ele.addChildElement("WorkflowRunInstanceName").setValue("s_M_" + mpname);
      SOAPMessage response = (SOAPMessage)dispatch.invoke(msg);
      SessionBean sb = new SessionBean();
      Document doc = response.getSOAPPart().getEnvelope().getBody().extractContentAsDocument();
      if (doc.getElementsByTagName("Year").getLength() > 1) {
         if (doc.getElementsByTagName("Year") != null) {
            String start_time = doc.getElementsByTagName("Year").item(0).getTextContent() + "-" + doc.getElementsByTagName("Month").item(0).getTextContent() + "-" + doc.getElementsByTagName("Date").item(0).getTextContent() + " " + doc.getElementsByTagName("Hours").item(0).getTextContent() + ":" + doc.getElementsByTagName("Minutes").item(0).getTextContent() + ":" + doc.getElementsByTagName("Seconds").item(0).getTextContent() + "";
            sb.setStart_time(start_time);
         }

         if (doc.getElementsByTagName("Year") != null) {
            String end_time = doc.getElementsByTagName("Year").item(1).getTextContent() + "-" + doc.getElementsByTagName("Month").item(1).getTextContent() + "-" + doc.getElementsByTagName("Date").item(1).getTextContent() + " " + doc.getElementsByTagName("Hours").item(1).getTextContent() + ":" + doc.getElementsByTagName("Minutes").item(1).getTextContent() + ":" + doc.getElementsByTagName("Seconds").item(1).getTextContent() + "";
            sb.setEnd_time(end_time);
         }
      }

      return sb;
   }

   public static SessionBean returnStatus(String sessionId, String domain, String server, String workflowname, String mpname, String sename, String fdname) throws Exception {
      String ns = ApplicationConstants.webservice_url;
      String wsdlUrl = ApplicationConstants.wsdl_url;
      URL url = new URL(wsdlUrl);
      QName sname = new QName(ns, "DataIntegrationService");
      Service service = Service.create(url, sname);
      Dispatch<SOAPMessage> dispatch = service.createDispatch(new QName(ns, "DataIntegration"), SOAPMessage.class, Mode.MESSAGE);
      SOAPMessage msg = MessageFactory.newInstance("SOAP 1.1 Protocol").createMessage();
      SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
      SOAPHeader head = envelope.getHeader();
      QName hename = new QName(ns, "Context", "ns0");
      SOAPHeaderElement hele = head.addHeaderElement(hename);
      hele.addChildElement("SessionId").setValue(sessionId);
      SOAPBody body = envelope.getBody();
      QName ename = new QName(ns, "GetTaskDetails", "ns0");
      SOAPBodyElement ele = body.addBodyElement(ename);
      SOAPElement di = ele.addChildElement("DIServiceInfo");
      di.addChildElement("DomainName").setValue(domain);
      di.addChildElement("ServiceName").setValue(server);
      ele.addChildElement("FolderName").setValue(fdname);
      ele.addChildElement("WorkflowName").setValue(workflowname);
      ele.addChildElement("TaskInstancePath").setValue(sename);
      ele.addChildElement("WorkflowRunInstanceName").setValue(sename);
      SOAPMessage response = (SOAPMessage)dispatch.invoke(msg);
      SessionBean sb = new SessionBean();
      Document doc = response.getSOAPPart().getEnvelope().getBody().extractContentAsDocument();
      if (doc.getElementsByTagName("Year").getLength() > 1) {
         if (doc.getElementsByTagName("Year") != null) {
            String start_time = doc.getElementsByTagName("Year").item(0).getTextContent() + "-" + doc.getElementsByTagName("Month").item(0).getTextContent() + "-" + doc.getElementsByTagName("Date").item(0).getTextContent() + " " + doc.getElementsByTagName("Hours").item(0).getTextContent() + ":" + doc.getElementsByTagName("Minutes").item(0).getTextContent() + ":" + doc.getElementsByTagName("Seconds").item(0).getTextContent() + "";
            sb.setStart_time(start_time);
         }

         if (doc.getElementsByTagName("Year") != null) {
            String end_time = doc.getElementsByTagName("Year").item(1).getTextContent() + "-" + doc.getElementsByTagName("Month").item(1).getTextContent() + "-" + doc.getElementsByTagName("Date").item(1).getTextContent() + " " + doc.getElementsByTagName("Hours").item(1).getTextContent() + ":" + doc.getElementsByTagName("Minutes").item(1).getTextContent() + ":" + doc.getElementsByTagName("Seconds").item(1).getTextContent() + "";
            sb.setEnd_time(end_time);
         }
      }

      return sb;
   }
}
