package com.chenyang.nse.bussiness.engine.infa.basic.wsclient;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.WebParam.Mode;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.Holder;

@WebService(
   name = "DataIntegrationInterface",
   targetNamespace = "http://www.informatica.com/wsh"
)
@SOAPBinding(
   parameterStyle = ParameterStyle.BARE
)
@XmlSeeAlso({ObjectFactory.class})
public interface DataIntegrationInterface {
   @WebMethod
   @WebResult(
      name = "LoginReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "param"
   )
   String login(@WebParam(name = "Login",targetNamespace = "http://www.informatica.com/wsh",partName = "param") LoginRequest param, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,mode = Mode.OUT,partName = "Context") Holder<SessionHeader> context) throws Fault;

   @WebMethod
   @WebResult(
      name = "LogoutReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "param"
   )
   VoidResponse logout(@WebParam(name = "Logout",targetNamespace = "http://www.informatica.com/wsh",partName = "param") VoidRequest param, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "InitializeDIServerConnectionReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "param"
   )
   VoidResponse initializeDIServerConnection(@WebParam(name = "InitializeDIServerConnection",targetNamespace = "http://www.informatica.com/wsh",partName = "param") InitializeDIServerConnectionRequest param, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "DeinitializeDIServerConnectionReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "param"
   )
   VoidResponse deinitializeDIServerConnection(@WebParam(name = "DeinitializeDIServerConnection",targetNamespace = "http://www.informatica.com/wsh",partName = "param") VoidRequest param, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "StartWorkflowLogFetchReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "param"
   )
   int startWorkflowLogFetch(@WebParam(name = "StartWorkflowLogFetch",targetNamespace = "http://www.informatica.com/wsh",partName = "param") StartWorkflowLogFetchRequest param, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "StartSessionLogFetchReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "param"
   )
   int startSessionLogFetch(@WebParam(name = "StartSessionLogFetch",targetNamespace = "http://www.informatica.com/wsh",partName = "param") StartSessionLogFetchRequest param, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "GetNextLogSegmentReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "param"
   )
   LogSegment getNextLogSegment(@WebParam(name = "GetNextLogSegment",targetNamespace = "http://www.informatica.com/wsh",partName = "param") GetNextLogSegmentRequest param, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "PingDIServerReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "PingDIServerReturn"
   )
   EPingState pingDIServer(@WebParam(name = "PingDIServer",targetNamespace = "http://www.informatica.com/wsh",partName = "PingDIServer") PingDIServerRequest pingDIServer, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "GetDIServerPropertiesReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "GetDIServerPropertiesReturn"
   )
   DIServerProperties getDIServerProperties(@WebParam(name = "GetDIServerProperties",targetNamespace = "http://www.informatica.com/wsh",partName = "GetDIServerProperties") DIServiceInfo getDIServerProperties, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "StartWorkflowReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "StartWorkflowReturn"
   )
   VoidResponse startWorkflow(@WebParam(name = "StartWorkflow",targetNamespace = "http://www.informatica.com/wsh",partName = "StartWorkflow") WorkflowRequest startWorkflow, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "StartWorkflowExReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "StartWorkflowExReturn"
   )
   TypeStartWorkflowExResponse startWorkflowEx(@WebParam(name = "StartWorkflowEx",targetNamespace = "http://www.informatica.com/wsh",partName = "StartWorkflowEx") TypeStartWorkflowExRequest startWorkflowEx, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "StartWorkflowFromTaskReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "StartWorkflowFromTaskReturn"
   )
   VoidResponse startWorkflowFromTask(@WebParam(name = "StartWorkflowFromTask",targetNamespace = "http://www.informatica.com/wsh",partName = "StartWorkflowFromTask") WorkflowRequest startWorkflowFromTask, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "StopWorkflowReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "StopWorkflowReturn"
   )
   VoidResponse stopWorkflow(@WebParam(name = "StopWorkflow",targetNamespace = "http://www.informatica.com/wsh",partName = "StopWorkflow") WorkflowRequest stopWorkflow, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "ScheduleWorkflowReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "ScheduleWorkflowReturn"
   )
   VoidResponse scheduleWorkflow(@WebParam(name = "ScheduleWorkflow",targetNamespace = "http://www.informatica.com/wsh",partName = "ScheduleWorkflow") WorkflowRequest scheduleWorkflow, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "UnscheduleWorkflowReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "UnscheduleWorkflowReturn"
   )
   VoidResponse unscheduleWorkflow(@WebParam(name = "UnscheduleWorkflow",targetNamespace = "http://www.informatica.com/wsh",partName = "UnscheduleWorkflow") WorkflowRequest unscheduleWorkflow, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "WaitTillWorkflowCompleteReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "WaitTillWorkflowCompleteReturn"
   )
   VoidResponse waitTillWorkflowComplete(@WebParam(name = "WaitTillWorkflowComplete",targetNamespace = "http://www.informatica.com/wsh",partName = "WaitTillWorkflowComplete") WorkflowRequest waitTillWorkflowComplete, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "ResumeWorkflowReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "ResumeWorkflowReturn"
   )
   VoidResponse resumeWorkflow(@WebParam(name = "ResumeWorkflow",targetNamespace = "http://www.informatica.com/wsh",partName = "ResumeWorkflow") WorkflowRequest resumeWorkflow, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "StartTaskReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "StartTaskReturn"
   )
   VoidResponse startTask(@WebParam(name = "StartTask",targetNamespace = "http://www.informatica.com/wsh",partName = "StartTask") TaskRequest startTask, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "StopTaskReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "StopTaskReturn"
   )
   VoidResponse stopTask(@WebParam(name = "StopTask",targetNamespace = "http://www.informatica.com/wsh",partName = "StopTask") TaskRequest stopTask, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "WaitTillTaskCompleteReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "WaitTillTaskCompleteReturn"
   )
   VoidResponse waitTillTaskComplete(@WebParam(name = "WaitTillTaskComplete",targetNamespace = "http://www.informatica.com/wsh",partName = "WaitTillTaskComplete") TaskRequest waitTillTaskComplete, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "RecoverWorkflowReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "RecoverWorkflowReturn"
   )
   VoidResponse recoverWorkflow(@WebParam(name = "RecoverWorkflow",targetNamespace = "http://www.informatica.com/wsh",partName = "RecoverWorkflow") WorkflowRequest recoverWorkflow, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "MonitorDIServerReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "MonitorDIServerReturn"
   )
   DIServerDetails monitorDIServer(@WebParam(name = "MonitorDIServer",targetNamespace = "http://www.informatica.com/wsh",partName = "MonitorDIServer") MonitorDIServerRequest monitorDIServer, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "GetWorkflowDetailsReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "GetWorkflowDetailsReturn"
   )
   WorkflowDetails getWorkflowDetails(@WebParam(name = "GetWorkflowDetails",targetNamespace = "http://www.informatica.com/wsh",partName = "GetWorkflowDetails") WorkflowRequest getWorkflowDetails, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "GetWorkflowDetailsExReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "GetWorkflowDetailsExReturn"
   )
   DIServerDetails getWorkflowDetailsEx(@WebParam(name = "GetWorkflowDetailsEx",targetNamespace = "http://www.informatica.com/wsh",partName = "GetWorkflowDetailsEx") TypeGetWorkflowDetailsExRequest getWorkflowDetailsEx, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "GetTaskDetailsReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "GetTaskDetailsReturn"
   )
   TaskDetails getTaskDetails(@WebParam(name = "GetTaskDetails",targetNamespace = "http://www.informatica.com/wsh",partName = "GetTaskDetails") TaskRequest getTaskDetails, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "GetTaskDetailsExReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "GetTaskDetailsExReturn"
   )
   DIServerDetails getTaskDetailsEx(@WebParam(name = "GetTaskDetailsEx",targetNamespace = "http://www.informatica.com/wsh",partName = "GetTaskDetailsEx") TypeGetTaskDetailsExRequest getTaskDetailsEx, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "GetSessionStatisticsReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "GetSessionStatisticsReturn"
   )
   SessionStatistics getSessionStatistics(@WebParam(name = "GetSessionStatistics",targetNamespace = "http://www.informatica.com/wsh",partName = "GetSessionStatistics") GetSessionStatisticsRequest getSessionStatistics, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "GetSessionPerformanceDataReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "GetSessionPerformanceDataReturn"
   )
   SessionPerformanceData getSessionPerformanceData(@WebParam(name = "GetSessionPerformanceData",targetNamespace = "http://www.informatica.com/wsh",partName = "GetSessionPerformanceData") GetSessionPerformanceDataRequest getSessionPerformanceData, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "GetWorkflowLogReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "GetWorkflowLogReturn"
   )
   Log getWorkflowLog(@WebParam(name = "GetWorkflowLog",targetNamespace = "http://www.informatica.com/wsh",partName = "GetWorkflowLog") GetWorkflowLogRequest getWorkflowLog, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;

   @WebMethod
   @WebResult(
      name = "GetSessionLogReturn",
      targetNamespace = "http://www.informatica.com/wsh",
      partName = "GetSessoinLogReturn"
   )
   Log getSessionLog(@WebParam(name = "GetSessionLog",targetNamespace = "http://www.informatica.com/wsh",partName = "GetSessionLog") GetSessionLogRequest getSessionLog, @WebParam(name = "Context",targetNamespace = "http://www.informatica.com/wsh",header = true,partName = "Context") SessionHeader context) throws Fault;
}
