package com.chenyang.nse.bussiness.entity.orm.table.console;

import com.chenyang.nse.bussiness.entity.orm.table.TInitEntity;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(
   name = "T_CONSOLE_DICTIONARY"
)
public class TConsoleDictionary extends TInitEntity {
   @Column(
      length = 32
   )
   private String typecode;
   @Column(
      length = 255
   )
   private String value;
   @Column(
      length = 64
   )
   private String name;
   @Column(
      length = 32
   )
   private String parentid;
   @Transient
   @Column(
      length = 64
   )
   private String typename;
   @Transient
   @Column(
      length = 255
   )
   private String parentvalue;
   @Column(
      length = 255
   )
   private String remark;

   public TConsoleDictionary() {
   }

   public TConsoleDictionary(String typecode, String value, String name, String parentid) {
      this.typecode = typecode;
      this.value = value;
      this.name = name;
      this.parentid = parentid;
   }

   public String getTypecode() {
      return this.typecode;
   }

   public void setTypecode(String typecode) {
      this.typecode = typecode;
   }

   public String getValue() {
      return this.value;
   }

   public void setValue(String value) {
      this.value = value;
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public String getParentid() {
      return this.parentid;
   }

   public void setParentid(String parentid) {
      this.parentid = parentid;
   }

   public String getTypename() {
      return this.typename;
   }

   public void setTypename(String typename) {
      this.typename = typename;
   }

   public String getParentvalue() {
      return this.parentvalue;
   }

   public void setParentvalue(String parentvalue) {
      this.parentvalue = parentvalue;
   }

   public String getRemark() {
      return this.remark;
   }

   public void setRemark(String remark) {
      this.remark = remark;
   }

   public String toString() {
      return "TConsoleDictionary [typecode=" + this.typecode + ", value=" + this.value + ", name=" + this.name + ", parentid=" + this.parentid + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
      result = 31 * result + (this.parentid == null ? 0 : this.parentid.hashCode());
      result = 31 * result + (this.typecode == null ? 0 : this.typecode.hashCode());
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TConsoleDictionary other = (TConsoleDictionary)obj;
         if (this.name == null) {
            if (other.name != null) {
               return false;
            }
         } else if (!this.name.equals(other.name)) {
            return false;
         }

         if (this.parentid == null) {
            if (other.parentid != null) {
               return false;
            }
         } else if (!this.parentid.equals(other.parentid)) {
            return false;
         }

         if (this.typecode == null) {
            if (other.typecode != null) {
               return false;
            }
         } else if (!this.typecode.equals(other.typecode)) {
            return false;
         }

         if (this.value == null) {
            if (other.value != null) {
               return false;
            }
         } else if (!this.value.equals(other.value)) {
            return false;
         }

         return true;
      }
   }
}
