package com.chenyang.nse.bussiness.entity.orm.table.console;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CONSOLE_PRIVILEGE"
)
public class TConsolePrivilege extends TBaseEntity {
   private String roleid;
   private String privilege;

   public TConsolePrivilege() {
   }

   public TConsolePrivilege(String roleid, String privilege) {
      this.roleid = roleid;
      this.privilege = privilege;
   }

   public String getRoleid() {
      return this.roleid;
   }

   public void setRoleid(String roleid) {
      this.roleid = roleid;
   }

   public String getPrivilege() {
      return this.privilege;
   }

   public void setPrivilege(String privilege) {
      this.privilege = privilege;
   }

   public String toString() {
      return "TConsolePrivilege [roleid=" + this.roleid + ", privilege=" + this.privilege + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.privilege == null ? 0 : this.privilege.hashCode());
      result = 31 * result + (this.roleid == null ? 0 : this.roleid.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TConsolePrivilege other = (TConsolePrivilege)obj;
         if (this.privilege == null) {
            if (other.privilege != null) {
               return false;
            }
         } else if (!this.privilege.equals(other.privilege)) {
            return false;
         }

         if (this.roleid == null) {
            if (other.roleid != null) {
               return false;
            }
         } else if (!this.roleid.equals(other.roleid)) {
            return false;
         }

         return true;
      }
   }
}
