package com.chenyang.nse.bussiness.entity.orm.table.console.engine;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(
   name = "T_CONSOLE_ENGINE_TYPE"
)
public class TConsoleEngineType extends TBaseEntity {
   private String enginetype;
   private String engineversion;
   @Transient
   private List<TConsoleEngineProperty> propertylist;

   public TConsoleEngineType() {
   }

   public TConsoleEngineType(String enginetype, String engineversion) {
      this.enginetype = enginetype;
      this.engineversion = engineversion;
   }

   public String getEnginetype() {
      return this.enginetype;
   }

   public void setEnginetype(String enginetype) {
      this.enginetype = enginetype;
   }

   public String getEngineversion() {
      return this.engineversion;
   }

   public void setEngineversion(String engineversion) {
      this.engineversion = engineversion;
   }

   public List<TConsoleEngineProperty> getPropertylist() {
      return this.propertylist;
   }

   public void setPropertylist(List<TConsoleEngineProperty> propertylist) {
      this.propertylist = propertylist;
   }

   public String toString() {
      return "TConsoleEngineType [enginetype=" + this.enginetype + ", engineversion=" + this.engineversion + ", propertylist=" + this.propertylist + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.enginetype == null ? 0 : this.enginetype.hashCode());
      result = 31 * result + (this.engineversion == null ? 0 : this.engineversion.hashCode());
      result = 31 * result + (this.propertylist == null ? 0 : this.propertylist.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TConsoleEngineType other = (TConsoleEngineType)obj;
         if (this.enginetype == null) {
            if (other.enginetype != null) {
               return false;
            }
         } else if (!this.enginetype.equals(other.enginetype)) {
            return false;
         }

         if (this.engineversion == null) {
            if (other.engineversion != null) {
               return false;
            }
         } else if (!this.engineversion.equals(other.engineversion)) {
            return false;
         }

         if (this.propertylist == null) {
            if (other.propertylist != null) {
               return false;
            }
         } else if (!this.propertylist.equals(other.propertylist)) {
            return false;
         }

         return true;
      }
   }
}
