package com.chenyang.nse.bussiness.entity.orm.table.core.masking;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CORE_MASKING_TASKRECORD"
)
public class TCoreMaskingTaskrecord extends TBaseEntity {
   private String taskid;
   private Date taketime;
   @Column(
      length = 2000
   )
   private String logtext;
   private String exeresult;
   private String userid;

   public TCoreMaskingTaskrecord() {
   }

   public TCoreMaskingTaskrecord(String taskid, Date taketime, String logtext, String exeresult, String userid) {
      this.taskid = taskid;
      this.taketime = taketime;
      this.logtext = logtext;
      this.exeresult = exeresult;
      this.userid = userid;
   }

   public String getTaskid() {
      return this.taskid;
   }

   public void setTaskid(String taskid) {
      this.taskid = taskid;
   }

   public Date getTaketime() {
      return this.taketime;
   }

   public void setTaketime(Date taketime) {
      this.taketime = taketime;
   }

   public String getLogtext() {
      return this.logtext;
   }

   public void setLogtext(String logtext) {
      this.logtext = logtext;
   }

   public String getExeresult() {
      return this.exeresult;
   }

   public void setExeresult(String exeresult) {
      this.exeresult = exeresult;
   }

   public String getUserid() {
      return this.userid;
   }

   public void setUserid(String userid) {
      this.userid = userid;
   }

   public String toString() {
      return "TCoreMaskingTaskrecord [taskid=" + this.taskid + ", taketime=" + this.taketime + ", logtext=" + this.logtext + ", exeresult=" + this.exeresult + ", userid=" + this.userid + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.exeresult == null ? 0 : this.exeresult.hashCode());
      result = 31 * result + (this.logtext == null ? 0 : this.logtext.hashCode());
      result = 31 * result + (this.taketime == null ? 0 : this.taketime.hashCode());
      result = 31 * result + (this.taskid == null ? 0 : this.taskid.hashCode());
      result = 31 * result + (this.userid == null ? 0 : this.userid.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreMaskingTaskrecord other = (TCoreMaskingTaskrecord)obj;
         if (this.exeresult == null) {
            if (other.exeresult != null) {
               return false;
            }
         } else if (!this.exeresult.equals(other.exeresult)) {
            return false;
         }

         if (this.logtext == null) {
            if (other.logtext != null) {
               return false;
            }
         } else if (!this.logtext.equals(other.logtext)) {
            return false;
         }

         if (this.taketime == null) {
            if (other.taketime != null) {
               return false;
            }
         } else if (!this.taketime.equals(other.taketime)) {
            return false;
         }

         if (this.taskid == null) {
            if (other.taskid != null) {
               return false;
            }
         } else if (!this.taskid.equals(other.taskid)) {
            return false;
         }

         if (this.userid == null) {
            if (other.userid != null) {
               return false;
            }
         } else if (!this.userid.equals(other.userid)) {
            return false;
         }

         return true;
      }
   }
}
