package com.chenyang.nse.bussiness.entity.vo;

import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.multipart.MultipartFile;

public class ReadExcel {
   private int totalRows = 0;
   private int totalCells = 0;
   private String errorMsg;

   public int getTotalRows() {
      return this.totalRows;
   }

   public void setTotalRows(int totalRows) {
      this.totalRows = totalRows;
   }

   public int getTotalCells() {
      return this.totalCells;
   }

   public void setTotalCells(int totalCells) {
      this.totalCells = totalCells;
   }

   public String getErrorMsg() {
      return this.errorMsg;
   }

   public void setErrorMsg(String errorMsg) {
      this.errorMsg = errorMsg;
   }

   public ReadExcel(int totalRows, int totalCells, String errorMsg) {
      this.totalRows = totalRows;
      this.totalCells = totalCells;
      this.errorMsg = errorMsg;
   }

   public ReadExcel() {
   }

   public List<TConsoleDictionary> getExcelInfo(MultipartFile mFile) {
      String fileName = mFile.getOriginalFilename();
      List<TConsoleDictionary> fileList = null;

      try {
         if (!this.validateExcel(fileName)) {
            return null;
         }

         boolean isExcel2003 = true;
         if (isExcel2007(fileName)) {
            isExcel2003 = false;
         }

         fileList = this.createExcel(mFile.getInputStream(), isExcel2003);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return fileList;
   }

   public List<TConsoleDictionary> createExcel(InputStream is, boolean isExcel2003) {
      List<TConsoleDictionary> fileList = null;

      try {
         Workbook wb = null;
         HSSFWorkbook var6;
         if (isExcel2003) {
            var6 = new HSSFWorkbook(is);
         } else {
            var6 = new HSSFWorkbook(is);
         }

         fileList = this.readExcelValue(var6);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return fileList;
   }

   private List<TConsoleDictionary> readExcelValue(Workbook wb) {
      Sheet sheet = wb.getSheetAt(0);
      this.totalRows = sheet.getPhysicalNumberOfRows();
      if (this.totalRows > 1 && sheet.getRow(0) != null) {
         this.totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
      }

      List<TConsoleDictionary> fileList = new ArrayList();

      for(int r = 1; r < this.totalRows; ++r) {
         Row row = sheet.getRow(r);
         if (row != null) {
            TConsoleDictionary tConsoleDictionary = new TConsoleDictionary();

            for(int c = 0; c < this.totalCells; ++c) {
               Cell cell = row.getCell(c);
               if (null != cell) {
                  if (c == 0) {
                     if (cell.getCellType() == 0) {
                        String typecode = String.valueOf(cell.getNumericCellValue());
                        tConsoleDictionary.setTypecode(typecode.substring(0, typecode.length() - 2 > 0 ? typecode.length() - 2 : 1));
                     } else {
                        tConsoleDictionary.setTypecode(cell.getStringCellValue());
                     }
                  } else if (c == 1) {
                     if (cell.getCellType() == 0) {
                        String setTypename = String.valueOf(cell.getNumericCellValue());
                        tConsoleDictionary.setTypename(setTypename.substring(0, setTypename.length() - 2 > 0 ? setTypename.length() - 2 : 1));
                     } else {
                        tConsoleDictionary.setTypename(cell.getStringCellValue());
                     }
                  } else if (c == 2) {
                     if (cell.getCellType() == 0) {
                        String value = String.valueOf(cell.getNumericCellValue());
                        tConsoleDictionary.setValue(value.substring(0, value.length() - 2 > 0 ? value.length() - 2 : 1));
                     } else {
                        tConsoleDictionary.setValue(cell.getStringCellValue());
                     }
                  } else if (c == 3) {
                     if (cell.getCellType() == 0) {
                        String name = String.valueOf(cell.getNumericCellValue());
                        tConsoleDictionary.setName(name.substring(0, name.length() - 2 > 0 ? name.length() - 2 : 1));
                     } else {
                        tConsoleDictionary.setName(cell.getStringCellValue());
                     }
                  } else if (c == 3) {
                     if (cell.getCellType() == 0) {
                        String name = String.valueOf(cell.getNumericCellValue());
                        tConsoleDictionary.setName(name.substring(0, name.length() - 2 > 0 ? name.length() - 2 : 1));
                     } else {
                        tConsoleDictionary.setName(cell.getStringCellValue());
                     }
                  } else if (c == 4) {
                     if (cell.getCellType() == 0) {
                        String parentvalue = String.valueOf(cell.getNumericCellValue());
                        tConsoleDictionary.setParentvalue(parentvalue.substring(0, parentvalue.length() - 2 > 0 ? parentvalue.length() - 2 : 1));
                     } else {
                        tConsoleDictionary.setParentvalue(cell.getStringCellValue());
                     }
                  }
               }
            }

            fileList.add(tConsoleDictionary);
         }
      }

      return fileList;
   }

   public boolean validateExcel(String filePath) {
      if (filePath != null && (isExcel2003(filePath) || isExcel2007(filePath))) {
         return true;
      } else {
         this.errorMsg = "文件名不是excel格式";
         return false;
      }
   }

   public static boolean isExcel2003(String filePath) {
      return filePath.matches("^.+\\/(?!)(xls)$");
   }

   public static boolean isExcel2007(String filePath) {
      return filePath.matches("^.+\\/(?!)(xlsx)$");
   }
}
