package com.chenyang.nse.bussiness.entity.vo;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeGridSensitiveDataVO implements Comparable<TreeGridSensitiveDataVO>, Serializable {
   private static DecimalFormat format = new DecimalFormat("0.00");
   private String id;
   private String datasourceid;
   private String datasourcename;
   private String schema;
   private String name;
   private String parentid;
   private String parentname;
   private String state;
   private String regexType;
   private String regexName;
   private String columnId;
   private String groupId;
   private String ruleId;
   private String ruleName;
   private String matchRate;
   private String distinctRate;
   private String distinctCount;
   private String totalCount;
   private String validCount;
   private String matchCount;
   private String columnChecked;
   private String flag;
   private String remark;
   private String key;
   private String isshowdata;
   private String isfile;
   private String iconCls;
   private List<String> matchValues;
   private List<String> notMatchValues;
   private List<TreeGridSensitiveDataVO> children;
   private Map<String, TreeGridSensitiveDataVO> childrenMap;
   private String isIntelligent;

   public String getIsfile() {
      return this.isfile;
   }

   public void setIsfile(String isfile) {
      this.isfile = isfile;
   }

   public String getIsshowdata() {
      return this.isshowdata;
   }

   public void setIsshowdata(String isshowdata) {
      this.isshowdata = isshowdata;
   }

   public String getKey() {
      return this.key;
   }

   public void setKey(String key) {
      this.key = key;
   }

   public String getRemark() {
      return this.remark;
   }

   public void setRemark(String remark) {
      this.remark = remark;
   }

   public String getIsIntelligent() {
      return this.isIntelligent;
   }

   public void setIsIntelligent(String isIntelligent) {
      this.isIntelligent = isIntelligent;
   }

   public TreeGridSensitiveDataVO() {
   }

   public TreeGridSensitiveDataVO(String id, String name, String flag, String iconCls, boolean hasChildren) {
      this.id = id;
      this.name = name;
      this.flag = flag;
      this.iconCls = iconCls;
      if (hasChildren) {
         this.childrenMap = new HashMap();
         this.children = new ArrayList();
      }

   }

   public TreeGridSensitiveDataVO(String datasourcename, String schema, String parentname, String name, String totalCount, String validCount, String matchCount, String matchRate, String regexType, String ruleName) {
      this.datasourcename = datasourcename;
      this.schema = schema;
      this.parentname = parentname;
      this.name = name;
      this.totalCount = totalCount;
      this.validCount = validCount;
      this.matchCount = matchCount;
      this.matchRate = matchRate;
      this.regexType = regexType;
      this.ruleName = ruleName;
   }

   public TreeGridSensitiveDataVO(String datasourcename, String schema, String parentname, String name, String totalCount, String validCount, String matchCount, String matchRate, String regexType, String ruleName, String remark) {
      this.datasourcename = datasourcename;
      this.schema = schema;
      this.parentname = parentname;
      this.name = name;
      this.totalCount = totalCount;
      this.validCount = validCount;
      this.matchCount = matchCount;
      this.matchRate = matchRate;
      this.regexType = regexType;
      this.ruleName = ruleName;
      this.remark = remark;
   }

   public TreeGridSensitiveDataVO(String name, String state, List<TreeGridSensitiveDataVO> children) {
      this.name = name;
      this.state = state;
      this.children = children;
   }

   public TreeGridSensitiveDataVO(String name, String parentname, String state, String regexType, String columnId, String ruleId, String ruleName, String regexName, String columnChecked, long totalCount, long validCount, long matchCount, Long distinctCount, List<String> matchValues, List<String> notMatchValues) {
      this.name = name;
      this.parentname = parentname;
      this.state = state;
      this.regexType = regexType;
      this.columnId = columnId;
      this.ruleId = ruleId;
      this.ruleName = ruleName;
      this.regexName = regexName;
      this.columnChecked = columnChecked;
      this.totalCount = String.valueOf(totalCount);
      this.validCount = String.valueOf(validCount);
      this.matchCount = String.valueOf(matchCount);
      this.distinctCount = String.valueOf(distinctCount);
      this.matchValues = null;
      this.notMatchValues = null;
      if (matchCount > 0L) {
         if (matchCount == validCount) {
            this.matchRate = "100";
         } else {
            this.matchRate = format.format((double)matchCount * (double)1.0F / (double)validCount * (double)100.0F);
         }
      } else {
         this.matchRate = "0";
      }

      if (distinctCount > 0L) {
         if (distinctCount == validCount) {
            this.distinctRate = "1";
         } else {
            this.distinctRate = format.format((double)distinctCount * (double)1.0F / (double)validCount);
         }
      } else {
         this.distinctRate = "0";
      }

   }

   public int compareTo(TreeGridSensitiveDataVO v) {
      return this.getName().compareTo(v.getName());
   }

   public String getId() {
      return this.id;
   }

   public void setId(String id) {
      this.id = id;
   }

   public String getDatasourceid() {
      return this.datasourceid;
   }

   public void setDatasourceid(String datasourceid) {
      this.datasourceid = datasourceid;
   }

   public String getDatasourcename() {
      return this.datasourcename;
   }

   public void setDatasourcename(String datasourcename) {
      this.datasourcename = datasourcename;
   }

   public String getSchema() {
      return this.schema;
   }

   public void setSchema(String schema) {
      this.schema = schema;
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public String getParentid() {
      return this.parentid;
   }

   public void setParentid(String parentid) {
      this.parentid = parentid;
   }

   public String getParentname() {
      return this.parentname;
   }

   public void setParentname(String parentname) {
      this.parentname = parentname;
   }

   public String getState() {
      return this.state;
   }

   public void setState(String state) {
      this.state = state;
   }

   public String getRegexType() {
      return this.regexType;
   }

   public void setRegexType(String regexType) {
      this.regexType = regexType;
   }

   public String getRegexName() {
      return this.regexName;
   }

   public void setRegexName(String regexName) {
      this.regexName = regexName;
   }

   public String getRuleId() {
      return this.ruleId;
   }

   public void setRuleId(String ruleId) {
      this.ruleId = ruleId;
   }

   public String getRuleName() {
      return this.ruleName;
   }

   public void setRuleName(String ruleName) {
      this.ruleName = ruleName;
   }

   public String getMatchRate() {
      return this.matchRate;
   }

   public void setMatchRate(String matchRate) {
      this.matchRate = matchRate;
   }

   public String getDistinctRate() {
      return this.distinctRate;
   }

   public void setDistinctRate(String distinctRate) {
      this.distinctRate = distinctRate;
   }

   public String getDistinctCount() {
      return this.distinctCount;
   }

   public void setDistinctCount(String distinctCount) {
      this.distinctCount = distinctCount;
   }

   public String getTotalCount() {
      return this.totalCount;
   }

   public void setTotalCount(String totalCount) {
      this.totalCount = totalCount;
   }

   public String getValidCount() {
      return this.validCount;
   }

   public void setValidCount(String validCount) {
      this.validCount = validCount;
   }

   public String getMatchCount() {
      return this.matchCount;
   }

   public void setMatchCount(String matchCount) {
      this.matchCount = matchCount;
   }

   public String getColumnChecked() {
      return this.columnChecked;
   }

   public void setColumnChecked(String columnChecked) {
      this.columnChecked = columnChecked;
   }

   public List<String> getMatchValues() {
      return this.matchValues;
   }

   public void setMatchValues(List<String> matchValues) {
      this.matchValues = matchValues;
   }

   public List<String> getNotMatchValues() {
      return this.notMatchValues;
   }

   public void setNotMatchValues(List<String> notMatchValues) {
      this.notMatchValues = notMatchValues;
   }

   public List<TreeGridSensitiveDataVO> getChildren() {
      return this.children;
   }

   public void setChildren(List<TreeGridSensitiveDataVO> children) {
      this.children = children;
   }

   public String getColumnId() {
      return this.columnId;
   }

   public void setColumnId(String columnId) {
      this.columnId = columnId;
   }

   public String getFlag() {
      return this.flag;
   }

   public void setFlag(String flag) {
      this.flag = flag;
   }

   public String getIconCls() {
      return this.iconCls;
   }

   public void setIconCls(String iconCls) {
      this.iconCls = iconCls;
   }

   public Map<String, TreeGridSensitiveDataVO> getChildrenMap() {
      return this.childrenMap;
   }

   public void setChildrenMap(Map<String, TreeGridSensitiveDataVO> childrenMap) {
      this.childrenMap = childrenMap;
   }

   public String getGroupId() {
      return this.groupId;
   }

   public void setGroupId(String groupId) {
      this.groupId = groupId;
   }
}
