package com.chenyang.nse.bussiness.enumeration.datamapping;

public enum EdataMappingType {
   ORACLE("ORACLE", "1"),
   MYSQL("MYSQL", "0"),
   DB2("DB2", "3"),
   MSSQLSERVER("MSSQLSERVER", "2"),
   RAPIDSDB("RAPIDSDB", "13"),
   FILESYSTEM("FILESYSTEM", "6"),
   HIVE("HIVE", "7"),
   OCEANBASE("OCEANBASE", "22"),
   INFORMIX("INFORMIX", "4"),
   SYBASE("SYBASE", "5"),
   SYBASE_IQ("SYBASE_IQ", "8"),
   TERADATA("TERADATA", "9"),
   MARIADB("MARIADB", "11"),
   GREENPLUM("GREENPLUM", "12"),
   KAFKA("KAFKA", "14"),
   DBF("DBF", "15"),
   POSTGRESQL("POSTGRESQL", "12"),
   DM("DM", "0");

   private String name;
   private String flag;

   private EdataMappingType(String name, String flag) {
      this.name = name;
      this.flag = flag;
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public String getFlag() {
      return this.flag;
   }

   public void setFlag(String flag) {
      this.flag = flag;
   }

   public static String getFlagByName(String name) {
      String flag = "";

      for(EdataMappingType em : values()) {
         if (name.equals(em.getName())) {
            flag = em.getFlag();
            break;
         }
      }

      return flag;
   }
}
