package com.chenyang.nse.bussiness.incencryption.service.impl;

import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.incencryption.model.EncryptionColumn;
import com.chenyang.nse.bussiness.incencryption.service.IncEncryptionTask;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncEncryptionTaskImpl implements IncEncryptionTask {
   protected Logger logger = LoggerFactory.getLogger(this.getClass());
   protected String projectId;
   protected String dataSystemId;
   protected String schema;
   protected String table;
   protected List<EncryptionColumn> encryptionColumns;
   protected TCoreDatasystem datasystem;

   public IncEncryptionTaskImpl(String projectId, String dataSystemId, String schema, String table, List<EncryptionColumn> encryptionColumns) {
      this.projectId = projectId;
      this.dataSystemId = dataSystemId;
      this.schema = schema;
      this.table = table;
      this.encryptionColumns = encryptionColumns;
   }

   public TCoreDatasystem getDatasystem() {
      return this.datasystem;
   }

   public IncEncryptionTaskImpl setDatasystem(TCoreDatasystem datasystem) {
      this.datasystem = datasystem;
      return this;
   }

   public String getTaskTag() {
      return this.projectId + ":" + this.dataSystemId + ":" + this.schema + ":" + this.table;
   }

   public void run() {
      if (this.encryptionColumns != null && this.encryptionColumns.size() != 0) {
         for(EncryptionColumn encryptionColumn : this.encryptionColumns) {
            this.encryptColumn(encryptionColumn.getColumnName(), encryptionColumn.getEncryptionType(), encryptionColumn.getSecretKey(), encryptionColumn.getIsLike(), encryptionColumn.getKeepfirst(), encryptionColumn.getEncdigit(), encryptionColumn.getTwoindex());
         }

      }
   }

   protected void encryptColumn(String column, String encryptionType, String secretKey, String isLike, String keepfirst, String encdigit, String twoindex) {
      try {
         Connection conn = JdbcTool.getConnection(this.datasystem);
         Throwable var9 = null;

         try {
            Statement stmt = conn.createStatement(1003, 1008);
            Throwable var11 = null;

            try {
               String batchFetchSql = this.buildBatchFetchSql(column);
               this.logger.info(batchFetchSql);

               while(true) {
                  ResultSet rs = stmt.executeQuery(batchFetchSql);
                  Throwable var14 = null;

                  try {
                     if (!rs.next()) {
                        return;
                     }

                     while(true) {
                        String plainText = rs.getString(column);
                        String cipherText = this.encrypt(encryptionType, secretKey, plainText, isLike, keepfirst, encdigit, twoindex);
                        rs.updateString(column + "_COPY", cipherText);
                        rs.updateRow();
                        if (!rs.next()) {
                           break;
                        }
                     }
                  } catch (Throwable var65) {
                     var14 = var65;
                     throw var65;
                  } finally {
                     if (rs != null) {
                        if (var14 != null) {
                           try {
                              rs.close();
                           } catch (Throwable var64) {
                              var14.addSuppressed(var64);
                           }
                        } else {
                           rs.close();
                        }
                     }

                  }
               }
            } catch (Throwable var67) {
               var11 = var67;
               throw var67;
            } finally {
               if (stmt != null) {
                  if (var11 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var63) {
                        var11.addSuppressed(var63);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var69) {
            var9 = var69;
            throw var69;
         } finally {
            if (conn != null) {
               if (var9 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var62) {
                     var9.addSuppressed(var62);
                  }
               } else {
                  conn.close();
               }
            }

         }
      } catch (Exception e) {
         this.logger.error(e.getMessage(), e);
         throw new IncEncryptionTaskException(e.getMessage(), e);
      }
   }

   protected String buildBatchFetchSql(String column) {
      StringBuffer buffer = new StringBuffer();
      buffer.append("SELECT * FROM " + this.schema + "." + this.table);
      buffer.append(" WHERE " + column + "_COPY IS NULL");
      buffer.append(" AND " + column + " IS NOT NULL");
      buffer.append(" LIMIT 1000");
      String batchFetchSql = buffer.toString();
      return batchFetchSql;
   }

   protected String encrypt(String encryptionType, String secretKey, String plainText, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      return null != encryptionType && !"".equals(encryptionType) ? EncProvider.encryptEcb(encryptionType, secretKey, plainText, isLike, keepfirst, encdigit, twoindex) : plainText;
   }

   public static class IncEncryptionTaskException extends RuntimeException {
      public IncEncryptionTaskException(String message, Throwable cause) {
         super(message, cause);
      }
   }
}
