package com.chenyang.nse.bussiness.init;

import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.service.core.PowerCenterFirstConnService;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class PowerCenterFirstConnect implements ApplicationListener<ContextRefreshedEvent> {
   @Autowired
   PowerCenterFirstConnService powerCenterFirstConnService;

   public void onApplicationEvent(ContextRefreshedEvent event) {
      if (event.getApplicationContext().getParent() == null) {
         String engineid = this.powerCenterFirstConnService.getEngineid();
         InfoProperty info = this.powerCenterFirstConnService.getInfoProperty(engineid);
         Runtime rn = Runtime.getRuntime();
         Process p = null;

         try {
            p = rn.exec(info.getPmrepexepath() + "connect -r " + info.getRepository() + " -d " + info.getDomainname() + " -n " + info.getUsername() + " -x " + info.getPassword());
            System.out.println(p.toString());
         } catch (IOException e) {
            e.printStackTrace();
         }

         InputStream is = p.getInputStream();

         try {
            p.waitFor();
         } catch (InterruptedException e) {
            e.printStackTrace();
         }

         try {
            is.close();
         } catch (IOException e) {
            e.printStackTrace();
         }

         p.destroy();
      }

   }
}
