package com.chenyang.nse.bussiness.interceptor;

import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseMenu;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class OperationInterceptor implements HandlerInterceptor {
   public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
      Object obj = request.getSession().getAttribute("loginUser");
      LoginUser loginUser = null;
      if (obj != null) {
         loginUser = (LoginUser)obj;
      }

      String s1 = request.getRealPath("./");
      String s2 = request.getRealPath("/");
      String s3 = request.getContextPath();
      String strDirPath = request.getSession().getServletContext().getRealPath("/");
      String ser = request.getServletPath();
      String url = request.getRequestURL().toString();
      String uri = request.getRequestURI();
      String ip = request.getHeader("x-forwarded-for");
      if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("Proxy-Client-IP");
      }

      if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("WL-Proxy-Client-IP");
      }

      if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("HTTP_CLIENT_IP");
      }

      if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("HTTP_X_FORWARDED_FOR");
      }

      if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getRemoteAddr();
      }

      if (loginUser == null) {
         response.setContentType("text/html");
         PrintWriter out = response.getWriter();
         String s = url.split(ser)[0];
         String js = "<script type=\"text/javascript\">top.location.href='" + s + "';</script>";
         out.println(js);
         return false;
      } else {
         List<String> menuurl = new ArrayList();

         for(TBaseMenu menu : loginUser.getMenus()) {
            for(TBaseMenu submenu : menu.getSubmenu()) {
               String tempurl = submenu.getUrl();
               menuurl.add(tempurl);
            }
         }

         for(String resourceurl : menuurl) {
            if (ser.startsWith(resourceurl)) {
               return true;
            }
         }

         response.setContentType("text/html");
         PrintWriter out = response.getWriter();
         String js = "<script type=\"text/javascript\">alert('访问资源不存在，或者你没有此资源的操作权限');</script>";
         out.println(js);
         return false;
      }
   }

   public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
   }

   public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
   }
}
