package com.chenyang.nse.bussiness.kms.model;

import com.chenyang.nse.bussiness.local.service.TestService;
import com.chenyang.nse.bussiness.tools.spring.SpringUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsSecretKeys {
   protected static final Logger logger = LoggerFactory.getLogger(KmsSecretKeys.class);
   private Map<String, KmsSecretKey> kmsSecretKeyMap = new ConcurrentHashMap();
   private static boolean initFlag = false;
   private static KmsSecretKeys instance = null;

   private KmsSecretKeys(Collection<KmsSecretKey> collection) {
      collection.stream().forEach((e) -> {
         KmsSecretKey var10000 = (KmsSecretKey)this.kmsSecretKeyMap.put(e.getTid(), e);
      });
   }

   public KmsSecretKey getKmsSecretKey(String id) {
      return (KmsSecretKey)this.kmsSecretKeyMap.get(id);
   }

   public void remove(String id) {
      this.kmsSecretKeyMap.remove(id);
   }

   public void put(KmsSecretKey kmsSecretKey) {
      this.kmsSecretKeyMap.put(kmsSecretKey.getTid(), kmsSecretKey);
   }

   public boolean contains(String id) {
      return this.kmsSecretKeyMap.containsKey(id);
   }

   public int size() {
      return this.kmsSecretKeyMap.size();
   }

   public static synchronized void init(Collection<KmsSecretKey> collection) {
      if (!initFlag) {
         instance = new KmsSecretKeys(collection);
         initFlag = true;
      }
   }

   public static KmsSecretKeys getInstance() {
      if (instance.kmsSecretKeyMap.size() == 0) {
         initialize();
      }

      return instance;
   }

   static synchronized void initialize() {
      if (instance.kmsSecretKeyMap.size() <= 0) {
         TestService service = (TestService)SpringUtil.getBean(TestService.class);
         service.initSecretKey();
      }
   }
}
