package com.chenyang.nse.bussiness.odbc.business;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import util.SqlUtil;

public class SQLParseApi implements OdbcApiCallable {
   public Object invoke(byte[] data) {
      ObjectMapper mapper = new ObjectMapper();

      try {
         Map<String, String> params = (Map)mapper.readValue(data, Map.class);
         SqlUtil util = new SqlUtil();
         params.put("encryption", "1");
         Map<String, Object> map = util.parseSqlStructure(params);
         if (map != null) {
            map.remove("statement");
         }

         return map;
      } catch (IOException e) {
         e.printStackTrace();
         return new HashMap();
      }
   }
}
