package com.chenyang.nse.bussiness.performance_monitor.service;

import com.chenyang.nse.bussiness.performance_monitor.entity.PerformanceMonitorBase;
import com.chenyang.nse.bussiness.performance_monitor.entity.PerformanceMonitorProcess;
import com.chenyang.nse.bussiness.performance_monitor.entity.PerformanceMonitorRecord;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public interface PerformanceMonitorService {
   void savePerformanceBase(PerformanceMonitorBase base);

   void savePerformanceProcesses(List<PerformanceMonitorProcess> process);

   List<PerformanceMonitorRecord> getRecordsByPage(int start, int end, String appName, String sql, String proxyName, String datasystemName, String startTime, String endTime, String appUser, String dbUser);

   List<PerformanceMonitorBase> getRecordsForDashBoard(String appName, String appUser, String startTime, String endTime);

   Integer getTotal(int start, int end, String appName, String sql, String proxyName, String datasystemName, String startTime, String endTime, String appUser, String dbUser);

   Map<String, List<String>> queryParams();

   Map<String, Integer> getAvgTimeBySql(String appUser, String appName, String startTime, String endTime);
}
