package com.chenyang.nse.bussiness.rulesupply.controller;

import com.chenyang.nse.bussiness.annot.PassToken;
import com.chenyang.nse.bussiness.tools.strategy.StrategyData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"core"})
public class MaskingStrategyController {
   protected Logger logger = LoggerFactory.getLogger(this.getClass());
   @Autowired
   protected StrategyData strategyData;

   @PassToken
   @RequestMapping({"/maskrule"})
   public void maskrule(@RequestParam(required = false) String projectid, HttpServletResponse response) throws IOException {
      this.logger.info("projectid={}", projectid);

      try {
         String strategyjson = this.strategyData.getDesensitizationStrategy(projectid, "1");
         byte[] strategybytes = strategyjson.getBytes(StandardCharsets.UTF_8);
         response.setContentType("application/json");
         response.setContentLength(strategybytes.length);
         response.addHeader("rescode", "0");
         response.addHeader("resinfo", "success");
         response.getOutputStream().write(strategybytes);
      } catch (Exception e) {
         this.logger.error(e.getMessage(), e);
         response.addHeader("rescode", "1");
         response.addHeader("resinfo", String.format("[%s][%s]", e.getClass().getName(), e.getMessage()));
      }

   }
}
