package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationDataSourcefieldDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationDataTargetfieldDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationDatamappingDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationDataSourcefield;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationDataTargetfield;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationDatamapping;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DesensitizationDataMappingServiceImpl implements DesensitizationDataMappingService {
   @Autowired
   private DesensitizationDatamappingDao desensitizationDatamappingDao;
   @Autowired
   private DesensitizationDataTargetfieldDao desensitizationDataTargetfieldDao;
   @Autowired
   private DesensitizationDataSourcefieldDao desensitizationDataSourcefieldDao;

   public List<Map<String, String>> getDatamappingInfo(String sourcesystemtype, String targetsystemtype) {
      List<Map<String, String>> list = this.desensitizationDatamappingDao.getDatamappingInfo(sourcesystemtype, targetsystemtype);
      return list;
   }

   public List<Map<String, String>> getDatamappingInfo1(PageInfo pageinfo, String sourcesystemtype, String targetsystemtype) {
      List<Map<String, String>> list = this.desensitizationDatamappingDao.getDatamappingInfo1(pageinfo, sourcesystemtype, targetsystemtype);
      return list;
   }

   public BigInteger getDatamappingCount(String sourcesystemtype, String targetsystemtype) {
      BigInteger count = this.desensitizationDatamappingDao.getDatamappingCount(sourcesystemtype, targetsystemtype);
      return count;
   }

   public DataGridVO<DesensitizationDatamapping> selectDatamappingInfo(PageInfo pageinfo, String sourcesystemtype, String targetsystemtype) {
      List<DesensitizationDatamapping> list = this.desensitizationDatamappingDao.queryByPageInfo(pageinfo, new Criterion[]{Restrictions.eq("datasystemtype", sourcesystemtype)});
      return new DataGridVO<DesensitizationDatamapping>(pageinfo.getCount(), list);
   }

   public List<DesensitizationDataTargetfield> getTargetFieldByType(String datasystemtype) {
      List<DesensitizationDataTargetfield> list = this.desensitizationDataTargetfieldDao.queryAll("fieldname", true, new Criterion[]{Restrictions.eq("datasystemtype", datasystemtype)});
      return list;
   }

   public void deletedatainfo(String mappingid, String sourceid) {
      if (mappingid != null && !"".equals(mappingid)) {
         this.desensitizationDatamappingDao.removeById(mappingid);
      }

      this.desensitizationDataSourcefieldDao.removeById(sourceid);
   }

   public void modifyDataInfo(Map<String, String> map) {
      String id = (String)map.get("id");
      String sourcefieldid = (String)map.get("sourcefieldid");
      String flag = (String)map.get("flag");
      String targetfieldid = (String)map.get("targetfieldid");
      String targetlength = (String)map.get("targetlength");
      String targetdecimal = (String)map.get("targetdecimal");
      String targetsystemtype = (String)map.get("targetsystemtype");
      String sourcesystemtype = (String)map.get("sourcesystemtype");
      String pwcsrclength = (String)map.get("pwcsrclength");
      String pwcsrcscale = (String)map.get("pwcsrcscale");
      String pwcsqlength = (String)map.get("pwcsqlength");
      String pwcsqscale = (String)map.get("pwcsqscale");
      String pwcdateformat = (String)map.get("pwcdateformat");
      String note = (String)map.get("note");
      String isdefault = (String)map.get("isdefault");
      String sourcedefault = (String)map.get("sourcedefault");
      DesensitizationDatamapping desensitizationDatamapping = new DesensitizationDatamapping();
      if (id != "" && id != null) {
         desensitizationDatamapping.setId(id);
      }

      desensitizationDatamapping.setSourcefieldid(sourcefieldid);
      desensitizationDatamapping.setFlag(flag);
      desensitizationDatamapping.setTargetfieldid(targetfieldid);
      desensitizationDatamapping.setTargetlength(flag.equals("1") ? targetlength : "");
      desensitizationDatamapping.setTargetdecimal(flag.equals("1") ? targetdecimal : "");
      desensitizationDatamapping.setTargetsystemtype(targetsystemtype);
      desensitizationDatamapping.setSourcesystemtype(sourcesystemtype);
      desensitizationDatamapping.setNote(note);
      desensitizationDatamapping.setIsdefault(isdefault);
      desensitizationDatamapping.setPwcsrclength(pwcsrclength);
      desensitizationDatamapping.setPwcsrcscale(pwcsrcscale);
      desensitizationDatamapping.setPwcsqlength(pwcsqlength);
      desensitizationDatamapping.setPwcsqscale(pwcsqscale);
      desensitizationDatamapping.setPwcdateformat(pwcdateformat);
      desensitizationDatamapping.setSourcedefault(sourcedefault);
      String sql_isdefault = "update desensitization_data_mapping set isdefault = 0     where targetfieldid = '" + targetfieldid + "' and sourcesystemtype = '" + sourcesystemtype + "'";
      String sql_sourcedefault = "update desensitization_data_mapping set sourcedefault = 0 where sourcefieldid in (SELECT id from desensitization_data_sourcefield where datasystemtype = '" + sourcesystemtype + "' and fieldname = (select fieldname from desensitization_data_sourcefield where id =  '" + sourcefieldid + "'))";
      if ("1".equals(isdefault)) {
         this.desensitizationDatamappingDao.updateIsdefault(sql_isdefault);
      }

      if ("1".equals(sourcedefault)) {
         this.desensitizationDatamappingDao.updateIsdefault(sql_sourcedefault);
      }

      this.desensitizationDatamappingDao.saveOrUpdate(desensitizationDatamapping);
   }

   public void insertDataInfo(Map<String, String> map) {
      DesensitizationDataSourcefield desensitizationDataSourcefield = new DesensitizationDataSourcefield();
      String fieldname = (String)map.get("fieldname");
      String datasystemtype = (String)map.get("datasystemtype");
      desensitizationDataSourcefield.setFieldname(fieldname);
      desensitizationDataSourcefield.setDatasystemtype(datasystemtype);
      this.desensitizationDataSourcefieldDao.save(desensitizationDataSourcefield);
   }

   public void removedatainfo(String sourcefieldid) {
      Criterion csourcefieldid = Restrictions.eq("sourcefieldid", sourcefieldid);
      this.desensitizationDatamappingDao.remove(new Criterion[]{csourcefieldid});
      this.desensitizationDataSourcefieldDao.removeById(sourcefieldid);
   }

   public List<Map<String, String>> getPwctypeBySourceType(String sourcesystemtype, String targetsystemtype, String sourcefieldname) {
      List<Map<String, String>> list = this.desensitizationDatamappingDao.getPwctypeBySourceType(sourcesystemtype, targetsystemtype, sourcefieldname);
      return list;
   }

   public List<Map<String, String>> getPwctypeBySourcelist(String sourcesystemtype, String targetsystemtype) {
      List<Map<String, String>> list = this.desensitizationDatamappingDao.getPwctypeList(sourcesystemtype, targetsystemtype);
      return list;
   }
}
