package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.base.TBaseGroupRoleDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseMenuDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseRoleDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseRolemenuDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserroleDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRolemenu;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserrole;
import com.chenyang.nse.bussiness.entity.vo.MenuGridVO;
import com.chenyang.nse.bussiness.service.console.RoleService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RoleServiceImpl implements RoleService {
   @Autowired
   private TBaseRoleDao tBaseRoleDao;
   @Autowired
   private TBaseUserroleDao tBaseUserroleDao;
   @Autowired
   private TBaseRolemenuDao tBaseRolemenuDao;
   @Autowired
   private TBaseMenuDao tBaseMenuDao;
   @Autowired
   private TBaseGroupRoleDao tBaseGroupRoleDao;

   public List<TBaseRole> queryRoleByFlag(String flag) {
      if (flag != null && !"".equals(flag)) {
         List<TBaseRole> list = this.tBaseRoleDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("flag", flag), Restrictions.ne("id", "1")});
         return list;
      } else {
         return this.tBaseRoleDao.queryAll(Order.desc("createtime"), new Criterion[0]);
      }
   }

   public List<TBaseRole> query(Map<String, Object> params, PageInfo pageInfo) {
      long count = this.tBaseRoleDao.count();
      pageInfo.setCount(count);
      String rolename = "";
      if (null != params && null != params.get("rolename")) {
         rolename = (String)params.get("rolename");
      }

      String remark = "";
      if (null != params && null != params.get("remark")) {
         remark = (String)params.get("remark");
      }

      Conjunction conjunction = Restrictions.conjunction();
      conjunction.add(Restrictions.like("rolename", rolename, MatchMode.ANYWHERE).ignoreCase());
      conjunction.add(Restrictions.like("remark", remark, MatchMode.ANYWHERE).ignoreCase());
      List<TBaseRole> list = this.tBaseRoleDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{conjunction});

      for(int i = 0; i < list.size(); ++i) {
         if ("1".equals(((TBaseRole)list.get(i)).getId())) {
            list.remove(list.get(i));
            pageInfo.setCount(count - 1L);
         }
      }

      return list;
   }

   public List<TBaseRole> queryAll() {
      Criterion croleid = Restrictions.ne("id", "1");
      List<TBaseRole> list = this.tBaseRoleDao.queryAll(new Criterion[]{croleid});
      return list;
   }

   public boolean checkNameExit(String rolename) {
      Criterion crolename = Restrictions.eq("rolename", rolename);
      long count = this.tBaseRoleDao.count(new Criterion[]{crolename});
      return count > 0L;
   }

   public TBaseRole queryRoleByUserId(String userid) {
      Criterion cuserid = Restrictions.eq("userid", userid);
      TBaseUserrole userrole = (TBaseUserrole)this.tBaseUserroleDao.queryUnique(new Criterion[]{cuserid});
      return userrole != null ? (TBaseRole)this.tBaseRoleDao.get(userrole.getRoleid()) : null;
   }

   public void save(TBaseRole role) {
      if (role.getId() == null) {
         role.setId(StringTool.getTablePrimaryKey());
         role.setCreateuser(CommonUtils.loginUsername());
         role.setCreatetime(new Date());
         this.tBaseRoleDao.save(role);
      } else {
         role.setUpdateuser(CommonUtils.loginUsername());
         role.setUpdatetime(new Date());
         this.tBaseRoleDao.save(role);
      }

   }

   public void remove(String id) {
      this.tBaseRoleDao.removeById(id);
      this.tBaseGroupRoleDao.remove(new Criterion[]{Restrictions.eq("roleid", id)});
   }

   public void deleteRoleMenuByRoleid(String roleid) {
      Criterion croleid = Restrictions.eq("roleid", roleid);
      List<TBaseRolemenu> list = this.tBaseRolemenuDao.queryAll(new Criterion[]{croleid});
      this.tBaseRolemenuDao.remove(list);
   }

   public void saveRoleMenu(List<String> menuidlist, String roleid) {
      String username = CommonUtils.loginUsername();

      for(String menuid : menuidlist) {
         TBaseRolemenu rolemenu = new TBaseRolemenu(roleid, menuid);
         rolemenu.setId(StringTool.getTablePrimaryKey());
         rolemenu.setCreateuser(username);
         rolemenu.setCreatetime(new Date());
         this.tBaseRolemenuDao.save(rolemenu);
      }

   }

   public void deleteRoleMenu(List<String> menuidlist, String roleid) {
      Criterion cmenuid = Restrictions.in("menuid", menuidlist);
      Criterion croleid = Restrictions.in("roleid", new Object[]{roleid});
      this.tBaseRolemenuDao.remove(new Criterion[]{cmenuid, croleid});
   }

   public List<TBaseRolemenu> queryMenuByRoleid(String roleid) {
      Criterion croleid = Restrictions.eq("roleid", roleid);
      return this.tBaseRolemenuDao.queryAll(new Criterion[]{croleid});
   }

   public List<MenuGridVO> queryMenuGridByRoleid(String roleid) {
      List<TBaseRolemenu> roleMenuList = this.tBaseRolemenuDao.queryAll(new Criterion[]{Restrictions.eq("roleid", roleid)});
      if (roleMenuList != null && roleMenuList.size() != 0) {
         List<String> menuList = new ArrayList();

         for(TBaseRolemenu troleMenu : roleMenuList) {
            menuList.add(troleMenu.getMenuid());
         }

         List<MenuGridVO> list = this.tBaseMenuDao.queryMenuGrid(menuList);
         return list;
      } else {
         return null;
      }
   }

   public int queryUserRoleCountByRoleId(String roleid) {
      Criterion croleid = Restrictions.eq("roleid", roleid);
      long count = this.tBaseUserroleDao.count(new Criterion[]{croleid});
      return Integer.valueOf(String.valueOf(count));
   }

   public TBaseRole queryRoleId(String roleid) {
      return (TBaseRole)this.tBaseRoleDao.get(roleid);
   }

   public List<TBaseRole> queryRolesByUserId(String userId) {
      if (StringUtils.isNotBlank(userId)) {
         return this.tBaseRoleDao.queryAll(Order.desc("createtime"), new Criterion[0]);
      } else {
         List<TBaseRole> uservolist = this.tBaseRoleDao.queryRolesByUserId(userId);
         return uservolist;
      }
   }

   public void updataRole(TBaseRole role) {
      TBaseRole tBaseRole = (TBaseRole)this.tBaseRoleDao.queryUnique(new Criterion[]{Restrictions.eq("id", role.getId())});
      tBaseRole.setRolename(role.getRolename());
      tBaseRole.setRemark(role.getRemark() == null ? "" : role.getRemark());
      tBaseRole.setUpdateuser(CommonUtils.loginUsername());
      tBaseRole.setUpdatetime(new Date());
      this.tBaseRoleDao.saveOrUpdate(tBaseRole);
   }
}
