package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.base.TBaseGroupDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseGroupMenuDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseGroupRoleDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUsergroupDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseGroup;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseGroupmenu;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseGrouprole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsergroup;
import com.chenyang.nse.bussiness.service.console.UserGroupService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(
   propagation = Propagation.REQUIRED
)
public class UserGroupServiceImpl implements UserGroupService {
   @Autowired
   private TBaseGroupDao tBaseGroupDao;
   @Autowired
   private TBaseUsergroupDao tBaseUsergroupDao;
   @Autowired
   private TBaseUserDao tBaseUserDao;
   @Autowired
   private TBaseGroupRoleDao tBaseGroupRoleDao;
   @Autowired
   private TBaseGroupMenuDao tBaseGroupMenuDao;

   public List<TBaseGroup> query(PageInfo pageInfo) {
      List<TBaseGroup> list = this.tBaseGroupDao.queryByPageInfo(pageInfo, Order.desc("createtime"));
      return list;
   }

   public List<TBaseGroup> query(PageInfo pageInfo, Map<String, Object> params) {
      List<TBaseGroup> list = new ArrayList();
      if (!params.isEmpty()) {
         if (null == params.get("groupname") || "".equals(params.get("groupname")) || null != params.get("remark") && !"".equals(params.get("remark"))) {
            if (null == params.get("remark") || "".equals(params.get("remark")) || null != params.get("groupname") && !"".equals(params.get("groupname"))) {
               if (null != params.get("remark") && !"".equals(params.get("remark")) && null != params.get("groupname") && !"".equals(params.get("groupname"))) {
                  Criterion cngroupname = Restrictions.like("groupname", params.get("groupname").toString(), MatchMode.ANYWHERE).ignoreCase();
                  Criterion cnremark = Restrictions.like("remark", params.get("remark").toString(), MatchMode.ANYWHERE).ignoreCase();
                  list = this.tBaseGroupDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{cngroupname, cnremark});
               } else {
                  list = this.tBaseGroupDao.queryByPageInfo(pageInfo, Order.desc("createtime"));
               }
            } else {
               Criterion cnremark = Restrictions.like("remark", params.get("remark").toString(), MatchMode.ANYWHERE).ignoreCase();
               list = this.tBaseGroupDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{cnremark});
            }
         } else {
            Criterion cngroupname = Restrictions.like("groupname", params.get("groupname").toString(), MatchMode.ANYWHERE).ignoreCase();
            list = this.tBaseGroupDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{cngroupname});
         }
      }

      return list;
   }

   public TBaseGroup queryGroupByGroupName(String groupname) {
      Criterion cgroupname = Restrictions.eq("groupname", groupname);
      TBaseGroup group = (TBaseGroup)this.tBaseGroupDao.queryUnique(new Criterion[]{cgroupname});
      return group == null ? null : group;
   }

   public boolean checkNameExit(String deptname) {
      Criterion cname = Restrictions.eq("groupname", deptname);
      long count = this.tBaseGroupDao.count(new Criterion[]{cname});
      return count > 0L;
   }

   @Transactional
   public void save(TBaseGroup group) {
      if (group.getId() == null) {
         group.setId(StringTool.getTablePrimaryKey());
         group.setCreateuser(CommonUtils.loginUsername());
         group.setCreatetime(new Date());
         this.tBaseGroupDao.save(group);
      } else {
         TBaseGroup tBaseGroup = (TBaseGroup)this.tBaseGroupDao.queryUnique(new Criterion[]{Restrictions.eq("id", group.getId())});
         tBaseGroup.setRemark(group.getRemark());
         tBaseGroup.setGroupname(group.getGroupname());
         tBaseGroup.setUpdateuser(CommonUtils.loginUsername());
         tBaseGroup.setUpdatetime(new Date());
         this.tBaseGroupDao.saveOrUpdate(tBaseGroup);
      }

   }

   @Transactional
   public TBaseGroup saveGroup(TBaseGroup group) {
      if (group.getId() == null) {
         group.setId(StringTool.getTablePrimaryKey());
         group.setCreatetime(new Date());
         group.setCreateuser(CommonUtils.loginUsername());
         if (null == group.getRemark()) {
            group.setRemark("");
         }

         this.tBaseGroupDao.save(group);
      } else {
         group.setUpdateuser(CommonUtils.loginUsername());
         group.setUpdatetime(new Date());
         this.tBaseGroupDao.saveOrUpdate(group);
      }

      return group;
   }

   @Transactional
   public void saveGroupRole(TBaseGroup group, List<String> idList) {
      Criterion groupidCn = Restrictions.eq("groupid", group.getId());
      this.tBaseGroupRoleDao.remove(new Criterion[]{groupidCn});
      Map<String, String> map = new HashMap();

      for(int i = 0; i < idList.size(); ++i) {
         if (!map.containsKey(idList.get(i))) {
            TBaseGrouprole tBaseGrouprole = new TBaseGrouprole();
            tBaseGrouprole.setId(StringTool.getTablePrimaryKey());
            tBaseGrouprole.setGroupid(group.getId());
            tBaseGrouprole.setRoleid((String)idList.get(i));
            tBaseGrouprole.setCreatetime(new Date());
            tBaseGrouprole.setCreateuser(CommonUtils.loginUsername());
            this.tBaseGroupRoleDao.save(tBaseGrouprole);
         }
      }

   }

   public TBaseGroup queryGroupByid(String groupid) {
      TBaseGroup queryUnique = (TBaseGroup)this.tBaseGroupDao.queryUnique(new Criterion[]{Restrictions.eq("id", groupid)});
      return queryUnique;
   }

   public List<TBaseGrouprole> querygroupRoleBygroupid(String groupid) {
      return this.tBaseGroupRoleDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupid)});
   }

   public List<TBaseGroupmenu> querygroupMenuBygroupid(String groupid) {
      return this.tBaseGroupMenuDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupid)});
   }

   @Transactional
   public void saveGroupMenu(TBaseGroup group, List<String> idList) {
      Criterion groupidCn = Restrictions.eq("groupid", group.getId());
      this.tBaseGroupMenuDao.remove(new Criterion[]{groupidCn});

      for(int i = 0; i < idList.size(); ++i) {
         TBaseGroupmenu tBaseGroupmenu = new TBaseGroupmenu();
         if (tBaseGroupmenu.getId() == null) {
            tBaseGroupmenu.setId(StringTool.getTablePrimaryKey());
            tBaseGroupmenu.setGroupid(group.getId());
            tBaseGroupmenu.setMenuid((String)idList.get(i));
            tBaseGroupmenu.setCreatetime(new Date());
            tBaseGroupmenu.setCreateuser(CommonUtils.loginUsername());
            this.tBaseGroupMenuDao.save(tBaseGroupmenu);
         }
      }

   }

   public void saveUserGroup(TBaseUsergroup userGroup) {
      userGroup.setId(StringTool.getTablePrimaryKey());
      userGroup.setCreatetime(new Date());
      userGroup.setCreateuser(CommonUtils.loginUsername());
      this.tBaseUsergroupDao.save(userGroup);
   }

   public void removeGroupByid(String groupid) {
      this.tBaseGroupDao.removeById(groupid);
      Criterion groupidCn = Restrictions.eq("groupid", groupid);
      this.tBaseGroupRoleDao.remove(new Criterion[]{groupidCn});
      this.tBaseGroupMenuDao.remove(new Criterion[]{groupidCn});
      this.tBaseUsergroupDao.remove(new Criterion[]{groupidCn});
   }

   public List<TBaseUsergroup> queryUsergroupBygroupid(String groupid) {
      return this.tBaseUsergroupDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupid)});
   }

   public TBaseGroup queryGroupByFlag(String flag) {
      Criterion cflag = Restrictions.eq("flag", flag);
      return (TBaseGroup)this.tBaseGroupDao.queryUnique(new Criterion[]{cflag});
   }

   public void removeUserGroupByUserId(String userid) {
      this.tBaseUsergroupDao.removeUserGroupByUserId(userid);
   }

   public List<TBaseGroup> queryallgroups() {
      return this.tBaseGroupDao.queryAll(Order.desc("createtime"), new Criterion[0]);
   }

   public TBaseGroup queryGroupByUserId(String userId) {
      Criterion cuserid = Restrictions.eq("userid", userId);
      TBaseUsergroup usergroup = (TBaseUsergroup)this.tBaseUsergroupDao.queryUnique(new Criterion[]{cuserid});
      if (usergroup == null) {
         return null;
      } else {
         TBaseGroup group = (TBaseGroup)this.tBaseGroupDao.get(usergroup.getGroupid());
         return group;
      }
   }

   public List<TBaseUser> queryUserByGroupId(String groupId) {
      List<String> userid = this.tBaseUsergroupDao.queryUserIdListByGroupId(groupId);
      List<TBaseUser> list = null;
      if (userid != null && userid.size() > 0) {
         Criterion cuserid = Restrictions.in("id", userid);
         list = this.tBaseUserDao.queryAll(new Criterion[]{cuserid});
      }

      return list;
   }

   public void remove(List<String> idlist) {
      Criterion cdefault = Restrictions.eq("flag", "1");
      TBaseGroup dgroup = (TBaseGroup)this.tBaseGroupDao.queryUnique(new Criterion[]{cdefault});
      if (dgroup != null) {
         Criterion cgroupid = Restrictions.in("groupid", idlist);

         for(TBaseUsergroup item : this.tBaseUsergroupDao.queryAll(new Criterion[]{cgroupid})) {
            item.setGroupid(dgroup.getId());
            this.tBaseUsergroupDao.saveOrUpdate(item);
         }

         Criterion cid = Restrictions.in("id", idlist);
         this.tBaseGroupDao.remove(new Criterion[]{cid});
      }
   }
}
