package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.table.console.TXmlFileDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.TXmlFile;
import com.chenyang.nse.bussiness.service.console.XmlEditService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class XmlEditServiceImpl implements XmlEditService {
   @Autowired
   private TXmlFileDao tXmlFileDao;

   public List<TXmlFile> getXmlList(Map<String, Map<String, String>> list) {
      List<TXmlFile> fileList = new ArrayList();

      for(String str : list.keySet()) {
         Map<String, String> childrens = (Map)list.get(str);

         for(String entry : childrens.keySet()) {
            TXmlFile obj = new TXmlFile();
            obj.setPgroup(str);
            obj.setPname(entry);
            obj.setPvalue((String)childrens.get(entry));
            fileList.add(obj);
            this.tXmlFileDao.saveOrUpdate(obj);
         }
      }

      return fileList;
   }
}
