package com.chenyang.nse.bussiness.service.core;

import com.chenyang.nse.bussiness.entity.orm.table.core.datamap.TCoreDatamap;
import com.chenyang.nse.bussiness.entity.orm.table.core.datamap.TCoreDatamapColumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.datamap.TCoreDatamapTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.datamap.TCoreDatamapTablealias;
import com.chenyang.nse.bussiness.entity.orm.table.core.datamap.TCoreDatamapTablerelation;
import com.chenyang.nse.bussiness.entity.orm.table.core.datamap.TCoreDatamapUsermap;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.entity.vo.TreeVO;
import java.sql.Connection;
import java.util.List;

public interface DataMapService {
   Connection getConnectionByDataSystemId(String datasystemid);

   List<TreeVO> initTree(String flag, String code, String text, String parentid, String alias, String userid);

   List<TreeVO> initUserTree(String flag, String code, String text, String parentid, String alias, String userid);

   TCoreDatamap queryDataMap(String datamapid);

   TCoreDatamap queryDataMapUnique(String datasystemid, String dbschema);

   void generateDataMap(String datasystemid, String schema);

   void removeDataMap(String datamapid);

   void removeDataMap(String datasystemid, String schema);

   List<TCoreDatamapTable> queryDataMapTable(String datamapid);

   List<TCoreDatamapTable> queryDataMapUserTable(String datamapid, String userid);

   List<TCoreDatamapTable> queryDataMapUserTable(String datamapid, String userid, String excludetable);

   List<TCoreDatamapTable> queryDataMapTable(String datamapid, String excludetable);

   TCoreDatamapTable queryDataMapTable(String datasystemid, String schema, String table);

   TCoreDatamapTable queryDataMapTableById(String tableid);

   List<TCoreDatamapTablerelation> queryDataMapTableRelation(String datamapid);

   TCoreDatamapTablerelation queryTableRelation(String datamapid, String sourcetableid, String targettableid);

   TCoreDatamapTablealias setTableAlias(String datasystemid, String schema, String table, String alias);

   void synchronizeDataMapTableAlias(TCoreDatamapTablealias tableAlias);

   List<TCoreDatamapColumn> queryDataMapColumnById(String tablerelationid);

   void saveDataMapTableRelation(String datamapid, String sourcetableid, String targettableid);

   void saveDataMapUserMap(TCoreDatamapUsermap usermap);

   void removeUserMap(String datamapid, String tableid, String userid);

   void saveTableNote(TCoreDatamapTable table);

   void saveColumnNote(TCoreDatamapColumn column);

   TCoreMaskingTask queryMaskingTask(String engineid, String taskname);

   TCoreMaskingTask saveTask(String userid, String engineid, String folderName, String taskname, String note, String tableid, String datatargetid, String datatargetschema, String targetTableName);
}
