package com.chenyang.nse.bussiness.service.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreParameter;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingDetailrecord;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingFilesystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingHive;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.temporary.TCoreMonitorTemporary;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.TreeGridSensitiveDataVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TCoreMaskingFilesystemVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TCoreMaskingTaskVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TaskRecordVO;
import java.sql.Connection;
import java.util.List;
import java.util.Map;

public interface MaskingTaskService {
   TCoreMaskingTask queryMaskingTaskById(String id);

   TCoreMaskingTable queryTableByTaskId(String taskid);

   TCoreMaskingRule queryMaskingRuleById(String id);

   TCoreMaskingTask queryTaskByName(String taskname);

   TCoreMaskingTask queryEngineMaskingTaskByTaskName(String engineid, String taskname);

   List<TCoreParameter> queryParameterByMaskingTableId(String maskingtableid);

   void modifyTask(TCoreMaskingTask task);

   void updateTask(String taskid, String ispass);

   void removeNoNameTask(String engineid);

   TCoreMaskingTask queryTaskByTname(String tname);

   List<TCoreMaskingTask> queryAllTask();

   List<TreeGridSensitiveDataVO> querySensitiveColumnsByGroupId(String groupId);

   TCoreSensitivecolumn getSensitiveColumn(String datasystemid, String schema, String table, String column);

   List<TCoreMaskingDetailrecord> querytablerecord(String recordid);

   List<TaskRecordVO> querytaskrecord(String taskid);

   int getLines(String targetname);

   ResultVO addAndModifyMaskingTask(Map<String, String> map);

   void removeTask(String taskid);

   List<TCoreMaskingTask> queryTask(String engineid, String taskname, PageInfo pageInfo);

   List<TCoreMaskingTask> queryTaskList(String engineid, String taskname);

   List<TCoreMaskingTask> queryTaskList(String taskid);

   List<TCoreMonitorTemporary> queryTasktmpo(String taskid, String groupid, PageInfo pageInfo, int index);

   List<TCoreMonitorTemporary> queryTasktmpoNew(String taskid, String groupid, PageInfo pageInfo, int index);

   List<TCoreMonitorTemporary> queryTasktmpoCoreIndex(String taskid);

   boolean stopwork(String taskid);

   InfoProperty getInfoProperty(TCoreMaskingTask task);

   InfoProperty getInfoPropertySelf(TCoreMaskingselfTask task);

   Connection getConnectionByDataSystemId(String datasystemid);

   List<TCoreDatasystem> queryFTP();

   List<TCoreDatasystem> querySFTP();

   TCoreMaskingTask queryMaskingTaskByID(String taskid);

   TCoreMaskingTaskVO queryMaskingTaskVOByID(String taskid);

   Map<String, Object> queryTaskDetailInfo(String taskid, String datadirection, String flag, String tasktype);

   List<Map<String, Object>> querySingleTable(String sourceid, String sourceflag, String targetid, String targetflag);

   List<Map<String, Object>> queryMultiTable(String sourceid, String sourceflag);

   TCoreMaskingFilesystem queryMaskingFilesystemByID(String filesystemid);

   ResultVO copyTableByFile(String filestructureid, String tdatasystem, String tschema, String ttable);

   List<TCoreMaskingTable> queryMaskingTable(String taskid, String direction);

   List<TCoreMaskingHive> queryMaskingHive(String taskid, String direction);

   List<TCoreMaskingFilesystemVO> queryMaskingFile(String taskid, String direction);

   TCoreMonitorTemporary gettmp(String tmpid);

   Map<String, Object> queryMultiDBSourceMapping(String taskid, String[] tablename);

   Map<String, Object> queryMultiHiveSourceMapping(String taskid, String[] tablename);

   Map<String, Object> queryMultiFSSourceMapping(Map<String, String> map);

   Map<String, Object> queryMultiDbToFsStructure(String taskid);

   List<ColumnInfo> queryTableColumName(String taskid, String sourceid);

   List<TCoreMaskingTask> queryTaskListByIndex(String engineid, String taskname);

   List<Map<String, Object>> querySingleDbMapping(String taskid, String sourceflag, String targetflag);

   void removeRecord(String taskid);

   List<TCoreMonitorTemporary> queryTCoreMonitorTemporaryList(String taskid);

   void update(TCoreMonitorTemporary temporary);

   List queryTaskVersionList(String taskId);

   String stopWorkflow(String taskid, String name);
}
