package com.chenyang.nse.bussiness.service.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreComplianceDirectory;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataScope;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiveLevel;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreColumnKey;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreScopeDirectory;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreTableField;
import com.chenyang.nse.bussiness.entity.vo.ProgressInfo;
import com.chenyang.nse.bussiness.entity.vo.TreeVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.AssignmentNameVO;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface SearchFieldService {
   List<TConsoleSearchregex> query(PageInfo pageInfo);

   void saveData(List<String> datascope, Map<String, String> map, TCoreDatasystem datasystem, List<String> table, String schema, String edition_id, String findtaskId, List<String> dataAreaList, List<String> editionScopeList, String editionsearchId, String scopestate, String projectId, String version, String datasourceid);

   List<TCoreComplianceDirectory> getComplianceDirectory();

   List<TCoreSensitiveLevel> getSensitiveLevel();

   List<TCoreDataScope> getDataScope();

   void searchTablelist(String s, String checksure, String schemaTable, String columnname, String sensitivesearch, String compliancesearch, String datascopesearch, Set<Object> zrange);

   List<AssignmentNameVO> assignmentNameVO(PageInfo pageInfo, String taskname);

   void toSaveRedis(String s) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

   List<TCoreScopeDirectory> getScopeDirectory();

   List<TreeVO> queryDataScopeTree();

   String getdatasystemid(String taskname);

   void deleteDiscoverytask(String id);

   List<TCoreTableField> query(List<String> tablename, String schema);

   List<HashMap<String, String>> getScopeField(Map<String, Object> parameter);

   void saveColumnType(List<String> dataColumList, List<String> datascoTidList, boolean isCustomVersion) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

   void removeColumnType(String contid, String setuptype);

   List<HashMap<String, String>> isSureColumn(String datasystem_id, String schema, String table, String name, String projectId);

   void toSureRedisColumn(List<String> dataColumList, List<String> datascoTidList);

   String getScopecount(String dataSystemId, String tableName, String schemaName, String filedName);

   String getSensitivecount(String dataSystemId, String tableName, String schemaName, String filedName);

   String getCompliancecount(String dataSystemId, String tableName, String schemaName, String filedName);

   List getScopeInfo(String dataSystemId, String tableName, String schemaName, String filedName);

   List getSensitiveInfo(String dataSystemId, String tableName, String schemaName, String filedName);

   List getComplianceInfo(String dataSystemId, String tableName, String schemaName, String filedName);

   void getAllTableColumnsByName(Map<String, String> map, String continuestate, String taskname, TCoreDatasystem datasystem, List<String> table, String schemas, ProgressInfo progressInfo, String s, String findtaskId, List<String> dataAreaList, List<String> editionScopeList, String editionsearchId, String setuptype, String versions);

   List<TCoreColumnKey> getColumnKey(String id);

   void clearColumnKey(String s);

   List<TCoreColumnKey> getColumnKeyByPage(String s, int rows, int page);

   void removeSingle(String setuptype, String singleid);

   String isDatascope(String isDatascope);

   void addScopeLog(List<String> dataColumList, List<String> datascoTidList, String scope_category, List<String> datascoLevelTidList, List<String> dataLevelColumList) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;
}
