package com.chenyang.nse.bussiness.service.core.backup.impl;

import cn.hutool.core.util.ObjectUtil;
import com.chenyang.nse.bussiness.dao.core.TCoreDataSourceSchemaDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.ColumnPrimaryKeyInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.ColumnPrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDataBackUpVO;
import com.chenyang.nse.bussiness.service.core.backup.DataBackUpService;
import com.chenyang.nse.bussiness.service.core.encryption.EncryptionConfigService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataBackUpServiceImpl implements DataBackUpService {
   @Autowired
   TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao;
   @Autowired
   TCoreDataSourceSchemaDao tCoreDatasourceSchemaDao;
   @Autowired
   TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   EncryptionConfigService encryptionConfigService;
   @Autowired
   ColumnPrimaryKeyInfoDao columnPrimaryKeyInfoDao;

   public String checkTable(TCoreDataBackUpVO params) {
      String projectId = params.getProjectId();
      String datasystemId = params.getDatasystemId();
      String schemaName = params.getSchemaName();

      for(String tableName : params.getTableName()) {
         List<TCoreEncryptionTypeField> sourceFields = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", datasystemId), Restrictions.eq("tschemas", schemaName), Restrictions.eq("names", tableName)});
         List<TCoreEncryptionTypeField> targetFields = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", params.getR_projectId()), Restrictions.eq("datasystem_id", params.getR_datasystemId()), Restrictions.eq("tschemas", params.getR_schemaName()), Restrictions.eq("names", tableName), Restrictions.eq("flag", "5")});

         for(TCoreEncryptionTypeField sourceField : sourceFields) {
            for(TCoreEncryptionTypeField targetField : targetFields) {
               if (targetField.getTable_field_id() != null && sourceField.getTable_field_id() != null && targetField.getTable_field_id().equalsIgnoreCase(sourceField.getTable_field_id())) {
                  return tableName + "." + sourceField.getTable_field_id();
               }
            }
         }
      }

      return null;
   }

   public void dataSync(TCoreDataBackUpVO params) {
      String projectId = params.getProjectId();
      String datasystemId = params.getDatasystemId();
      String schemaName = params.getSchemaName();
      List<String> tableList = params.getTableName();
      new ArrayList();

      for(String tableName : tableList) {
         for(TCoreEncryptionTypeField tCoreEncryptionTypeField : this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", datasystemId), Restrictions.eq("tschemas", schemaName), Restrictions.eq("names", tableName)})) {
            ColumnPrimaryKeyInfo columnPrimaryKeyInfo = (ColumnPrimaryKeyInfo)this.columnPrimaryKeyInfoDao.queryUnique(new Criterion[]{Restrictions.eq("project_id", projectId), Restrictions.eq("datasystem_id", datasystemId), Restrictions.eq("tschema", schemaName), Restrictions.eq("tname", tableName)});
            TCoreEncryptionTypeField t1 = new TCoreEncryptionTypeField();
            t1.setTable_field_id(tCoreEncryptionTypeField.getTable_field_id());
            t1.setNames(tableName);
            t1.setProjectid(params.getR_projectId());
            t1.setDatasystem_id(params.getR_datasystemId());
            t1.setTschemas(params.getR_schemaName());
            t1.setFlag("0");
            t1.setCreatetime(new Date());
            t1.setEncryption_secretkey_id(tCoreEncryptionTypeField.getEncryption_secretkey_id());
            t1.setDataareaid(tCoreEncryptionTypeField.getDataareaid());
            t1.setCombination_id(tableName + tCoreEncryptionTypeField.getTable_field_id());
            t1.setDescribe_info(tCoreEncryptionTypeField.getDescribe_info());
            t1.setColumn_size(tCoreEncryptionTypeField.getColumn_size());
            t1.setColumn_type(tCoreEncryptionTypeField.getColumn_type());
            t1.setState("0");
            t1.setDataareaname(tCoreEncryptionTypeField.getDataareaname());
            List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList1 = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", params.getR_projectId()), Restrictions.eq("datasystem_id", params.getR_datasystemId()), Restrictions.eq("tschemas", params.getR_schemaName()), Restrictions.eq("names", tableName), Restrictions.eq("table_field_id", tCoreEncryptionTypeField.getTable_field_id())});
            if (tCoreEncryptionTypeFieldList1.size() > 0) {
               TCoreEncryptionTypeField TCoreEncryptionTypeField2 = (TCoreEncryptionTypeField)tCoreEncryptionTypeFieldList1.get(0);
               TCoreEncryptionTypeField2.setEncryption_secretkey_id(tCoreEncryptionTypeField.getEncryption_secretkey_id());
               this.tCoreEncryptionTypeFieldDao.update(TCoreEncryptionTypeField2);
            } else {
               if (!ObjectUtil.isEmpty(columnPrimaryKeyInfo)) {
                  columnPrimaryKeyInfo.setProject_id(params.getR_projectId());
                  columnPrimaryKeyInfo.setDatasystem_id(params.getR_datasystemId());
                  columnPrimaryKeyInfo.setTschema(params.getR_schemaName());
                  columnPrimaryKeyInfo.setTname(tableName);
                  this.columnPrimaryKeyInfoDao.save(columnPrimaryKeyInfo);
               }

               this.tCoreEncryptionTypeFieldDao.save(t1);
            }
         }
      }

   }
}
