package com.chenyang.nse.bussiness.service.core.dataproject.impl;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.controller.core.dataproject.ExecuteDiscoverytaskController;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDictionaryDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSearchregexDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreCurrencyInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDataFileGroupDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreSecretkeyDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreTaskFindruleDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TcoreDiscoveryDataResultDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TcoreDiscoveryResultsRecordDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.EncryptionConfigDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructureDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurespliterDao;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.db.ForeignKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreCurrencyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataFileGroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFileDetail;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TableJoinsInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryColumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryDataResult;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryResult;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreTaskFindrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryption;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurespliter;
import com.chenyang.nse.bussiness.entity.vo.ProgressInfo;
import com.chenyang.nse.bussiness.entity.vo.SensitiveColumn;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreProjectVersionVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.TdataDiscoveryService;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.service.core.dataproject.ExecuteDiscoverytaskService;
import com.chenyang.nse.bussiness.service.core.dataproject.TableJoinsInfoService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.correlation.CorrelationTool;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpTool;
import com.chenyang.nse.bussiness.tools.dmp.TableStructureInfo;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import com.chenyang.nse.bussiness.tools.es.EsUtil;
import com.chenyang.nse.bussiness.tools.excel.ReadExcelTool;
import com.chenyang.nse.bussiness.tools.filesystem.UnknownFileStruTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MongodbTool;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.net.FtpTool;
import com.chenyang.nse.bussiness.tools.net.SFTPUtil;
import com.chenyang.nse.bussiness.tools.net.SSHTool;
import com.chenyang.nse.bussiness.tools.number.IdnoTool;
import com.chenyang.nse.bussiness.tools.number.MobileNumberTool;
import com.chenyang.nse.bussiness.tools.redis.CacheUtil;
import com.chenyang.nse.bussiness.tools.sql.SqlFileTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.xml.ReadAllXmlTool;
import com.chenyang.nse.bussiness.tools.xml.ReadJsonTool;
import com.chenyang.nse.bussiness.tools.xml.TxtTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.mongodb.MongoClient;
import dm.jdbc.desc.Column;
import dm.jdbc.driver.DmdbNClob;
import dm.jdbc.driver.DmdbResultSetMetaData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ExecuteDiscoverytaskServiceImpl implements ExecuteDiscoverytaskService {
   @Autowired
   private TConsoleDictionaryDao tConsoleDictionaryDao;
   @Autowired
   private TcoreDiscoveryDataResultDao tcoreDiscoveryDataResultDao;
   @Autowired
   private RedisService redisService;
   @Autowired
   private TCoreFileStructurespliterDao tCoreFileStructurespliterDao;
   @Autowired
   private TCoreFileStructureDao tCoreFileStructureDao;
   @Autowired
   private TCoreFileStructurecolumnDao tCoreFileStructurecolumnDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TcoreDiscoveryResultsRecordDao tcoreDiscoveryResultsRecordDao;
   @Autowired
   private TCoreCurrencyInfoDao tCoreCurrencyInfoDao;
   @Autowired
   private TCoreDataFileGroupDao tCoreDataFileGroupDao;
   @Autowired
   private TConsoleSearchregexDao tConsoleSearchregexDao;
   @Autowired
   private TCoreTaskFindruleDao tCoreTaskFindruleDao;
   @Autowired
   private TdataDiscoveryService tdataDiscoveryService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private DesensitizationDataMappingService desensitizationDataMappingService;
   @Autowired
   private TableJoinsInfoService tableJoinsInfoService;
   @Autowired
   private ExecuteDiscoverytaskService executeDiscoverytaskService;
   @Autowired
   private TdataProjectService tdataProjectService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao;
   @Autowired
   private TCoreSecretkeyDao tCoreSecretkeyDao;
   @Autowired
   private TCoreEncryptionDao tCoreEncryptionDao;
   @Autowired
   private EncryptionConfigDao encryptionConfigDao;
   private static final String issure_N = "0";
   private static final String issure_Y = "1";
   private static final String issure_W = "2";
   private static final String issure_B = "3";
   private volatile List<String> vlist = new ArrayList();
   public static final String CURRENCY_TYPECODE = "18";
   public static final String FLOAT_TYPECODE = "19";
   public static final String NATION_TYPECODE = "20";
   public static final String MARRY_TYPECODE = "21";
   private static final String tdatadiscovery = "TdataDiscoveryIntelligence";
   public static final String TASKSTATUS_DONE = "0";
   public static final String TASKSTATUS_DOING = "1";
   public static final String TASKSTATUS_ERROR = "2";
   public static final String TASKSTATUS_STOP = "3";
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");
   private static final Logger handleprocessLogger = LoggerFactory.getLogger("handleprocessLogger");
   private Map<String, Method> methods = new HashMap();
   private int yearNow = 2100;
   private Pattern phoneNoReplacePattern;
   private Pattern allChinesePattern;
   private List<String> singleFirstNameList;
   private List<String> doubleFirstNameList;
   private Pattern allEnglishPattern;
   private List<String> nationality;
   private List<String> religionList;
   private List<String> nationList;
   private List<String> politicList;
   private List<String> birthAddress;
   private Pattern diplomapattern;
   private List<String> diplomaList;
   private List<String> diplomanoList;
   private List<String> socialList;
   private List<String> socialList1;
   private Pattern ip4Pattern;
   private List<String> firstSixNumList;
   private Pattern identifyNoPattern;
   private SimpleDateFormat identifyNoDateFormat;
   private int[] identifyNoFactors = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
   private char[] identifyNoResults = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
   private Pattern chineseAddressPattern;
   private Pattern chineseAddressPatternFirstSix;
   private Pattern chineseAddressPatternFirstThree;
   private Pattern telephoneNoSimplePattern;
   private Pattern isContainsChineseOrEnglish;
   private Pattern telephoneNoPattern;
   private Pattern mobilephoneNoSimplePattern;
   private List<String> firstThreeNoList;
   private Pattern phoneNoSimplePattern;
   private Pattern emailPattern;
   private Pattern emailPrefix;
   private Pattern emailSuffix;
   private Pattern companyNamePattern;
   private Pattern shopNamePattern;
   private List<String> postCodeList;
   private Pattern postCodePattern6;
   private int[] factors = new int[]{3, 7, 9, 10, 5, 8, 4, 2};
   private Pattern organizationCodePattern;
   private Pattern cardNoPattern;
   private Pattern taxCodePattern15;
   private Pattern taxCodePattern20;
   private List<String> zoneCodeList;
   private Pattern businessLicenseCodePattern;
   private List<String> ticketList;

   public void execute(String taskid, String projectid, String version, String userid, String username, Boolean isAssignTable, List<TcoreDiscoveryColumn> columnList) {
      long startTime = System.currentTimeMillis();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e1) {
         e1.printStackTrace();
      }

      String monitorDir = props.getProperty("monitorFile");
      String rateDir = props.getProperty("rateDir");
      CacheUtil.delCacheValue(taskid + "tableSum");
      CacheUtil.delCacheValue(taskid + "tableCount");
      if (!isAssignTable) {
         this.tdataDiscoveryService.updateTaskstatus(taskid, "1", version);
      }

      ExecuteDiscoverytaskController.tasklogger.info(MesUtil.getMsg("DIS_002", new String[0]));
      new TcoreDiscoveryTask();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      List<Map<String, Object>> sensitiveRule = this.tdataProjectService.querySensitiveRuleList(projectid);
      ExecuteDiscoverytaskController.tasklogger.info(MesUtil.getMsg("DIS_003", new String[0]));
      Map<String, String> map = new HashMap();
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

      try {
         TcoreDiscoveryTask discoveryTask = this.tdataDiscoveryService.queryTaskByid(taskid);
         ExecuteDiscoverytaskController.tasklogger.info(MesUtil.getMsg("DIS_004", new String[0]));
         List<TcoreTaskFindrule> discoveryRule = this.tdataDiscoveryService.queryFindrulelist(taskid);
         ExecuteDiscoverytaskController.tasklogger.info(MesUtil.getMsg("DIS_005", new String[0]));
         if (!isAssignTable) {
            this.executeDiscoverytaskService.delFile(monitorDir + projectid + File.separator + taskid);
            this.executeDiscoverytaskService.delDiscoveryResult(discoveryTask.getResultid());
            this.executeDiscoverytaskService.delDiscoveryDataResult(taskid);
            if (StringUtils.isBlank(version)) {
               this.executeDiscoverytaskService.delFile(rateDir + "match" + File.separator + projectid + File.separator + taskid);
               this.executeDiscoverytaskService.delFile(rateDir + "unmatched" + File.separator + projectid + File.separator + taskid);
            }
         }

         ExecuteDiscoverytaskController.tasklogger.info(MesUtil.getMsg("DIS_006", new String[0]));
         if ("2".equals(discoveryTask.getDiscoverytype())) {
            List<TCoreProjectFile> discoveryFile = this.tdataDiscoveryService.queryFilelist(taskid);
            if ("unknow".equals(((TCoreProjectFile)discoveryFile.get(0)).getIsknowstructure())) {
               map = this.executeDiscoverytaskService.getAllFileColumnsByContentUnknowstructure(discoveryFile, version, discoveryRule, discoveryTask, sensitiveRule, projectid, userid);
               String picDir = props.getProperty("pictureDir");
               this.deleteDirectory(picDir);
            } else if ("5".equals(((TCoreProjectFile)discoveryFile.get(0)).getFiletype())) {
               map = this.executeDiscoverytaskService.getAllFileColumnsByContent(discoveryFile, version, discoveryRule, discoveryTask, sensitiveRule, projectid, userid);
            } else if ("0".equals(((TCoreProjectFile)discoveryFile.get(0)).getFiletype())) {
               TCoreDatasystem datasystem = new TCoreDatasystem();
               datasystem.setDbtype("ORCLE-DMP");
               datasystem.setFlag("4");
               map = this.executeDiscoverytaskService.getAlldmpTableColumnsByContent(datasystem, discoveryFile, version, discoveryRule, discoveryTask, sensitiveRule, projectid, userid);
            }
         } else if ("4".equals(discoveryTask.getDiscoverytype())) {
            List<TcoreDiscoveryColumn> discoveryColumn = this.tdataDiscoveryService.queryDiscoveryColumn(taskid);
            TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(((TcoreDiscoveryColumn)discoveryColumn.get(0)).getDatasourceid());
            map = this.executeDiscoverytaskService.getAllCollections(datasystem, discoveryColumn, version, discoveryRule, discoveryTask, sensitiveRule, projectid, userid);
         } else {
            List<TcoreDiscoveryColumn> var30 = this.tdataDiscoveryService.queryDiscoveryColumn(taskid);
            if (isAssignTable) {
               var30 = columnList;
            }

            ExecuteDiscoverytaskController.tasklogger.info(MesUtil.getMsg("DIS_007", new String[0]));
            TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(((TcoreDiscoveryColumn)var30.get(0)).getDatasourceid());
            map = this.executeDiscoverytaskService.getAllTableColumns(datasystem, var30, version, discoveryRule, discoveryTask, sensitiveRule, projectid, userid, isAssignTable);
         }

         if (map != null && !"true".equals(map.get("isstop"))) {
            String sureTable = "";
            String sureColumn = "";
            String columnSum = "";
            String tableCount = "";
            sureTable = (String)map.get("sureTable");
            sureColumn = (String)map.get("sureColumn");
            columnSum = (String)map.get("columnSum");
            tableCount = (String)map.get("tableCount");
            long endTime = System.currentTimeMillis();
            String runtime = DateTimeTool.formatDuring(endTime - startTime);
            TcoreDiscoveryDataResult tcoreDiscoveryDataResult = new TcoreDiscoveryDataResult();
            tcoreDiscoveryDataResult.setTasktime(runtime);
            tcoreDiscoveryDataResult.setFieldcount(columnSum);
            tcoreDiscoveryDataResult.setTablecount(tableCount);
            tcoreDiscoveryDataResult.setSensitivefield(sureColumn);
            tcoreDiscoveryDataResult.setSensitivetable(sureTable);
            tcoreDiscoveryDataResult.setTaskid(taskid);
            tcoreDiscoveryDataResult.setCreatetime(new Date());
            if (!isAssignTable) {
               this.tdataDiscoveryService.saveDiscoveryDataResult(tcoreDiscoveryDataResult);
            }
         }

         if (!isAssignTable) {
            if ("true".equals(map.get("error"))) {
               this.tdataDiscoveryService.updateTaskstatus(taskid, "2", version);
            } else if ("true".equals(map.get("isstop"))) {
               this.tdataDiscoveryService.updateTaskstatus(taskid, "3", version);
            } else {
               this.tdataDiscoveryService.updateTaskstatus(taskid, "0", version);
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
         if (!isAssignTable) {
            this.tdataDiscoveryService.updateTaskstatus(taskid, "2", version);
         }

         this.executeDiscoverytaskService.writeFile("errormanage", "数据库操作异常,非常严重," + formatter.format(new Date()) + ",dbcaozuo2_db\r\n", monitorDir);
         String content = this.executeDiscoverytaskService.geterrorprint(e);
         this.executeDiscoverytaskService.writeErroFile("dbcaozuo2_db", content, monitorDir);
      }

   }

   public Map<String, String> getAllTableColumns(TCoreDatasystem datasystem, List<TcoreDiscoveryColumn> discoveryColumn, String version, List<TcoreTaskFindrule> discoveryRule, TcoreDiscoveryTask discoveryTask, List<Map<String, Object>> sensitiveRule, String projectid, String userid, boolean isautofind) {
      if (!isautofind) {
         this.delResultSql(discoveryTask.getResultid());
      }

      ExecuteDiscoverytaskController.tasklogger.info(MesUtil.getMsg("DIS_008", new String[0]));
      Map<String, String> resultMap = new HashMap();
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      this.vlist.remove("pool" + discoveryTask.getId());
      String flag = discoveryTask.getFlag();
      String taskid = discoveryTask.getId();
      if ("0".equals(flag)) {
         List<TableJoinsInfo> queryAllbyTaskid = this.tableJoinsInfoService.queryAllbyTaskid(taskid);
         if (queryAllbyTaskid.size() > 0) {
            ExecuteDiscoverytaskController.tasklogger.info(MesUtil.getMsg("DIS_009", new String[0]));

            for(TableJoinsInfo tableJoinsInfo : queryAllbyTaskid) {
               String id = tableJoinsInfo.getId();
               this.tableJoinsInfoService.removeTbcolumByTJid(id);
            }

            this.tableJoinsInfoService.removeByTaskid(taskid);
         }
      }

      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = props.getProperty("monitorFile") + projectid + File.separator + discoveryTask.getId() + File.separator;
      String readOneTime = props.getProperty("readCntByOneTime");
      int batcheSize = new Integer(props.getProperty("jdbc_insert_batche_size"));
      String driver = props.getProperty("jdbc.driver");
      String jdbcurl = props.getProperty("jdbc.url");
      String user = props.getProperty("jdbc.user");
      String password = props.getProperty("jdbc.password");
      double confidenceRate = Double.parseDouble(props.getProperty("confidenceRate"));
      String num = "50000";
      String task_table = discoveryTask.getResultid();
      if (isautofind) {
         task_table = discoveryTask.getAutofindresultid();
      }

      new TcoreDiscoveryDataResult();
      TcoreDiscoveryResult tcoreDiscoveryResult = new TcoreDiscoveryResult();
      Connection tconnection = null;
      PreparedStatement pstmt = null;
      PreparedStatement pstmt_correlation = null;
      List<String> list_table = JdbcTool.sql_insert_q(tcoreDiscoveryResult);
      list_table.add("id");
      String tcoreDiscoveryResult_sql = JdbcTool.sql_insert(list_table, task_table);
      tcoreDiscoveryResult_sql = tcoreDiscoveryResult_sql + ") values (";

      for(int i = 0; i < list_table.size(); ++i) {
         if (i == 0) {
            tcoreDiscoveryResult_sql = tcoreDiscoveryResult_sql + "?";
         } else {
            tcoreDiscoveryResult_sql = tcoreDiscoveryResult_sql + ",?";
         }
      }

      tcoreDiscoveryResult_sql = tcoreDiscoveryResult_sql + ")";
      String correlation_sql = "update " + task_table + " set correlation=? where tschemas=? and ttables=? and tfields=?";

      try {
         tconnection = JdbcTool.getConnectionlog(driver, jdbcurl, user, password);
         ExecuteDiscoverytaskController.tasklogger.info(MesUtil.getMsg("DIS_010", new String[0]));
         tconnection.setAutoCommit(false);
      } catch (ClassNotFoundException e3) {
         this.writeFile("errormanage", "本地数据库连接异常,非常严重," + formatter.format(new Date()) + ",connCNFError_db\r\n", url);
         String content = this.geterrorprint(e3);
         ExecuteDiscoverytaskController.tasklogger.error(MesUtil.getMsg("DIS_ERR_01", new String[]{content}));
         this.writeErroFile("connCNFError_db", content, url);
         resultMap.put("error", "true");
         e3.printStackTrace();
      } catch (SQLException e3) {
         this.writeFile("errormanage", "本地数据库连接异常,非常严重," + formatter.format(new Date()) + ",connSQLError_db\r\n", url);
         String content = this.geterrorprint(e3);
         this.writeErroFile("connSQLError_db", content, url);
         ExecuteDiscoverytaskController.tasklogger.error(MesUtil.getMsg("DIS_ERR_01", new String[]{content}));
         resultMap.put("error", "true");
         e3.printStackTrace();
      }

      try {
         pstmt = tconnection.prepareStatement(tcoreDiscoveryResult_sql);
      } catch (SQLException e2) {
         this.writeFile("errormanage", "创建sql失败,非常严重," + formatter.format(new Date()) + ",createresultSQLError_db\r\n", url);
         String content = this.geterrorprint(e2);
         this.writeErroFile("createresultSQLError_db", content, url);
         ExecuteDiscoverytaskController.tasklogger.error(MesUtil.getMsg("DIS_ERR_02", new String[]{content}));
         resultMap.put("error", "true");
         e2.printStackTrace();
      }

      try {
         pstmt_correlation = tconnection.prepareStatement(correlation_sql);
      } catch (SQLException e2) {
         this.writeFile("errormanage", "创建sql失败,非常严重," + formatter.format(new Date()) + ",createconneSQLError_db\r\n", url);
         String content = this.geterrorprint(e2);
         this.writeErroFile("createconneSQLError_db", content, url);
         ExecuteDiscoverytaskController.tasklogger.error(MesUtil.getMsg("DIS_ERR_02", new String[]{content}));
         resultMap.put("error", "true");
         e2.printStackTrace();
      }

      String selectDataType = discoveryTask.getCyfs();
      String hits = discoveryTask.getCys();
      String rate = discoveryTask.getPpl();
      boolean isIntelligence = false;
      List<TcoreTaskFindrule> regexByNamelist = new ArrayList();
      List<TcoreTaskFindrule> regexByContent = new ArrayList();
      List<TcoreTaskFindrule> regexByCommentlist = new ArrayList();

      for(int x = 0; x < discoveryRule.size(); ++x) {
         if ("1".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getFlag())) {
            regexByNamelist.add(new TcoreTaskFindrule(((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid(), ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea(), ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename(), ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex(), "", ((TcoreTaskFindrule)discoveryRule.get(x)).getRuleid()));
         } else if (!"2".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getFlag())) {
            if ("4".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getFlag())) {
               regexByCommentlist.add(new TcoreTaskFindrule(((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid(), ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea(), ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename(), ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex(), "", ((TcoreTaskFindrule)discoveryRule.get(x)).getRuleid()));
            } else {
               isIntelligence = true;
            }
         } else {
            String discoveryway = "";
            String mixRule = "";
            String mixdataareaid = "";
            String mixdataarea = "";
            String mixrulename = "";
            if (!" ".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway()) && !"undefined".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway()) && ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway() != null && !"01".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway()) && !"04".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
               if ("03".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
                  discoveryway = ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway();
                  List<TConsoleSearchregex> tConsoleSearchregexList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("name", ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename())});

                  for(int u = 0; u < tConsoleSearchregexList.size(); ++u) {
                     TcoreTaskFindrule tcoreTaskFindrule = new TcoreTaskFindrule();
                     tcoreTaskFindrule.setRegex(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getRegex());
                     tcoreTaskFindrule.setDataareaid(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDataarea_id());
                     tcoreTaskFindrule.setDataarea(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getType());
                     tcoreTaskFindrule.setRulename(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getName());
                     tcoreTaskFindrule.setDiscoverway(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDiscoverway());
                     tcoreTaskFindrule.setDictionaryClass(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDictionaryClass());
                     tcoreTaskFindrule.setMatchingwaSy(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getMatchingway());
                     tcoreTaskFindrule.setRuleid(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getId());
                     regexByContent.add(tcoreTaskFindrule);
                  }
               } else if ("02".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
                  StringBuffer buf = new StringBuffer();
                  StringBuffer bufDataarea = new StringBuffer();
                  StringBuffer bufDataareaid = new StringBuffer();
                  StringBuffer bufRulename = new StringBuffer();
                  discoveryway = ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway();
                  List<TConsoleSearchregex> tConsoleSearchregexList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("type", ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename())});

                  for(int u = 0; u < tConsoleSearchregexList.size(); ++u) {
                     List<TCoreDataFileGroup> tCoreDataFileGroupList = this.tCoreDataFileGroupDao.queryAll(new Criterion[]{Restrictions.eq("searchregexid", ((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getId())});

                     for(int i = 0; i < tCoreDataFileGroupList.size(); ++i) {
                        List<TConsoleSearchregex> tConsoleSearchregexList1 = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("type", ((TCoreDataFileGroup)tCoreDataFileGroupList.get(i)).getDatafilename())});

                        for(int z = 0; z < tConsoleSearchregexList1.size(); ++z) {
                           if ("1".equals(((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getDefaulttype())) {
                              String a = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getRegex();
                              String b = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getType();
                              String c = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getDataarea_id();
                              String d = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getName();
                              buf.append("_#_" + a);
                              bufRulename.append("_#_" + d);
                              bufDataareaid.append("_#_" + c);
                              bufDataarea.append("_#_" + b);
                           }
                        }
                     }
                  }

                  buf.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex());
                  bufDataarea.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea());
                  bufDataareaid.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid());
                  bufRulename.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename());
                  bufRulename.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getRuleid());
                  mixRule = buf.toString();
                  mixdataareaid = bufDataareaid.toString();
                  mixdataarea = bufDataarea.toString();
                  mixrulename = bufRulename.toString();
                  String[] regexlist = mixRule.split("_#_");

                  for(int i = 0; i < regexlist.length; ++i) {
                     TcoreTaskFindrule tcoreTaskFindrule = new TcoreTaskFindrule();
                     tcoreTaskFindrule.setRegex(mixRule.split("_#_")[i]);
                     tcoreTaskFindrule.setDataareaid(mixdataareaid.split("_#_")[i]);
                     tcoreTaskFindrule.setDataarea(mixdataarea.split("_#_")[i]);
                     tcoreTaskFindrule.setDataarea(mixrulename.split("_#_")[i]);
                     tcoreTaskFindrule.setMixdataarea(((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea());
                     tcoreTaskFindrule.setDiscoverway("02");
                     tcoreTaskFindrule.setRuleid(mixrulename.split("_#_")[i]);
                     regexByContent.add(tcoreTaskFindrule);
                  }
               }
            } else {
               discoveryway = " ";
               mixRule = ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex();
               mixdataareaid = ((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid();
               mixdataarea = ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea();
               mixrulename = ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename();
               regexByContent.add(new TcoreTaskFindrule(mixdataareaid, mixdataarea, mixrulename, mixRule, discoveryway, ((TcoreTaskFindrule)discoveryRule.get(x)).getRuleid()));
            }
         }
      }

      boolean isSelectData = this.isSelectData(hits, discoveryRule.size());
      boolean isVersion = version != null && !"".equals(version) && !"0".equals(version);
      Connection connection = null;
      if ("ES".equals(datasystem.getDbtype())) {
         boolean c = EsUtil.connectES(datasystem);
         if (!c) {
            String content = "错误信息:" + datasystem.getDbip() + ",这个IP地址连接失败";
            this.writeFile("errormanage", "执行失败,非常严重," + formatter.format(new Date()) + ",connError_db\r\n", url);
            this.writeErroFile("connError_db", content, url);
            ExecuteDiscoverytaskController.tasklogger.error(MesUtil.getMsg("DIS_ERR_03", new String[]{content}));
            resultMap.put("error", "true");
            return null;
         }
      } else if ("MONGODB".equals(datasystem.getDbtype())) {
         MongoClient client = null;

         try {
            client = MongodbTool.connect(datasystem.getDbservername(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), true);
         } catch (Exception e) {
            this.writeFile("errormanage", "mongodb连接异常,非常严重," + formatter.format(new Date()) + ",MongoDB_connect\r\n", url);
            String content = this.geterrorprint(e);
            this.writeErroFile("MongoDB_connect", content, url);
            e.printStackTrace();
         }

         if (client == null) {
            String content = "错误信息:" + datasystem.getDbip() + ",这个IP地址连接失败";
            this.writeFile("errormanage", "执行失败,非常严重," + formatter.format(new Date()) + ",connError_db\r\n", url);
            this.writeErroFile("connError_db", content, url);
            resultMap.put("error", "true");
            return null;
         }
      } else {
         connection = JdbcTool.getConnection(datasystem);
         if (connection == null) {
            String content = "错误信息:" + datasystem.getDbip() + ",这个IP地址连接失败";
            this.writeFile("errormanage", "执行失败,非常严重," + formatter.format(new Date()) + ",connError_db\r\n", url);
            this.writeErroFile("connError_db", content, url);
            ExecuteDiscoverytaskController.tasklogger.error(MesUtil.getMsg("DIS_ERR_03", new String[]{content}));
            resultMap.put("error", "true");
            return null;
         }
      }

      String dbType = datasystem.getDbtype();
      String columnSurroundCharacterLeft = XmlTool.getFileValue(dbType + "/db-columnSurroundCharacterLeft");
      String columnSurroundCharacterRight = XmlTool.getFileValue(dbType + "/db-columnSurroundCharacterRight");
      long schemaIndex = 1L;
      int sureTable = 0;
      int sureColumn = 0;
      int columnSum = 0;
      int tableSum = 0;
      int tableCount = discoveryColumn.size();
      int cnt = 0;
      int cnt_correlation = 0;
      boolean result = false;
      CacheUtil.put(discoveryTask.getId() + "tableCount", tableCount);
      CacheUtil.delCacheValue("taskstatus_" + discoveryTask.getId());
      CacheUtil.delCacheValue("TdataDiscoveryIntelligence_list");
      CacheUtil.delCacheValue("TdataDiscoveryIntelligence_placeList");
      CacheUtil.delCacheValue("TdataDiscoveryIntelligence_columnNo");
      HashMap<String, List<String>> scMap = new HashMap();
      List<String> schemaslist = new ArrayList();

      for(int i = 0; i < discoveryColumn.size(); ++i) {
         List<String> tableLst = new ArrayList();
         String sc = ((TcoreDiscoveryColumn)discoveryColumn.get(i)).getTschema();
         if (null == scMap.get(sc)) {
            tableLst.add(((TcoreDiscoveryColumn)discoveryColumn.get(i)).getTablename());
            scMap.put(sc, tableLst);
            schemaslist.add(sc);
         } else {
            tableLst = (List)scMap.get(sc);
            tableLst.add(((TcoreDiscoveryColumn)discoveryColumn.get(i)).getTablename());
            scMap.put(sc, tableLst);
         }
      }

      HashMap<String, TCoreProjectVersionVO> version_map = new HashMap();
      if (isVersion) {
         version_map = this.queryProjectVersion(projectid, discoveryTask.getId(), version, userid);
      }

      List<Pattern> patternNameList = new ArrayList();
      List<Pattern> patternContentList = new ArrayList();
      List<Pattern> patternCommentList = new ArrayList();

      for(TcoreTaskFindrule searchRegex : regexByNamelist) {
         try {
            patternNameList.add(Pattern.compile(searchRegex.getRegex()));
         } catch (PatternSyntaxException var128) {
         }
      }

      for(TcoreTaskFindrule searchRegex : regexByContent) {
         try {
            patternContentList.add(Pattern.compile(searchRegex.getRegex()));
         } catch (PatternSyntaxException var127) {
         }
      }

      for(TcoreTaskFindrule searchRegex : regexByCommentlist) {
         try {
            patternCommentList.add(Pattern.compile(searchRegex.getRegex()));
         } catch (PatternSyntaxException var126) {
         }
      }

      for(String schema : schemaslist) {
         ExecuteDiscoverytaskController.tasklogger.info(MesUtil.getMsg("DIS_011", new String[]{schema}));
         List<String> tblist = new ArrayList();
         List<String> allTableListOfSchema = (List)scMap.get(schema);
         long tableIndex = 1L;
         String queryTableDataSql = this.getQuerySql(selectDataType, dbType, schema, Long.parseLong(hits), "");
         String tabletemp = "";

         for(String tableName : allTableListOfSchema) {
            ExecuteDiscoverytaskController.tasklogger.info(MesUtil.getMsg("DIS_012", new String[]{schema, tableName}));
            tblist.add(tableName);
            String columnameliststr = "";
            int placeNo = 0;
            new ArrayList();
            List<ColumnInfo> columnamelist;
            if ("ES".equals(dbType)) {
               columnamelist = EsUtil.getESColumnInfoList(datasystem, schema, tableName);
            } else if ("MONGODB".equals(dbType)) {
               columnamelist = MongodbTool.getMongodbColumns(datasystem, schema, tableName);
            } else {
               columnamelist = JdbcTool.getAllColumnInfo(connection, schema, tableName);
            }

            if (columnamelist.size() == 0) {
               this.writeFile("errormanage", "找不到表,比较严重," + formatter.format(new Date()) + ",findtablefiled_db\r\n", url);
               String content = "错误信息:" + schema + "下的" + tableName + "表无法找到";
               this.writeErroFile("findtablefiled_db", content, url);
               ++tableSum;
               resultMap.put("error", "true");
            } else {
               if (isIntelligence) {
                  ArrayList<List<String>> list = new ArrayList();
                  List<String> placeList = new ArrayList();
                  CacheUtil.put("TdataDiscoveryIntelligence_list_" + tableName, list);
                  CacheUtil.put("TdataDiscoveryIntelligence_placeList_" + tableName, placeList);
               }

               columnSum += columnamelist.size();
               if (this.vlist.size() != 0 && this.vlist.contains("pool" + discoveryTask.getId())) {
                  break;
               }

               if (columnamelist.size() > 0) {
                  if ("0".equals(flag)) {
                     this.findTablePFk(taskid, connection, schema, tableName, columnamelist, allTableListOfSchema);
                  }

                  if (isVersion) {
                     if (!isSelectData) {
                        for(ColumnInfo columnInfo : columnamelist) {
                           String dataarea_id = "";
                           String dataarea_name = "";
                           String issure = "0";
                           String tschemas = schema;
                           String sensitive_id = "";
                           String sensitive_name = "";
                           String datasystem_id = datasystem.getId();
                           String sampling = hits;
                           String teffe_sampling = "0";
                           String fields = "";
                           String fieldremark = "";
                           String matching = "0%";
                           String table = tableName;
                           String keyid = schema + tableName + columnInfo.getColumnname();
                           if (version_map.get(keyid) != null) {
                              dataarea_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaId();
                              dataarea_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaName();
                              issure = ((TCoreProjectVersionVO)version_map.get(keyid)).getIssure();
                              sensitive_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getSensitiveId();
                              sensitive_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getSensitiveName();
                              fields = columnInfo.getColumnname();
                              fieldremark = columnInfo.getRemarks();

                              try {
                                 pstmt.setObject(1, datasystem_id);
                                 pstmt.setObject(2, tschemas);
                                 pstmt.setObject(3, table);
                                 pstmt.setObject(4, fields);
                                 pstmt.setObject(5, fieldremark);
                                 pstmt.setObject(6, sampling);
                                 pstmt.setObject(7, teffe_sampling);
                                 pstmt.setObject(8, matching);
                                 pstmt.setObject(9, dataarea_id);
                                 pstmt.setObject(10, dataarea_name);
                                 pstmt.setObject(11, sensitive_id);
                                 pstmt.setObject(12, sensitive_name);
                                 pstmt.setObject(13, issure);
                                 pstmt.setObject(14, "");
                                 pstmt.setObject(15, "");
                                 pstmt.setObject(16, "");
                                 pstmt.setObject(17, UUID.randomUUID().toString());
                                 pstmt.addBatch();
                                 ++cnt;
                                 if (cnt % batcheSize == 0) {
                                    long useTime1 = System.currentTimeMillis();
                                    pstmt.executeBatch();
                                    pstmt.clearBatch();
                                    tconnection.commit();
                                    long useTime2 = System.currentTimeMillis();
                                    System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                                 }
                              } catch (SQLException e) {
                                 this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",piliangExe_banben_faild_db\r\n", url);
                                 String content = this.geterrorprint(e);
                                 this.writeErroFile("piliangExe_banben_faild_db", content, url);
                                 resultMap.put("error", "true");
                                 e.printStackTrace();
                              }

                              ++sureColumn;
                              if (!tabletemp.equals(tableName)) {
                                 ++sureTable;
                              }

                              tabletemp = tableName;
                           } else {
                              try {
                                 pstmt.setObject(1, datasystem_id);
                                 pstmt.setObject(2, tschemas);
                                 pstmt.setObject(3, table);
                                 pstmt.setObject(4, columnInfo.getColumnname());
                                 pstmt.setObject(5, columnInfo.getRemarks());
                                 pstmt.setObject(6, sampling);
                                 pstmt.setObject(7, teffe_sampling);
                                 pstmt.setObject(8, matching);
                                 pstmt.setObject(9, dataarea_id);
                                 pstmt.setObject(10, dataarea_name);
                                 pstmt.setObject(11, sensitive_id);
                                 pstmt.setObject(12, sensitive_name);
                                 pstmt.setObject(13, issure);
                                 pstmt.setObject(14, "");
                                 pstmt.setObject(15, "");
                                 pstmt.setObject(16, "");
                                 pstmt.setObject(17, UUID.randomUUID().toString());
                                 pstmt.addBatch();
                                 ++cnt;
                                 if (cnt % batcheSize == 0) {
                                    long useTime1 = System.currentTimeMillis();
                                    pstmt.executeBatch();
                                    pstmt.clearBatch();
                                    tconnection.commit();
                                    long useTime2 = System.currentTimeMillis();
                                    System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                                 }
                              } catch (SQLException e) {
                                 e.printStackTrace();
                                 this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",piliangExe_faild_db\r\n", url);
                                 String content = this.geterrorprint(e);
                                 this.writeErroFile("piliangExe_faild_db", content, url);
                                 resultMap.put("error", "true");
                              }

                              ++sureColumn;
                              if (!tabletemp.equals(tableName)) {
                                 ++sureTable;
                              }

                              tabletemp = tableName;
                           }
                        }
                     } else {
                        new StringBuffer();
                        String queryTableDataSqlTemp = "";
                        Map<String, String> remarkmap = new HashMap();

                        for(ColumnInfo columnInfo : columnamelist) {
                           String keyid = schema + tableName + columnInfo.getColumnname();
                           if (version_map.get(keyid) != null) {
                              String dataarea_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaId();
                              String dataarea_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaName();
                              String issure = ((TCoreProjectVersionVO)version_map.get(keyid)).getIssure();
                              String tschemas = schema;
                              String sensitive_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getSensitiveId();
                              String sensitive_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getSensitiveName();
                              String datasystem_id = datasystem.getId();
                              String sampling = hits;
                              String teffe_sampling = "0";
                              String fields = columnInfo.getColumnname();
                              String fieldremark = columnInfo.getRemarks();
                              String matching = "0%";
                              String table = tableName;

                              try {
                                 pstmt.setObject(1, datasystem_id);
                                 pstmt.setObject(2, tschemas);
                                 pstmt.setObject(3, table);
                                 pstmt.setObject(4, fields);
                                 pstmt.setObject(5, fieldremark);
                                 pstmt.setObject(6, sampling);
                                 pstmt.setObject(7, teffe_sampling);
                                 pstmt.setObject(8, matching);
                                 pstmt.setObject(9, dataarea_id);
                                 pstmt.setObject(10, dataarea_name);
                                 pstmt.setObject(11, sensitive_id);
                                 pstmt.setObject(12, sensitive_name);
                                 pstmt.setObject(13, issure);
                                 pstmt.setObject(14, "");
                                 pstmt.setObject(15, "");
                                 pstmt.setObject(16, "");
                                 pstmt.setObject(17, UUID.randomUUID().toString());
                                 pstmt.addBatch();
                                 ++cnt;
                                 if (cnt % batcheSize == 0) {
                                    long useTime1 = System.currentTimeMillis();
                                    pstmt.executeBatch();
                                    pstmt.clearBatch();
                                    tconnection.commit();
                                    long useTime2 = System.currentTimeMillis();
                                    System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                                 }
                              } catch (SQLException e) {
                                 e.printStackTrace();
                                 this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",piliangexefail_guize_db\r\n", url);
                                 String content = this.geterrorprint(e);
                                 this.writeErroFile("piliangexefail_guize_db", content, url);
                                 resultMap.put("error", "true");
                              }

                              ++sureColumn;
                              if (!tabletemp.equals(tableName)) {
                                 ++sureTable;
                              }

                              tabletemp = tableName;
                           } else {
                              if (regexByNamelist.size() > 0) {
                                 String teffe_sampling = "0";

                                 try {
                                    ++cnt;
                                    result = this.getSensitiveColumnByName(tcoreDiscoveryResult, datasystem.getId(), datasystem.getSysname(), schema, tableName, columnInfo.getColumnname(), columnInfo.getRemarks(), regexByNamelist, patternNameList, tcoreDiscoveryResult_sql, rate, hits, list_table, teffe_sampling, sensitiveRule, pstmt, cnt, batcheSize, tconnection, columnInfo.getTypename());
                                 } catch (SQLException e) {
                                    this.writeFile("errormanage", "查询发现规则异常,非常严重," + formatter.format(new Date()) + ",findguizefaild_db\r\n", url);
                                    String content = this.geterrorprint(e);
                                    this.writeErroFile("findguizefaild_db", content, url);
                                    resultMap.put("error", "true");
                                    e.printStackTrace();
                                 }

                                 if (result) {
                                    ++sureColumn;
                                    if (!tabletemp.equals(tableName)) {
                                       ++sureTable;
                                    }
                                    continue;
                                 }

                                 tabletemp = tableName;
                              }

                              if (regexByCommentlist.size() > 0) {
                                 String teffe_sampling = "0";

                                 try {
                                    ++cnt;
                                    result = this.getSensitiveColumnByComment(tcoreDiscoveryResult, datasystem.getId(), datasystem.getSysname(), schema, tableName, columnInfo.getColumnname(), columnInfo.getRemarks(), regexByCommentlist, patternCommentList, tcoreDiscoveryResult_sql, rate, hits, list_table, teffe_sampling, sensitiveRule, pstmt, cnt, batcheSize, tconnection, columnInfo.getTypename());
                                 } catch (SQLException e) {
                                    e.printStackTrace();
                                    this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",unbanbenpiliangdealguize_db\r\n", url);
                                    String content = this.geterrorprint(e);
                                    this.writeErroFile("unbanbenpiliangdealguize_db", content, url);
                                    resultMap.put("error", "true");
                                 }

                                 if (result) {
                                    ++sureColumn;
                                    if (!tabletemp.equals(tableName)) {
                                       ++sureTable;
                                    }

                                    tabletemp = tableName;
                                    continue;
                                 }
                              }

                              if (regexByContent.size() > 0 && !"ES".equals(dbType) && !"MONGODB".equals(dbType)) {
                                 if (columnInfo.getTypename().equalsIgnoreCase("sql_variant")) {
                                    columnameliststr = "convert(varchar(100), SERVERPROPERTY('" + columnInfo.getColumnname() + "')) as " + columnSurroundCharacterLeft + columnInfo.getColumnname() + columnSurroundCharacterRight;
                                 } else {
                                    columnameliststr = columnSurroundCharacterLeft + columnInfo.getColumnname() + columnSurroundCharacterRight;
                                 }

                                 if (columnameliststr.equals("1")) {
                                    queryTableDataSql = this.getQuerySql("1", dbType, schema, 1L, num);
                                 }

                                 queryTableDataSqlTemp = MessageFormat.format(queryTableDataSql, tableName, columnameliststr);
                                 remarkmap.put(columnInfo.getColumnname(), columnInfo.getRemarks());
                              }

                              if (regexByContent.size() > 0) {
                                 if (!"ES".equals(dbType) && !"MONGODB".equals(dbType)) {
                                    PreparedStatement tableDataStatement = null;
                                    int readCntByOneTime = new Integer(readOneTime);
                                    ResultSet tableDataResultSet = null;

                                    try {
                                       if (EdbType.DB2.toString().equalsIgnoreCase(datasystem.getDbtype())) {
                                          tableDataStatement = connection.prepareStatement(queryTableDataSqlTemp);
                                       } else if (EdbType.INFORMIX.toString().equalsIgnoreCase(datasystem.getDbtype())) {
                                          tableDataStatement = connection.prepareStatement(queryTableDataSqlTemp);
                                       } else {
                                          tableDataStatement = connection.prepareStatement(queryTableDataSqlTemp, 1003, 1007);
                                       }

                                       tableDataStatement.setFetchSize(readCntByOneTime);
                                       tableDataResultSet = tableDataStatement.executeQuery();
                                    } catch (Exception e) {
                                       this.writeFile("errormanage", "查询表数据时报错,非常严重," + formatter.format(new Date()) + ",findtabledatafaild_db\r\n", url);
                                       String content = this.geterrorprint(e);
                                       this.writeErroFile("findtabledatafaild_db", content, url);
                                       resultMap.put("error", "true");
                                       Connection oldConnection = connection;
                                       connection = JdbcTool.getConnection(datasystem);

                                       try {
                                          oldConnection.close();
                                       } catch (Exception e1) {
                                          this.writeFile("errormanage", "关闭数据库连接异常,非常严重," + formatter.format(new Date()) + ",closedbfaid_db\r\n", url);
                                          String content1 = this.geterrorprint(e1);
                                          this.writeErroFile("closedbfaid_db", content1, url);
                                          resultMap.put("error", "true");
                                       }

                                       try {
                                          tableDataStatement.close();
                                       } catch (Exception e1) {
                                          this.writeFile("errormanage", "关闭PreparedStatement异常,非常严重," + formatter.format(new Date()) + ",closepsfaid_db\r\n", url);
                                          String content1 = this.geterrorprint(e1);
                                          this.writeErroFile("closepsfaid_db", content1, url);
                                          resultMap.put("error", "true");
                                       }
                                    }

                                    if (tableDataResultSet != null) {
                                       int columncount = 0;
                                       ++cnt;
                                       columncount = this.getSensitiveColumnsByContent(datasystem.getId(), datasystem.getSysname(), schema, tableDataResultSet, tableName, rate, hits, regexByContent, patternContentList, tcoreDiscoveryResult_sql, list_table, sensitiveRule, projectid, discoveryTask.getId(), pstmt, cnt, batcheSize, tconnection, isIntelligence, placeNo, version, remarkmap);
                                       sureColumn += columncount;
                                       if (columncount > 0 && !tabletemp.equals(tableName)) {
                                          ++sureTable;
                                          tabletemp = tableName;
                                       }
                                    }

                                    try {
                                       tableDataStatement.close();
                                    } catch (Exception e1) {
                                       this.writeFile("errormanage", "关闭PreparedStatement异常,非常严重," + formatter.format(new Date()) + ",closeps2faid_db\r\n", url);
                                       String content1 = this.geterrorprint(e1);
                                       this.writeErroFile("closeps2faid_db", content1, url);
                                       resultMap.put("error", "true");
                                    }
                                 } else if ("ES".equals(dbType)) {
                                    Map<String, ArrayList> tableData = null;
                                    EsUtil esUtil = new EsUtil();

                                    try {
                                       tableData = esUtil.getData(datasystem, schema, tableName, hits);
                                       tableData = (Map)tableData.entrySet().stream().filter((mapx) -> ((String)mapx.getKey()).equals(columnInfo.getColumnname())).collect(Collectors.toMap((h) -> (String)h.getKey(), (h) -> (ArrayList)h.getValue()));
                                       if (tableData.size() == 0) {
                                          tableData.put(columnInfo.getColumnname(), null);
                                       }
                                    } catch (Exception e) {
                                       this.writeFile("errormanage", "查询表数据时报错,非常严重," + formatter.format(new Date()) + ",findtabledatafaild_db\r\n", url);
                                       String content = this.geterrorprint(e);
                                       this.writeErroFile("findtabledatafaild_db", content, url);
                                       resultMap.put("error", "true");
                                    }

                                    if (!ObjectUtils.isEmpty(tableData)) {
                                       int columncount = 0;
                                       ++cnt;
                                       columncount = this.getSensitiveColumnsByContentOfEs(datasystem.getId(), datasystem.getSysname(), schema, tableData, tableName, rate, hits, regexByContent, patternContentList, tcoreDiscoveryResult_sql, list_table, sensitiveRule, projectid, discoveryTask.getId(), pstmt, cnt, batcheSize, tconnection, isIntelligence, placeNo, version, remarkmap);
                                       sureColumn += columncount;
                                       if (columncount > 0 && !tabletemp.equals(tableName)) {
                                          ++sureTable;
                                          tabletemp = tableName;
                                       }
                                    }
                                 } else if ("MONGODB".equals(dbType)) {
                                    MongoClient client = null;

                                    try {
                                       client = MongodbTool.connect(datasystem.getDbservername(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), true);
                                    } catch (Exception e) {
                                       this.writeFile("errormanage", "mongodb连接异常,非常严重," + formatter.format(new Date()) + ",MongoDB_connect\r\n", url);
                                       String content = this.geterrorprint(e);
                                       this.writeErroFile("MongoDB_connect", content, url);
                                       e.printStackTrace();
                                    }

                                    if (client == null) {
                                       String content = "错误信息:" + datasystem.getDbip() + ",这个IP地址连接失败";
                                       this.writeFile("errormanage", "执行失败,非常严重," + formatter.format(new Date()) + ",connError_db\r\n", url);
                                       this.writeErroFile("connError_db", content, url);
                                       resultMap.put("error", "true");
                                       return null;
                                    }

                                    Map<String, String> map = new HashMap();

                                    try {
                                       map = MongodbTool.findAll(client, schema, tableName);
                                    } catch (Exception e1) {
                                       this.writeFile("errormanage", "获取集合" + tableName + "内容失败,非常严重," + formatter.format(new Date()) + ",MongoDB_collection\r\n", url);
                                       String content = this.geterrorprint(e1);
                                       this.writeErroFile("MongoDB_collection", content, url);
                                       e1.printStackTrace();
                                    }

                                    String content = (String)map.get("content");
                                    if (content.length() > 0) {
                                       content = "[" + content.substring(0, content.length() - 1) + "]";
                                    }

                                    Map<String, List<String>> wjList = new HashMap();
                                    if (content.length() > 0) {
                                       try {
                                          ReadJsonTool.parseJSON2Map(wjList, content, "");
                                       } catch (Exception e) {
                                          e.printStackTrace();
                                       }
                                    }

                                    boolean flag1 = false;
                                    List<String> value = null;

                                    for(Map.Entry<String, List<String>> entry : wjList.entrySet()) {
                                       if ("_id/$oid".equals(entry.getKey())) {
                                          flag1 = true;
                                          value = (List)entry.getValue();
                                       }
                                    }

                                    if (flag1) {
                                       wjList.put("_id", value);
                                    }

                                    wjList = (Map)wjList.entrySet().stream().filter((m) -> ((String)m.getKey()).equals(columnInfo.getColumnname())).collect(Collectors.toMap((p) -> (String)p.getKey(), (p) -> (List)p.getValue()));
                                    if (wjList.size() > 0) {
                                       int columncount = this.getNosqlSensitiveColumnsByContent(datasystem.getId(), datasystem.getSysname(), wjList, schema, rate, hits, regexByContent, patternContentList, sensitiveRule, projectid, discoveryTask.getId(), "none", isSelectData, tableName, pstmt, cnt, batcheSize, tconnection);
                                       ++cnt;
                                       sureColumn += columncount;
                                       if (columncount > 0 && !tabletemp.equals(tableName)) {
                                          ++sureTable;
                                          tabletemp = tableName;
                                       }
                                    }
                                 }
                              }
                           }
                        }
                     }
                  } else if (!isSelectData) {
                     for(ColumnInfo columnInfo : columnamelist) {
                        String dataarea_id = "";
                        String dataarea_name = "";
                        String issure = "0";
                        String tschemas = schema;
                        String sensitive_id = "";
                        String sensitive_name = "";
                        String datasystem_id = datasystem.getId();
                        String sampling = hits;
                        String teffe_sampling = "0";
                        String fields = columnInfo.getColumnname();
                        String fieldremark = columnInfo.getRemarks();
                        String matching = "0%";
                        String table = tableName;

                        try {
                           pstmt.setObject(1, datasystem_id);
                           pstmt.setObject(2, tschemas);
                           pstmt.setObject(3, table);
                           pstmt.setObject(4, fields);
                           pstmt.setObject(5, fieldremark);
                           pstmt.setObject(6, sampling);
                           pstmt.setObject(7, teffe_sampling);
                           pstmt.setObject(8, matching);
                           pstmt.setObject(9, dataarea_id);
                           pstmt.setObject(10, dataarea_name);
                           pstmt.setObject(11, sensitive_id);
                           pstmt.setObject(12, sensitive_name);
                           pstmt.setObject(13, issure);
                           pstmt.setObject(14, "");
                           pstmt.setObject(15, "");
                           pstmt.setObject(16, "");
                           pstmt.setObject(17, UUID.randomUUID().toString());
                           pstmt.addBatch();
                           ++cnt;
                           if (cnt % batcheSize == 0) {
                              long useTime1 = System.currentTimeMillis();
                              pstmt.executeBatch();
                              pstmt.clearBatch();
                              tconnection.commit();
                              long useTime2 = System.currentTimeMillis();
                              System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                           }
                        } catch (SQLException e) {
                           e.printStackTrace();
                           this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",unbanbenpiliangdeal_db\r\n", url);
                           String content = this.geterrorprint(e);
                           this.writeErroFile("unbanbenpiliangdeal_db", content, url);
                           resultMap.put("error", "true");
                        }

                        ++sureColumn;
                        if (!tabletemp.equals(tableName)) {
                           ++sureTable;
                        }

                        tabletemp = tableName;
                     }
                  } else {
                     new StringBuffer();
                     String queryTableDataSqlTemp = "";
                     Map<String, String> remarkmap = new HashMap();

                     for(int i = 0; i < columnamelist.size(); ++i) {
                        ColumnInfo columnInfo = (ColumnInfo)columnamelist.get(i);
                        if (regexByNamelist.size() > 0) {
                           String teffe_sampling = "0";

                           try {
                              ++cnt;
                              result = this.getSensitiveColumnByName(tcoreDiscoveryResult, datasystem.getId(), datasystem.getSysname(), schema, tableName, columnInfo.getColumnname(), columnInfo.getRemarks(), regexByNamelist, patternNameList, tcoreDiscoveryResult_sql, rate, hits, list_table, teffe_sampling, sensitiveRule, pstmt, cnt, batcheSize, tconnection, columnInfo.getTypename());
                           } catch (SQLException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",unbanbenpiliangdealguize_db\r\n", url);
                              String content = this.geterrorprint(e);
                              this.writeErroFile("unbanbenpiliangdealguize_db", content, url);
                              resultMap.put("error", "true");
                           }

                           if (result) {
                              ++sureColumn;
                              if (!tabletemp.equals(tableName)) {
                                 ++sureTable;
                              }

                              tabletemp = tableName;
                              continue;
                           }
                        }

                        if (regexByCommentlist.size() > 0) {
                           String teffe_sampling = "0";

                           try {
                              ++cnt;
                              result = this.getSensitiveColumnByComment(tcoreDiscoveryResult, datasystem.getId(), datasystem.getSysname(), schema, tableName, columnInfo.getColumnname(), columnInfo.getRemarks(), regexByCommentlist, patternCommentList, tcoreDiscoveryResult_sql, rate, hits, list_table, teffe_sampling, sensitiveRule, pstmt, cnt, batcheSize, tconnection, columnInfo.getTypename());
                           } catch (SQLException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",unbanbenpiliangdealguize_db\r\n", url);
                              String content = this.geterrorprint(e);
                              this.writeErroFile("unbanbenpiliangdealguize_db", content, url);
                              resultMap.put("error", "true");
                           }

                           if (result) {
                              ++sureColumn;
                              if (!tabletemp.equals(tableName)) {
                                 ++sureTable;
                              }

                              tabletemp = tableName;
                              continue;
                           }
                        }

                        if (regexByContent.size() > 0 && !"ES".equals(dbType) && !"MONGODB".equals(dbType)) {
                           if (columnInfo.getTypename().equalsIgnoreCase("sql_variant")) {
                              columnameliststr = "convert(varchar(100), SERVERPROPERTY('" + columnInfo.getColumnname() + "')) as " + columnSurroundCharacterLeft + columnInfo.getColumnname() + columnSurroundCharacterRight;
                           } else {
                              columnameliststr = columnSurroundCharacterLeft + columnInfo.getColumnname() + columnSurroundCharacterRight;
                           }

                           if (columnameliststr.equals("1")) {
                              queryTableDataSql = this.getQuerySql("1", dbType, schema, 1L, num);
                           }

                           if (queryTableDataSql != null) {
                              queryTableDataSqlTemp = MessageFormat.format(queryTableDataSql, tableName, columnameliststr);
                           } else {
                              this.writeFile("errormanage", "查询表数据的sql错误,非常严重," + formatter.format(new Date()) + ",queryTableDataSql\r\n", url);
                              String content = "查询表数据的sql错误";
                              this.writeErroFile("queryTableDataSql", content, url);
                              resultMap.put("error", "true");
                           }

                           remarkmap.put(columnInfo.getColumnname(), columnInfo.getRemarks());
                        }

                        if (regexByContent.size() <= 0) {
                           try {
                              pstmt.setObject(1, datasystem.getId());
                              pstmt.setObject(2, schema);
                              pstmt.setObject(3, tableName);
                              pstmt.setObject(4, columnInfo.getColumnname());
                              pstmt.setObject(5, columnInfo.getRemarks());
                              pstmt.setObject(6, "0");
                              pstmt.setObject(7, "0");
                              pstmt.setObject(8, "0%");
                              pstmt.setObject(9, "");
                              pstmt.setObject(10, "");
                              pstmt.setObject(11, "");
                              pstmt.setObject(12, "");
                              pstmt.setObject(13, "0");
                              pstmt.setObject(14, "");
                              pstmt.setObject(15, "");
                              pstmt.setObject(16, "");
                              pstmt.setObject(17, UUID.randomUUID().toString());
                              pstmt.addBatch();
                              ++cnt;
                              if (cnt % batcheSize == 0) {
                                 long useTime1 = System.currentTimeMillis();
                                 pstmt.executeBatch();
                                 pstmt.clearBatch();
                                 tconnection.commit();
                                 long useTime2 = System.currentTimeMillis();
                                 System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                              }
                           } catch (SQLException e) {
                              this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pilinagnotguize_db\r\n", url);
                              String content = this.geterrorprint(e);
                              this.writeErroFile("pilinagnotguize_db", content, url);
                              e.printStackTrace();
                              resultMap.put("error", "true");
                           }
                        } else if (!"ES".equals(dbType) && !"MONGODB".equals(dbType)) {
                           PreparedStatement tableDataStatement = null;
                           ResultSet tableDataResultSet = null;
                           int readCntByOneTime = new Integer(readOneTime);

                           try {
                              if (EdbType.DB2.toString().equalsIgnoreCase(datasystem.getDbtype())) {
                                 tableDataStatement = connection.prepareStatement(queryTableDataSqlTemp);
                              } else if (EdbType.INFORMIX.toString().equalsIgnoreCase(datasystem.getDbtype())) {
                                 tableDataStatement = connection.prepareStatement(queryTableDataSqlTemp);
                              } else {
                                 tableDataStatement = connection.prepareStatement(queryTableDataSqlTemp, 1003, 1007);
                              }

                              tableDataStatement.setFetchSize(readCntByOneTime);
                              tableDataResultSet = tableDataStatement.executeQuery();
                           } catch (Exception e) {
                              this.writeFile("errormanage", "查询表数据时报错,非常严重," + formatter.format(new Date()) + ",findtable_db\r\n", url);
                              String content = this.geterrorprint(e);
                              this.writeErroFile("findtable_db", content, url);
                              resultMap.put("error", "true");
                              Connection oldConnection = connection;
                              connection = JdbcTool.getConnection(datasystem);

                              try {
                                 oldConnection.close();
                              } catch (Exception e1) {
                                 this.writeFile("errormanage", "关闭数据库连接异常,非常严重," + formatter.format(new Date()) + ",closedb_db\r\n", url);
                                 String content1 = this.geterrorprint(e1);
                                 this.writeErroFile("closedb_db", content, url);
                                 resultMap.put("error", "true");
                              }

                              try {
                                 tableDataStatement.close();
                              } catch (Exception e1) {
                                 this.writeFile("errormanage", "关闭PreparedStatement异常,非常严重," + formatter.format(new Date()) + ",closeps_db\r\n", url);
                                 String content1 = this.geterrorprint(e1);
                                 this.writeErroFile("closeps_db", content, url);
                                 resultMap.put("error", "true");
                              }
                           }

                           if (tableDataResultSet != null) {
                              int columncount = 0;
                              ++cnt;
                              columncount = this.getSensitiveColumnsByContent(datasystem.getId(), datasystem.getSysname(), schema, tableDataResultSet, tableName, rate, hits, regexByContent, patternContentList, tcoreDiscoveryResult_sql, list_table, sensitiveRule, projectid, discoveryTask.getId(), pstmt, cnt, batcheSize, tconnection, isIntelligence, placeNo, version, remarkmap);
                              sureColumn += columncount;
                              if (columncount > 0 && !tabletemp.equals(tableName)) {
                                 ++sureTable;
                                 tabletemp = tableName;
                              }
                           }

                           try {
                              tableDataStatement.close();
                           } catch (Exception e1) {
                              this.writeFile("errormanage", "关闭PreparedStatement异常,非常严重," + formatter.format(new Date()) + ",closepst_db\r\n", url);
                              String content1 = this.geterrorprint(e1);
                              this.writeErroFile("closepst_db", content1, url);
                              resultMap.put("error", "true");
                           }
                        } else if ("MONGODB".equals(dbType)) {
                           MongoClient client = null;

                           try {
                              client = MongodbTool.connect(datasystem.getDbservername(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), true);
                           } catch (Exception e) {
                              this.writeFile("errormanage", "mongodb连接异常,非常严重," + formatter.format(new Date()) + ",MongoDB_connect\r\n", url);
                              String content = this.geterrorprint(e);
                              this.writeErroFile("MongoDB_connect", content, url);
                              e.printStackTrace();
                           }

                           if (client == null) {
                              String content = "错误信息:" + datasystem.getDbip() + ",这个IP地址连接失败";
                              this.writeFile("errormanage", "执行失败,非常严重," + formatter.format(new Date()) + ",connError_db\r\n", url);
                              this.writeErroFile("connError_db", content, url);
                              resultMap.put("error", "true");
                              return null;
                           }

                           Map<String, String> map = new HashMap();

                           try {
                              map = MongodbTool.findAll(client, schema, tableName);
                           } catch (Exception e1) {
                              this.writeFile("errormanage", "获取集合" + tableName + "内容失败,非常严重," + formatter.format(new Date()) + ",MongoDB_collection\r\n", url);
                              String content = this.geterrorprint(e1);
                              this.writeErroFile("MongoDB_collection", content, url);
                              e1.printStackTrace();
                           }

                           String content = (String)map.get("content");
                           if (content.length() > 0) {
                              content = "[" + content.substring(0, content.length() - 1) + "]";
                           }

                           Map<String, List<String>> wjList = new HashMap();
                           if (content.length() > 0) {
                              try {
                                 ReadJsonTool.parseJSON2Map(wjList, content, "");
                              } catch (Exception e) {
                                 e.printStackTrace();
                              }
                           }

                           boolean flag1 = false;
                           List<String> value = null;

                           for(Map.Entry<String, List<String>> entry : wjList.entrySet()) {
                              if ("_id/$oid".equals(entry.getKey())) {
                                 flag1 = true;
                                 value = (List)entry.getValue();
                              }
                           }

                           if (flag1) {
                              wjList.put("_id", value);
                           }

                           wjList = (Map)wjList.entrySet().stream().filter((m) -> ((String)m.getKey()).equals(columnInfo.getColumnname())).collect(Collectors.toMap((p) -> (String)p.getKey(), (p) -> (List)p.getValue()));
                           if (wjList.size() > 0) {
                              int columncount = this.getNosqlSensitiveColumnsByContent(datasystem.getId(), datasystem.getSysname(), wjList, schema, rate, hits, regexByContent, patternContentList, sensitiveRule, projectid, discoveryTask.getId(), "none", isSelectData, tableName, pstmt, cnt, batcheSize, tconnection);
                              ++cnt;
                              sureColumn += columncount;
                              if (columncount > 0 && !tabletemp.equals(tableName)) {
                                 ++sureTable;
                                 tabletemp = tableName;
                              }
                           }
                        }
                     }
                  }
               }

               ++tableIndex;
               ++tableSum;
               this.writeFile("done", tableName + "," + schema + "," + formatter.format(new Date()) + "\r\n", url);
               CacheUtil.put(discoveryTask.getId() + "tableSum", tableSum);
               if (isIntelligence) {
                  ArrayList<List<String>> list = (ArrayList)CacheUtil.getCacheValue("TdataDiscoveryIntelligence_list_" + tableName);
                  List<String> placeList = (List)CacheUtil.getCacheValue("TdataDiscoveryIntelligence_placeList_" + tableName);
                  StringBuffer correlationstr = new StringBuffer();
                  if (list != null && list.size() > 0 && placeList != null && placeList.size() > 0) {
                     if (placeList.size() > 1) {
                        for(int i = 0; i < placeList.size(); ++i) {
                           Map<String, Float> map = CorrelationTool.check(list, Integer.parseInt((String)placeList.get(i)), confidenceRate);
                           System.out.println(map);

                           for(String key : map.keySet()) {
                              correlationstr.append(key + "=" + map.get(key) + ",");
                           }

                           try {
                              if (correlationstr.length() > 0) {
                                 pstmt_correlation.setObject(1, correlationstr.toString().substring(0, correlationstr.length() - 1));
                              } else {
                                 pstmt_correlation.setObject(1, "");
                              }

                              pstmt_correlation.setObject(2, schema);
                              pstmt_correlation.setObject(3, tableName);
                              pstmt_correlation.setObject(4, ((List)list.get(Integer.parseInt((String)placeList.get(i)))).get(0));
                              pstmt_correlation.addBatch();
                           } catch (SQLException e) {
                              e.printStackTrace();
                           }

                           correlationstr.setLength(0);
                        }
                     } else {
                        Map<String, Float> map = CorrelationTool.check(list, Integer.parseInt((String)placeList.get(0)), confidenceRate);

                        for(String key : map.keySet()) {
                           correlationstr.append(key + "=" + map.get(key) + ",");
                        }

                        try {
                           if (correlationstr.length() > 0) {
                              pstmt_correlation.setObject(1, correlationstr.toString().substring(0, correlationstr.length() - 1));
                           } else {
                              pstmt_correlation.setObject(1, "");
                           }

                           pstmt_correlation.setObject(2, schema);
                           pstmt_correlation.setObject(3, tableName);
                           pstmt_correlation.setObject(4, ((List)list.get(Integer.parseInt((String)placeList.get(0)))).get(0));
                           pstmt_correlation.addBatch();
                        } catch (SQLException e) {
                           e.printStackTrace();
                        }
                     }

                     CacheUtil.delCacheValue("TdataDiscoveryIntelligence_list_" + tableName);
                     CacheUtil.delCacheValue("TdataDiscoveryIntelligence_placeList_" + tableName);
                     CacheUtil.delCacheValue("TdataDiscoveryIntelligence_columnNo_" + tableName);
                  }
               }
            }
         }

         ++schemaIndex;
      }

      for(String schema : schemaslist) {
         new ArrayList();
         List<String> allTableListOfSchema = (List)scMap.get(schema);
         if ("0".equals(flag)) {
            List<ColumnInfo> var202 = this.tableJoinsInfoService.queryTbForCol(connection, schema);

            for(String tableName : allTableListOfSchema) {
               List<ForeignKeyInfo> fkList = this.tableJoinsInfoService.getFkList(connection, schema, tableName);
               this.tableJoinsInfoService.findColFK(taskid, tableName, var202, fkList);
            }
         }
      }

      try {
         pstmt.executeBatch();
         tconnection.commit();
         pstmt_correlation.executeBatch();
         tconnection.commit();
         pstmt.close();
         pstmt_correlation.close();
         tconnection.close();
      } catch (SQLException e) {
         this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",endpilinagfaild_db\r\n", url);
         String content = this.geterrorprint(e);
         this.writeErroFile("endpilinagfaild_db", content, url);
         resultMap.put("error", "true");
         e.printStackTrace();
      }

      SqlFileTool.exportSql(discoveryTask.getResultid());
      HashMap<String, TCoreProjectVersionVO> var188 = null;
      if (this.vlist.size() != 0 && this.vlist.contains("pool" + discoveryTask.getId())) {
         resultMap.put("isstop", "true");
      } else {
         resultMap.put("sureTable", String.valueOf(sureTable));
         resultMap.put("sureColumn", String.valueOf(sureColumn));
         resultMap.put("columnSum", String.valueOf(columnSum));
         resultMap.put("tableCount", String.valueOf(tableCount));
      }

      CacheUtil.put(discoveryTask.getId() + "tableCount", tableCount);
      return resultMap;
   }

   public void findTablePFk(String taskid, Connection connection, String schema, String tablename, List<ColumnInfo> columnInfoList, List<String> tablenamelist) {
      this.tableJoinsInfoService.saveJoinsInfo(connection, schema, tablename, columnInfoList, taskid, tablenamelist);
   }

   public int getSensitiveColumnsByContent(String datasourceid, String datasourcename, String schema, ResultSet resultSet, String tableName, String rate, String hits, List<TcoreTaskFindrule> searchRegexList, List<Pattern> patternList, String tcoreDiscoveryResult_sql, List<String> list_table, List<Map<String, Object>> sensitiveRule, String projectid, String taskid, PreparedStatement pstmt, int cnt, int batcheSize, Connection tconnection, boolean isIntelligence, int placeNo, String version, Map<String, String> remarkmap) {
      int count = 0;
      new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = props.getProperty("rateDir");
      String matchurl = url + "match" + File.separator + projectid + File.separator + taskid + File.separator + tableName + File.separator;
      String unmatchedurl = url + "unmatched" + File.separator + projectid + File.separator + taskid + File.separator + tableName + File.separator;
      String isrepeatvalue = props.get("isrepeatvalue").toString();
      String isRate = props.get("isRate").toString();
      int matchNum = 0;
      int unmatched = 0;
      int columnNo = 0;
      String cph = "湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领A-Z]{1}[A-Z]{1}[A-Z0-9]{4}[A-Z0-9挂学警港澳]{1}$";
      StringBuffer matchstr = new StringBuffer();
      StringBuffer unmatchstr = new StringBuffer();
      if ("1".equals(isRate)) {
         matchNum = Integer.parseInt(props.get("rateNum").toString());
         unmatched = matchNum;
      }

      try {
         Map<Integer, List<String>> columnValueMap = new HashMap();
         Map<Integer, Set<String>> columnDistinctValueMap = new HashMap();
         Map<Integer, List<String>> columnAllValueMap = new HashMap();
         ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
         int columnCount = resultSetMetaData.getColumnCount();
         long rowCount = 0L;
         long[] nullOrEmptyCount = new long[columnCount];
         List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList = this.tCoreEncryptionTypeFieldDao.getTCoreEncryptionTypeField(tableName, schema, datasourceid);
         new ArrayList();
         new TCoreEncryption();
         new TCoreSecretkey();
         HashMap<String, String> fieldSecretMap = new HashMap();
         HashMap<String, String> fieldtypeMap = new HashMap();
         HashMap<String, String> isLikeMap = new HashMap();
         HashMap<String, String> keepFirstMap = new HashMap();
         HashMap<String, String> encDigitMap = new HashMap();
         HashMap<String, String> twoindexMap = new HashMap();

         for(TCoreEncryptionTypeField t : tCoreEncryptionTypeFieldList) {
            if ("5".equals(t.getFlag())) {
               TCoreSecretkey secretKey = (TCoreSecretkey)this.tCoreSecretkeyDao.get(t.getEncryption_secretkey_id());
               fieldSecretMap.put(t.getTable_field_id(), secretKey.getSectet_key_value());
               isLikeMap.put(t.getTable_field_id(), t.getIslike());
               keepFirstMap.put(t.getTable_field_id(), t.getKeepfirst());
               encDigitMap.put(t.getTable_field_id(), t.getEncdigit());
               twoindexMap.put(t.getTable_field_id(), t.getTwoindex());
               TCoreEncryption tCoreEncryption = (TCoreEncryption)this.tCoreEncryptionDao.get(secretKey.getEncryption_id());
               String encryption_type = tCoreEncryption.getEncryption_type();
               fieldtypeMap.put(t.getTable_field_id(), encryption_type);
            }
         }

         TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasourceid);

         for(String dbtype = datasystem.getDbtype(); resultSet.next(); ++rowCount) {
            for(int i = 0; i < columnCount; ++i) {
               if (rowCount == 0L) {
                  columnValueMap.put(i, new ArrayList());
                  columnDistinctValueMap.put(i, new HashSet());
                  columnAllValueMap.put(i, new ArrayList());
               }

               Object columnValueObj = null;
               if (resultSetMetaData.getColumnType(i + 1) == 2009) {
                  System.out.println("表名：" + tableName);
                  System.out.println("不支持的列：" + resultSetMetaData.getColumnName(i + 1));
               } else {
                  try {
                     resultSet.getObject(i + 1);
                     String columnname = "";
                     if ("DM".equals(dbtype)) {
                        DmdbResultSetMetaData dmmetaData = (DmdbResultSetMetaData)resultSetMetaData;
                        Class c = DmdbResultSetMetaData.class;
                        Field fieldcolumns = c.getDeclaredField("columns");
                        fieldcolumns.setAccessible(true);
                        Column[] cs = (Column[])fieldcolumns.get(dmmetaData);
                        columnname = cs[i].name;
                     } else {
                        columnname = resultSetMetaData.getColumnName(i + 1);
                     }

                     if (fieldSecretMap.containsKey(columnname)) {
                        if (resultSet.getObject(i + 1) != null) {
                           String fieldSecretKey = (String)fieldSecretMap.get(columnname);
                           String encryptionType = (String)fieldtypeMap.get(columnname);
                           columnValueObj = EncProvider.decryptEcb(encryptionType, fieldSecretKey, resultSet.getObject(i + 1).toString(), (String)isLikeMap.get(columnname), (String)keepFirstMap.get(columnname), (String)encDigitMap.get(columnname), (String)twoindexMap.get(columnname));
                        } else {
                           columnValueObj = null;
                        }
                     } else {
                        columnValueObj = resultSet.getObject(i + 1);
                     }

                     if (columnValueObj instanceof DmdbNClob) {
                        DmdbNClob temp = (DmdbNClob)columnValueObj;
                        columnValueObj = temp.data;
                     }

                     if (resultSetMetaData.getScale(i + 1) > 0) {
                        String fmt = "";

                        for(int j = 0; j < resultSetMetaData.getScale(i + 1); ++j) {
                           fmt = fmt + "0";
                        }

                        DecimalFormat df = new DecimalFormat("0." + fmt);
                        columnValueObj = df.format(columnValueObj);
                     }
                  } catch (Exception var128) {
                     columnValueObj = null;
                  }
               }

               if (columnValueObj != null) {
                  String columnValue = columnValueObj.toString();
                  if (columnValueObj instanceof byte[]) {
                     columnValue = "";
                  }

                  if (!"".equals(columnValue.trim())) {
                     ((List)columnValueMap.get(i)).add(columnValue);
                     ((Set)columnDistinctValueMap.get(i)).add(columnValue);
                  } else {
                     int var10002 = (int) nullOrEmptyCount[i]++;
                  }

                  ((List)columnAllValueMap.get(i)).add(columnValue);
               } else {
                  int var175 = (int) nullOrEmptyCount[i]++;
                  ((List)columnAllValueMap.get(i)).add(null);
               }
            }
         }

         if (rowCount <= 0L) {
            for(int i = 0; i < columnCount; ++i) {
               String columnname = resultSetMetaData.getColumnName(i + 1);
               pstmt.setObject(1, datasourceid);
               pstmt.setObject(2, schema);
               pstmt.setObject(3, tableName);
               pstmt.setObject(4, columnname);
               pstmt.setObject(5, "");
               pstmt.setObject(6, "0");
               pstmt.setObject(7, "0");
               pstmt.setObject(8, "0%");
               pstmt.setObject(9, "");
               pstmt.setObject(10, "");
               pstmt.setObject(11, "");
               pstmt.setObject(12, "");
               pstmt.setObject(13, "0");
               pstmt.setObject(14, "");
               pstmt.setObject(15, "");
               pstmt.setObject(16, "");
               pstmt.setObject(17, UUID.randomUUID().toString());
               pstmt.addBatch();
               ++cnt;
               if (cnt % batcheSize == 0) {
                  long useTime1 = System.currentTimeMillis();
                  pstmt.executeBatch();
                  pstmt.clearBatch();
                  tconnection.commit();
                  long useTime2 = System.currentTimeMillis();
                  System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
               }
            }

            boolean var137 = false;
         } else {
            for(int i = 0; i < columnCount; ++i) {
               String columnname = resultSetMetaData.getColumnName(i + 1);
               long validCount = rowCount - nullOrEmptyCount[i];
               double distinctCount = (double)((Set)columnDistinctValueMap.get(i)).size();
               SensitiveColumn column = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, validCount, (long)distinctCount);
               List<String> columnValues = (List)columnValueMap.get(i);
               List<String> columnAllValues = (List)columnAllValueMap.get(i);
               if (isIntelligence && !"datetime".equals(resultSetMetaData.getColumnType(i + 1)) && validCount > 0L) {
                  List<String> columnList = new ArrayList();
                  columnList.add(columnname);

                  for(int x = 0; x < columnAllValues.size(); ++x) {
                     columnList.add(columnAllValues.get(x));
                  }

                  ArrayList<List<String>> list = (ArrayList)CacheUtil.getCacheValue("TdataDiscoveryIntelligence_list_" + tableName);
                  list.add(columnList);
                  CacheUtil.put("TdataDiscoveryIntelligence_list_" + tableName, list);
                  if (CacheUtil.getCacheValue("TdataDiscoveryIntelligence_columnNo_" + tableName) != null) {
                     columnNo = (Integer)CacheUtil.getCacheValue("TdataDiscoveryIntelligence_columnNo_" + tableName);
                     ++columnNo;
                     CacheUtil.put("TdataDiscoveryIntelligence_columnNo_" + tableName, columnNo);
                  } else {
                     CacheUtil.put("TdataDiscoveryIntelligence_columnNo_" + tableName, columnNo);
                  }
               }

               long maxMatchCount = 0L;
               List<String> maxMatchValues = null;
               List<String> maxNotMathValues = null;
               String dataarea_id = "";
               String dataarea_name = "";
               String issure = "0";
               String tschemas = column.getSchema();
               String fields = column.getColumnName();
               String fieldremark = (String)remarkmap.get(column.getColumnName());
               String matching = rate;
               String sensitive_id = "";
               String sensitive_name = "";
               String teffe_sampling = "";
               NumberFormat nf = NumberFormat.getInstance();
               Number m = nf.parse(rate);
               if (null != columnValues && columnValues.size() != 0) {
                  int patternIndex = 0;

                  for(Pattern pattern : patternList) {
                     matchstr.setLength(0);
                     unmatchstr.setLength(0);
                     if ("1".equals(isRate)) {
                        matchNum = Integer.parseInt(props.get("rateNum").toString());
                        unmatched = matchNum;
                     }

                     TcoreTaskFindrule searchRegex = (TcoreTaskFindrule)searchRegexList.get(patternIndex++);
                     String dataareaid = searchRegex.getDataareaid();
                     String regexType = searchRegex.getDataarea();
                     String ruleid = searchRegex.getRuleid();
                     String regexName = searchRegex.getRulename();
                     String disoverway = searchRegex.getDiscoverway();
                     String dictionaryClass = searchRegex.getDictionaryClass();
                     String matchingway = searchRegex.getMatchingwaSy();
                     String mixdataarea = searchRegex.getMixdataarea();
                     int level = 0;
                     long matchCount = 0L;
                     long nomatchCount = 0L;
                     List<String> tempMatchValues = new ArrayList();
                     List<String> matchValues = new ArrayList();
                     List<String> notMatchValues = new ArrayList();
                     Map<String, Integer> namerepeatmap = new HashMap();
                     if (pattern.pattern().startsWith("MethodName:")) {
                        String methodName = pattern.pattern().substring(11);
                        int maxLength = -1;
                        if (methodName.contains("MaxLength:")) {
                           if (methodName.contains("Weight:")) {
                              String[] parameters = methodName.split("\\|MaxLength:");
                              if (parameters.length == 2) {
                                 methodName = parameters[0];
                                 String[] Weight = parameters[1].split("\\|Weight:");
                                 maxLength = Integer.parseInt(Weight[0]);

                                 try {
                                    level = Integer.parseInt(Weight[1]);
                                 } catch (Exception var126) {
                                    level = 0;
                                 }
                              }
                           } else {
                              String[] parameters = methodName.split("\\|MaxLength:");
                              if (parameters.length == 2) {
                                 methodName = parameters[0];
                                 maxLength = Integer.parseInt(parameters[1]);
                              }
                           }
                        }

                        for(String val : columnValues) {
                           if (this.matches(methodName, maxLength, val, level)) {
                              ++matchCount;
                              matchValues.add(val);
                              if ("姓名".equals(regexType)) {
                                 Integer integer = (Integer)namerepeatmap.get(val);
                                 namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                              }

                              tempMatchValues.add(regexType + ":" + val);
                              if (matchNum > 0) {
                                 matchstr.append(val + "\r\n");
                                 --matchNum;
                              }
                           } else {
                              ++nomatchCount;
                              notMatchValues.add(val);
                              if (unmatched > 0) {
                                 unmatchstr.append(val + "\r\n");
                                 --unmatched;
                              }
                           }
                        }
                     } else if ("03".equals(disoverway)) {
                        List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryDictionaryFile(dictionaryClass);

                        for(String val : columnValues) {
                           if (this.dicmatch(list, matchingway, val)) {
                              ++matchCount;
                              matchValues.add(val);
                              if ("姓名".equals(regexType)) {
                                 Integer integer = (Integer)namerepeatmap.get(val);
                                 namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                              }

                              tempMatchValues.add(regexType + ":" + val);
                              if (matchNum > 0) {
                                 matchstr.append(val + "\r\n");
                                 --matchNum;
                              }
                           } else {
                              ++nomatchCount;
                              notMatchValues.add(val);
                              if (unmatched > 0) {
                                 unmatchstr.append(val + "\r\n");
                                 --unmatched;
                              }
                           }
                        }
                     } else {
                        for(String val : columnValues) {
                           if (pattern.matcher(val).matches()) {
                              ++matchCount;
                              matchValues.add(val);
                              if ("姓名".equals(regexType)) {
                                 Integer integer = (Integer)namerepeatmap.get(val);
                                 namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                              }

                              tempMatchValues.add(regexType + ":" + val);
                              if (matchNum > 0) {
                                 matchstr.append(val + "\r\n");
                                 --matchNum;
                              }
                           } else {
                              ++nomatchCount;
                              notMatchValues.add(val);
                              if (unmatched > 0) {
                                 unmatchstr.append(val + "\r\n");
                                 --unmatched;
                              }
                           }
                        }
                     }

                     if (matchstr.length() > 0) {
                        this.writeFileRefresh(columnname, matchstr.toString(), matchurl);
                     } else {
                        this.writeFileRefresh(columnname, "", matchurl);
                     }

                     if (unmatchstr.length() > 0) {
                        this.writeFileRefresh(columnname, unmatchstr.toString(), unmatchedurl);
                     } else {
                        this.writeFileRefresh(columnname, "", unmatchedurl);
                     }

                     boolean isrepeatdata = true;
                     if ("姓名".equals(regexType)) {
                        Integer matchValuessize = (int)((double)matchValues.size() * Double.parseDouble(isrepeatvalue));

                        for(Map.Entry<String, Integer> entry : namerepeatmap.entrySet()) {
                           if ((Integer)entry.getValue() > matchValuessize) {
                              isrepeatdata = false;
                              break;
                           }
                        }
                     }

                     if (columnValues.size() > Integer.parseInt(hits)) {
                        teffe_sampling = hits;
                     } else {
                        teffe_sampling = String.valueOf(columnValues.size());
                     }

                     NumberFormat numberFormat = NumberFormat.getInstance();
                     numberFormat.setMaximumFractionDigits(2);
                     String result = numberFormat.format((double)((float)matchCount / (float)columnValues.size() * 100.0F));
                     matching = result + "%";
                     if ((double)matchCount / (double)columnValues.size() >= m.doubleValue() / (double)100.0F) {
                        if (isrepeatdata) {
                           column.setMatchResult(regexType, regexName, (long)matchValues.size(), matchValues, notMatchValues);
                        }

                        (new StringBuilder()).append(schema).append("_m").append(tableName).append("_m").append(columnname).toString();
                        HashMap<String, List<String>> keyhash = new HashMap();
                        List<String> matchValuesList = new ArrayList();
                        List<String> notMatchValuesList = new ArrayList();
                        if (matchValues.size() > 100) {
                           matchValuesList.addAll(matchValues.subList(0, 100));
                        } else if (matchValues.size() != 0) {
                           matchValuesList.addAll(matchValues.subList(0, matchValues.size()));
                        }

                        if (notMatchValues.size() > 100) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                        } else if (notMatchValues.size() != 0) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                        }

                        keyhash.put("matchValues", matchValuesList);
                        keyhash.put("notMatchValues", notMatchValuesList);
                        dataarea_id = dataareaid;
                        dataarea_name = regexType;
                        if (disoverway == "02") {
                           dataarea_name = mixdataarea;
                        }

                        sensitive_id = ruleid;
                        sensitive_name = regexName;
                        ++count;
                        if (isIntelligence && pattern.pattern().startsWith("MethodName:") && (pattern.pattern().substring(11).contains("isPersonName") || pattern.pattern().substring(11).contains("isMobilephoneNo") || pattern.pattern().substring(11).contains("isIdentifyNo") || pattern.pattern().substring(11).contains("isCardNo") || pattern.pattern().substring(11).contains(cph))) {
                           List<String> placeList = (List)CacheUtil.getCacheValue("TdataDiscoveryIntelligence_placeList_" + tableName);
                           if (placeList != null) {
                              placeList.add(String.valueOf(columnNo));
                           }

                           CacheUtil.put("TdataDiscoveryIntelligence_placeList_" + tableName, placeList);
                        }
                        break;
                     }

                     if (maxMatchCount < matchCount) {
                        maxMatchCount = matchCount;
                        maxMatchValues = tempMatchValues;
                        maxNotMathValues = notMatchValues;
                     }
                  }

                  if (!column.isSensitiveColumn()) {
                     if (maxMatchCount > 0L) {
                        column.setMatchCount(maxMatchCount);
                        column.setMatchValues(maxMatchValues);
                        column.setNotMatchValues(maxNotMathValues);
                     } else {
                        column.setNotMatchValues(columnValues);
                     }
                  }

                  pstmt.setObject(1, datasourceid);
                  pstmt.setObject(2, tschemas);
                  pstmt.setObject(3, tableName);
                  pstmt.setObject(4, fields);
                  pstmt.setObject(5, fieldremark);
                  pstmt.setObject(6, hits);
                  pstmt.setObject(7, teffe_sampling);
                  pstmt.setObject(8, matching);
                  pstmt.setObject(9, dataarea_id);
                  pstmt.setObject(10, dataarea_name);
                  pstmt.setObject(11, sensitive_id);
                  pstmt.setObject(12, sensitive_name);
                  pstmt.setObject(13, issure);
                  pstmt.setObject(14, "");
                  pstmt.setObject(15, "");
                  pstmt.setObject(16, "");
                  pstmt.setObject(17, UUID.randomUUID().toString());
                  pstmt.addBatch();
                  if (cnt % batcheSize == 0) {
                     long useTime1 = System.currentTimeMillis();
                     pstmt.executeBatch();
                     pstmt.clearBatch();
                     tconnection.commit();
                     long useTime2 = System.currentTimeMillis();
                     System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                  }
               } else {
                  pstmt.setObject(1, datasourceid);
                  pstmt.setObject(2, tschemas);
                  pstmt.setObject(3, tableName);
                  pstmt.setObject(4, fields);
                  pstmt.setObject(5, fieldremark);
                  pstmt.setObject(6, hits);
                  pstmt.setObject(7, "0");
                  pstmt.setObject(8, "0%");
                  pstmt.setObject(9, dataarea_id);
                  pstmt.setObject(10, dataarea_name);
                  pstmt.setObject(11, sensitive_id);
                  pstmt.setObject(12, sensitive_name);
                  pstmt.setObject(13, issure);
                  pstmt.setObject(14, "");
                  pstmt.setObject(15, "");
                  pstmt.setObject(16, "");
                  pstmt.setObject(17, UUID.randomUUID().toString());
                  pstmt.addBatch();
               }
            }
         }
      } catch (Exception e) {
         this.tdataDiscoveryService.updateTaskstatus(taskid, "2", version);
         e.printStackTrace();
      } finally {
         try {
            resultSet.close();
         } catch (Exception e1) {
            e1.printStackTrace();
         }

         return count;
      }
   }

   private boolean dicmatch(List<TConsoleDictionary> list, String matchingway, String val) {
      boolean flag = false;

      for(TConsoleDictionary dic : list) {
         String dicvalue = dic.getValue();
         if ("左匹配".equals(matchingway)) {
            flag = val.startsWith(dicvalue);
            if (flag) {
               break;
            }
         } else if ("右匹配".equals(matchingway)) {
            flag = val.endsWith(dicvalue);
            if (flag) {
               break;
            }
         } else if ("等于".equals(matchingway)) {
            flag = val.equals(dicvalue);
            if (flag) {
               break;
            }
         } else if ("包含".equals(matchingway)) {
            if (val.indexOf(dicvalue) != -1) {
               flag = true;
               break;
            }

            flag = false;
         }
      }

      return flag;
   }

   public boolean matches(String methodName, int maxLength, String matchString, int level) {
      boolean result = false;
      if (methodName != null && matchString != null) {
         matchString = matchString.replaceAll(" ", "");
         if (!matchString.equals("")) {
            if (maxLength == -1) {
               try {
                  if (!this.methods.containsKey(methodName)) {
                     this.methods.put(methodName, this.getClass().getDeclaredMethod(methodName, String.class));
                  }

                  result = (Boolean)((Method)this.methods.get(methodName)).invoke(this, matchString);
               } catch (Exception e) {
                  e.printStackTrace();
               }
            } else if (matchString.length() <= maxLength) {
               try {
                  if (methodName.equals("isChineseAddress")) {
                     if (!this.methods.containsKey(methodName)) {
                        this.methods.put(methodName, this.getClass().getDeclaredMethod(methodName, String.class, Integer.TYPE, Integer.TYPE));
                     }

                     result = (Boolean)((Method)this.methods.get(methodName)).invoke(this, matchString, maxLength, level);
                  } else {
                     if (!this.methods.containsKey(methodName)) {
                        this.methods.put(methodName, this.getClass().getDeclaredMethod(methodName, String.class, Integer.TYPE));
                     }

                     result = (Boolean)((Method)this.methods.get(methodName)).invoke(this, matchString, maxLength);
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }
         }
      }

      return result;
   }

   public boolean getSensitiveColumnByName(TcoreDiscoveryResult tcoreDiscoveryResult, String datasourceid, String datasourcename, String schema, String tableName, String columnName, String fieldremark, List<TcoreTaskFindrule> regexByNamelist, List<Pattern> patternList, String tcoreDiscoveryResult_sql, String rate, String hits, List<String> list_table, String teffe_sampling, List<Map<String, Object>> sensitiveRule, PreparedStatement pstmt, int cnt, int batcheSize, Connection tconnection, String typename) throws SQLException {
      SensitiveColumn column = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnName);
      int index = 0;
      boolean temp = false;
      String dataarea_id = "";
      String dataarea_name = "";
      String issure = "0";
      String sensitive_id = "";
      String sensitive_name = "";
      String matching = "0%";

      for(Pattern pattern : patternList) {
         if (pattern.matcher(column.getColumnName()).matches()) {
            TcoreTaskFindrule searchRegex = (TcoreTaskFindrule)regexByNamelist.get(index);
            dataarea_id = searchRegex.getDataareaid();
            dataarea_name = searchRegex.getDataarea();
            String ruleid = searchRegex.getRuleid();
            String regexName = searchRegex.getRulename();
            temp = true;
            pstmt.setObject(1, datasourceid);
            pstmt.setObject(2, schema);
            pstmt.setObject(3, tableName);
            pstmt.setObject(4, columnName);
            pstmt.setObject(5, fieldremark);
            pstmt.setObject(6, hits);
            pstmt.setObject(7, teffe_sampling);
            pstmt.setObject(8, matching);
            pstmt.setObject(9, dataarea_id);
            pstmt.setObject(10, dataarea_name);
            pstmt.setObject(11, ruleid);
            pstmt.setObject(12, regexName);
            pstmt.setObject(13, issure);
            pstmt.setObject(14, "");
            pstmt.setObject(15, "");
            pstmt.setObject(16, "");
            pstmt.setObject(17, UUID.randomUUID().toString());
            pstmt.addBatch();
            if (cnt % batcheSize == 0) {
               long useTime1 = System.currentTimeMillis();
               pstmt.executeBatch();
               pstmt.clearBatch();
               tconnection.commit();
               long useTime2 = System.currentTimeMillis();
               System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
            }
            break;
         }

         TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(column.getDatasourceid());
         String dbtype = tCoreDatasystem.getDbtype();
         String dbSourceFlag = EdataMappingType.getFlagByName(dbtype.toUpperCase());
         List<Map<String, String>> pwctypeBySourceTypeList = this.desensitizationDataMappingService.getPwctypeBySourceType(dbSourceFlag, "10", this.delparentheses(typename));
         TcoreTaskFindrule searchRegex = (TcoreTaskFindrule)regexByNamelist.get(index);
         if (searchRegex.getDataarea().equals("大字段类型") && (typename.toLowerCase().contains("blob") || typename.toLowerCase().contains("clob") || typename.toLowerCase().contains("image"))) {
            dataarea_id = searchRegex.getDataareaid();
            dataarea_name = searchRegex.getDataarea();

            for(int x = 0; x < sensitiveRule.size(); ++x) {
               if (dataarea_id.equals(((Map)sensitiveRule.get(x)).get("dataarea_id"))) {
                  sensitive_id = (String)((Map)sensitiveRule.get(x)).get("rule_id");
                  sensitive_name = (String)((Map)sensitiveRule.get(x)).get("name");
               }
            }

            temp = true;
            pstmt.setObject(1, datasourceid);
            pstmt.setObject(2, schema);
            pstmt.setObject(3, tableName);
            pstmt.setObject(4, columnName);
            pstmt.setObject(5, fieldremark);
            pstmt.setObject(6, hits);
            pstmt.setObject(7, teffe_sampling);
            pstmt.setObject(8, matching);
            pstmt.setObject(9, dataarea_id);
            pstmt.setObject(10, dataarea_name);
            pstmt.setObject(11, sensitive_id);
            pstmt.setObject(12, sensitive_name);
            pstmt.setObject(13, issure);
            pstmt.setObject(14, "");
            pstmt.setObject(15, "");
            pstmt.setObject(16, "");
            pstmt.setObject(17, UUID.randomUUID().toString());
            pstmt.addBatch();
            if (cnt % batcheSize == 0) {
               long useTime1 = System.currentTimeMillis();
               pstmt.executeBatch();
               pstmt.clearBatch();
               tconnection.commit();
               long useTime2 = System.currentTimeMillis();
               System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
            }
            break;
         }

         if (searchRegex.getDataarea().equals("特殊字段类型") && pwctypeBySourceTypeList.size() > 0 && "binary".equalsIgnoreCase((String)((Map)pwctypeBySourceTypeList.get(0)).get("pwctype"))) {
            dataarea_id = searchRegex.getDataareaid();
            dataarea_name = searchRegex.getDataarea();

            for(int x = 0; x < sensitiveRule.size(); ++x) {
               if (dataarea_id.equals(((Map)sensitiveRule.get(x)).get("dataarea_id"))) {
                  sensitive_id = (String)((Map)sensitiveRule.get(x)).get("rule_id");
                  sensitive_name = (String)((Map)sensitiveRule.get(x)).get("name");
               }
            }

            temp = true;
            pstmt.setObject(1, datasourceid);
            pstmt.setObject(2, schema);
            pstmt.setObject(3, tableName);
            pstmt.setObject(4, columnName);
            pstmt.setObject(5, fieldremark);
            pstmt.setObject(6, hits);
            pstmt.setObject(7, teffe_sampling);
            pstmt.setObject(8, matching);
            pstmt.setObject(9, dataarea_id);
            pstmt.setObject(10, dataarea_name);
            pstmt.setObject(11, sensitive_id);
            pstmt.setObject(12, sensitive_name);
            pstmt.setObject(13, issure);
            pstmt.setObject(14, "");
            pstmt.setObject(15, "");
            pstmt.setObject(16, "");
            pstmt.setObject(17, UUID.randomUUID().toString());
            pstmt.addBatch();
            if (cnt % batcheSize == 0) {
               long useTime1 = System.currentTimeMillis();
               pstmt.executeBatch();
               pstmt.clearBatch();
               tconnection.commit();
               long useTime2 = System.currentTimeMillis();
               System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
            }
            break;
         }

         ++index;
      }

      return temp;
   }

   public boolean getSensitiveColumnByComment(TcoreDiscoveryResult tcoreDiscoveryResult, String datasourceid, String datasourcename, String schema, String tableName, String columnName, String fieldremark, List<TcoreTaskFindrule> regexByNamelist, List<Pattern> patternList, String tcoreDiscoveryResult_sql, String rate, String hits, List<String> list_table, String teffe_sampling, List<Map<String, Object>> sensitiveRule, PreparedStatement pstmt, int cnt, int batcheSize, Connection tconnection, String typename) throws SQLException {
      new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnName);
      int index = 0;
      boolean temp = false;
      String dataarea_id = "";
      String dataarea_name = "";
      String issure = "0";
      String sensitive_id = "";
      String sensitive_name = "";
      String matching = "0%";

      for(Pattern pattern : patternList) {
         if (StringUtils.isNotBlank(fieldremark) && pattern.matcher(fieldremark).matches()) {
            TcoreTaskFindrule searchRegex = (TcoreTaskFindrule)regexByNamelist.get(index);
            dataarea_id = searchRegex.getDataareaid();
            dataarea_name = searchRegex.getDataarea();
            String ruleid = searchRegex.getRuleid();
            String regexName = searchRegex.getRulename();
            temp = true;
            pstmt.setObject(1, datasourceid);
            pstmt.setObject(2, schema);
            pstmt.setObject(3, tableName);
            pstmt.setObject(4, columnName);
            pstmt.setObject(5, fieldremark);
            pstmt.setObject(6, hits);
            pstmt.setObject(7, teffe_sampling);
            pstmt.setObject(8, matching);
            pstmt.setObject(9, dataarea_id);
            pstmt.setObject(10, dataarea_name);
            pstmt.setObject(11, ruleid);
            pstmt.setObject(12, regexName);
            pstmt.setObject(13, issure);
            pstmt.setObject(14, "");
            pstmt.setObject(15, "");
            pstmt.setObject(16, "");
            pstmt.setObject(17, UUID.randomUUID().toString());
            pstmt.addBatch();
            if (cnt % batcheSize == 0) {
               long useTime1 = System.currentTimeMillis();
               pstmt.executeBatch();
               pstmt.clearBatch();
               tconnection.commit();
               long useTime2 = System.currentTimeMillis();
               System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
            }
            break;
         }

         ++index;
      }

      return temp;
   }

   public Map<String, String> getAllFileColumnsByContent(List<TCoreProjectFile> discoveryFile, String version, List<TcoreTaskFindrule> discoveryRule, TcoreDiscoveryTask discoveryTask, List<Map<String, Object>> sensitiveRule, String projectid, String userid) {
      Map<String, String> resultMap = new HashMap();
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      this.vlist.remove("pool" + discoveryTask.getId());
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = props.getProperty("monitorFile") + projectid + File.separator + discoveryTask.getId() + File.separator;
      String task_table = discoveryTask.getResultid();
      new TcoreDiscoveryDataResult();
      TcoreDiscoveryResult tcoreDiscoveryResult = new TcoreDiscoveryResult();
      StringBuilder tcoreDiscoveryResult_sql = new StringBuilder();
      List<String> list_table = JdbcTool.sql_insert_q(tcoreDiscoveryResult);
      list_table.add("id");
      String sqlBase = JdbcTool.sql_insert_z(list_table, task_table);
      tcoreDiscoveryResult_sql.append(sqlBase);
      String selectDataType = discoveryTask.getCyfs();
      String hits = discoveryTask.getCys();
      String rate = discoveryTask.getPpl();
      List<TcoreTaskFindrule> regexByContent = new ArrayList();

      for(int x = 0; x < discoveryRule.size(); ++x) {
         if (!"1".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getFlag())) {
            String discoveryway = "";
            String mixRule = "";
            String mixdataareaid = "";
            String mixdataarea = "";
            String mixrulename = "";
            if (!" ".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway()) && !"undefined".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway()) && ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway() != null && !"01".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
               if ("03".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
                  discoveryway = ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway();
                  List<TConsoleSearchregex> tConsoleSearchregexList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("name", ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename())});

                  for(int u = 0; u < tConsoleSearchregexList.size(); ++u) {
                     TcoreTaskFindrule tcoreTaskFindrule = new TcoreTaskFindrule();
                     tcoreTaskFindrule.setRegex(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getRegex());
                     tcoreTaskFindrule.setDataareaid(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDataarea_id());
                     tcoreTaskFindrule.setDataarea(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getType());
                     tcoreTaskFindrule.setRulename(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getName());
                     tcoreTaskFindrule.setDiscoverway(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDiscoverway());
                     tcoreTaskFindrule.setDictionaryClass(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDictionaryClass());
                     tcoreTaskFindrule.setMatchingwaSy(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getMatchingway());
                     regexByContent.add(tcoreTaskFindrule);
                  }
               } else if ("02".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
                  StringBuffer buf = new StringBuffer();
                  StringBuffer bufDataarea = new StringBuffer();
                  StringBuffer bufDataareaid = new StringBuffer();
                  StringBuffer bufRulename = new StringBuffer();
                  discoveryway = ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway();
                  List<TConsoleSearchregex> tConsoleSearchregexList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("name", ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename())});

                  for(int u = 0; u < tConsoleSearchregexList.size(); ++u) {
                     List<TCoreDataFileGroup> tCoreDataFileGroupList = this.tCoreDataFileGroupDao.queryAll(new Criterion[]{Restrictions.eq("searchregexid", ((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getId())});

                     for(int i = 0; i < tCoreDataFileGroupList.size(); ++i) {
                        List<TConsoleSearchregex> tConsoleSearchregexList1 = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("type", ((TCoreDataFileGroup)tCoreDataFileGroupList.get(i)).getDatafilename())});

                        for(int z = 0; z < tConsoleSearchregexList1.size(); ++z) {
                           if ("1".equals(((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getDefaulttype())) {
                              String a = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getRegex();
                              String b = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getType();
                              String c = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getDataarea_id();
                              String d = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getName();
                              buf.append("_#_" + a);
                              bufRulename.append("_#_" + d);
                              bufDataareaid.append("_#_" + c);
                              bufDataarea.append("_#_" + b);
                           }
                        }
                     }
                  }

                  buf.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex());
                  bufDataarea.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea());
                  bufDataareaid.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid());
                  bufRulename.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename());
                  mixRule = buf.toString();
                  mixdataareaid = bufDataareaid.toString();
                  mixdataarea = bufDataarea.toString();
                  mixrulename = bufRulename.toString();
                  String[] regexlist = mixRule.split("_#_");

                  for(int i = 0; i < regexlist.length; ++i) {
                     TcoreTaskFindrule tcoreTaskFindrule = new TcoreTaskFindrule();
                     tcoreTaskFindrule.setRegex(mixRule.split("_#_")[i]);
                     tcoreTaskFindrule.setDataareaid(mixdataareaid.split("_#_")[i]);
                     tcoreTaskFindrule.setDataarea(mixdataarea.split("_#_")[i]);
                     tcoreTaskFindrule.setDataarea(mixrulename.split("_#_")[i]);
                     regexByContent.add(tcoreTaskFindrule);
                  }
               }
            } else {
               discoveryway = " ";
               mixRule = ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex();
               mixdataareaid = ((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid();
               mixdataarea = ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea();
               mixrulename = ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename();
               regexByContent.add(new TcoreTaskFindrule(mixdataareaid, mixdataarea, mixrulename, mixRule, discoveryway, ((TcoreTaskFindrule)discoveryRule.get(x)).getRuleid()));
            }
         }
      }

      boolean isSelectData = this.isSelectData(hits, discoveryRule.size());
      boolean isVersion = version != null && !"0".equals(version);
      int sureTable = 0;
      int sureColumn = 0;
      int columnSum = 0;
      int tableSum = 0;
      int tableCount = discoveryFile.size();
      CacheUtil.put(discoveryTask.getId() + "tableCount", tableCount);
      CacheUtil.delCacheValue("taskstatus_" + discoveryTask.getId());
      new HashMap();
      HashMap<String, TCoreProjectVersionVO> version_map = new HashMap();
      if (isVersion) {
         version_map = this.queryProjectVersion(projectid, discoveryTask.getId(), version, userid);
      }

      List<Pattern> patternContentList = new ArrayList();

      for(TcoreTaskFindrule searchRegex : regexByContent) {
         patternContentList.add(Pattern.compile(searchRegex.getRegex()));
      }

      SFTPUtil sftp = null;

      for(TCoreProjectFile file : discoveryFile) {
         Map<String, List<String>> wjlist = new HashMap();
         TCoreFileStructurespliter tCoreFileStructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", file.getFilestructureid())});
         List<TCoreFileStructurecolumn> tCoreFileStructurecolumnlist = this.tCoreFileStructurecolumnDao.queryAll(new Criterion[]{Restrictions.eq("filestructureid", file.getFilestructureid())});
         TCoreFileStructure tCoreFileStructure = (TCoreFileStructure)this.tCoreFileStructureDao.queryUnique(new Criterion[]{Restrictions.eq("id", file.getFilestructureid())});
         List<String> widthname = new ArrayList();
         List<String> tablehname = new ArrayList();

         for(TCoreFileStructurecolumn tCoreFileStructurecolumn : tCoreFileStructurecolumnlist) {
            widthname.add(tCoreFileStructurecolumn.getColumnaccuracy());
            tablehname.add(tCoreFileStructurecolumn.getColumnname());
         }

         TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(file.getFilesource());
         String code = "UTF-8";
         if ("FTP".equals(file.getFilesourcetype())) {
            InputStream dataInputStream = null;
            FTPClient ftpClient = new FTPClient();

            try {
               ftpClient.setControlEncoding(datasystem.getPagecode());
               if (!ftpClient.isConnected()) {
                  ftpClient.connect(datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()));
               }

               boolean loginresult = ftpClient.login(datasystem.getUsername(), datasystem.getPassword());
               if (loginresult) {
                  dataInputStream = FtpTool.getDataInputStream(ftpClient, file.getFileurl(), file.getFilename(), datasystem.getPagecode());
                  if (dataInputStream != null) {
                     code = ReadJsonTool.sftpCharset(dataInputStream);
                     dataInputStream.close();
                     ftpClient.disconnect();
                  }
               }
            } catch (Exception e) {
               e.printStackTrace();
            }
         } else if ("SFTP".equals(file.getFilesourcetype())) {
            sftp = new SFTPUtil(datasystem.getUsername(), datasystem.getPassword(), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()));
            SFTPUtil.login();
            InputStream dataInputStream = null;

            try {
               dataInputStream = sftp.getDataInputStream(file.getFileurl() + File.separator + file.getFilename());
               if (dataInputStream != null) {
                  code = ReadJsonTool.sftpCharset(dataInputStream);
                  dataInputStream.close();
               }
            } catch (Exception e) {
               e.printStackTrace();
            }
         } else {
            code = ReadJsonTool.charset(file.getFileurl() + File.separator + file.getFilename());
         }

         if ("0".equals(tCoreFileStructure.getSplitertype())) {
            String spliterchar = tCoreFileStructurespliter.getDelimiters();
            if ("YES".equals(tCoreFileStructurespliter.getDelimiterencoding())) {
               spliterchar = StringTool.toStringHex(spliterchar.replace("0x", ""));
            }

            if ("FTP".equals(file.getFilesourcetype())) {
               try {
                  wjlist = FileTool.getFTPFileDataBySpliter(datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), datasystem.getUsername(), datasystem.getPassword(), file.getFileurl(), file.getFilename(), (new Long(hits)).intValue(), spliterchar, tCoreFileStructurespliter.getQuotecharacter(), code, tCoreFileStructurecolumnlist.size());
               } catch (Exception e) {
                  this.writeFile("errormanage", "文件和结构不匹配,比较严重," + formatter.format(new Date()) + ",fileunmatchstructure_ftp\r\n", url);
                  String content = this.geterrorprint(e);
                  this.writeErroFile("fileunmatchstructure_ftp", content, url);
                  resultMap.put("error", "true");
                  e.printStackTrace();
               }
            } else if ("SFTP".equals(file.getFilesourcetype())) {
               try {
                  wjlist = FileTool.getSFTPFileDataBySpliterandSkiprows(sftp, file.getFileurl() + "/", file.getFilename(), (new Long(hits)).intValue(), spliterchar, tCoreFileStructurespliter.getQuotecharacter(), code, tCoreFileStructurecolumnlist.size(), tCoreFileStructure.getSkiprows());
               } catch (Exception e) {
                  this.writeFile("errormanage", "文件和结构不匹配,比较严重," + formatter.format(new Date()) + ",fileunmatchstructure_sftp\r\n", url);
                  String content = this.geterrorprint(e);
                  this.writeErroFile("fileunmatchstructure_sftp", content, url);
                  resultMap.put("error", "true");
                  e.printStackTrace();
               }
            } else {
               try {
                  wjlist = FileTool.getFileDataBySpliter(file.getFileurl() + "/" + file.getFilename(), (new Long(hits)).intValue(), spliterchar, tCoreFileStructurespliter.getQuotecharacter(), code, tCoreFileStructurecolumnlist.size());
               } catch (Exception e) {
                  this.writeFile("errormanage", "文件和结构不匹配,比较严重," + formatter.format(new Date()) + ",fileunmatchstructure_bendi\r\n", url);
                  String content = this.geterrorprint(e);
                  this.writeErroFile("fileunmatchstructure_bendi", content, url);
                  resultMap.put("error", "true");
                  e.printStackTrace();
               }
            }
         } else if ("FTP".equals(file.getFilesourcetype())) {
            wjlist = FileTool.getFTPFileDataByWidth(datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), datasystem.getUsername(), datasystem.getPassword(), file.getFileurl(), file.getFilegroup(), (new Long(hits)).intValue(), widthname, code);
         } else if ("SFTP".equals(file.getFilesourcetype())) {
            sftp = new SFTPUtil(datasystem.getUsername(), datasystem.getPassword(), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()));
            SFTPUtil.login();
            wjlist = FileTool.getSFTPFileDataByWidth(sftp, file.getFileurl() + "/", file.getFilename(), (new Long(hits)).intValue(), widthname, code);
         } else {
            wjlist = FileTool.getFileDataByWidth(file.getFileurl() + "/" + file.getFilename(), (new Long(hits)).intValue(), widthname, code);
         }

         if (wjlist == null) {
            this.writeFile("errormanage", "找不到文件,比较严重," + formatter.format(new Date()) + ",notfindfile_file\r\n", url);
            String content1 = "报错信息:不能找到路径:" + file.getFileurl() + "下的" + file.getFilename() + "文件.";
            this.writeErroFile("notfindfile_file", content1, url);
            --tableCount;
            resultMap.put("error", "true");
         } else {
            columnSum += wjlist.size();
            String quotecharacter = null;
            if (tCoreFileStructurespliter != null) {
               quotecharacter = tCoreFileStructurespliter.getQuotecharacter();
            }

            int columncount = this.getFileSensitiveColumnsByContent(tablehname, datasystem.getId(), datasystem.getSysname(), file.getFilegroup(), wjlist, file.getFilename().split("\\.")[0], rate, hits, regexByContent, patternContentList, tcoreDiscoveryResult_sql, list_table, sensitiveRule, projectid, discoveryTask.getId(), quotecharacter, isVersion, isSelectData, version_map);
            sureColumn += columncount;
            if (columncount > 0) {
               ++sureTable;
            }

            ++tableSum;
            this.writeFile("done", file.getFilename().split("\\.")[0] + "," + file.getFilegroup() + "," + formatter.format(new Date()) + "\r\n", url);
            CacheUtil.put(discoveryTask.getId() + "tableSum", tableSum);
         }
      }

      if (sftp != null) {
         sftp.logout();
      }

      HashMap<String, TCoreProjectVersionVO> var76 = null;
      if (this.vlist.size() != 0 && this.vlist.contains("pool" + discoveryTask.getId())) {
         resultMap.put("isstop", "true");
      } else {
         StringBuilder sql = tcoreDiscoveryResult_sql.deleteCharAt(tcoreDiscoveryResult_sql.length() - 1);
         resultMap.put("sureTable", String.valueOf(sureTable));
         resultMap.put("sureColumn", String.valueOf(sureColumn));
         resultMap.put("columnSum", String.valueOf(columnSum));
         resultMap.put("tableCount", String.valueOf(tableCount));

         try {
            this.tcoreDiscoveryResultsRecordDao.saveDiscoveryResults(sql);
         } catch (Exception e) {
            e.printStackTrace();
            this.writeFile("errormanage", "插入结果表失败,非常严重," + formatter.format(new Date()) + ",inserttable_content\r\n", url);
            String content1 = this.geterrorprint(e);
            this.writeErroFile("inserttable_content", content1, url);
            resultMap.put("error", "true");
         }
      }

      CacheUtil.put(discoveryTask.getId() + "tableCount", tableCount);
      return resultMap;
   }

   public Map<String, String> getAllFileColumnsByContentUnknowstructure(List<TCoreProjectFile> discoveryFile, String version, List<TcoreTaskFindrule> discoveryRule, TcoreDiscoveryTask discoveryTask, List<Map<String, Object>> sensitiveRule, String projectid, String userid) {
      Map<String, String> resultMap = new HashMap();
      this.vlist.remove("pool" + discoveryTask.getId());
      String task_table = discoveryTask.getResultid();
      new TcoreDiscoveryDataResult();
      TcoreDiscoveryResult tcoreDiscoveryResult = new TcoreDiscoveryResult();
      StringBuilder tcoreDiscoveryResult_sql = new StringBuilder();
      List<String> list_table = JdbcTool.sql_insert_q(tcoreDiscoveryResult);
      list_table.add("id");
      String sqlBase = JdbcTool.sql_insert_z(list_table, task_table);
      tcoreDiscoveryResult_sql.append(sqlBase);
      String sql1 = "";

      for(int i = 0; i < list_table.size(); ++i) {
         if (i == 0) {
            sql1 = sql1 + "?";
         } else {
            sql1 = sql1 + ",?";
         }
      }

      tcoreDiscoveryResult_sql.append("(");
      tcoreDiscoveryResult_sql.append(sql1);
      tcoreDiscoveryResult_sql.append(")");
      String selectDataType = discoveryTask.getCyfs();
      String hits = discoveryTask.getCys();
      String rate = discoveryTask.getPpl();
      Boolean isFaceRule = false;
      TcoreTaskFindrule findRuleFace = new TcoreTaskFindrule();
      List<TcoreTaskFindrule> regexByContent = new ArrayList();

      for(int x = 0; x < discoveryRule.size(); ++x) {
         if (!"1".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getFlag())) {
            String discoveryway = "";
            String mixRule = "";
            String mixdataareaid = "";
            String mixdataarea = "";
            String mixrulename = "";
            if (!" ".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway()) && !"undefined".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway()) && ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway() != null && !"01".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
               if ("03".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
                  discoveryway = ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway();
                  List<TConsoleSearchregex> tConsoleSearchregexList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("name", ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename())});

                  for(int u = 0; u < tConsoleSearchregexList.size(); ++u) {
                     TcoreTaskFindrule tcoreTaskFindrule = new TcoreTaskFindrule();
                     tcoreTaskFindrule.setRegex(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getRegex());
                     tcoreTaskFindrule.setDataareaid(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDataarea_id());
                     tcoreTaskFindrule.setDataarea(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getType());
                     tcoreTaskFindrule.setRulename(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getName());
                     tcoreTaskFindrule.setDiscoverway(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDiscoverway());
                     tcoreTaskFindrule.setDictionaryClass(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDictionaryClass());
                     tcoreTaskFindrule.setMatchingwaSy(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getMatchingway());
                     regexByContent.add(tcoreTaskFindrule);
                  }
               } else if ("02".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
                  StringBuffer buf = new StringBuffer();
                  StringBuffer bufDataarea = new StringBuffer();
                  StringBuffer bufDataareaid = new StringBuffer();
                  StringBuffer bufRulename = new StringBuffer();
                  discoveryway = ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway();
                  List<TConsoleSearchregex> tConsoleSearchregexList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("name", ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename())});

                  for(int u = 0; u < tConsoleSearchregexList.size(); ++u) {
                     List<TCoreDataFileGroup> tCoreDataFileGroupList = this.tCoreDataFileGroupDao.queryAll(new Criterion[]{Restrictions.eq("searchregexid", ((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getId())});

                     for(int i = 0; i < tCoreDataFileGroupList.size(); ++i) {
                        List<TConsoleSearchregex> tConsoleSearchregexList1 = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("type", ((TCoreDataFileGroup)tCoreDataFileGroupList.get(i)).getDatafilename())});

                        for(int z = 0; z < tConsoleSearchregexList1.size(); ++z) {
                           if ("1".equals(((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getDefaulttype())) {
                              String a = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getRegex();
                              String b = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getType();
                              String c = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getDataarea_id();
                              String d = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getName();
                              buf.append("_#_" + a);
                              bufRulename.append("_#_" + d);
                              bufDataareaid.append("_#_" + c);
                              bufDataarea.append("_#_" + b);
                           }
                        }
                     }
                  }

                  buf.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex());
                  bufDataarea.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea());
                  bufDataareaid.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid());
                  bufRulename.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename());
                  mixRule = buf.toString();
                  mixdataareaid = bufDataareaid.toString();
                  mixdataarea = bufDataarea.toString();
                  mixrulename = bufRulename.toString();
                  String[] regexlist = mixRule.split("_#_");

                  for(int i = 0; i < regexlist.length; ++i) {
                     if (mixRule.split("_#_")[i].contains("isFace")) {
                        isFaceRule = true;
                        findRuleFace.setDataareaid(mixdataareaid.split("_#_")[i]);
                        findRuleFace.setDataarea(mixdataarea.split("_#_")[i]);
                        findRuleFace.setDiscoverway("");
                        findRuleFace.setRegex(mixRule.split("_#_")[i]);
                        findRuleFace.setRulename(mixrulename.split("_#_")[i]);
                     } else {
                        TcoreTaskFindrule tcoreTaskFindrule = new TcoreTaskFindrule();
                        tcoreTaskFindrule.setRegex(mixRule.split("_#_")[i]);
                        tcoreTaskFindrule.setDataareaid(mixdataareaid.split("_#_")[i]);
                        tcoreTaskFindrule.setDataarea(mixdataarea.split("_#_")[i]);
                        tcoreTaskFindrule.setRulename(mixrulename.split("_#_")[i]);
                        regexByContent.add(tcoreTaskFindrule);
                     }
                  }
               }
            } else {
               discoveryway = " ";
               mixRule = ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex();
               mixdataareaid = ((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid();
               mixdataarea = ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea();
               mixrulename = ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename();
               if (mixRule.contains("isFace")) {
                  isFaceRule = true;
                  findRuleFace.setDataareaid(mixdataareaid);
                  findRuleFace.setDataarea(mixdataarea);
                  findRuleFace.setDiscoverway("");
                  findRuleFace.setRegex(mixRule);
                  findRuleFace.setRulename(mixrulename);
               } else {
                  regexByContent.add(new TcoreTaskFindrule(mixdataareaid, mixdataarea, mixrulename, mixRule, discoveryway, ((TcoreTaskFindrule)discoveryRule.get(x)).getRuleid()));
               }
            }
         }
      }

      Properties props = null;

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String url = props.getProperty("monitorFile") + projectid + File.separator + discoveryTask.getId() + File.separator;
      boolean isSelectData = this.isSelectData(hits, discoveryRule.size());
      int tableCount = 0;
      CacheUtil.delCacheValue("taskstatus_" + discoveryTask.getId());
      new HashMap();
      new HashMap();
      List<Pattern> patternContentList = new ArrayList();

      for(TcoreTaskFindrule searchRegex : regexByContent) {
         patternContentList.add(Pattern.compile(searchRegex.getRegex()));
      }

      String path = ((TCoreProjectFile)discoveryFile.get(0)).getFileurl();
      new HashMap();
      new ArrayList();
      new ArrayList();
      new TCoreDatasystem();
      String filesourceid = ((TCoreProjectFile)discoveryFile.get(0)).getFilesource();
      TCoreDatasystem var95 = this.dataSystemService.queryDataSystemById(filesourceid);
      String driver = props.getProperty("jdbc.driver");
      String jdbcurl = props.getProperty("jdbc.url");
      String user = props.getProperty("jdbc.user");
      String password = props.getProperty("jdbc.password");
      String monitorurl = props.getProperty("monitorFile") + projectid + File.separator + discoveryTask.getId() + File.separator;
      int batcheSize = new Integer(props.getProperty("jdbc_insert_batche_size"));
      PreparedStatement pstmt = null;
      Connection tconnection = null;

      try {
         tconnection = JdbcTool.getConnectionlog(driver, jdbcurl, user, password);
         tconnection.setAutoCommit(false);
      } catch (ClassNotFoundException e3) {
         this.writeFile("errormanage", "本地数据库连接异常,非常严重," + formatter.format(new Date()) + ",filesystemcommerro_file\r\n", url);
         String content1 = this.geterrorprint(e3);
         this.writeErroFile("filesystemcommerro_file", content1, url);
         resultMap.put("error", "true");
      } catch (SQLException e3) {
         this.writeFile("errormanage", "本地数据库连接异常,非常严重," + formatter.format(new Date()) + ",filesystemcommerro1_file\r\n", url);
         String content1 = this.geterrorprint(e3);
         this.writeErroFile("filesystemcommerro1_file", content1, url);
         resultMap.put("error", "true");
      }

      try {
         pstmt = tconnection.prepareStatement(tcoreDiscoveryResult_sql.toString());
      } catch (SQLException e2) {
         this.writeFile("errormanage", "创建sql失败,非常严重," + formatter.format(new Date()) + ",filesystemcreasql_file\r\n", url);
         String content1 = this.geterrorprint(e2);
         this.writeErroFile("filesystemcreasql_file", content1, url);
         resultMap.put("error", "true");
      }

      Map<String , String> var92;
      if ("FTP".equals(((TCoreProjectFile)discoveryFile.get(0)).getFilesourcetype())) {
         FTPClient ftpClient = new FTPClient();
         FtpTool ftpTool = null;
         SSHTool executor = null;
         boolean loginresult = false;

         try {
            ftpClient.setControlEncoding(var95.getPagecode());
            ftpClient.setControlKeepAliveReplyTimeout(1500000);
            ftpClient.setConnectTimeout(1500000);
            ftpClient.setControlKeepAliveTimeout(1500000L);
            ftpClient.enterLocalPassiveMode();
            if (!ftpClient.isConnected()) {
               ftpClient.connect(var95.getDbip(), Integer.parseInt(var95.getDbport()));
            }

            loginresult = ftpClient.login(var95.getUsername(), var95.getPassword());
            if (!loginresult) {
               this.writeFile("errormanage", "ftp连接失败,非常严重," + formatter.format(new Date()) + ",connect_ftp\r\n", url);
               String content = "ftp账号或密码错误";
               this.writeErroFile("connect_ftp", content, url);
               resultMap.put("error", "true");
            }

            ftpClient.setFileType(2);
            executor = new SSHTool(var95.getDbip(), var95.getUsername(), var95.getPassword());
         } catch (NumberFormatException e) {
            e.printStackTrace();
         } catch (SocketException e) {
            e.printStackTrace();
         } catch (IOException e) {
            e.printStackTrace();
         }

         try {
            String os = System.getProperty("os.name");
            if (!os.toLowerCase().startsWith("win")) {
               File file = new File("/data/infa_file/filecount.sh");
               InputStream is = new FileInputStream(file);
               FtpTool.uploadFile(ftpClient, "/data/infa_file/", "filecount.sh", is);
               FtpTool.uploadFile(ftpClient, "/data/infa_file/", "filecount.txt", is);
               ftpClient.sendSiteCommand("chmod 777 /data/infa_file/filecount.sh");
               if (executor != null) {
                  SSHTool.exec("/data/infa_file/./filecount.sh " + path);
               }

               List<String> list = FtpTool.getData(ftpClient, "/data/infa_file/", "filecount.txt", var95.getPagecode());
               if (list.size() > 0) {
                  tableCount = Integer.parseInt((String)list.get(0));
               }

               System.out.println("文件数--->" + tableCount);
            } else {
               File dir = new File(path);
               Process ps = Runtime.getRuntime().exec("cmd.exe /c dir /b /s /a-d | find /v /c \"\"", (String[])null, dir);
               BufferedReader br = new BufferedReader(new InputStreamReader(ps.getInputStream(), Charset.forName("GBK")));

               String line;
               for(line = null; (line = br.readLine()) != null; tableCount = Integer.parseInt(line)) {
                  System.out.println(line);
               }

               br.close();
               System.out.println("close ... ");
               ps.waitFor();
               System.out.println("wait over ...");
            }

            CacheUtil.put(discoveryTask.getId() + "tableCount", tableCount);
         } catch (Exception e) {
            this.writeFile("errormanage", "linux命令查询文件数量执行失败,非常严重," + formatter.format(new Date()) + ",findcounterro_ftp\r\n", url);
            String content1 = this.geterrorprint(e);
            this.writeErroFile("findcounterro_ftp", content1, url);
            resultMap.put("error", "true");
            e.printStackTrace();
         }

         int sureTable = 0;
         int columnSum = 0;
         int tableSum = 0;
         Map<String, String> resultmap = new HashMap();
         resultmap.put("sureTable", String.valueOf(sureTable));
         resultmap.put("tableSum", String.valueOf(tableSum));
         Set<Object> dataareaSet = new HashSet();
         var92 = this.getFtpFile(dataareaSet, resultmap, path, var95, ((TCoreProjectFile)discoveryFile.get(0)).getFilesourcetype(), isFaceRule, findRuleFace, hits, projectid, discoveryTask.getId(), rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, ftpClient, url);
         resultMap.put("columnSum", String.valueOf(dataareaSet.size()));
         if (ftpClient != null) {
            try {
               ftpClient.disconnect();
            } catch (IOException e) {
               e.printStackTrace();
            }
         }
      } else if ("SFTP".equals(((TCoreProjectFile)discoveryFile.get(0)).getFilesourcetype())) {
         SFTPUtil sftp = null;
         sftp = new SFTPUtil(var95.getUsername(), var95.getPassword(), var95.getDbip(), Integer.parseInt(var95.getDbport()));
         SFTPUtil.login();

         try {
            sftp.upload("/data/infa_file/", "/data/infa_file/filecount.sh");
            sftp.upload("/data/infa_file/", "/data/infa_file/filecount.txt");
            SFTPUtil.execCmd("chmod 777 /data/infa_file/filecount.sh");
            SFTPUtil.execCmd("/data/infa_file/./filecount.sh " + path);
            List<String> list = sftp.getData("/data/infa_file/filecount.txt", var95.getPagecode());
            if (list.size() > 0) {
               tableCount = Integer.parseInt((String)list.get(0));
            }

            CacheUtil.put(discoveryTask.getId() + "tableCount", tableCount);
         } catch (Exception e) {
            System.out.println("linux命令查询文件数量执行失败");
            this.writeFile("errormanage", "linux命令查询文件数量执行失败,非常严重," + formatter.format(new Date()) + ",findcounterro_sftp\r\n", url);
            String content1 = this.geterrorprint(e);
            this.writeErroFile("findcounterro_sftp", content1, url);
            resultMap.put("error", "true");
            e.printStackTrace();
         }

         int sureTable = 0;
         int columnSum = 0;
         int tableSum = 0;
         Map<String, String> resultmap = new HashMap();
         resultmap.put("sureTable", String.valueOf(sureTable));
         resultmap.put("tableSum", String.valueOf(tableSum));
         Set<Object> dataareaSet = new HashSet();
         var92 = this.getSftpFile(dataareaSet, resultmap, path, var95, ((TCoreProjectFile)discoveryFile.get(0)).getFilesourcetype(), isFaceRule, findRuleFace, hits, projectid, discoveryTask.getId(), rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, sftp, url);
         resultMap.put("columnSum", String.valueOf(dataareaSet.size()));
         if (sftp != null) {
            sftp.logout();
         }
      } else {
         try {
            String os = System.getProperty("os.name");
            if (os.toLowerCase().startsWith("win")) {
               File dir = new File(path);
               Process ps = Runtime.getRuntime().exec("/c dir /b /s /a-d | find /v /c \"\"", (String[])null, dir);
               BufferedReader br = new BufferedReader(new InputStreamReader(ps.getInputStream(), Charset.forName("GBK")));

               String line;
               for(line = null; (line = br.readLine()) != null; tableCount = Integer.parseInt(line)) {
                  System.out.println(line);
               }

               br.close();
               System.out.println("close ... ");
               ps.waitFor();
               System.out.println("wait over ...");
            } else {
               Runtime.getRuntime().exec("/data/infa_file/./filecount.sh " + path);
               File file = new File("/data/infa_file/filecount.txt");
               FileInputStream fis = new FileInputStream(file);
               InputStreamReader isr = new InputStreamReader(fis);

               BufferedReader bufferedReader;
               String line;
               for(bufferedReader = new BufferedReader(isr); (line = bufferedReader.readLine()) != null; tableCount = Integer.parseInt(line)) {
               }

               if (bufferedReader != null) {
                  bufferedReader.close();
               }

               if (isr != null) {
                  isr.close();
               }

               if (fis != null) {
                  fis.close();
               }
            }

            CacheUtil.put(discoveryTask.getId() + "tableCount", tableCount);
         } catch (Exception e) {
            System.out.println("linux命令查询文件数量执行失败");
            this.writeFile("errormanage", "linux命令查询文件数量执行失败,非常严重," + formatter.format(new Date()) + ",findcounterro_bendi\r\n", url);
            String content1 = this.geterrorprint(e);
            this.writeErroFile("findcounterro_bendi", content1, url);
            resultMap.put("error", "true");
            e.printStackTrace();
         }

         int sureTable = 0;
         int columnSum = 0;
         int tableSum = 0;
         Map<String, String> resultmap = new HashMap();
         resultmap.put("sureTable", String.valueOf(sureTable));
         CacheUtil.put(discoveryTask.getId() + "tableSum", tableSum);
         Set<Object> dataareaSet = new HashSet();
         var92 = this.getLocalFile(dataareaSet, resultmap, path, var95, ((TCoreProjectFile)discoveryFile.get(0)).getFilesourcetype(), isFaceRule, findRuleFace, hits, projectid, discoveryTask.getId(), rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt);
         resultMap.put("columnSum", String.valueOf(dataareaSet.size()));
      }

      try {
         pstmt.executeBatch();
         pstmt.clearBatch();
         tconnection.commit();
      } catch (SQLException e1) {
         this.writeFile("errormanage", "linux命令查询文件数量执行失败,非常严重," + formatter.format(new Date()) + ",piliangdealunknowstruct_bendi\r\n", url);
         String content1 = this.geterrorprint(e1);
         this.writeErroFile("piliangdealunknowstruct_bendi", content1, url);
         resultMap.put("error", "true");
         e1.printStackTrace();
      }

      try {
         if (tconnection != null) {
            tconnection.close();
         }

         if (pstmt != null) {
            pstmt.close();
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      tableCount = (Integer)CacheUtil.getCacheValue(discoveryTask.getId() + "tableCount");
      resultMap.put("tableCount", String.valueOf(tableCount));
      resultMap.put("sureTable", var92.get("sureTable"));
      return resultMap;
   }

   public Map<String, String> getSftpFile(Set<Object> dataareaSet, Map<String, String> resultmap, String path, TCoreDatasystem tCoreDatasystem, String fileSourceType, boolean isFaceRule, TcoreTaskFindrule findRuleFace, String hits, String projectid, String taskid, String rate, List<TcoreTaskFindrule> regexByContent, boolean isSelectData, List<Pattern> patternContentList, List<Map<String, Object>> sensitiveRule, int batcheSize, String monitorurl, Connection tconnection, PreparedStatement pstmt, SFTPUtil sftp, String url) {
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Map<String, Object> map = new HashMap();
      Vector<?> list = new Vector();
      boolean var62 = false;

      label554: {
         try {
            var62 = true;
            list = sftp.listFiles(path);
            var62 = false;
            break label554;
         } catch (SftpException e) {
            if (e.getMessage() != null) {
               if (e.getMessage().contains("Permission denied")) {
                  this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles_sftp\r\n", url);
                  String content1 = this.geterrorprint(e);
                  this.writeErroFile("listFiles_sftp", content1, url);
                  e.printStackTrace();
                  var62 = false;
               } else {
                  var62 = false;
               }
            } else {
               var62 = false;
            }
         } finally {
            if (var62) {
               map.put("listresult", true);
               map.put("list", list);
               Vector listFiles1 = (Vector)map.get("list");
               if ((Boolean)map.get("listresult")) {
                  for(int i = 0; i < listFiles1.size(); ++i) {
                     String fileName = ((ChannelSftp.LsEntry)listFiles1.get(i)).getFilename();
                     String longName = ((ChannelSftp.LsEntry)listFiles1.get(i)).getLongname();
                     List<String> detaillist = new ArrayList();
                     if (!".".equals(fileName) && !"..".equals(fileName) && !".".equals(fileName.substring(0, 1))) {
                        Pattern pattern = Pattern.compile("[^\\s]*");
                        Matcher matcher = pattern.matcher(longName);
                        int j = 0;
                        boolean flag = true;

                        while(matcher.find() && j < 5) {
                           if (!"".equals(matcher.group())) {
                              detaillist.add(matcher.group());
                              ++j;
                              flag = false;
                           }

                           if (!flag) {
                              break;
                           }
                        }

                        if (!"d".equals(((String)detaillist.get(0)).substring(0, 1)) && !"l".equals(((String)detaillist.get(0)).substring(0, 1)) && !"c".equals(((String)detaillist.get(0)).substring(0, 1)) && !"b".equals(((String)detaillist.get(0)).substring(0, 1))) {
                           if (!fileName.toString().toLowerCase().contains(".pipe")) {
                              InputStream dataInputStream = null;
                              String charset = "UTF-8";

                              try {
                                 dataInputStream = sftp.getDataInputStream(path + "/" + fileName);
                                 charset = ReadJsonTool.sftpCharset(dataInputStream);
                              } catch (Exception e) {
                                 Integer tableCount = (Integer)this.redisService.get(taskid + "tableCount");
                                 tableCount = tableCount - 1;
                                 this.redisService.set(taskid + "tableCount", tableCount);
                                 this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles2_sftp\r\n", url);
                                 String content1 = this.geterrorprint(e);
                                 this.writeErroFile("listFiles2_sftp", content1, url);
                                 e.printStackTrace();
                                 continue;
                              }

                              map = this.discoveryFileUnknowstructureSFTP(dataareaSet, fileName, path, path + "/" + fileName, tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, charset, tconnection, pstmt, sftp);
                              this.writeFile("done", fileName + "," + path + "," + formatter.format(new Date()) + "\r\n", monitorurl);
                              Integer sureTable = Integer.parseInt((String)resultmap.get("sureTable"));
                              Integer n = Integer.parseInt((String)map.get("sureTable"));
                              sureTable = sureTable + n;
                              resultmap.put("sureTable", sureTable.toString());
                              Integer tableSum = Integer.parseInt((String)resultmap.get("tableSum"));
                              if (tableSum == 10) {
                                 System.out.println();
                              }

                              tableSum = tableSum + 1;
                              resultmap.put("tableSum", tableSum.toString());
                              this.redisService.set(taskid + "tableSum", resultmap.get("tableSum"));
                           }
                        } else {
                           try {
                              if ("/".equals(path)) {
                                 this.getSftpFile(dataareaSet, resultmap, path + fileName, tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, sftp, url);
                              } else {
                                 this.getSftpFile(dataareaSet, resultmap, path + "/" + fileName, tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, sftp, url);
                              }
                           } catch (Exception e) {
                              if (e.getMessage() != null && e.getMessage().contains("Permission denied")) {
                                 this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles1_sftp\r\n", url);
                                 String content1 = this.geterrorprint(e);
                                 this.writeErroFile("listFiles1_sftp", content1, url);
                                 e.printStackTrace();
                              }
                           }
                        }
                     }
                  }
               }

            }
         }

         map.put("listresult", true);
         map.put("list", list);
         Vector<ChannelSftp.LsEntry> listFiles1 = (Vector)map.get("list");
         if ((Boolean)map.get("listresult")) {
            for(int i = 0; i < listFiles1.size(); ++i) {
               String fileName = ((ChannelSftp.LsEntry)listFiles1.get(i)).getFilename();
               String longName = ((ChannelSftp.LsEntry)listFiles1.get(i)).getLongname();
               List<String> detaillist = new ArrayList();
               if (!".".equals(fileName) && !"..".equals(fileName) && !".".equals(fileName.substring(0, 1))) {
                  Pattern pattern = Pattern.compile("[^\\s]*");
                  Matcher matcher = pattern.matcher(longName);
                  int j = 0;
                  boolean flag = true;

                  while(matcher.find() && j < 5) {
                     if (!"".equals(matcher.group())) {
                        detaillist.add(matcher.group());
                        ++j;
                        flag = false;
                     }

                     if (!flag) {
                        break;
                     }
                  }

                  if (!"d".equals(((String)detaillist.get(0)).substring(0, 1)) && !"l".equals(((String)detaillist.get(0)).substring(0, 1)) && !"c".equals(((String)detaillist.get(0)).substring(0, 1)) && !"b".equals(((String)detaillist.get(0)).substring(0, 1))) {
                     if (!fileName.toString().toLowerCase().contains(".pipe")) {
                        InputStream dataInputStream = null;
                        String charset = "UTF-8";

                        try {
                           dataInputStream = sftp.getDataInputStream(path + "/" + fileName);
                           charset = ReadJsonTool.sftpCharset(dataInputStream);
                        } catch (Exception e) {
                           Integer tableCount = (Integer)this.redisService.get(taskid + "tableCount");
                           tableCount = tableCount - 1;
                           this.redisService.set(taskid + "tableCount", tableCount);
                           this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles2_sftp\r\n", url);
                           String content1 = this.geterrorprint(e);
                           this.writeErroFile("listFiles2_sftp", content1, url);
                           e.printStackTrace();
                           continue;
                        }

                        map = this.discoveryFileUnknowstructureSFTP(dataareaSet, fileName, path, path + "/" + fileName, tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, charset, tconnection, pstmt, sftp);
                        this.writeFile("done", fileName + "," + path + "," + formatter.format(new Date()) + "\r\n", monitorurl);
                        Integer sureTable = Integer.parseInt((String)resultmap.get("sureTable"));
                        Integer n = Integer.parseInt((String)map.get("sureTable"));
                        sureTable = sureTable + n;
                        resultmap.put("sureTable", sureTable.toString());
                        Integer tableSum = Integer.parseInt((String)resultmap.get("tableSum"));
                        if (tableSum == 10) {
                           System.out.println();
                        }

                        tableSum = tableSum + 1;
                        resultmap.put("tableSum", tableSum.toString());
                        this.redisService.set(taskid + "tableSum", resultmap.get("tableSum"));
                     }
                  } else {
                     try {
                        if ("/".equals(path)) {
                           this.getSftpFile(dataareaSet, resultmap, path + fileName, tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, sftp, url);
                        } else {
                           this.getSftpFile(dataareaSet, resultmap, path + "/" + fileName, tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, sftp, url);
                        }
                     } catch (Exception e) {
                        if (e.getMessage() != null && e.getMessage().contains("Permission denied")) {
                           this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles1_sftp\r\n", url);
                           String content1 = this.geterrorprint(e);
                           this.writeErroFile("listFiles1_sftp", content1, url);
                           e.printStackTrace();
                        }
                     }
                  }
               }
            }
         }

         return resultmap;
      }

      map.put("listresult", true);
      map.put("list", list);
      Vector<ChannelSftp.LsEntry> listFiles1 = (Vector)map.get("list");
      if ((Boolean)map.get("listresult")) {
         for(int i = 0; i < listFiles1.size(); ++i) {
            String fileName = ((ChannelSftp.LsEntry)listFiles1.get(i)).getFilename();
            String longName = ((ChannelSftp.LsEntry)listFiles1.get(i)).getLongname();
            List<String> detaillist = new ArrayList();
            if (!".".equals(fileName) && !"..".equals(fileName) && !".".equals(fileName.substring(0, 1))) {
               Pattern pattern = Pattern.compile("[^\\s]*");
               Matcher matcher = pattern.matcher(longName);
               int j = 0;
               boolean flag = true;

               while(matcher.find() && j < 5) {
                  if (!"".equals(matcher.group())) {
                     detaillist.add(matcher.group());
                     ++j;
                     flag = false;
                  }

                  if (!flag) {
                     break;
                  }
               }

               if (!"d".equals(((String)detaillist.get(0)).substring(0, 1)) && !"l".equals(((String)detaillist.get(0)).substring(0, 1)) && !"c".equals(((String)detaillist.get(0)).substring(0, 1)) && !"b".equals(((String)detaillist.get(0)).substring(0, 1))) {
                  if (!fileName.toString().toLowerCase().contains(".pipe")) {
                     InputStream dataInputStream = null;
                     String charset = "UTF-8";

                     try {
                        dataInputStream = sftp.getDataInputStream(path + "/" + fileName);
                        charset = ReadJsonTool.sftpCharset(dataInputStream);
                     } catch (Exception e) {
                        Integer tableCount = (Integer)this.redisService.get(taskid + "tableCount");
                        tableCount = tableCount - 1;
                        this.redisService.set(taskid + "tableCount", tableCount);
                        this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles2_sftp\r\n", url);
                        String content1 = this.geterrorprint(e);
                        this.writeErroFile("listFiles2_sftp", content1, url);
                        e.printStackTrace();
                        continue;
                     }

                     map = this.discoveryFileUnknowstructureSFTP(dataareaSet, fileName, path, path + "/" + fileName, tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, charset, tconnection, pstmt, sftp);
                     this.writeFile("done", fileName + "," + path + "," + formatter.format(new Date()) + "\r\n", monitorurl);
                     Integer sureTable = Integer.parseInt((String)resultmap.get("sureTable"));
                     Integer n = Integer.parseInt((String)map.get("sureTable"));
                     sureTable = sureTable + n;
                     resultmap.put("sureTable", sureTable.toString());
                     Integer tableSum = Integer.parseInt((String)resultmap.get("tableSum"));
                     if (tableSum == 10) {
                        System.out.println();
                     }

                     tableSum = tableSum + 1;
                     resultmap.put("tableSum", tableSum.toString());
                     this.redisService.set(taskid + "tableSum", resultmap.get("tableSum"));
                  }
               } else {
                  try {
                     if ("/".equals(path)) {
                        this.getSftpFile(dataareaSet, resultmap, path + fileName, tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, sftp, url);
                     } else {
                        this.getSftpFile(dataareaSet, resultmap, path + "/" + fileName, tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, sftp, url);
                     }
                  } catch (Exception e) {
                     if (e.getMessage() != null && e.getMessage().contains("Permission denied")) {
                        this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles1_sftp\r\n", url);
                        String content1 = this.geterrorprint(e);
                        this.writeErroFile("listFiles1_sftp", content1, url);
                        e.printStackTrace();
                     }
                  }
               }
            }
         }
      }

      return resultmap;
   }

   public Map<String, String> getFtpFile(Set<Object> dataareaSet, Map<String, String> resultmap, String path, TCoreDatasystem tCoreDatasystem, String fileSourceType, boolean isFaceRule, TcoreTaskFindrule findRuleFace, String hits, String projectid, String taskid, String rate, List<TcoreTaskFindrule> regexByContent, boolean isSelectData, List<Pattern> patternContentList, List<Map<String, Object>> sensitiveRule, int batcheSize, String monitorurl, Connection tconnection, PreparedStatement pstmt, FTPClient ftp, String url) {
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Map<String, Object> map = new HashMap();
      new HashMap();
      new ArrayList();
      boolean var72 = false;

      label616: {
         try {
            label608: {
               try {
                  var72 = true;
                  Map<String, Object> filemap = FtpTool.listFiles(ftp, path, "", tCoreDatasystem.getPagecode());
                  List<Map<String, String>> list = (List)filemap.get("filelist");
                  map.put("list", list);
                  map.put("listresult", true);
                  var72 = false;
                  break label616;
               } catch (Exception var88) {
                  var88.printStackTrace();
                  map.put("listresult", false);
                  map.put("message", "远程服务器连接异常");
                  if (var88.getMessage() != null && var88.getMessage().contains("Permission denied")) {
                     this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles_ftp\r\n", url);
                     String content1 = this.geterrorprint(var88);
                     this.writeErroFile("listFiles_ftp", content1, url);
                     var88.printStackTrace();
                     var72 = false;
                     break label608;
                  } else {
                     this.writeFile("errormanage", "远程服务器连接异常,比较严重," + formatter.format(new Date()) + ",connerro_ftp\r\n", url);
                     String content1 = this.geterrorprint(var88);
                     this.writeErroFile("connerro_ftp", content1, url);
                     var88.printStackTrace();
                     var72 = false;
                  }
               }


            }
         } finally {
            if (var72) {
               new ArrayList();
               List<Map<String, String>> listFiles = (List)map.get("list");
               Iterator var42 = listFiles.iterator();

               while(true) {
                  Map<String, String> file;
                  InputStream dataInputStream;
                  String charset;
                  while(true) {
                     if (!var42.hasNext()) {
                        ;
                     } else {
                        file = (Map)var42.next();
                        Pattern pattern = Pattern.compile("[^\\s]*");
                        Matcher matcher = pattern.matcher((CharSequence)file.get("detail"));
                        List<String> detaillist = new ArrayList();
                        TCoreProjectFileDetail tCoreProjectFileDetail = new TCoreProjectFileDetail();
                        tCoreProjectFileDetail.setFilename((String)file.get("name"));
                        int i = 0;

                        while(matcher.find() && i < 5) {
                           if (!"".equals(matcher.group())) {
                              detaillist.add(matcher.group());
                              ++i;
                           }
                        }

                        if (!"d".equals(((String)detaillist.get(0)).substring(0, 1)) && !"l".equals(((String)detaillist.get(0)).substring(0, 1)) && !"c".equals(((String)detaillist.get(0)).substring(0, 1))) {
                           if (!((String)file.get("name")).toString().toLowerCase().contains(".pipe")) {
                              dataInputStream = null;
                              charset = "UTF-8";

                              try {
                                 ftp.enterLocalPassiveMode();
                                 dataInputStream = FtpTool.getDataInputStream(ftp, path, (String)file.get("name"), tCoreDatasystem.getPagecode());
                                 if (dataInputStream != null) {
                                    charset = ReadJsonTool.sftpCharset(dataInputStream);
                                    dataInputStream.close();
                                 }
                                 break;
                              } catch (Exception var83) {
                                 String name = (String)file.get("name");
                                 if (var83.getMessage() != null && var83.getMessage().contains("Permission denied")) {
                                    this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles2_ftp\r\n", url);
                                    String content1 = this.geterrorprint(var83);
                                    this.writeErroFile("listFiles2_ftp", content1, url);
                                    var83.printStackTrace();
                                    if (dataInputStream != null) {
                                       try {
                                          dataInputStream.close();
                                          ftp.completePendingCommand();
                                       } catch (IOException e1) {
                                          e1.printStackTrace();
                                       }
                                    }
                                 } else {
                                    this.writeFile("errormanage", "用户读文件失败,比较严重," + formatter.format(new Date()) + ",readfileerror_ftp\r\n", url);
                                    String content1 = this.geterrorprint(var83);
                                    this.writeErroFile("readfileerror_ftp", content1, url);
                                    var83.printStackTrace();

                                    try {
                                       if (dataInputStream != null) {
                                          dataInputStream.close();
                                          ftp.completePendingCommand();
                                       }
                                    } catch (IOException e1) {
                                       e1.printStackTrace();
                                    }
                                 }
                              }
                           }
                        } else {
                           try {
                              if ("/".equals(path)) {
                                 this.getFtpFile(dataareaSet, resultmap, path + (String)file.get("name"), tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, ftp, url);
                              } else {
                                 this.getFtpFile(dataareaSet, resultmap, path + "/" + (String)file.get("name"), tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, ftp, url);
                              }
                           } catch (Exception e1) {
                              if (e1.getMessage() != null && e1.getMessage().contains("Permission denied")) {
                                 this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles1_ftp\r\n", url);
                                 charset = this.geterrorprint(e1);
                                 this.writeErroFile("listFiles1_ftp", charset, url);
                                 e1.printStackTrace();
                              }
                           }
                        }
                     }
                  }

                  try {
                     if (dataInputStream != null) {
                        dataInputStream.close();
                        ftp.completePendingCommand();
                     }
                  } catch (IOException e) {
                     e.printStackTrace();
                  }

                  map = this.discoveryFileUnknowstructureFTP(dataareaSet, (String)file.get("name"), path, path + "/" + (String)file.get("name"), tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, charset, tconnection, pstmt, ftp);
                  this.writeFile("done", (String)file.get("name") + "," + path + "," + formatter.format(new Date()) + "\r\n", monitorurl);
                  Integer sureTable = Integer.parseInt((String)resultmap.get("sureTable"));
                  Integer n = Integer.parseInt((String)map.get("sureTable"));
                  sureTable = sureTable + n;
                  resultmap.put("sureTable", sureTable.toString());
                  Integer tableSum = Integer.parseInt((String)resultmap.get("tableSum"));
                  tableSum = tableSum + 1;
                  resultmap.put("tableSum", tableSum.toString());
                  this.redisService.set(taskid + "tableSum", resultmap.get("tableSum"));
               }
            }
         }

         new ArrayList();
         List<Map<String, String>> listFiles = (List)map.get("list");
         Iterator var95 = listFiles.iterator();

         while(true) {
            Map<String, String> file;
            InputStream dataInputStream;
            String charset;
            while(true) {
               if (!var95.hasNext()) {
                  return resultmap;
               }

               file = (Map)var95.next();
               Pattern pattern = Pattern.compile("[^\\s]*");
               Matcher matcher = pattern.matcher((CharSequence)file.get("detail"));
               List<String> detaillist = new ArrayList();
               TCoreProjectFileDetail tCoreProjectFileDetail = new TCoreProjectFileDetail();
               tCoreProjectFileDetail.setFilename((String)file.get("name"));
               int i = 0;

               while(matcher.find() && i < 5) {
                  if (!"".equals(matcher.group())) {
                     detaillist.add(matcher.group());
                     ++i;
                  }
               }

               if (!"d".equals(((String)detaillist.get(0)).substring(0, 1)) && !"l".equals(((String)detaillist.get(0)).substring(0, 1)) && !"c".equals(((String)detaillist.get(0)).substring(0, 1))) {
                  if (!((String)file.get("name")).toString().toLowerCase().contains(".pipe")) {
                     dataInputStream = null;
                     charset = "UTF-8";

                     try {
                        ftp.enterLocalPassiveMode();
                        dataInputStream = FtpTool.getDataInputStream(ftp, path, (String)file.get("name"), tCoreDatasystem.getPagecode());
                        if (dataInputStream != null) {
                           charset = ReadJsonTool.sftpCharset(dataInputStream);
                           dataInputStream.close();
                        }
                        break;
                     } catch (Exception var85) {
                        String name = (String)file.get("name");
                        if (var85.getMessage() != null && var85.getMessage().contains("Permission denied")) {
                           this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles2_ftp\r\n", url);
                           String content1 = this.geterrorprint(var85);
                           this.writeErroFile("listFiles2_ftp", content1, url);
                           var85.printStackTrace();
                           if (dataInputStream != null) {
                              try {
                                 dataInputStream.close();
                                 ftp.completePendingCommand();
                              } catch (IOException e1) {
                                 e1.printStackTrace();
                              }
                           }
                        } else {
                           this.writeFile("errormanage", "用户读文件失败,比较严重," + formatter.format(new Date()) + ",readfileerror_ftp\r\n", url);
                           String content1 = this.geterrorprint(var85);
                           this.writeErroFile("readfileerror_ftp", content1, url);
                           var85.printStackTrace();

                           try {
                              if (dataInputStream != null) {
                                 dataInputStream.close();
                                 ftp.completePendingCommand();
                              }
                           } catch (IOException e1) {
                              e1.printStackTrace();
                           }
                        }
                     }
                  }
               } else {
                  try {
                     if ("/".equals(path)) {
                        this.getFtpFile(dataareaSet, resultmap, path + (String)file.get("name"), tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, ftp, url);
                     } else {
                        this.getFtpFile(dataareaSet, resultmap, path + "/" + (String)file.get("name"), tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, ftp, url);
                     }
                  } catch (Exception e1) {
                     if (e1.getMessage() != null && e1.getMessage().contains("Permission denied")) {
                        this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles1_ftp\r\n", url);
                        charset = this.geterrorprint(e1);
                        this.writeErroFile("listFiles1_ftp", charset, url);
                        e1.printStackTrace();
                     }
                  }
               }
            }

            try {
               if (dataInputStream != null) {
                  dataInputStream.close();
                  ftp.completePendingCommand();
               }
            } catch (IOException e) {
               e.printStackTrace();
            }

            map = this.discoveryFileUnknowstructureFTP(dataareaSet, (String)file.get("name"), path, path + "/" + (String)file.get("name"), tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, charset, tconnection, pstmt, ftp);
            this.writeFile("done", (String)file.get("name") + "," + path + "," + formatter.format(new Date()) + "\r\n", monitorurl);
            Integer sureTable = Integer.parseInt((String)resultmap.get("sureTable"));
            Integer n = Integer.parseInt((String)map.get("sureTable"));
            sureTable = sureTable + n;
            resultmap.put("sureTable", sureTable.toString());
            Integer tableSum = Integer.parseInt((String)resultmap.get("tableSum"));
            tableSum = tableSum + 1;
            resultmap.put("tableSum", tableSum.toString());
            this.redisService.set(taskid + "tableSum", resultmap.get("tableSum"));
         }
      }

      new ArrayList();
      List<Map<String, String>> var93 = (List)map.get("list");
      Iterator var96 = var93.iterator();

      while(true) {
         Map<String, String> file;
         InputStream dataInputStream;
         String charset;
         while(true) {
            if (!var96.hasNext()) {
               return resultmap;
            }

            file = (Map)var96.next();
            Pattern pattern = Pattern.compile("[^\\s]*");
            Matcher matcher = pattern.matcher((CharSequence)file.get("detail"));
            List<String> detaillist = new ArrayList();
            TCoreProjectFileDetail tCoreProjectFileDetail = new TCoreProjectFileDetail();
            tCoreProjectFileDetail.setFilename((String)file.get("name"));
            int i = 0;

            while(matcher.find() && i < 5) {
               if (!"".equals(matcher.group())) {
                  detaillist.add(matcher.group());
                  ++i;
               }
            }

            if (!"d".equals(((String)detaillist.get(0)).substring(0, 1)) && !"l".equals(((String)detaillist.get(0)).substring(0, 1)) && !"c".equals(((String)detaillist.get(0)).substring(0, 1))) {
               if (!((String)file.get("name")).toString().toLowerCase().contains(".pipe")) {
                  dataInputStream = null;
                  charset = "UTF-8";

                  try {
                     ftp.enterLocalPassiveMode();
                     dataInputStream = FtpTool.getDataInputStream(ftp, path, (String)file.get("name"), tCoreDatasystem.getPagecode());
                     if (dataInputStream != null) {
                        charset = ReadJsonTool.sftpCharset(dataInputStream);
                        dataInputStream.close();
                     }
                     break;
                  } catch (Exception var87) {
                     String name = (String)file.get("name");
                     if (var87.getMessage() != null && var87.getMessage().contains("Permission denied")) {
                        this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles2_ftp\r\n", url);
                        String content1 = this.geterrorprint(var87);
                        this.writeErroFile("listFiles2_ftp", content1, url);
                        var87.printStackTrace();
                        if (dataInputStream != null) {
                           try {
                              dataInputStream.close();
                              ftp.completePendingCommand();
                           } catch (IOException e1) {
                              e1.printStackTrace();
                           }
                        }
                     } else {
                        this.writeFile("errormanage", "用户读文件失败,比较严重," + formatter.format(new Date()) + ",readfileerror_ftp\r\n", url);
                        String content1 = this.geterrorprint(var87);
                        this.writeErroFile("readfileerror_ftp", content1, url);
                        var87.printStackTrace();

                        try {
                           if (dataInputStream != null) {
                              dataInputStream.close();
                              ftp.completePendingCommand();
                           }
                        } catch (IOException e1) {
                           e1.printStackTrace();
                        }
                     }
                  }
               }
            } else {
               try {
                  if ("/".equals(path)) {
                     this.getFtpFile(dataareaSet, resultmap, path + (String)file.get("name"), tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, ftp, url);
                  } else {
                     this.getFtpFile(dataareaSet, resultmap, path + "/" + (String)file.get("name"), tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt, ftp, url);
                  }
               } catch (Exception e1) {
                  if (e1.getMessage() != null && e1.getMessage().contains("Permission denied")) {
                     this.writeFile("errormanage", "用户没有读文件权限,比较严重," + formatter.format(new Date()) + ",listFiles1_ftp\r\n", url);
                     charset = this.geterrorprint(e1);
                     this.writeErroFile("listFiles1_ftp", charset, url);
                     e1.printStackTrace();
                  }
               }
            }
         }

         try {
            if (dataInputStream != null) {
               dataInputStream.close();
               ftp.completePendingCommand();
            }
         } catch (IOException e) {
            e.printStackTrace();
         }

         map = this.discoveryFileUnknowstructureFTP(dataareaSet, (String)file.get("name"), path, path + "/" + (String)file.get("name"), tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, charset, tconnection, pstmt, ftp);
         this.writeFile("done", (String)file.get("name") + "," + path + "," + formatter.format(new Date()) + "\r\n", monitorurl);
         Integer sureTable = Integer.parseInt((String)resultmap.get("sureTable"));
         Integer n = Integer.parseInt((String)map.get("sureTable"));
         sureTable = sureTable + n;
         resultmap.put("sureTable", sureTable.toString());
         Integer tableSum = Integer.parseInt((String)resultmap.get("tableSum"));
         tableSum = tableSum + 1;
         resultmap.put("tableSum", tableSum.toString());
         this.redisService.set(taskid + "tableSum", resultmap.get("tableSum"));
      }
   }

   public Map<String, Object> discoveryFileUnknowstructureSFTP(Set<Object> dataareaSet, String filename, String fileurl, String absolutePath, TCoreDatasystem tCoreDatasystem, String fileSourceType, boolean isFaceRule, TcoreTaskFindrule findRuleFace, String hits, String projectid, String taskid, String rate, List<TcoreTaskFindrule> regexByContent, boolean isSelectData, List<Pattern> patternContentList, List<Map<String, Object>> sensitiveRule, String code, Connection tconnection, PreparedStatement pstmt, SFTPUtil sftp) {
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String driver = props.getProperty("jdbc.driver");
      String jdbcurl = props.getProperty("jdbc.url");
      String user = props.getProperty("jdbc.user");
      String password = props.getProperty("jdbc.password");
      String url = props.getProperty("monitorFile") + projectid + File.separator + taskid + File.separator;
      int batcheSize = new Integer(props.getProperty("jdbc_insert_batche_size"));
      int sureTable = 0;
      int cnt = 0;
      String filecontent = "";
      String construct = "";
      Map<String, List<String>> fileconstruct = new HashMap();
      Map<String, List<String>> wjList = new HashMap();
      if (!filename.contains(".") || filename.split("\\.").length <= 1 || !"BMP".equalsIgnoreCase(filename.split("\\.")[1]) && !"JPG".equalsIgnoreCase(filename.split("\\.")[1]) && !"JPEG".equalsIgnoreCase(filename.split("\\.")[1]) && !"PNG".equalsIgnoreCase(filename.split("\\.")[1]) && !"GIF".equalsIgnoreCase(filename.split("\\.")[1])) {
         try {
            fileconstruct = UnknownFileStruTool.getSftpFileByPath(absolutePath, code, sftp);

            for(String key : fileconstruct.keySet()) {
               construct = key;
            }

            if (!filename.contains(".") || !"xls".equals(filename.split("\\.")[1]) && !"xlsx".equals(filename.split("\\.")[1])) {
               filecontent = UnknownFileStruTool.getFileContentSFTP(absolutePath, code, sftp);
            } else {
               filecontent = ReadExcelTool.readExcelContentSFTP(sftp, absolutePath);
            }
         } catch (Exception var57) {
            if (var57.getMessage() == null || !var57.getMessage().contains("FileNotFoundException") && !var57.getMessage().contains("权限不够")) {
               this.writeFile("errormanage", "读文件内容结构失败,比较严重," + formatter.format(new Date()) + ",readcontenterror_sftp\r\n", url);
               String content1 = this.geterrorprint(var57);
               this.writeErroFile("readcontenterror_sftp", content1, url);
               var57.printStackTrace();
               var57.printStackTrace();
            } else {
               this.writeFile("errormanage", "用户没有读该文件的权限,比较严重," + formatter.format(new Date()) + ",noquanxian_sftp\r\n", url);
               String content1 = this.geterrorprint(var57);
               this.writeErroFile("noquanxian_sftp", content1, url);
               var57.printStackTrace();
               var57.printStackTrace();
            }
         }

         if ("1".equals(construct)) {
            try {
               wjList = FileTool.getSFTPFileDataByWidth(sftp, fileurl + "/", filename, (new Long(hits)).intValue(), (List)fileconstruct.get("1"), code);
            } catch (Exception var56) {
               if (var56.getMessage() != null && var56.getMessage().contains("String index out of range")) {
                  construct = "0";
               } else {
                  this.writeFile("errormanage", "读固定宽度文件数据失败,比较严重," + formatter.format(new Date()) + ",readwidthfaild_sftp\r\n", url);
                  String content1 = this.geterrorprint(var56);
                  this.writeErroFile("readwidthfaild_sftp", content1, url);
                  var56.printStackTrace();
               }
            }
         } else if (!"2".equals(construct) && !"7".equals(construct)) {
            if ("3".equals(construct)) {
               new HashMap();
               List<String> list = (List)fileconstruct.get(construct);
               String jsoncontent = (String)list.get(0);

               try {
                  wjList = ReadJsonTool.iteraJsonOrArray(jsoncontent);
               } catch (Exception e) {
                  System.out.println(">>>>>>>>>>>>>>>>>>>>>>>" + absolutePath);
                  this.writeFile("errormanage", "读json文件数据失败,比较严重," + formatter.format(new Date()) + ",readjsonfaild_sftp\r\n", url);
                  String content1 = this.geterrorprint(e);
                  this.writeErroFile("readjsonfaild_sftp", content1, url);
                  e.printStackTrace();
               }
            } else if ("4".equals(construct)) {
               try {
                  Map<String, List<String>> map = new HashMap();
                  wjList = ReadAllXmlTool.xmlToStrSFTP(sftp, absolutePath, map);
               } catch (Exception e) {
                  this.writeFile("errormanage", "读xml文件数据失败,比较严重," + formatter.format(new Date()) + ",readxmlfaild_sftp\r\n", url);
                  String content1 = this.geterrorprint(e);
                  this.writeErroFile("readxmlfaild_sftp", content1, url);
                  e.printStackTrace();
               }
            } else if ("6".equals(construct)) {
               new HashMap();

               try {
                  wjList = ReadExcelTool.readExcelSFTP(sftp, absolutePath);
               } catch (Exception e) {
                  this.writeFile("errormanage", "读Excel文件数据失败,比较严重," + formatter.format(new Date()) + ",readexcelfaild_sftp\r\n", url);
                  String content1 = this.geterrorprint(e);
                  this.writeErroFile("readexcelfaild_sftp", content1, url);
                  e.printStackTrace();
               }
            }
         } else {
            try {
               wjList = this.getFiledataBySpliterSFTP(tCoreDatasystem, absolutePath, (new Long(hits)).intValue(), fileSourceType, code);
            } catch (Exception e) {
               this.writeFile("errormanage", "读分隔符文件数据失败,比较严重," + formatter.format(new Date()) + ",readfengefufaild_sftp\r\n", url);
               String content1 = this.geterrorprint(e);
               this.writeErroFile("readfengefufaild_sftp", content1, url);
               e.printStackTrace();
            }
         }

         if (wjList.size() > 0) {
            dataareaSet = this.getNostructureFileSensitiveColumnsByContent(tCoreDatasystem.getId(), dataareaSet, tCoreDatasystem.getSysname(), wjList, filename, rate, hits, regexByContent, patternContentList, sensitiveRule, projectid, taskid, "none", isSelectData, fileurl + File.separator, pstmt, cnt, batcheSize, tconnection, construct, filecontent);
            if (dataareaSet.size() > 0) {
               ++sureTable;
            }
         } else {
            try {
               pstmt.setObject(1, tCoreDatasystem.getId());
               pstmt.setObject(2, "");
               pstmt.setObject(3, fileurl + File.separator);
               pstmt.setObject(4, filename);
               pstmt.setObject(5, "");
               pstmt.setObject(6, hits);
               pstmt.setObject(7, "0");
               pstmt.setObject(8, "0%");
               pstmt.setObject(9, "");
               pstmt.setObject(10, "");
               pstmt.setObject(11, "");
               pstmt.setObject(12, "");
               pstmt.setObject(13, "0");
               pstmt.setObject(14, "");
               pstmt.setObject(15, construct);
               pstmt.setObject(16, filecontent);
               pstmt.setObject(17, UUID.randomUUID().toString());
               pstmt.addBatch();
               ++cnt;
               if (cnt % batcheSize == 0) {
                  long useTime1 = System.currentTimeMillis();
                  pstmt.executeBatch();
                  pstmt.clearBatch();
                  tconnection.commit();
                  long useTime2 = System.currentTimeMillis();
                  System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
               }
            } catch (SQLException e) {
               this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",zhixing_sftp\r\n", url);
               String content1 = this.geterrorprint(e);
               this.writeErroFile("zhixing_sftp", content1, url);
               e.printStackTrace();
            }
         }
      } else {
         String dataareaid = "";
         String dataarea = "";
         String regex = "";
         String rulename = "";
         String picDir = props.getProperty("pictureDir");
         File file = new File(picDir);
         if (!file.exists()) {
            file.mkdirs();
         }

         try {
            sftp.download(fileurl, filename, picDir + File.separator + filename);
         } catch (FileNotFoundException e1) {
            e1.printStackTrace();
         } catch (SftpException e1) {
            e1.printStackTrace();
         }

         if (isFaceRule) {
            try {
               if (isFace(picDir + File.separator + filename)) {
                  dataareaid = findRuleFace.getDataareaid();
                  dataarea = findRuleFace.getDataarea();
                  regex = findRuleFace.getRegex();
                  rulename = findRuleFace.getRulename();
                  ++sureTable;
                  dataareaSet.add(dataarea);
               }
            } catch (Exception e) {
               this.writeFile("errormanage", "Python3执行失败,非常严重," + formatter.format(new Date()) + ",python_file\r\n", url);
               String content1 = this.geterrorprint(e);
               this.writeErroFile("python_file", content1, url);
               e.printStackTrace();
            }
         }

         try {
            pstmt.setObject(1, tCoreDatasystem.getId());
            pstmt.setObject(2, "");
            pstmt.setObject(3, fileurl);
            pstmt.setObject(4, filename);
            pstmt.setObject(5, "");
            pstmt.setObject(6, hits);
            pstmt.setObject(7, "1");
            pstmt.setObject(8, "100%");
            pstmt.setObject(9, dataareaid);
            pstmt.setObject(10, dataarea);
            pstmt.setObject(11, regex);
            pstmt.setObject(12, rulename);
            pstmt.setObject(13, "");
            pstmt.setObject(14, "");
            pstmt.setObject(15, "5");
            pstmt.setObject(16, filecontent);
            pstmt.setObject(17, UUID.randomUUID().toString());
            pstmt.addBatch();
            ++cnt;
            if (cnt % batcheSize == 0) {
               long useTime1 = System.currentTimeMillis();
               pstmt.executeBatch();
               pstmt.clearBatch();
               tconnection.commit();
               long useTime2 = System.currentTimeMillis();
               System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }
      }

      try {
         pstmt.executeBatch();
         pstmt.clearBatch();
         tconnection.commit();
      } catch (SQLException e1) {
         this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",zhixing1_sftp\r\n", url);
         String content1 = this.geterrorprint(e1);
         this.writeErroFile("zhixing1_sftp", content1, url);
         e1.printStackTrace();
      }

      Map<String, Object> resultMap = new HashMap();
      if (this.vlist.size() != 0 && this.vlist.contains("pool" + taskid)) {
         resultMap.put("isstop", "true");
      } else {
         resultMap.put("sureTable", String.valueOf(sureTable));
         resultMap.put("columnSum", dataareaSet);
      }

      return resultMap;
   }

   public Map<String, Object> discoveryFileUnknowstructureFTP(Set<Object> dataareaSet, String filename, String fileurl, String absolutePath, TCoreDatasystem tCoreDatasystem, String fileSourceType, boolean isFaceRule, TcoreTaskFindrule findRuleFace, String hits, String projectid, String taskid, String rate, List<TcoreTaskFindrule> regexByContent, boolean isSelectData, List<Pattern> patternContentList, List<Map<String, Object>> sensitiveRule, String code, Connection tconnection, PreparedStatement pstmt, FTPClient ftp) {
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String driver = props.getProperty("jdbc.driver");
      String jdbcurl = props.getProperty("jdbc.url");
      String user = props.getProperty("jdbc.user");
      String password = props.getProperty("jdbc.password");
      String url = props.getProperty("monitorFile") + projectid + File.separator + taskid + File.separator;
      int batcheSize = new Integer(props.getProperty("jdbc_insert_batche_size"));
      int sureTable = 0;
      int cnt = 0;
      String filecontent = "";
      Map<String, List<String>> fileconstruct = new HashMap();
      String construct = "";
      Map<String, List<String>> wjList = new HashMap();
      if (!filename.contains(".") || filename.split("\\.").length <= 1 || !"BMP".equalsIgnoreCase(filename.split("\\.")[1]) && !"JPG".equalsIgnoreCase(filename.split("\\.")[1]) && !"JPEG".equalsIgnoreCase(filename.split("\\.")[1]) && !"PNG".equalsIgnoreCase(filename.split("\\.")[1]) && !"GIF".equalsIgnoreCase(filename.split("\\.")[1])) {
         try {
            fileconstruct = UnknownFileStruTool.getFtpFileByPath(ftp, absolutePath, code, filename, fileurl);

            for(String key : fileconstruct.keySet()) {
               construct = key;
            }

            if (!filename.contains(".") || !"xls".equals(filename.split("\\.")[1]) && !"xlsx".equals(filename.split("\\.")[1])) {
               filecontent = UnknownFileStruTool.getFileContentFTP(ftp, absolutePath, filename, fileurl, code);
            } else {
               filecontent = ReadExcelTool.readExcelContentFTP(ftp, absolutePath, filename, fileurl);
            }
         } catch (Exception var56) {
            if (var56.getMessage() == null || !var56.getMessage().contains("Permission denied") && !var56.getMessage().contains("权限不够")) {
               this.writeFile("errormanage", "读文件内容结构失败,非常严重," + formatter.format(new Date()) + ",failreadfile_ftp\r\n", url);
               String content1 = this.geterrorprint(var56);
               this.writeErroFile("failreadfile_ftp", content1, url);
               var56.printStackTrace();
            } else {
               this.writeFile("errormanage", "用户没有读该文件的权限,非常严重," + formatter.format(new Date()) + ",xuanxianunknow_ftp\r\n", url);
               String content1 = this.geterrorprint(var56);
               this.writeErroFile("xuanxianunknow_ftp", content1, url);
               var56.printStackTrace();
               var56.printStackTrace();
            }
         }

         if ("1".equals(construct)) {
            try {
               wjList = FileTool.getFTPFileDataByWidth(ftp, fileurl, filename, (new Long(hits)).intValue(), (List)fileconstruct.get("1"), code);
            } catch (Exception var55) {
               if (var55.getMessage() != null && var55.getMessage().contains("String index out of range")) {
                  construct = "0";
               } else {
                  this.writeFile("errormanage", "读固定宽度文件数据失败,比较严重," + formatter.format(new Date()) + ",readwidth_ftp\r\n", url);
                  String content1 = this.geterrorprint(var55);
                  this.writeErroFile("readwidth_ftp", content1, url);
                  var55.printStackTrace();
               }
            }
         } else if (!"2".equals(construct) && !"7".equals(construct)) {
            if ("3".equals(construct)) {
               try {
                  new HashMap();
                  List<String> list = (List)fileconstruct.get(construct);
                  String content = (String)list.get(0);
                  wjList = ReadJsonTool.iteraJsonOrArray(content);
               } catch (Exception e) {
                  this.writeFile("errormanage", "读json文件数据失败,比较严重," + formatter.format(new Date()) + ",readjson_ftp\r\n", url);
                  String content1 = this.geterrorprint(e);
                  this.writeErroFile("readjson_ftp", content1, url);
                  e.printStackTrace();
               }
            } else if ("4".equals(construct)) {
               try {
                  Map<String, List<String>> map = new HashMap();
                  wjList = ReadAllXmlTool.xmlToStrFTP(ftp, absolutePath, map);
               } catch (Exception e) {
                  this.writeFile("errormanage", "读xml文件数据失败,比较严重," + formatter.format(new Date()) + ",readxml_ftp\r\n", url);
                  String content1 = this.geterrorprint(e);
                  this.writeErroFile("readxml_ftp", content1, url);
                  e.printStackTrace();
               }
            } else if ("6".equals(construct)) {
               try {
                  new HashMap();
                  wjList = ReadExcelTool.readExcelFTP(ftp, absolutePath, filename, fileurl);
               } catch (Exception e) {
                  this.writeFile("errormanage", "读excel文件数据失败,比较严重," + formatter.format(new Date()) + ",readexcel_ftp\r\n", url);
                  String content1 = this.geterrorprint(e);
                  this.writeErroFile("readexcel_ftp", content1, url);
                  e.printStackTrace();
               }
            }
         } else {
            try {
               wjList = this.getFiledataBySpliterFTP(ftp, fileurl + File.separator, filename, (new Long(hits)).intValue(), fileSourceType, code);
            } catch (Exception e) {
               this.writeFile("errormanage", "读分隔符文件数据失败,比较严重," + formatter.format(new Date()) + ",readfengefu_ftp\r\n", url);
               String content1 = this.geterrorprint(e);
               this.writeErroFile("readfengefu_ftp", content1, url);
               e.printStackTrace();
            }
         }

         if (wjList.size() > 0) {
            dataareaSet = this.getNostructureFileSensitiveColumnsByContent(tCoreDatasystem.getId(), dataareaSet, tCoreDatasystem.getSysname(), wjList, filename, rate, hits, regexByContent, patternContentList, sensitiveRule, projectid, taskid, "none", isSelectData, fileurl + File.separator, pstmt, cnt, batcheSize, tconnection, construct, filecontent);
            if (dataareaSet.size() > 0) {
               ++sureTable;
            }
         } else {
            try {
               pstmt.setObject(1, tCoreDatasystem.getId());
               pstmt.setObject(2, "");
               pstmt.setObject(3, fileurl + File.separator);
               pstmt.setObject(4, filename);
               pstmt.setObject(5, "");
               pstmt.setObject(6, hits);
               pstmt.setObject(7, "0");
               pstmt.setObject(8, "0%");
               pstmt.setObject(9, "");
               pstmt.setObject(10, "");
               pstmt.setObject(11, "");
               pstmt.setObject(12, "");
               pstmt.setObject(13, "0");
               pstmt.setObject(14, "");
               pstmt.setObject(15, construct);
               pstmt.setObject(16, filecontent);
               pstmt.setObject(17, UUID.randomUUID().toString());
               pstmt.addBatch();
               ++cnt;
               if (cnt % batcheSize == 0) {
                  long useTime1 = System.currentTimeMillis();
                  pstmt.executeBatch();
                  pstmt.clearBatch();
                  tconnection.commit();
                  long useTime2 = System.currentTimeMillis();
                  System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
               }
            } catch (SQLException e) {
               this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pichuliq_ftp\r\n", url);
               String content1 = this.geterrorprint(e);
               this.writeErroFile("pichuliq_ftp", content1, url);
               e.printStackTrace();
            }
         }
      } else {
         String dataareaid = "";
         String dataarea = "";
         String regex = "";
         String rulename = "";
         String picDir = props.getProperty("pictureDir");
         File file = new File(picDir);
         if (!file.exists()) {
            file.mkdirs();
         }

         boolean flag = FtpTool.downFile(ftp, fileurl, filename, picDir);
         if (isFaceRule && flag) {
            try {
               if (isFace(picDir + File.separator + filename)) {
                  dataareaid = findRuleFace.getDataareaid();
                  dataarea = findRuleFace.getDataarea();
                  regex = findRuleFace.getRegex();
                  rulename = findRuleFace.getRulename();
                  ++sureTable;
                  dataareaSet.add(dataarea);
               }
            } catch (Exception e) {
               this.writeFile("errormanage", "Python3执行失败,非常严重," + formatter.format(new Date()) + ",python_file\r\n", url);
               String content1 = this.geterrorprint(e);
               this.writeErroFile("python_file", content1, url);
               e.printStackTrace();
            }
         }

         try {
            pstmt.setObject(1, tCoreDatasystem.getId());
            pstmt.setObject(2, "");
            pstmt.setObject(3, fileurl);
            pstmt.setObject(4, filename);
            pstmt.setObject(5, "");
            pstmt.setObject(6, hits);
            pstmt.setObject(7, "1");
            pstmt.setObject(8, "100%");
            pstmt.setObject(9, dataareaid);
            pstmt.setObject(10, dataarea);
            pstmt.setObject(11, regex);
            pstmt.setObject(12, rulename);
            pstmt.setObject(13, "");
            pstmt.setObject(14, "");
            pstmt.setObject(15, "5");
            pstmt.setObject(16, filecontent);
            pstmt.setObject(17, UUID.randomUUID().toString());
            pstmt.addBatch();
            ++cnt;
            if (cnt % batcheSize == 0) {
               long useTime1 = System.currentTimeMillis();
               pstmt.executeBatch();
               pstmt.clearBatch();
               tconnection.commit();
               long useTime2 = System.currentTimeMillis();
               System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
            }
         } catch (SQLException e) {
            this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pichuli_ftp\r\n", url);
            String content1 = this.geterrorprint(e);
            this.writeErroFile("pichuli_ftp", content1, url);
            e.printStackTrace();
         }
      }

      try {
         pstmt.executeBatch();
         pstmt.clearBatch();
         tconnection.commit();
      } catch (SQLException e1) {
         this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pichuliq1_ftp\r\n", url);
         String content1 = this.geterrorprint(e1);
         this.writeErroFile("pichuliq1_ftp", content1, url);
         e1.printStackTrace();
      }

      Map<String, Object> resultMap = new HashMap();
      if (this.vlist.size() != 0 && this.vlist.contains("pool" + taskid)) {
         resultMap.put("isstop", "true");
      } else {
         resultMap.put("sureTable", String.valueOf(sureTable));
         resultMap.put("columnSum", String.valueOf(dataareaSet.size()));
      }

      return resultMap;
   }

   public Map<String, String> discoveryFileUnknowstructure(Set<Object> dataareaSet, String filename, String fileurl, String absolutePath, TCoreDatasystem tCoreDatasystem, String fileSourceType, boolean isFaceRule, TcoreTaskFindrule findRuleFace, String hits, String projectid, String taskid, String rate, List<TcoreTaskFindrule> regexByContent, boolean isSelectData, List<Pattern> patternContentList, List<Map<String, Object>> sensitiveRule, int batcheSize, String url, Connection tconnection, PreparedStatement pstmt) {
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      new HashMap();
      int cnt = 0;
      int sureTable = 0;
      String code = ReadJsonTool.charset(absolutePath);
      String filecontent = "";
      Map<String, List<String>> fileconstruct = new HashMap();
      String construct = "";
      Map<String, List<String>> wjList = new HashMap();
      if (!filename.contains(".") || filename.split("\\.").length <= 1 || !"BMP".equalsIgnoreCase(filename.split("\\.")[1]) && !"JPG".equalsIgnoreCase(filename.split("\\.")[1]) && !"JPEG".equalsIgnoreCase(filename.split("\\.")[1]) && !"PNG".equalsIgnoreCase(filename.split("\\.")[1]) && !"GIF".equalsIgnoreCase(filename.split("\\.")[1])) {
         try {
            System.out.println("开始解析文件结构-->" + filename);
            fileconstruct = UnknownFileStruTool.getFileByPath(absolutePath, code);
            System.out.println("解析文件结构结束");

            for(String key : fileconstruct.keySet()) {
               construct = key;
            }

            if (!filename.contains(".") || !"xls".equals(filename.split("\\.")[1]) && !"xlsx".equals(filename.split("\\.")[1])) {
               filecontent = UnknownFileStruTool.getFileContent(absolutePath, code);
            } else {
               filecontent = ReadExcelTool.readExcelContent(absolutePath);
            }
         } catch (Exception var49) {
            if (var49.getMessage() == null || !var49.getMessage().contains("FileNotFoundException") && !var49.getMessage().contains("权限不够")) {
               this.writeFile("errormanage", "读文件内容结构失败,比较严重," + formatter.format(new Date()) + ",readfileerro_bendi\r\n", url);
               String content1 = this.geterrorprint(var49);
               this.writeErroFile("readfileerro_bendi", content1, url);
               var49.printStackTrace();
            } else {
               this.writeFile("errormanage", "用户没有读该文件的权限,比较严重," + formatter.format(new Date()) + ",noquanxian_bendi\r\n", url);
               String content1 = this.geterrorprint(var49);
               this.writeErroFile("noquanxian_bendi", content1, url);
               var49.printStackTrace();
            }
         }

         try {
            if ("1".equals(construct)) {
               try {
                  wjList = FileTool.getFileDataByWidth(absolutePath, (new Long(hits)).intValue(), (List)fileconstruct.get("1"), code);
               } catch (Exception var47) {
                  if (var47.getMessage() != null && var47.getMessage().contains("String index out of range")) {
                     construct = "0";
                  } else {
                     this.writeFile("errormanage", "读固定宽度文件数据失败,比较严重," + formatter.format(new Date()) + ",readwidthfile_bendi\r\n", url);
                     String content1 = this.geterrorprint(var47);
                     this.writeErroFile("readwidthfile_bendi", content1, url);
                     var47.printStackTrace();
                  }
               }
            } else if (!"2".equals(construct) && !"7".equals(construct)) {
               if ("3".equals(construct)) {
                  try {
                     new HashMap();
                     List<String> list = (List)fileconstruct.get(construct);
                     String content = (String)list.get(0);
                     wjList = ReadJsonTool.iteraJsonOrArray(content);
                  } catch (Exception e) {
                     this.writeFile("errormanage", "读json文件数据失败,比较严重," + formatter.format(new Date()) + ",readjsonfile_bendi\r\n", url);
                     String content1 = this.geterrorprint(e);
                     this.writeErroFile("readjsonfile_bendi", content1, url);
                     e.printStackTrace();
                  }
               } else if ("4".equals(construct)) {
                  try {
                     Map<String, List<String>> map = new HashMap();
                     wjList = ReadAllXmlTool.xmlToStr(absolutePath, map);
                  } catch (Exception e) {
                     this.writeFile("errormanage", "读xml文件数据失败,比较严重," + formatter.format(new Date()) + ",readxmlfile_bendi\r\n", url);
                     String content1 = this.geterrorprint(e);
                     this.writeErroFile("readxmlfile_bendi", content1, url);
                     e.printStackTrace();
                  }
               } else if ("6".equals(construct)) {
                  try {
                     new HashMap();
                     wjList = ReadExcelTool.readExcel(absolutePath);
                  } catch (Exception e) {
                     this.writeFile("errormanage", "读excel文件数据失败,比较严重," + formatter.format(new Date()) + ",readexcelfile_bendi\r\n", url);
                     String content1 = this.geterrorprint(e);
                     this.writeErroFile("readexcelfile_bendi", content1, url);
                     e.printStackTrace();
                  }
               }
            } else {
               try {
                  wjList = this.getFiledataBySpliter(tCoreDatasystem, fileurl + File.separator, filename, (new Long(hits)).intValue(), fileSourceType, code);
               } catch (Exception e) {
                  this.writeFile("errormanage", "读分隔符文件数据失败,比较严重," + formatter.format(new Date()) + ",readfengefufile_bendi\r\n", url);
                  String content1 = this.geterrorprint(e);
                  this.writeErroFile("readfengefufile_bendi", content1, url);
                  e.printStackTrace();
               }
            }
         } catch (Exception e2) {
            e2.printStackTrace();
         }

         if (wjList == null) {
            this.writeFile("errormanage", "文件没有找到,比较严重," + formatter.format(new Date()) + ",readexcelfile_bendi\r\n", url);
            String content1 = "报错信息:不能找到路径:" + absolutePath + "下的" + filename + "文件.";
            this.writeErroFile("readexcelfile_bendi", content1, url);
         }

         if (wjList.size() > 0) {
            dataareaSet = this.getNostructureFileSensitiveColumnsByContent(tCoreDatasystem.getId(), dataareaSet, tCoreDatasystem.getSysname(), wjList, filename, rate, hits, regexByContent, patternContentList, sensitiveRule, projectid, taskid, "none", isSelectData, fileurl + File.separator, pstmt, cnt, batcheSize, tconnection, construct, filecontent);
            if (dataareaSet.size() > 0) {
               ++sureTable;
            }
         } else {
            try {
               pstmt.setObject(1, tCoreDatasystem.getId());
               pstmt.setObject(2, "");
               pstmt.setObject(3, fileurl + File.separator);
               pstmt.setObject(4, filename);
               pstmt.setObject(5, "");
               pstmt.setObject(6, hits);
               pstmt.setObject(7, "0");
               pstmt.setObject(8, "0%");
               pstmt.setObject(9, "");
               pstmt.setObject(10, "");
               pstmt.setObject(11, "");
               pstmt.setObject(12, "");
               pstmt.setObject(13, "0");
               pstmt.setObject(14, "");
               pstmt.setObject(15, construct);
               pstmt.setObject(16, filecontent);
               pstmt.setObject(17, UUID.randomUUID().toString());
               pstmt.addBatch();
               ++cnt;
               if (cnt % batcheSize == 0) {
                  long useTime1 = System.currentTimeMillis();
                  pstmt.executeBatch();
                  pstmt.clearBatch();
                  tconnection.commit();
                  long useTime2 = System.currentTimeMillis();
                  System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
               }
            } catch (SQLException e) {
               this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pilinagew_bendi\r\n", url);
               String content1 = this.geterrorprint(e);
               this.writeErroFile("pilinagew_bendi", content1, url);
               e.printStackTrace();
               e.printStackTrace();
            }
         }
      } else {
         String dataareaid = "";
         String dataarea = "";
         String regex = "";
         String rulename = "";
         if (isFaceRule) {
            try {
               if (isFace(fileurl + File.separator + filename)) {
                  dataareaid = findRuleFace.getDataareaid();
                  dataarea = findRuleFace.getDataarea();
                  regex = findRuleFace.getRegex();
                  rulename = findRuleFace.getRulename();
                  ++sureTable;
                  dataareaSet.add(dataarea);
               }
            } catch (Exception e) {
               this.writeFile("errormanage", "Python3执行失败,非常严重," + formatter.format(new Date()) + ",python_file\r\n", url);
               String content1 = this.geterrorprint(e);
               this.writeErroFile("python_file", content1, url);
               e.printStackTrace();
            }
         }

         try {
            pstmt.setObject(1, tCoreDatasystem.getId());
            pstmt.setObject(2, "");
            pstmt.setObject(3, fileurl);
            pstmt.setObject(4, filename);
            pstmt.setObject(5, "");
            pstmt.setObject(6, hits);
            pstmt.setObject(7, "1");
            pstmt.setObject(8, "100%");
            pstmt.setObject(9, dataareaid);
            pstmt.setObject(10, dataarea);
            pstmt.setObject(11, regex);
            pstmt.setObject(12, rulename);
            pstmt.setObject(13, "");
            pstmt.setObject(14, "");
            pstmt.setObject(15, "5");
            pstmt.setObject(16, "");
            pstmt.setObject(17, UUID.randomUUID().toString());
            pstmt.addBatch();
            ++cnt;
            if (cnt % batcheSize == 0) {
               long useTime1 = System.currentTimeMillis();
               pstmt.executeBatch();
               pstmt.clearBatch();
               tconnection.commit();
               long useTime2 = System.currentTimeMillis();
               System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
            }
         } catch (SQLException e) {
            this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pichuliq1_bendi\r\n", url);
            String content1 = this.geterrorprint(e);
            this.writeErroFile("pichuliq1_bendi", content1, url);
            e.printStackTrace();
         }
      }

      Map<String, String> resultMap = new HashMap();
      if (this.vlist.size() != 0 && this.vlist.contains("pool" + taskid)) {
         resultMap.put("isstop", "true");
      } else {
         resultMap.put("sureTable", String.valueOf(sureTable));
         resultMap.put("columnSum", String.valueOf(dataareaSet.size()));
      }

      return resultMap;
   }

   public Map<String, List<String>> getFiledataBySpliterSFTP(TCoreDatasystem datasystem, String absolutePath, int count, String sourceType, String code) throws Exception {
      Map<String, List<String>> map = new HashMap();
      boolean fileexit = false;
      int fileDataCount = 0;
      List<String> datademo = new ArrayList();
      SFTPUtil sftp = null;
      sftp = new SFTPUtil(datasystem.getUsername(), datasystem.getPassword(), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()));
      SFTPUtil.login();
      fileexit = sftp.isExitFile(absolutePath);
      if (!fileexit) {
         return null;
      } else {
         try {
            fileDataCount = sftp.getDataCount(absolutePath);
         } catch (Exception e1) {
            e1.printStackTrace();
         }

         boolean flag = true;
         int num = 0;
         if (count > fileDataCount) {
            count = fileDataCount;
         }

         if (count < 0) {
            return null;
         } else {
            boolean b = count * 2 > fileDataCount;
            Reader in = null;
            BufferedReader reader = null;
            InputStream is = null;
            if (fileDataCount <= count) {
               count = fileDataCount;
            }

            try {
               is = sftp.getDataInputStream(absolutePath);
               in = new InputStreamReader(is, code);
               reader = new BufferedReader(in);

               for(int i = 0; i < count; ++i) {
                  String s = reader.readLine();
                  datademo.add(UnknownFileStruTool.replaceSeparation(s, " "));
                  if (flag) {
                     String replaceSeparation = UnknownFileStruTool.replaceSeparation(s, " ").trim();
                     String[] split = replaceSeparation.split(" ");
                     num = split.length;
                     flag = false;
                  }
               }
            } catch (Exception e) {
               e.printStackTrace();
            } finally {
               if (reader != null) {
                  reader.close();
               }

               if (in != null) {
                  in.close();
               }

               if (is != null) {
                  is.close();
               }

            }

            List<List<String>> ll = StringTool.splitString(datademo, " ", num, "none");

            for(int i = 0; i < ll.size(); ++i) {
               map.put(String.valueOf(i + 1), ll.get(i));
            }

            return map;
         }
      }
   }

   public Map<String, List<String>> getFiledataBySpliterFTP(TCoreDatasystem datasystem, String path, String filename, int count, String sourceType, String code) throws Exception {
      Map<String, List<String>> map = new HashMap();
      boolean fileexit = false;
      int fileDataCount = 0;
      List<String> datademo = new ArrayList();
      boolean flag = true;
      int num = 0;
      fileexit = FtpTool.isFileExist(datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), datasystem.getUsername(), datasystem.getPassword(), path, filename);
      if (!fileexit) {
         return map;
      } else {
         try {
            fileDataCount = FtpTool.getDataCount(datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), datasystem.getUsername(), datasystem.getPassword(), path, filename);
         } catch (Exception e1) {
            e1.printStackTrace();
         }

         if (count < 0) {
            return map;
         } else {
            boolean b = count * 2 > fileDataCount;
            Reader in = null;
            LineNumberReader reader = null;
            if (fileDataCount <= count) {
               count = fileDataCount;
            }

            try {
               InputStream is = FtpTool.getDataInputStream(datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), datasystem.getUsername(), datasystem.getPassword(), path, filename, code);
               in = new InputStreamReader(is, code);
               reader = new LineNumberReader(in);

               for(int i = 0; i < fileDataCount && datademo.size() < count; ++i) {
                  String s = reader.readLine();
                  datademo.add(UnknownFileStruTool.replaceSeparation(s, " "));
                  if (flag) {
                     String replaceSeparation = UnknownFileStruTool.replaceSeparation(s, " ").trim();
                     String[] split = replaceSeparation.split(" ");
                     num = split.length;
                     flag = false;
                  }
               }

               reader.close();
               in.close();
               is.close();
            } catch (Exception e) {
               e.printStackTrace();
            }

            List<List<String>> ll = StringTool.splitString(datademo, " ", num, "none");

            for(int i = 0; i < ll.size(); ++i) {
               map.put(String.valueOf(i + 1), ll.get(i));
            }

            return map;
         }
      }
   }

   public Map<String, List<String>> getFiledataBySpliterFTP(FTPClient ftp, String path, String filename, int count, String sourceType, String code) throws Exception {
      Map<String, List<String>> map = new HashMap();
      boolean fileexit = false;
      int fileDataCount = 0;
      List<String> datademo = new ArrayList();
      boolean flag = true;
      int num = 0;
      fileexit = FtpTool.isFileExist(ftp, path, filename);
      if (!fileexit) {
         return map;
      } else {
         try {
            fileDataCount = FtpTool.getDataCount(ftp, path, filename);
         } catch (Exception e1) {
            e1.printStackTrace();
         }

         if (count < 0) {
            return map;
         } else {
            boolean b = count * 2 > fileDataCount;
            Reader in = null;
            LineNumberReader reader = null;
            InputStream is = null;
            if (fileDataCount <= count) {
               count = fileDataCount;
            }

            try {
               is = FtpTool.getDataInputStream(ftp, path, filename, code);
               in = new InputStreamReader(is, code);
               reader = new LineNumberReader(in);

               for(int i = 0; i < fileDataCount && datademo.size() < count; ++i) {
                  String s = reader.readLine();
                  datademo.add(UnknownFileStruTool.replaceSeparation(s, " "));
                  if (flag) {
                     String replaceSeparation = UnknownFileStruTool.replaceSeparation(s, " ").trim();
                     String[] split = replaceSeparation.split(" ");
                     num = split.length;
                     flag = false;
                  }
               }

               List<List<String>> ll = StringTool.splitString(datademo, " ", num, "none");

               for(int i = 0; i < ll.size(); ++i) {
                  map.put(String.valueOf(i + 1), ll.get(i));
               }
            } catch (Exception e) {
               e.printStackTrace();
            } finally {
               try {
                  if (reader != null) {
                     reader.close();
                  }

                  if (in != null) {
                     in.close();
                  }

                  if (is != null) {
                     is.close();
                     ftp.completePendingCommand();
                  }
               } catch (IOException e) {
                  e.printStackTrace();
               }

            }

            return map;
         }
      }
   }

   public Map<String, List<String>> getFiledataBySpliter(TCoreDatasystem datasystem, String path, String filename, int count, String sourceType, String code) throws Exception {
      Map<String, List<String>> map = new HashMap();
      boolean fileexit = false;
      int fileDataCount = FileTool.getFileDataCount(path + filename);
      List<String> datademo = new ArrayList();
      boolean flag = true;
      int num = 0;
      fileexit = FileTool.isFileExit(path + filename);
      if (!fileexit) {
         return null;
      } else {
         if (count > fileDataCount) {
            count = fileDataCount;
         }

         if (count < 0) {
            return null;
         } else {
            boolean b = count * 2 > fileDataCount;
            Reader in = null;
            BufferedReader reader = null;
            if (fileDataCount <= count) {
               count = fileDataCount;
            }

            try {
               in = new InputStreamReader(new FileInputStream(path + filename), code);
               reader = new BufferedReader(in);

               for(int i = 0; i < count; ++i) {
                  String s = reader.readLine();
                  datademo.add(UnknownFileStruTool.replaceSeparation(s, " ").trim());
                  if (flag) {
                     String replaceSeparation = UnknownFileStruTool.replaceSeparation(s, " ").trim();
                     String[] split = replaceSeparation.split(" ");
                     num = split.length;
                     flag = false;
                  }
               }
            } catch (Exception e) {
               e.printStackTrace();
            } finally {
               if (reader != null) {
                  reader.close();
               }

               if (in != null) {
                  in.close();
               }

            }

            List<List<String>> ll = StringTool.splitString(datademo, " ", num, "none");

            for(int i = 0; i < ll.size(); ++i) {
               map.put(String.valueOf(i + 1), ll.get(i));
            }

            return map;
         }
      }
   }

   public Map<String, String> getLocalFile(Set<Object> dataareaSet, Map<String, String> resultmap, String path, TCoreDatasystem tCoreDatasystem, String fileSourceType, boolean isFaceRule, TcoreTaskFindrule findRuleFace, String hits, String projectid, String taskid, String rate, List<TcoreTaskFindrule> regexByContent, boolean isSelectData, List<Pattern> patternContentList, List<Map<String, Object>> sensitiveRule, int batcheSize, String monitorurl, Connection tconnection, PreparedStatement pstmt) {
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      File file = new File(path);
      File[] tempList = file.listFiles();

      try {
         for(int i = 0; i < tempList.length; ++i) {
            if (tempList[i].isFile()) {
               String fileName = tempList[i].getName().toString();
               String absolutePath = tempList[i].getAbsolutePath();
               int lastIndexOf = absolutePath.lastIndexOf(File.separator);
               String fileurl = absolutePath.substring(0, lastIndexOf);
               if (fileName.contains(".pipe") && file.length() == 0L) {
                  continue;
               }

               try {
                  if (file.getParent() != null) {
                     File canonDir = file.getParentFile().getCanonicalFile();
                     File canon = new File(canonDir, file.getName());
                     File canonicalFile = canon.getCanonicalFile();
                     File absoluteFile = canon.getAbsoluteFile();
                     if (!canonicalFile.equals(absoluteFile)) {
                        continue;
                     }
                  }
               } catch (Exception var34) {
               }

               new HashMap();
               Map<String, String> var36 = this.discoveryFileUnknowstructure(dataareaSet, fileName, fileurl, absolutePath, tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt);
               this.writeFile("done", fileName + "," + fileurl + "," + formatter.format(new Date()) + "\r\n", monitorurl);
               Integer sureTable = Integer.parseInt((String)resultmap.get("sureTable"));
               Integer n = Integer.parseInt((String)var36.get("sureTable"));
               sureTable = sureTable + n;
               resultmap.put("sureTable", sureTable.toString());
               Integer tableSum = Integer.parseInt(this.redisService.get(taskid + "tableSum").toString());
               tableSum = tableSum + 1;
               Integer tableCount = (Integer)this.redisService.get(taskid + "tableCount");
               if (tableSum > tableCount) {
                  tableSum = tableCount;
               }

               this.redisService.set(taskid + "tableSum", tableSum.toString());
            }

            if (tempList[i].isDirectory()) {
               this.getLocalFile(dataareaSet, resultmap, tempList[i].getAbsolutePath(), tCoreDatasystem, fileSourceType, isFaceRule, findRuleFace, hits, projectid, taskid, rate, regexByContent, isSelectData, patternContentList, sensitiveRule, batcheSize, monitorurl, tconnection, pstmt);
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return resultmap;
   }

   public int getFileSensitiveColumnsByContent(List<String> tablelist, String datasourceid, String datasourcename, String schema, Map<String, List<String>> resultSet, String tableName, String rate, String hits, List<TcoreTaskFindrule> regexByContent, List<Pattern> patternList, StringBuilder tcoreDiscoveryResult_sql, List<String> list_table, List<Map<String, Object>> sensitiveRule, String projectid, String taskid, String quotecharacter, boolean isVersion, boolean isSelectData, HashMap<String, TCoreProjectVersionVO> version_map) {
      int count = 0;
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = props.getProperty("rateDir");
      String matchurl = url + "match" + File.separator + projectid + File.separator + taskid + File.separator + tableName + File.separator;
      String unmatchedurl = url + "unmatched" + File.separator + projectid + File.separator + taskid + File.separator + tableName + File.separator;
      String isrepeatvalue = props.get("isrepeatvalue").toString();
      String isRate = props.get("isRate").toString();
      int matchNum = 0;
      int unmatched = 0;
      StringBuffer matchstr = new StringBuffer();
      StringBuffer unmatchstr = new StringBuffer();
      if ("1".equals(isRate)) {
         matchNum = Integer.parseInt(props.get("rateNum").toString());
         unmatched = matchNum;
      }

      try {
         Map<Integer, List<String>> columnValueMap = new HashMap();
         Map<Integer, Set<String>> columnDistinctValueMap = new HashMap();
         int columnCount = 0;
         if (resultSet != null) {
            columnCount = resultSet.size();
         }

         int hangcount = 0;
         if (null != resultSet && resultSet.get("1") != null) {
            hangcount = ((List)resultSet.get("1")).size();
         }

         long rowCount = (long)hangcount;
         long[] nullOrEmptyCount = new long[columnCount];

         for(int i = 0; i < columnCount; ++i) {
            Set<String> set = new HashSet();
            List<String> list = new ArrayList();

            for(int j = 0; j < hangcount; ++j) {
               set.add((resultSet.get(String.valueOf(i + 1))).get(j));
               list.add((resultSet.get(String.valueOf(i + 1))).get(j));
            }

            columnDistinctValueMap.put(i, set);
            columnValueMap.put(i, list);
         }

         if (rowCount == 0L) {
            for(int i = 0; i < columnCount; ++i) {
               String columnname = (String)tablelist.get(i);
               SensitiveColumn nodata = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, 0L, 0L);
               nodata.setIsfile("1");
               tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", "", "", "0", schema, "", "", datasourceid, "0", "0", columnname, "", "0%", tableName, list_table));
            }

            return count;
         } else {
            if (isVersion) {
               if (!isSelectData) {
                  for(int i = 0; i < resultSet.size(); ++i) {
                     String columnname = (String)tablelist.get(i);
                     double distinctCount = (double)((Set)columnDistinctValueMap.get(i)).size();
                     SensitiveColumn column = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, rowCount, (long)distinctCount);
                     column.setIsfile("1");
                     List<String> columnValues = (List)columnValueMap.get(i);
                     if (null != columnValues && columnValues.size() != 0) {
                        long maxMatchCount = 0L;
                        List<String> maxMatchValues = null;
                        List<String> maxNotMathValues = null;
                        String dataarea_id = "";
                        String dataarea_name = "";
                        String issure = "0";
                        String tschemas = column.getSchema();
                        String datasystem_id = datasourceid;
                        String sampling = hits;
                        String fields = column.getColumnName();
                        String fieldremark = "";
                        String matching = rate;
                        String table = tableName;
                        String sensitive_id = "";
                        String sensitive_name = "";
                        String teffe_sampling = "";
                        NumberFormat nf = NumberFormat.getPercentInstance();
                        nf.parse(rate);
                        String keyid = schema + tableName + columnname;
                        if (version_map.get(keyid) != null) {
                           dataarea_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaId();
                           dataarea_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaName();
                           issure = "1";
                           sensitive_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getSensitiveId();
                           sensitive_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getSchemaName();
                           if (sensitive_name.equals("白名单")) {
                              issure = "2";
                              sensitive_name = "";
                           } else if (sensitive_name.equals("黑名单")) {
                              issure = "3";
                              sensitive_name = "";
                           }

                           teffe_sampling = "0";
                           matching = "0%";

                           try {
                              tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", dataarea_id, dataarea_name, issure, tschemas, sensitive_id, sensitive_name, datasystem_id, sampling, teffe_sampling, fields, fieldremark, matching, table, list_table));
                           } catch (IllegalAccessException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "安全权限异常,非常严重," + formatter.format(new Date()) + ",safesensitive_file\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("safesensitive_file", content1, url);
                           } catch (IllegalArgumentException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "参数错误异常,非常严重," + formatter.format(new Date()) + ",safepara_file\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("safepara_file", content1, url);
                           } catch (InvocationTargetException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "反射异常,非常严重," + formatter.format(new Date()) + ",safefanse_file\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("safefanse_file", content1, url);
                           }

                           ++count;
                        } else {
                           try {
                              tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", dataarea_id, dataarea_name, issure, tschemas, sensitive_id, sensitive_name, datasystem_id, sampling, teffe_sampling, fields, fieldremark, matching, table, list_table));
                           } catch (IllegalAccessException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "安全权限异常,非常严重," + formatter.format(new Date()) + ",unbanbensafesensive_file\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("unbanbensafesensive_file", content1, url);
                           } catch (IllegalArgumentException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "参数错误异常,非常严重," + formatter.format(new Date()) + ",unbanbensafecanshu_file\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("unbanbensafecanshu_file", content1, url);
                           } catch (InvocationTargetException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "反射异常,非常严重," + formatter.format(new Date()) + ",unbanbensafefanse_file\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("unbanbensafefanse_file", content1, url);
                           }

                           ++count;
                        }
                     }
                  }
               } else {
                  for(int i = 0; i < resultSet.size(); ++i) {
                     String columnname = (String)tablelist.get(i);
                     double distinctCount = (double)((Set)columnDistinctValueMap.get(i)).size();
                     SensitiveColumn column = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, rowCount, (long)distinctCount);
                     column.setIsfile("1");
                     List<String> columnValues = (List)columnValueMap.get(i);
                     if (null != columnValues && columnValues.size() != 0) {
                        long maxMatchCount = 0L;
                        List<String> maxMatchValues = null;
                        List<String> maxNotMathValues = null;
                        String dataarea_id = "";
                        String dataarea_name = "";
                        String issure = "0";
                        String tschemas = column.getSchema();
                        String datasystem_id = datasourceid;
                        String sampling = hits;
                        String fields = column.getColumnName();
                        String fieldremark = "";
                        String matching = rate;
                        String table = tableName;
                        String sensitive_id = "";
                        String sensitive_name = "";
                        String teffe_sampling = "";
                        NumberFormat nf = NumberFormat.getPercentInstance();
                        Number m = nf.parse(rate);
                        new StringBuffer();
                        String keyid = schema + tableName + columnname;
                        if (version_map.get(keyid) != null) {
                           dataarea_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaId();
                           dataarea_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaName();
                           sensitive_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getSensitiveId();
                           sensitive_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getSensitiveName();
                           if (sensitive_name.equals("白名单")) {
                              issure = "2";
                              sensitive_name = "";
                           } else if (sensitive_name.equals("黑名单")) {
                              issure = "3";
                              sensitive_name = "";
                           }

                           teffe_sampling = "0";
                           matching = "0%";

                           try {
                              tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", dataarea_id, dataarea_name, issure, tschemas, sensitive_id, sensitive_name, datasystem_id, sampling, teffe_sampling, fields, fieldremark, matching, table, list_table));
                           } catch (IllegalAccessException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "安全权限异常,非常严重," + formatter.format(new Date()) + ",guizeunbanbensafesensitive_file\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("guizeunbanbensafesensitive_file", content1, url);
                           } catch (IllegalArgumentException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "参数错误异常,非常严重," + formatter.format(new Date()) + ",guizeunbanbensafecanshu_file\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("guizeunbanbensafecanshu_file", content1, url);
                           } catch (InvocationTargetException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "反射异常,非常严重," + formatter.format(new Date()) + ",guizeunbanbensafefanse_file\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("guizeunbanbensafefanse_file", content1, url);
                           }

                           ++count;
                        } else if (regexByContent.size() > 0) {
                           int patternIndex = 0;

                           for(Pattern pattern : patternList) {
                              matchstr.setLength(0);
                              unmatchstr.setLength(0);
                              if ("1".equals(isRate)) {
                                 matchNum = Integer.parseInt(props.get("rateNum").toString());
                                 unmatched = matchNum;
                              }

                              TcoreTaskFindrule searchRegex = (TcoreTaskFindrule)regexByContent.get(patternIndex++);
                              String dataareaid = searchRegex.getDataareaid();
                              String regexType = searchRegex.getDataarea();
                              String regexName = searchRegex.getRulename();
                              long matchCount = 0L;
                              List<String> tempMatchValues = new ArrayList();
                              List<String> matchValues = new ArrayList();
                              List<String> notMatchValues = new ArrayList();
                              List<String> invalidValues = new ArrayList();
                              if (pattern.pattern().startsWith("MethodName:")) {
                                 String methodName = pattern.pattern().substring(11);
                                 int maxLength = -1;
                                 int level = 0;
                                 if (methodName.contains("MaxLength:")) {
                                    if (methodName.contains("Weight:")) {
                                       String[] parameters = methodName.split("\\|MaxLength:");
                                       if (parameters.length == 2) {
                                          methodName = parameters[0];
                                          String[] Weight = parameters[1].split("\\|Weight:");
                                          maxLength = Integer.parseInt(Weight[0]);

                                          try {
                                             level = Integer.parseInt(Weight[1]);
                                          } catch (Exception var112) {
                                             level = 0;
                                          }
                                       }
                                    } else {
                                       String[] parameters = methodName.split("\\|MaxLength:");
                                       if (parameters.length == 2) {
                                          methodName = parameters[0];
                                          maxLength = Integer.parseInt(parameters[1]);
                                       }
                                    }
                                 }

                                 for(String val : columnValues) {
                                    String vals = this.getquotecharacter(val, quotecharacter);
                                    if (vals.trim().equals("")) {
                                       invalidValues.add(val);
                                    } else if (!vals.equals("ghca_value_no_marcher") && this.matches(methodName, maxLength, vals, 0)) {
                                       ++matchCount;
                                       matchValues.add(val);
                                       tempMatchValues.add(regexType + ":" + val);
                                       if (matchNum > 0) {
                                          matchstr.append(val + "\r\n");
                                          --matchNum;
                                       }
                                    } else {
                                       notMatchValues.add(val);
                                       if (unmatched > 0) {
                                          unmatchstr.append(val + "\r\n");
                                          --unmatched;
                                       }
                                    }
                                 }
                              } else {
                                 for(String val : columnValues) {
                                    String vals = this.getquotecharacter(val, quotecharacter);
                                    if (vals.trim().equals("")) {
                                       invalidValues.add(val);
                                    } else if (!vals.equals("ghca_value_no_marcher") && pattern.matcher(vals).matches()) {
                                       ++matchCount;
                                       matchValues.add(val);
                                       tempMatchValues.add(regexType + ":" + val);
                                       if (matchNum > 0) {
                                          matchstr.append(val + "\r\n");
                                          --matchNum;
                                       }
                                    } else {
                                       notMatchValues.add(val);
                                       if (unmatched > 0) {
                                          unmatchstr.append(val + "\r\n");
                                          --unmatched;
                                       }
                                    }
                                 }
                              }

                              this.writeFileRefresh(columnname, matchstr.toString(), matchurl);
                              this.writeFileRefresh(columnname, unmatchstr.toString(), unmatchedurl);

                              for(String string : invalidValues) {
                                 columnValues.remove(string);
                              }

                              NumberFormat numberFormat = NumberFormat.getInstance();
                              numberFormat.setMaximumFractionDigits(2);
                              String result = numberFormat.format((double)((float)matchCount / (float)columnValues.size() * 100.0F));
                              matching = result + "%";
                              if ((double)matchCount / (double)columnValues.size() >= m.doubleValue()) {
                                 column.setMatchResult(regexType, regexName, (long)matchValues.size(), matchValues, notMatchValues);
                                 (new StringBuilder()).append(schema).append("_m").append(tableName).append("_m").append(columnname).toString();
                                 HashMap<String, List<String>> keyhash = new HashMap();
                                 List<String> matchValuesList = new ArrayList();
                                 List<String> notMatchValuesList = new ArrayList();
                                 if (matchValues.size() > 100) {
                                    matchValuesList.addAll(matchValues.subList(0, 100));
                                 } else if (matchValues.size() != 0) {
                                    matchValuesList.addAll(matchValues.subList(0, matchValues.size()));
                                 }

                                 if (notMatchValues.size() > 100) {
                                    notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                                 } else if (notMatchValues.size() != 0) {
                                    notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                                 }

                                 keyhash.put("matchValues", matchValuesList);
                                 keyhash.put("notMatchValues", notMatchValuesList);
                                 dataarea_id = dataareaid;
                                 dataarea_name = regexType;

                                 for(int x = 0; x < sensitiveRule.size(); ++x) {
                                    if (dataareaid.equals(((Map)sensitiveRule.get(x)).get("dataarea_id"))) {
                                       sensitive_id = (String)((Map)sensitiveRule.get(x)).get("rule_id");
                                       sensitive_name = (String)((Map)sensitiveRule.get(x)).get("name");
                                    }
                                 }

                                 ++count;
                                 break;
                              }

                              List<String> notMatchValuesList = new ArrayList();
                              if (notMatchValues.size() > 100) {
                                 notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                              } else if (notMatchValues.size() != 0) {
                                 notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                              }

                              column.setIsshowdata("1");
                              (new StringBuilder()).append(schema).append("_m").append(tableName).append("_m").append(columnname).toString();
                              HashMap<String, List<String>> keyhash = new HashMap();
                              keyhash.put("matchValues", matchValues);
                              keyhash.put("notMatchValues", notMatchValuesList);
                              if (maxMatchCount < matchCount) {
                                 maxMatchCount = matchCount;
                                 maxMatchValues = tempMatchValues;
                                 maxNotMathValues = notMatchValues;
                              }
                           }

                           if (!column.isSensitiveColumn()) {
                              if (maxMatchCount > 0L) {
                                 column.setMatchCount(maxMatchCount);
                                 column.setMatchValues(maxMatchValues);
                                 column.setNotMatchValues(maxNotMathValues);
                              } else {
                                 column.setNotMatchValues(columnValues);
                              }
                           }

                           if (columnValues.size() > Integer.parseInt(hits)) {
                              teffe_sampling = hits;
                           } else {
                              teffe_sampling = String.valueOf(columnValues.size());
                           }

                           tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", dataarea_id, dataarea_name, issure, tschemas, sensitive_id, sensitive_name, datasourceid, hits, teffe_sampling, fields, fieldremark, matching, tableName, list_table));
                        }
                     }
                  }
               }
            } else if (!isSelectData) {
               for(int i = 0; i < resultSet.size(); ++i) {
                  String columnname = (String)tablelist.get(i);
                  double distinctCount = (double)((Set)columnDistinctValueMap.get(i)).size();
                  SensitiveColumn column = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, rowCount, (long)distinctCount);
                  column.setIsfile("1");
                  List<String> columnValues = (List)columnValueMap.get(i);
                  if (null != columnValues && columnValues.size() != 0) {
                     String dataarea_id = "";
                     String dataarea_name = "";
                     String issure = "0";
                     String tschemas = schema;
                     String sensitive_id = "";
                     String sensitive_name = "";
                     String datasystem_id = datasourceid;
                     String sampling = hits;
                     String teffe_sampling = "0";
                     String fields = column.getColumnName();
                     String fieldremark = "";
                     String matching = "0%";
                     String table = tableName;

                     try {
                        tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", dataarea_id, dataarea_name, issure, tschemas, sensitive_id, sensitive_name, datasystem_id, sampling, teffe_sampling, fields, fieldremark, matching, table, list_table));
                     } catch (IllegalAccessException e) {
                        e.printStackTrace();
                        this.writeFile("errormanage", "安全权限异常,非常严重," + formatter.format(new Date()) + ",unguizeunbanbensafesensitive_file\r\n", url);
                        String content1 = this.geterrorprint(e);
                        this.writeErroFile("unguizeunbanbensafesensitive_file", content1, url);
                     } catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        this.writeFile("errormanage", "参数错误异常,非常严重," + formatter.format(new Date()) + ",unguizeunbanbensafecanshu_file\r\n", url);
                        String content1 = this.geterrorprint(e);
                        this.writeErroFile("unguizeunbanbensafecanshu_file", content1, url);
                     } catch (InvocationTargetException e) {
                        e.printStackTrace();
                        this.writeFile("errormanage", "反射异常,非常严重," + formatter.format(new Date()) + ",unguizeunbanbensafefanse_file\r\n", url);
                        String content1 = this.geterrorprint(e);
                        this.writeErroFile("unguizeunbanbensafefanse_file", content1, url);
                     }

                     ++count;
                  }
               }
            } else if (regexByContent.size() > 0) {
               for(int i = 0; i < resultSet.size(); ++i) {
                  String columnname = (String)tablelist.get(i);
                  double distinctCount = (double)((Set)columnDistinctValueMap.get(i)).size();
                  SensitiveColumn column = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, rowCount, (long)distinctCount);
                  column.setIsfile("1");
                  List<String> columnValues = (List)columnValueMap.get(i);
                  if (null != columnValues && columnValues.size() != 0) {
                     long maxMatchCount = 0L;
                     List<String> maxMatchValues = null;
                     List<String> maxNotMathValues = null;
                     String dataarea_id = "";
                     String dataarea_name = "";
                     String issure = "0";
                     String sensitive_id = "";
                     String sensitive_name = "";
                     String teffe_sampling = "0";
                     String fields = column.getColumnName();
                     String fieldremark = "";
                     String matching = "0%";
                     NumberFormat nf = NumberFormat.getPercentInstance();
                     Number m = nf.parse(rate);
                     int patternIndex = 0;

                     for(Pattern pattern : patternList) {
                        matchstr.setLength(0);
                        unmatchstr.setLength(0);
                        if ("1".equals(isRate)) {
                           matchNum = Integer.parseInt(props.get("rateNum").toString());
                           unmatched = matchNum;
                        }

                        TcoreTaskFindrule searchRegex = (TcoreTaskFindrule)regexByContent.get(patternIndex++);
                        String dataareaid = searchRegex.getDataareaid();
                        String regexType = searchRegex.getDataarea();
                        String regexName = searchRegex.getRulename();
                        String disoverway = searchRegex.getDiscoverway();
                        String dictionaryClass = searchRegex.getDictionaryClass();
                        String matchingway = searchRegex.getMatchingwaSy();
                        long matchCount = 0L;
                        List<String> tempMatchValues = new ArrayList();
                        List<String> matchValues = new ArrayList();
                        List<String> notMatchValues = new ArrayList();
                        List<String> invalidValues = new ArrayList();
                        new HashMap();
                        if (pattern.pattern().startsWith("MethodName:")) {
                           String methodName = pattern.pattern().substring(11);
                           int maxLength = -1;
                           int level = 0;
                           if (methodName.contains("MaxLength:")) {
                              if (methodName.contains("Weight:")) {
                                 String[] parameters = methodName.split("\\|MaxLength:");
                                 if (parameters.length == 2) {
                                    methodName = parameters[0];
                                    String[] Weight = parameters[1].split("\\|Weight:");
                                    maxLength = Integer.parseInt(Weight[0]);

                                    try {
                                       level = Integer.parseInt(Weight[1]);
                                    } catch (Exception var108) {
                                       level = 0;
                                    }
                                 }
                              } else {
                                 String[] parameters = methodName.split("\\|MaxLength:");
                                 if (parameters.length == 2) {
                                    methodName = parameters[0];
                                    maxLength = Integer.parseInt(parameters[1]);
                                 }
                              }
                           }

                           for(String val : columnValues) {
                              String vals = this.getquotecharacter(val, quotecharacter);
                              if (vals.trim().equals("")) {
                                 invalidValues.add(val);
                              } else if (!vals.equals("ghca_value_no_marcher") && this.matches(methodName, maxLength, vals, 0)) {
                                 ++matchCount;
                                 matchValues.add(val);
                                 tempMatchValues.add(regexType + ":" + val);
                                 if (matchNum > 0) {
                                    matchstr.append(val + "\r\n");
                                    --matchNum;
                                 }
                              } else {
                                 notMatchValues.add(val);
                                 if (unmatched > 0) {
                                    unmatchstr.append(val + "\r\n");
                                    --unmatched;
                                 }
                              }
                           }
                        } else if ("03".equals(disoverway)) {
                           List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryDictionaryFile(dictionaryClass);

                           for(String val : columnValues) {
                              if (this.dicmatch(list, matchingway, val)) {
                                 ++matchCount;
                                 matchValues.add(val);
                                 tempMatchValues.add(regexType + ":" + val);
                                 if (matchNum > 0) {
                                    matchstr.append(val + "\r\n");
                                    --matchNum;
                                 }
                              } else {
                                 notMatchValues.add(val);
                                 if (unmatched > 0) {
                                    unmatchstr.append(val + "\r\n");
                                    --unmatched;
                                 }
                              }
                           }
                        } else {
                           for(String val : columnValues) {
                              String vals = this.getquotecharacter(val, quotecharacter);
                              if (vals.trim().equals("")) {
                                 invalidValues.add(val);
                              } else if (!vals.equals("ghca_value_no_marcher") && pattern.matcher(vals).matches()) {
                                 ++matchCount;
                                 matchValues.add(val);
                                 tempMatchValues.add(regexType + ":" + val);
                                 if (matchNum > 0) {
                                    matchstr.append(val + "\r\n");
                                    --matchNum;
                                 }
                              } else {
                                 notMatchValues.add(val);
                                 if (unmatched > 0) {
                                    unmatchstr.append(val + "\r\n");
                                    --unmatched;
                                 }
                              }
                           }
                        }

                        this.writeFileRefresh(columnname, matchstr.toString(), matchurl);
                        this.writeFileRefresh(columnname, unmatchstr.toString(), unmatchedurl);

                        for(String string : invalidValues) {
                           columnValues.remove(string);
                        }

                        NumberFormat numberFormat = NumberFormat.getInstance();
                        numberFormat.setMaximumFractionDigits(2);
                        String result = "0";
                        if (columnValues.size() > 0) {
                           result = numberFormat.format((double)((float)matchCount / (float)columnValues.size() * 100.0F));
                        }

                        matching = result + "%";
                        if ((double)matchCount / (double)columnValues.size() >= m.doubleValue()) {
                           column.setMatchResult(regexType, regexName, (long)matchValues.size(), matchValues, notMatchValues);
                           (new StringBuilder()).append(schema).append("_m").append(tableName).append("_m").append(columnname).toString();
                           HashMap<String, List<String>> keyhash = new HashMap();
                           List<String> matchValuesList = new ArrayList();
                           List<String> notMatchValuesList = new ArrayList();
                           if (matchValues.size() > 100) {
                              matchValuesList.addAll(matchValues.subList(0, 100));
                           } else if (matchValues.size() != 0) {
                              matchValuesList.addAll(matchValues.subList(0, matchValues.size()));
                           }

                           if (notMatchValues.size() > 100) {
                              notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                           } else if (notMatchValues.size() != 0) {
                              notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                           }

                           keyhash.put("matchValues", matchValuesList);
                           keyhash.put("notMatchValues", notMatchValuesList);
                           dataarea_id = dataareaid;
                           dataarea_name = regexType;

                           for(int x = 0; x < sensitiveRule.size(); ++x) {
                              if (dataareaid.equals(((Map)sensitiveRule.get(x)).get("dataarea_id"))) {
                                 sensitive_id = (String)((Map)sensitiveRule.get(x)).get("rule_id");
                                 sensitive_name = (String)((Map)sensitiveRule.get(x)).get("name");
                              }
                           }

                           ++count;
                           break;
                        }

                        List<String> notMatchValuesList = new ArrayList();
                        if (notMatchValues.size() > 100) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                        } else if (notMatchValues.size() != 0) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                        }

                        column.setIsshowdata("1");
                        (new StringBuilder()).append(schema).append("_m").append(tableName).append("_m").append(columnname).toString();
                        HashMap<String, List<String>> keyhash = new HashMap();
                        keyhash.put("matchValues", matchValues);
                        keyhash.put("notMatchValues", notMatchValuesList);
                        if (maxMatchCount < matchCount) {
                           maxMatchCount = matchCount;
                           maxMatchValues = tempMatchValues;
                           maxNotMathValues = notMatchValues;
                        }
                     }

                     if (!column.isSensitiveColumn()) {
                        if (maxMatchCount > 0L) {
                           column.setMatchCount(maxMatchCount);
                           column.setMatchValues(maxMatchValues);
                           column.setNotMatchValues(maxNotMathValues);
                        } else {
                           column.setNotMatchValues(columnValues);
                        }
                     }

                     if (columnValues.size() > Integer.parseInt(hits)) {
                        teffe_sampling = hits;
                     } else {
                        teffe_sampling = String.valueOf(columnValues.size());
                     }

                     tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", dataarea_id, dataarea_name, issure, schema, sensitive_id, sensitive_name, datasourceid, hits, teffe_sampling, fields, fieldremark, matching, tableName, list_table));
                  }
               }
            } else {
               for(int i = 0; i < resultSet.size(); ++i) {
                  String columnname = (String)tablelist.get(i);
                  tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", "", "", "", schema, "", "", datasourceid, hits, "0", columnname, "", rate, tableName, list_table));
               }
            }

            return count;
         }
      } catch (Exception e) {
         e.printStackTrace();
         return count;
      } finally {
         ;
      }
   }

   public Set<Object> getNostructureFileSensitiveColumnsByContent(String datasourceid, Set<Object> dataareaSet, String datasourcename, Map<String, List<String>> resultSet, String fileName, String rate, String hits, List<TcoreTaskFindrule> regexByContent, List<Pattern> patternList, List<Map<String, Object>> sensitiveRule, String projectid, String taskid, String quotecharacter, boolean isSelectData, String filedir, PreparedStatement pstmt, int cnt, int batcheSize, Connection tconnection, String fileType, String filecontent) {
      int count = 0;
      Set<Object> dataareaSet1 = new HashSet();
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = props.getProperty("rateDir");
      String isrepeatvalue = props.get("isrepeatvalue").toString();
      Map<Integer, List<String>> columnValueMap = new HashMap();
      Map<Integer, Set<String>> columnDistinctValueMap = new HashMap();
      int columnCount = 0;
      if (resultSet != null) {
         columnCount = resultSet.size();
      }

      int hangcount = 0;
      long[] nullOrEmptyCount = new long[columnCount];
      Set<String> keySet = resultSet.keySet();
      int n = 0;

      for(String key : keySet) {
         Set<String> set = new HashSet();
         List<String> list = new ArrayList();
         List<String> valuelist = (List)resultSet.get(key);
         hangcount = valuelist.size();

         for(int j = 0; j < valuelist.size(); ++j) {
            set.add(String.valueOf(((List)resultSet.get(key)).get(j)));
            list.add(String.valueOf(((List)resultSet.get(key)).get(j)));
         }

         columnDistinctValueMap.put(n, set);
         columnValueMap.put(n, list);
         ++n;
      }

      long rowCount = (long)hangcount;
      if (rowCount == 0L) {
         try {
            pstmt.setObject(1, datasourceid);
            pstmt.setObject(2, "");
            pstmt.setObject(3, filedir);
            pstmt.setObject(4, fileName);
            pstmt.setObject(5, "");
            pstmt.setObject(6, hits);
            pstmt.setObject(7, "0");
            pstmt.setObject(8, "0%");
            pstmt.setObject(9, "");
            pstmt.setObject(10, "");
            pstmt.setObject(11, "");
            pstmt.setObject(12, "");
            pstmt.setObject(13, "0");
            pstmt.setObject(14, "");
            pstmt.setObject(15, fileType);
            pstmt.setObject(16, filecontent);
            pstmt.setObject(17, UUID.randomUUID().toString());
            pstmt.addBatch();
            ++cnt;
            if (cnt % batcheSize == 0) {
               long useTime1 = System.currentTimeMillis();
               pstmt.executeBatch();
               pstmt.clearBatch();
               tconnection.commit();
               long useTime2 = System.currentTimeMillis();
               System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
            }
         } catch (SQLException e) {
            this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pidealfd321w\r\n", url);
            String content1 = this.geterrorprint(e);
            this.writeErroFile("pidealfd321w", content1, url);
            e.printStackTrace();
         }

         return dataareaSet1;
      } else {
         try {
            if (!isSelectData) {
               try {
                  pstmt.setObject(1, datasourceid);
                  pstmt.setObject(2, "");
                  pstmt.setObject(3, filedir);
                  pstmt.setObject(4, fileName);
                  pstmt.setObject(5, "");
                  pstmt.setObject(6, hits);
                  pstmt.setObject(7, "0");
                  pstmt.setObject(8, "0%");
                  pstmt.setObject(9, "");
                  pstmt.setObject(10, "");
                  pstmt.setObject(11, "");
                  pstmt.setObject(12, "");
                  pstmt.setObject(13, "0");
                  pstmt.setObject(14, "");
                  pstmt.setObject(15, fileType);
                  pstmt.setObject(16, filecontent);
                  pstmt.setObject(17, UUID.randomUUID().toString());
                  pstmt.addBatch();
                  ++cnt;
                  if (cnt % batcheSize == 0) {
                     long useTime1 = System.currentTimeMillis();
                     pstmt.executeBatch();
                     pstmt.clearBatch();
                     tconnection.commit();
                     long useTime2 = System.currentTimeMillis();
                     System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                  }
               } catch (SQLException e) {
                  this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pidealfd321\r\n", url);
                  String content1 = this.geterrorprint(e);
                  this.writeErroFile("pidealfd321", content1, url);
                  e.printStackTrace();
               }
            } else {
               String dataarea_id = "";
               StringBuffer dataarea_name = new StringBuffer();
               String issure = "0";
               String tschemas = "";
               String sensitive_id = "";
               String sensitive_name = "";
               String datasystem_id = datasourceid;
               String teffe_sampling = "0";
               String fields = fileName;
               String fieldremark = "";
               StringBuffer matching = new StringBuffer();
               String table = filedir;
               if (regexByContent.size() <= 0) {
                  teffe_sampling = "0";
               } else {
                  for(int i = 0; i < resultSet.size(); ++i) {
                     List<String> columnValues = (List)columnValueMap.get(i);
                     if (columnValues.size() > Integer.parseInt(hits)) {
                        teffe_sampling = hits;
                     } else {
                        teffe_sampling = String.valueOf(columnValues.size());
                     }

                     if (null != columnValues && columnValues.size() != 0) {
                        NumberFormat nf = NumberFormat.getPercentInstance();
                        Number m = nf.parse(rate);
                        int patternIndex = 0;

                        for(Pattern pattern : patternList) {
                           TcoreTaskFindrule searchRegex = (TcoreTaskFindrule)regexByContent.get(patternIndex++);
                           String regexType = searchRegex.getDataarea();
                           String disoverway = searchRegex.getDiscoverway();
                           String dictionaryClass = searchRegex.getDictionaryClass();
                           String matchingway = searchRegex.getMatchingwaSy();
                           long matchCount = 0L;
                           List<String> tempMatchValues = new ArrayList();
                           List<String> matchValues = new ArrayList();
                           List<String> notMatchValues = new ArrayList();
                           List<String> invalidValues = new ArrayList();
                           new HashMap();
                           if (pattern.pattern().startsWith("MethodName:")) {
                              String methodName = pattern.pattern().substring(11);
                              int maxLength = -1;
                              int level = 0;
                              if (methodName.contains("MaxLength:")) {
                                 if (methodName.contains("Weight:")) {
                                    String[] parameters = methodName.split("\\|MaxLength:");
                                    if (parameters.length == 2) {
                                       methodName = parameters[0];
                                       String[] Weight = parameters[1].split("\\|Weight:");
                                       maxLength = Integer.parseInt(Weight[0]);

                                       try {
                                          level = Integer.parseInt(Weight[1]);
                                       } catch (Exception var80) {
                                          level = 0;
                                       }
                                    }
                                 } else {
                                    String[] parameters = methodName.split("\\|MaxLength:");
                                    if (parameters.length == 2) {
                                       methodName = parameters[0];
                                       maxLength = Integer.parseInt(parameters[1]);
                                    }
                                 }
                              }

                              for(String val : columnValues) {
                                 String vals = this.getquotecharacter(val, quotecharacter);
                                 if (vals.trim().equals("")) {
                                    invalidValues.add(val);
                                 } else if (!vals.equals("ghca_value_no_marcher") && this.matches(methodName, maxLength, vals, 0)) {
                                    ++matchCount;
                                    matchValues.add(val);
                                    tempMatchValues.add(regexType + ":" + val);
                                 } else {
                                    notMatchValues.add(val);
                                 }
                              }
                           } else if ("03".equals(disoverway)) {
                              List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryDictionaryFile(dictionaryClass);

                              for(String val : columnValues) {
                                 if (this.dicmatch(list, matchingway, val)) {
                                    ++matchCount;
                                    matchValues.add(val);
                                    tempMatchValues.add(regexType + ":" + val);
                                 } else {
                                    notMatchValues.add(val);
                                 }
                              }
                           } else {
                              for(String val : columnValues) {
                                 String vals = this.getquotecharacter(val, quotecharacter);
                                 if (vals.trim().equals("")) {
                                    invalidValues.add(val);
                                 } else if (!vals.equals("ghca_value_no_marcher") && pattern.matcher(vals).matches()) {
                                    ++matchCount;
                                    matchValues.add(val);
                                    tempMatchValues.add(regexType + ":" + val);
                                 } else {
                                    notMatchValues.add(val);
                                 }
                              }
                           }

                           for(String string : invalidValues) {
                              columnValues.remove(string);
                           }

                           NumberFormat numberFormat = NumberFormat.getInstance();
                           numberFormat.setMaximumFractionDigits(2);
                           String result = numberFormat.format((double)((float)matchCount / (float)columnValues.size() * 100.0F));
                           if ((double)matchCount / (double)columnValues.size() >= m.doubleValue()) {
                              HashMap<String, List<String>> keyhash = new HashMap();
                              List<String> matchValuesList = new ArrayList();
                              List<String> notMatchValuesList = new ArrayList();
                              if (matchValues.size() > 100) {
                                 matchValuesList.addAll(matchValues.subList(0, 100));
                              } else if (matchValues.size() != 0) {
                                 matchValuesList.addAll(matchValues.subList(0, matchValues.size()));
                              }

                              if (notMatchValues.size() > 100) {
                                 notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                              } else if (notMatchValues.size() != 0) {
                                 notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                              }

                              keyhash.put("matchValues", matchValuesList);
                              keyhash.put("notMatchValues", notMatchValuesList);
                              dataarea_name.append(regexType + "|");
                              matching.append(result + "%|");
                              dataareaSet.add(regexType);
                              dataareaSet1.add(regexType);
                           } else {
                              List<String> notMatchValuesList = new ArrayList();
                              if (notMatchValues.size() > 100) {
                                 notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                              } else if (notMatchValues.size() != 0) {
                                 notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                              }

                              HashMap<String, List<String>> keyhash = new HashMap();
                              keyhash.put("matchValues", matchValues);
                              keyhash.put("notMatchValues", notMatchValuesList);
                           }
                        }
                     }
                  }
               }

               String matchingstr = matching.toString();
               String dataarea_namestr = dataarea_name.toString();
               if (matching.toString().length() > 1) {
                  matchingstr = matching.toString().substring(0, matching.toString().length() - 1);
               }

               if (dataarea_name.toString().length() > 1) {
                  dataarea_namestr = dataarea_name.toString().substring(0, dataarea_name.toString().length() - 1);
               }

               try {
                  pstmt.setObject(1, datasystem_id);
                  pstmt.setObject(2, "");
                  pstmt.setObject(3, table);
                  pstmt.setObject(4, fields);
                  pstmt.setObject(5, "");
                  pstmt.setObject(6, hits);
                  pstmt.setObject(7, teffe_sampling);
                  pstmt.setObject(8, matchingstr);
                  pstmt.setObject(9, dataarea_id);
                  pstmt.setObject(10, dataarea_namestr);
                  pstmt.setObject(11, sensitive_id);
                  pstmt.setObject(12, sensitive_name);
                  pstmt.setObject(13, issure);
                  pstmt.setObject(14, "");
                  pstmt.setObject(15, fileType);
                  pstmt.setObject(16, filecontent);
                  pstmt.setObject(17, UUID.randomUUID().toString());
                  pstmt.addBatch();
                  ++cnt;
                  if (cnt % batcheSize == 0) {
                     long useTime1 = System.currentTimeMillis();
                     pstmt.executeBatch();
                     pstmt.clearBatch();
                     tconnection.commit();
                     long useTime2 = System.currentTimeMillis();
                     System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                  }
               } catch (SQLException e) {
                  this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pidealfd\r\n", url);
                  String content1 = this.geterrorprint(e);
                  this.writeErroFile("pidealfd", content1, url);
                  e.printStackTrace();
               }
            }
         } catch (NumberFormatException e) {
            e.printStackTrace();
         } catch (ParseException e) {
            e.printStackTrace();
         }

         return dataareaSet1;
      }
   }

   public int getNosqlSensitiveColumnsByContent(String datasourceid, String datasourcename, Map<String, List<String>> resultSet, String schema, String rate, String hits, List<TcoreTaskFindrule> regexByContent, List<Pattern> patternList, List<Map<String, Object>> sensitiveRule, String projectid, String taskid, String quotecharacter, boolean isSelectData, String tableName, PreparedStatement pstmt, int cnt, int batcheSize, Connection tconnection) {
      int count = 0;
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = props.getProperty("rateDir");
      String isrepeatvalue = props.get("isrepeatvalue").toString();
      String isRate = props.get("isRate").toString();
      String matchurl = url + "match" + File.separator + projectid + File.separator + taskid + File.separator + tableName + File.separator;
      String unmatchedurl = url + "unmatched" + File.separator + projectid + File.separator + taskid + File.separator + tableName + File.separator;
      new HashMap();
      new HashMap();
      int matchNum = 0;
      int unmatched = 0;
      StringBuffer matchstr = new StringBuffer();
      StringBuffer unmatchstr = new StringBuffer();
      List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList = this.tCoreEncryptionTypeFieldDao.getTCoreEncryptionTypeField(tableName, schema, datasourceid);
      new ArrayList();
      new TCoreEncryption();
      new TCoreSecretkey();
      HashMap<String, String> fieldSecretMap = new HashMap();
      HashMap<String, String> fieldtypeMap = new HashMap();
      HashMap<String, String> isLikeMap = new HashMap();
      HashMap<String, String> keepFirstMap = new HashMap();
      HashMap<String, String> encDigitMap = new HashMap();
      HashMap<String, String> twoindexmap = new HashMap();

      for(TCoreEncryptionTypeField t : tCoreEncryptionTypeFieldList) {
         if ("5".equals(t.getFlag())) {
            TCoreSecretkey secretKey = (TCoreSecretkey)this.tCoreSecretkeyDao.get(t.getEncryption_secretkey_id());
            fieldSecretMap.put(t.getTable_field_id(), secretKey.getSectet_key_value());
            isLikeMap.put(t.getTable_field_id(), t.getIslike());
            keepFirstMap.put(t.getTable_field_id(), t.getKeepfirst());
            encDigitMap.put(t.getTable_field_id(), t.getEncdigit());
            TCoreEncryption tCoreEncryption = (TCoreEncryption)this.tCoreEncryptionDao.get(secretKey.getEncryption_id());
            String encryption_type = tCoreEncryption.getEncryption_type();
            fieldtypeMap.put(t.getTable_field_id(), encryption_type);
         }
      }

      try {
         if (regexByContent.size() > 0) {
            for(String key : resultSet.keySet()) {
               String dataarea_id = "";
               String dataarea_name = "";
               String issure = "0";
               String sensitive_id = "";
               String sensitive_name = "";
               String datasystem_id = datasourceid;
               String teffe_sampling = "0";
               String matching = "";
               String table = tableName;
               if (!isSelectData) {
                  try {
                     pstmt.setObject(1, datasourceid);
                     pstmt.setObject(2, schema);
                     pstmt.setObject(3, tableName);
                     pstmt.setObject(4, key);
                     pstmt.setObject(5, "");
                     pstmt.setObject(6, hits);
                     pstmt.setObject(7, "0");
                     pstmt.setObject(8, "0%");
                     pstmt.setObject(9, "");
                     pstmt.setObject(10, "");
                     pstmt.setObject(11, "");
                     pstmt.setObject(12, "");
                     pstmt.setObject(13, "0");
                     pstmt.setObject(14, "");
                     pstmt.setObject(15, "");
                     pstmt.setObject(16, "");
                     pstmt.setObject(17, UUID.randomUUID().toString());
                     pstmt.addBatch();
                     ++cnt;
                     if (cnt % batcheSize == 0) {
                        long useTime1 = System.currentTimeMillis();
                        pstmt.executeBatch();
                        pstmt.clearBatch();
                        tconnection.commit();
                        long useTime2 = System.currentTimeMillis();
                        System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                     }
                  } catch (SQLException e) {
                     this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pidealfd321\r\n", url);
                     String content1 = this.geterrorprint(e);
                     this.writeErroFile("pidealfd321", content1, url);
                     e.printStackTrace();
                  }
               } else {
                  List<String> columnValues = (List)resultSet.get(key);
                  List<String> newcolumnValues = new ArrayList();

                  for(String s : columnValues) {
                     if (fieldSecretMap.containsKey(key)) {
                        if (s != null) {
                           String fieldSecretKey = (String)fieldSecretMap.get(key);
                           String encryptionType = (String)fieldtypeMap.get(key);
                           s = EncProvider.decryptEcb(encryptionType, fieldSecretKey, s, (String)isLikeMap.get(key), (String)keepFirstMap.get(key), (String)encDigitMap.get(key), (String)twoindexmap.get(key));
                           newcolumnValues.add(s);
                        } else {
                           Object var100 = null;
                        }
                     }
                  }

                  if (newcolumnValues.size() > 0) {
                     columnValues = newcolumnValues;
                  }

                  if (columnValues.size() > Integer.parseInt(hits)) {
                     teffe_sampling = hits;
                  } else {
                     teffe_sampling = String.valueOf(columnValues.size());
                  }

                  if (null != columnValues && columnValues.size() != 0) {
                     NumberFormat nf = NumberFormat.getInstance();
                     Number m = nf.parse(rate);
                     int patternIndex = 0;

                     for(Pattern pattern : patternList) {
                        matchstr.setLength(0);
                        unmatchstr.setLength(0);
                        if ("1".equals(isRate)) {
                           matchNum = Integer.parseInt(props.get("rateNum").toString());
                           unmatched = matchNum;
                        }

                        TcoreTaskFindrule searchRegex = (TcoreTaskFindrule)regexByContent.get(patternIndex++);
                        String dataareaid = searchRegex.getDataareaid();
                        String regexType = searchRegex.getDataarea();
                        String regexName = searchRegex.getRulename();
                        String disoverway = searchRegex.getDiscoverway();
                        String dictionaryClass = searchRegex.getDictionaryClass();
                        String matchingway = searchRegex.getMatchingwaSy();
                        String mixdataarea = searchRegex.getMixdataarea();
                        long matchCount = 0L;
                        List<String> tempMatchValues = new ArrayList();
                        List<String> matchValues = new ArrayList();
                        List<String> notMatchValues = new ArrayList();
                        List<String> invalidValues = new ArrayList();
                        new HashMap();
                        if (pattern.pattern().startsWith("MethodName:")) {
                           String methodName = pattern.pattern().substring(11);
                           int maxLength = -1;
                           int level = 0;
                           if (methodName.contains("MaxLength:")) {
                              if (methodName.contains("Weight:")) {
                                 String[] parameters = methodName.split("\\|MaxLength:");
                                 if (parameters.length == 2) {
                                    methodName = parameters[0];
                                    String[] Weight = parameters[1].split("\\|Weight:");
                                    maxLength = Integer.parseInt(Weight[0]);

                                    try {
                                       level = Integer.parseInt(Weight[1]);
                                    } catch (Exception var87) {
                                       level = 0;
                                    }
                                 }
                              } else {
                                 String[] parameters = methodName.split("\\|MaxLength:");
                                 if (parameters.length == 2) {
                                    methodName = parameters[0];
                                    maxLength = Integer.parseInt(parameters[1]);
                                 }
                              }
                           }

                           for(String val : columnValues) {
                              String vals = this.getquotecharacter(val, quotecharacter);
                              if (vals.trim().equals("")) {
                                 invalidValues.add(val);
                              } else if (!vals.equals("ghca_value_no_marcher") && this.matches(methodName, maxLength, vals, 0)) {
                                 ++matchCount;
                                 matchValues.add(val);
                                 tempMatchValues.add(regexType + ":" + val);
                                 if (matchNum > 0) {
                                    matchstr.append(val + "\r\n");
                                    --matchNum;
                                 }
                              } else {
                                 notMatchValues.add(val);
                                 if (unmatched > 0) {
                                    unmatchstr.append(val + "\r\n");
                                    --unmatched;
                                 }
                              }
                           }
                        } else if ("03".equals(disoverway)) {
                           List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryDictionaryFile(dictionaryClass);

                           for(String val : columnValues) {
                              if (this.dicmatch(list, matchingway, val)) {
                                 ++matchCount;
                                 matchValues.add(val);
                                 tempMatchValues.add(regexType + ":" + val);
                                 if (matchNum > 0) {
                                    matchstr.append(val + "\r\n");
                                    --matchNum;
                                 }
                              } else {
                                 notMatchValues.add(val);
                                 if (unmatched > 0) {
                                    unmatchstr.append(val + "\r\n");
                                    --unmatched;
                                 }
                              }
                           }
                        } else {
                           for(String val : columnValues) {
                              String vals = this.getquotecharacter(val, quotecharacter);
                              if (vals.trim().equals("")) {
                                 invalidValues.add(val);
                              } else if (!vals.equals("ghca_value_no_marcher") && pattern.matcher(vals).matches()) {
                                 ++matchCount;
                                 matchValues.add(val);
                                 tempMatchValues.add(regexType + ":" + val);
                                 if (matchNum > 0) {
                                    matchstr.append(val + "\r\n");
                                    --matchNum;
                                 }
                              } else {
                                 notMatchValues.add(val);
                                 if (unmatched > 0) {
                                    unmatchstr.append(val + "\r\n");
                                    --unmatched;
                                 }
                              }
                           }
                        }

                        for(String string : invalidValues) {
                           columnValues.remove(string);
                        }

                        if (matchstr.length() > 0) {
                           this.writeFileRefresh(key, matchstr.toString(), matchurl);
                        } else {
                           this.writeFileRefresh(key, "", matchurl);
                        }

                        if (unmatchstr.length() > 0) {
                           this.writeFileRefresh(key, unmatchstr.toString(), unmatchedurl);
                        } else {
                           this.writeFileRefresh(key, "", unmatchedurl);
                        }

                        NumberFormat numberFormat = NumberFormat.getInstance();
                        numberFormat.setMaximumFractionDigits(2);
                        String result = numberFormat.format((double)((float)matchCount / (float)columnValues.size() * 100.0F));
                        matching = result + "%";
                        if ((double)matchCount / (double)columnValues.size() >= m.doubleValue() / (double)100.0F) {
                           HashMap<String, List<String>> keyhash = new HashMap();
                           List<String> matchValuesList = new ArrayList();
                           List<String> notMatchValuesList = new ArrayList();
                           if (matchValues.size() > 100) {
                              matchValuesList.addAll(matchValues.subList(0, 100));
                           } else if (matchValues.size() != 0) {
                              matchValuesList.addAll(matchValues.subList(0, matchValues.size()));
                           }

                           if (notMatchValues.size() > 100) {
                              notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                           } else if (notMatchValues.size() != 0) {
                              notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                           }

                           keyhash.put("matchValues", matchValuesList);
                           keyhash.put("notMatchValues", notMatchValuesList);
                           dataarea_id = dataareaid;
                           dataarea_name = regexType;
                           if (disoverway == "02") {
                              dataarea_name = mixdataarea;
                           }

                           for(int x = 0; x < sensitiveRule.size(); ++x) {
                              if (dataareaid.equals(((Map)sensitiveRule.get(x)).get("dataarea_id"))) {
                                 sensitive_id = String.valueOf(((Map)sensitiveRule.get(x)).get("rule_id"));
                                 sensitive_name = (String)((Map)sensitiveRule.get(x)).get("name");
                              }
                           }

                           ++count;
                           break;
                        }

                        List<String> notMatchValuesList = new ArrayList();
                        if (notMatchValues.size() > 100) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                        } else if (notMatchValues.size() != 0) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                        }

                        HashMap<String, List<String>> keyhash = new HashMap();
                        keyhash.put("matchValues", matchValues);
                        keyhash.put("notMatchValues", notMatchValuesList);
                     }

                     try {
                        pstmt.setObject(1, datasystem_id);
                        pstmt.setObject(2, schema);
                        pstmt.setObject(3, table);
                        pstmt.setObject(4, key);
                        pstmt.setObject(5, "");
                        pstmt.setObject(6, hits);
                        pstmt.setObject(7, teffe_sampling);
                        pstmt.setObject(8, matching);
                        pstmt.setObject(9, dataarea_id);
                        pstmt.setObject(10, dataarea_name);
                        pstmt.setObject(11, sensitive_id);
                        pstmt.setObject(12, sensitive_name);
                        pstmt.setObject(13, issure);
                        pstmt.setObject(14, "");
                        pstmt.setObject(15, "");
                        pstmt.setObject(16, "");
                        pstmt.setObject(17, UUID.randomUUID().toString());
                        pstmt.addBatch();
                        ++cnt;
                        if (cnt % batcheSize == 0) {
                           long useTime1 = System.currentTimeMillis();
                           pstmt.executeBatch();
                           pstmt.clearBatch();
                           tconnection.commit();
                           long useTime2 = System.currentTimeMillis();
                           System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                        }
                     } catch (SQLException e) {
                        this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pidealfd\r\n", url);
                        String content1 = this.geterrorprint(e);
                        this.writeErroFile("pidealfd", content1, url);
                        e.printStackTrace();
                     }
                  }
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return count;
   }

   public Map<String, String> getAlldmpTableColumnsByContent(TCoreDatasystem datasystem, List<TCoreProjectFile> discoveryFile, String version, List<TcoreTaskFindrule> discoveryRule, TcoreDiscoveryTask discoveryTask, List<Map<String, Object>> sensitiveRule, String projectid, String userid) {
      Map<String, String> resultMap = new HashMap();
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = props.getProperty("monitorFile") + projectid + File.separator + discoveryTask.getId() + File.separator;
      String readOneTime = props.getProperty("readCntByOneTime");
      String num = "50000";
      this.vlist.remove("pool" + discoveryTask.getId());
      String task_table = discoveryTask.getResultid();
      new TcoreDiscoveryDataResult();
      TcoreDiscoveryResult tcoreDiscoveryResult = new TcoreDiscoveryResult();
      String dbType = datasystem.getDbtype();
      StringBuilder tcoreDiscoveryResult_sql = new StringBuilder();
      List<String> list_table = JdbcTool.sql_insert_q(tcoreDiscoveryResult);
      list_table.add("id");
      String sqlBase = JdbcTool.sql_insert_z(list_table, task_table);
      tcoreDiscoveryResult_sql.append(sqlBase);
      String selectDataType = discoveryTask.getCyfs();
      String hits = discoveryTask.getCys();
      String rate = discoveryTask.getPpl();
      List<TcoreTaskFindrule> regexByNamelist = new ArrayList();
      List<TcoreTaskFindrule> regexByContent = new ArrayList();

      for(int x = 0; x < discoveryRule.size(); ++x) {
         if ("1".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getFlag())) {
            regexByNamelist.add(new TcoreTaskFindrule(((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid(), ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea(), ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename(), ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex(), "", ((TcoreTaskFindrule)discoveryRule.get(x)).getRuleid()));
         } else {
            String discoveryway = "";
            String mixRule = "";
            String mixdataareaid = "";
            String mixdataarea = "";
            String mixrulename = "";
            if (!"undefined".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway()) && !" ".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway()) && ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway() != null && !"01".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
               if ("03".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
                  discoveryway = ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway();
                  List<TConsoleSearchregex> tConsoleSearchregexList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("name", ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename())});

                  for(int u = 0; u < tConsoleSearchregexList.size(); ++u) {
                     TcoreTaskFindrule tcoreTaskFindrule = new TcoreTaskFindrule();
                     tcoreTaskFindrule.setRegex(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getRegex());
                     tcoreTaskFindrule.setDataareaid(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDataarea_id());
                     tcoreTaskFindrule.setDataarea(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getType());
                     tcoreTaskFindrule.setRulename(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getName());
                     tcoreTaskFindrule.setDiscoverway(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDiscoverway());
                     tcoreTaskFindrule.setDictionaryClass(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDictionaryClass());
                     tcoreTaskFindrule.setMatchingwaSy(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getMatchingway());
                     regexByContent.add(tcoreTaskFindrule);
                  }
               } else if ("02".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
                  StringBuffer buf = new StringBuffer();
                  StringBuffer bufDataarea = new StringBuffer();
                  StringBuffer bufDataareaid = new StringBuffer();
                  StringBuffer bufRulename = new StringBuffer();
                  discoveryway = ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway();
                  List<TConsoleSearchregex> tConsoleSearchregexList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("name", ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename())});

                  for(int u = 0; u < tConsoleSearchregexList.size(); ++u) {
                     List<TCoreDataFileGroup> tCoreDataFileGroupList = this.tCoreDataFileGroupDao.queryAll(new Criterion[]{Restrictions.eq("searchregexid", ((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getId())});

                     for(int i = 0; i < tCoreDataFileGroupList.size(); ++i) {
                        List<TConsoleSearchregex> tConsoleSearchregexList1 = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("type", ((TCoreDataFileGroup)tCoreDataFileGroupList.get(i)).getDatafilename())});

                        for(int z = 0; z < tConsoleSearchregexList1.size(); ++z) {
                           if ("1".equals(((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getDefaulttype())) {
                              String a = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getRegex();
                              String b = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getType();
                              String c = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getDataarea_id();
                              String d = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getName();
                              buf.append("_#_" + a);
                              bufRulename.append("_#_" + d);
                              bufDataareaid.append("_#_" + c);
                              bufDataarea.append("_#_" + b);
                           }
                        }
                     }
                  }

                  buf.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex());
                  bufDataarea.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea());
                  bufDataareaid.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid());
                  bufRulename.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename());
                  mixRule = buf.toString();
                  mixdataareaid = bufDataareaid.toString();
                  mixdataarea = bufDataarea.toString();
                  mixrulename = bufRulename.toString();
                  String[] regexlist = mixRule.split("_#_");

                  for(int i = 0; i < regexlist.length; ++i) {
                     TcoreTaskFindrule tcoreTaskFindrule = new TcoreTaskFindrule();
                     tcoreTaskFindrule.setRegex(mixRule.split("_#_")[i]);
                     tcoreTaskFindrule.setDataareaid(mixdataareaid.split("_#_")[i]);
                     tcoreTaskFindrule.setDataarea(mixdataarea.split("_#_")[i]);
                     tcoreTaskFindrule.setDataarea(mixrulename.split("_#_")[i]);
                     regexByContent.add(tcoreTaskFindrule);
                  }
               }
            } else {
               discoveryway = " ";
               mixRule = ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex();
               mixdataareaid = ((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid();
               mixdataarea = ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea();
               mixrulename = ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename();
               regexByContent.add(new TcoreTaskFindrule(mixdataareaid, mixdataarea, mixrulename, mixRule, discoveryway, ((TcoreTaskFindrule)discoveryRule.get(x)).getRuleid()));
            }
         }
      }

      boolean isSelectData = this.isSelectData(hits, discoveryRule.size());
      boolean isVersion = version != null && !"0".equals(version);
      long schemaIndex = 1L;
      int sureTable = 0;
      int sureColumn = 0;
      int columnSum = 0;
      int tableSum = 0;
      List<String> dmpfiledirlist = new ArrayList();
      List<String> allTableList = new ArrayList();
      new ArrayList();
      TCoreProjectFile tCoreProjectFile = (TCoreProjectFile)discoveryFile.get(0);
      String dmpFilePath = tCoreProjectFile.getFileurl();
      String dmpFileNames = tCoreProjectFile.getFilename();
      String[] fileNameArr = dmpFileNames.split(",");
      String dmptables = tCoreProjectFile.getDmptables();
      String[] tableArr = dmptables.split(",");
      String filePathName = "";

      for(int i = 0; i < fileNameArr.length; ++i) {
         filePathName = filePathName + dmpFilePath + File.separator + fileNameArr[i];
         if (i != fileNameArr.length - 1) {
            filePathName = filePathName + "[+]";
         }
      }

      List<String> schemas = new ArrayList();

      for(int i = 0; i < tableArr.length; ++i) {
         schemas.add(filePathName + "~" + tableArr[i]);
      }

      int tableCount = tableArr.length;
      boolean result = false;
      this.redisService.set(discoveryTask.getId() + "tableCount", tableCount);
      this.redisService.remove("taskstatus_" + discoveryTask.getId());
      new HashMap();
      List<String> schemaslist = new ArrayList();
      HashMap<String, TCoreProjectVersionVO> version_map = new HashMap();
      if (isVersion) {
         version_map = this.queryProjectVersion(projectid, discoveryTask.getId(), version, userid);
      }

      List<Pattern> patternNameList = new ArrayList();
      List<Pattern> patternContentList = new ArrayList();

      for(TcoreTaskFindrule searchRegex : regexByNamelist) {
         patternNameList.add(Pattern.compile(searchRegex.getRegex()));
      }

      for(TcoreTaskFindrule searchRegex : regexByContent) {
         patternContentList.add(Pattern.compile(searchRegex.getRegex()));
      }

      String multiDempFile = ((TCoreProjectFile)discoveryFile.get(0)).getDmpfiletype();
      String dmptype = ((TCoreProjectFile)discoveryFile.get(0)).getDmptype();
      HashMap<String, List<String>> hash = new HashMap();
      String fileSuffix = "";
      List<String> floatdic = this.tConsoleDictionaryDao.queryValueByTypeCode("19");
      if ("0".equals(multiDempFile)) {
         for(String schema : schemas) {
            List<String> table = new ArrayList();
            String[] s = schema.split("~");
            String a = s[0].substring(0, s[0].lastIndexOf("."));
            fileSuffix = s[0].substring(s[0].lastIndexOf("."));
            String b = s[1];
            if (hash.get(a) == null) {
               table.add(b);
               hash.put(a, table);
               schemaslist.add(a);
            } else {
               table = (List)hash.get(a);
               table.add(b);
               hash.put(a, table);
            }
         }
      } else {
         for(String schema : schemas) {
            List<String> tableNameList = new ArrayList();
            String[] schemaArr = schema.split("~");
            String[] filelistdir = schemaArr[0].split("\\[\\+\\]");
            String dmpKey = "";
            dmpfiledirlist = new ArrayList();

            for(String filedir : filelistdir) {
               dmpKey = filedir.substring(0, filedir.lastIndexOf("."));
               fileSuffix = filedir.substring(filedir.lastIndexOf("."));
               dmpfiledirlist.add(dmpKey + fileSuffix);
            }

            if (!hash.containsKey(dmpKey)) {
               tableNameList.add(schemaArr[1]);
               hash.put(dmpKey, tableNameList);
               schemaslist.add(dmpKey);
            } else {
               tableNameList = (List)hash.get(dmpKey);
               tableNameList.add(schemaArr[1]);
               hash.put(dmpKey, tableNameList);
            }
         }
      }

      for(String schema : schemaslist) {
         String tableInfo = null;
         new ArrayList();
         List<String> var165 = (List)hash.get(schema);
         allTableList.addAll(var165);
         long tableIndex = 1L;
         List<TCoreCurrencyInfo> tableInfoL = this.tCoreCurrencyInfoDao.getCurrencyInfoTable(datasystem.getSysname(), schema);
         if (tableInfoL.size() > 0) {
            tableInfo = ((TCoreCurrencyInfo)tableInfoL.get(0)).getCurrencytable();
         }

         List<String> var133 = this.tConsoleDictionaryDao.queryValueByTypeCode("18");
         Map<String, List<List<Object>>> noaifindValuesMapList = null;
         Map<String, List<ColumnInfoVO>> columnameVoMapList = null;
         Map<String, Object> tableInfoMap = null;
         if ("0".equals(dmptype)) {
            if ("1".equals(multiDempFile)) {
               String redisTaskKey = "";

               for(int i = 0; i < dmpfiledirlist.size(); ++i) {
                  if (i > 0) {
                     redisTaskKey = redisTaskKey + ",";
                  }

                  redisTaskKey = redisTaskKey + (String)dmpfiledirlist.get(i);
               }

               tableInfoMap = (Map)this.redisService.get(redisTaskKey + "multiDmpdp_tableInfoMap");
               List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
               columnameVoMapList = new HashMap();

               for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                  TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                  columnameVoMapList.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
               }

               noaifindValuesMapList = MultipleDmpDpTool.prasingDataByTableNameByRowNum(dmpfiledirlist, tableInfoMap, var165, Long.parseLong(hits));
            } else {
               tableInfoMap = (Map)this.redisService.get(schema + fileSuffix + "Dmpdp_tableInfoMap");
               List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
               columnameVoMapList = new HashMap();

               for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                  TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                  columnameVoMapList.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
               }

               noaifindValuesMapList = DmpDpTool.prasingDataByTableNameByRowNum(schema + fileSuffix, tableInfoMap, var165, Long.parseLong(hits));
            }
         } else if ("1".equals(multiDempFile)) {
            String redisTaskKey = "";

            for(int i = 0; i < dmpfiledirlist.size(); ++i) {
               if (i > 0) {
                  redisTaskKey = redisTaskKey + ",";
               }

               redisTaskKey = redisTaskKey + (String)dmpfiledirlist.get(i);
            }

            tableInfoMap = (Map)this.redisService.get(redisTaskKey + "multiDmp_tableInfoMap");
            List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
            columnameVoMapList = new HashMap();

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
               columnameVoMapList.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
            }

            noaifindValuesMapList = MultipleDmpTool.prasingDataByTableNameByRowNum(dmpfiledirlist, tableInfoMap, var165, Long.parseLong(hits));
         } else {
            tableInfoMap = (Map)this.redisService.get(schema + fileSuffix + "Dmp_tableInfoMap");
            List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
            columnameVoMapList = new HashMap();

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
               columnameVoMapList.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
            }

            noaifindValuesMapList = DmpTool.prasingDataByTableNameByRowNum(schema + fileSuffix, tableInfoMap, var165, Long.parseLong(hits));
         }

         this.getQuerySql(selectDataType, dbType, schema, Long.parseLong(hits), "");
         String tabletemp = "";

         for(String tableName : var165) {
            System.out.println("表名----》" + tableName);
            new ArrayList();
            new HashMap();
            List<ColumnInfoVO> columnameVolist;
            if ("0".equals(dmptype)) {
               if ("0".equals(multiDempFile)) {
                  columnameVolist = (List)columnameVoMapList.get(tableName);
               } else {
                  columnameVolist = (List)columnameVoMapList.get(tableName);
               }
            } else if ("0".equals(multiDempFile)) {
               columnameVolist = (List)columnameVoMapList.get(tableName);
            } else {
               columnameVolist = (List)columnameVoMapList.get(tableName);
            }

            if (columnameVolist.size() == 0) {
               this.writeFile("errormanage", "找不到表,比较严重," + formatter.format(new Date()) + ",findtablefiled_dmp\r\n", url);
               String content = "错误信息:" + schema + "下的" + tableName + "表无法找到";
               this.writeErroFile("findtablefiled_dmp", content, url);
               resultMap.put("error", "true");
            } else {
               List<List<Object>> noaifindValueslist = null;
               if ("0".equals(dmptype)) {
                  if ("0".equals(multiDempFile)) {
                     noaifindValueslist = (List)noaifindValuesMapList.get(tableName);
                  } else {
                     noaifindValueslist = (List)noaifindValuesMapList.get(tableName);
                  }
               } else if ("0".equals(multiDempFile)) {
                  noaifindValueslist = (List)noaifindValuesMapList.get(tableName);
               } else {
                  noaifindValueslist = (List)noaifindValuesMapList.get(tableName);
               }

               columnSum += columnameVolist.size();
               schema = schema.substring(schema.lastIndexOf("/") + 1);
               if (this.vlist.size() != 0 && this.vlist.contains("pool" + discoveryTask.getId())) {
                  break;
               }

               if (columnameVolist.size() > 0) {
                  if (isVersion) {
                     if (!isSelectData) {
                        String dataarea_id = "";
                        String dataarea_name = "";
                        String issure = "0";
                        String tschemas = schema;
                        String sensitive_id = "";
                        String sensitive_name = "";
                        String datasystem_id = datasystem.getId();
                        String sampling = hits;
                        String teffe_sampling = "0";
                        String fields = "";
                        String fieldremark = "";
                        String matching = "0%";
                        String table = tableName;

                        for(ColumnInfo columnInfo : columnameVolist) {
                           String keyid = schema + tableName + columnInfo.getColumnname();
                           if (version_map.get(keyid) != null) {
                              dataarea_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaId();
                              dataarea_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaName();
                              issure = "1";
                              sensitive_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getSensitiveId();
                              sensitive_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getSchemaName();
                              if (sensitive_name.equals("白名单")) {
                                 issure = "2";
                                 sensitive_name = "";
                              } else if (sensitive_name.equals("黑名单")) {
                                 issure = "3";
                                 sensitive_name = "";
                              }

                              fields = columnInfo.getColumnname();
                              fieldremark = columnInfo.getRemarks();

                              try {
                                 tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", dataarea_id, dataarea_name, issure, tschemas, sensitive_id, sensitive_name, datasystem_id, sampling, teffe_sampling, fields, fieldremark, matching, table, list_table));
                              } catch (IllegalAccessException e) {
                                 e.printStackTrace();
                                 this.writeFile("errormanage", "安全权限异常,非常严重," + formatter.format(new Date()) + ",safesensitive_dmp\r\n", url);
                                 String content1 = this.geterrorprint(e);
                                 this.writeErroFile("safesensitive_dmp", content1, url);
                                 resultMap.put("error", "true");
                              } catch (IllegalArgumentException e) {
                                 e.printStackTrace();
                                 this.writeFile("errormanage", "参数错误异常,非常严重," + formatter.format(new Date()) + ",safecanshu_dmp\r\n", url);
                                 String content1 = this.geterrorprint(e);
                                 this.writeErroFile("safecanshu_dmp", content1, url);
                                 resultMap.put("error", "true");
                              } catch (InvocationTargetException e) {
                                 e.printStackTrace();
                                 this.writeFile("errormanage", "反射异常,非常严重," + formatter.format(new Date()) + ",safefanse_dmp\r\n", url);
                                 String content1 = this.geterrorprint(e);
                                 this.writeErroFile("safefanse_dmp", content1, url);
                                 resultMap.put("error", "true");
                              }

                              ++sureColumn;
                              if (!tabletemp.equals(table)) {
                                 ++sureTable;
                              }

                              tabletemp = table;
                           } else {
                              try {
                                 tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", dataarea_id, dataarea_name, issure, tschemas, sensitive_id, sensitive_name, datasystem_id, sampling, teffe_sampling, columnInfo.getColumnname(), columnInfo.getRemarks(), matching, table, list_table));
                              } catch (IllegalAccessException e) {
                                 e.printStackTrace();
                                 this.writeFile("errormanage", "安全权限异常,非常严重," + formatter.format(new Date()) + ",banbensafesensitive_dmp\r\n", url);
                                 String content1 = this.geterrorprint(e);
                                 this.writeErroFile("banbensafesensitive_dmp", content1, url);
                                 resultMap.put("error", "true");
                              } catch (IllegalArgumentException e) {
                                 e.printStackTrace();
                                 this.writeFile("errormanage", "参数错误异常,非常严重," + formatter.format(new Date()) + ",banbensafecanshu_dmp\r\n", url);
                                 String content1 = this.geterrorprint(e);
                                 this.writeErroFile("banbensafecanshu_dmp", content1, url);
                                 resultMap.put("error", "true");
                              } catch (InvocationTargetException e) {
                                 e.printStackTrace();
                                 this.writeFile("errormanage", "反射异常,非常严重," + formatter.format(new Date()) + ",banbensafefanse_dmp\r\n", url);
                                 String content1 = this.geterrorprint(e);
                                 this.writeErroFile("banbensafefanse_dmp", content1, url);
                                 resultMap.put("error", "true");
                              }

                              ++sureColumn;
                              if (!tabletemp.equals(table)) {
                                 ++sureTable;
                              }

                              tabletemp = table;
                           }
                        }
                     } else {
                        int i = 0;

                        for(ColumnInfoVO columnInfo : columnameVolist) {
                           new StringBuffer();
                           String keyid = schema + tableName + columnInfo.getColumnname();
                           if (version_map.get(keyid) != null) {
                              String dataarea_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaId();
                              String dataarea_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getDataareaName();
                              String issure = "0";
                              String tschemas = schema;
                              String sensitive_id = ((TCoreProjectVersionVO)version_map.get(keyid)).getSensitiveId();
                              String sensitive_name = ((TCoreProjectVersionVO)version_map.get(keyid)).getSensitiveName();
                              if (sensitive_name.equals("白名单")) {
                                 issure = "2";
                                 sensitive_name = "";
                              } else if (sensitive_name.equals("黑名单")) {
                                 issure = "3";
                                 sensitive_name = "";
                              }

                              String datasystem_id = datasystem.getId();
                              String sampling = hits;
                              String teffe_sampling = "0";
                              String fields = columnInfo.getColumnname();
                              String fieldremark = columnInfo.getRemarks();
                              String matching = "0%";
                              String table = tableName;

                              try {
                                 tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", dataarea_id, dataarea_name, issure, tschemas, sensitive_id, sensitive_name, datasystem_id, sampling, teffe_sampling, fields, fieldremark, matching, table, list_table));
                              } catch (IllegalAccessException e) {
                                 e.printStackTrace();
                                 this.writeFile("errormanage", "安全权限异常,非常严重," + formatter.format(new Date()) + ",guizebanbensafesensitive_dmp\r\n", url);
                                 String content1 = this.geterrorprint(e);
                                 this.writeErroFile("guizebanbensafesensitive_dmp", content1, url);
                                 resultMap.put("error", "true");
                              } catch (IllegalArgumentException e) {
                                 e.printStackTrace();
                                 this.writeFile("errormanage", "参数错误异常,非常严重," + formatter.format(new Date()) + ",guizebanbensafecanshu_dmp\r\n", url);
                                 String content1 = this.geterrorprint(e);
                                 this.writeErroFile("guizebanbensafecanshu_dmp", content1, url);
                                 resultMap.put("error", "true");
                              } catch (InvocationTargetException e) {
                                 e.printStackTrace();
                                 this.writeFile("errormanage", "反射异常,非常严重," + formatter.format(new Date()) + ",guizebanbensafefanse_dmp\r\n", url);
                                 String content1 = this.geterrorprint(e);
                                 this.writeErroFile("guizebanbensafefanse_dmp", content1, url);
                                 resultMap.put("error", "true");
                              }

                              ++sureColumn;
                              if (!tabletemp.equals(tableName)) {
                                 ++sureTable;
                              }

                              tabletemp = tableName;
                           } else if (regexByContent.size() > 0 && noaifindValueslist != null) {
                              int columncount = this.getSensitivedmpColumnsByContent(datasystem.getId(), datasystem.getSysname(), schema, columnInfo, i, noaifindValueslist, tableName, rate, hits, regexByContent, patternContentList, tcoreDiscoveryResult_sql, list_table, sensitiveRule, projectid, discoveryTask.getId(), (List)null, (List)null);
                              sureColumn += columncount;
                              if (columncount > 0 && !tabletemp.equals(tableName)) {
                                 ++sureTable;
                                 tabletemp = tableName;
                              }
                           }

                           ++i;
                        }
                     }
                  } else {
                     int i = 0;

                     for(ColumnInfoVO columnInfo : columnameVolist) {
                        if (!isSelectData) {
                           String dataarea_id = "";
                           String dataarea_name = "";
                           String issure = "0";
                           String tschemas = schema;
                           String sensitive_id = "";
                           String sensitive_name = "";
                           String datasystem_id = datasystem.getId();
                           String sampling = hits;
                           String teffe_sampling = "0";
                           String fields = columnInfo.getColumnname();
                           String fieldremark = columnInfo.getRemarks();
                           String matching = "0%";
                           String table = tableName;

                           try {
                              tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", dataarea_id, dataarea_name, issure, tschemas, sensitive_id, sensitive_name, datasystem_id, sampling, teffe_sampling, fields, fieldremark, matching, table, list_table));
                           } catch (IllegalAccessException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "安全权限异常,非常严重," + formatter.format(new Date()) + ",unbanbensafesensitive_dmp\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("unbanbensafesensitive_dmp", content1, url);
                              resultMap.put("error", "true");
                           } catch (IllegalArgumentException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "参数错误异常,非常严重," + formatter.format(new Date()) + ",unbanbensafecanshu_dmp\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("unbanbensafecanshu_dmp", content1, url);
                              resultMap.put("error", "true");
                           } catch (InvocationTargetException e) {
                              e.printStackTrace();
                              this.writeFile("errormanage", "反射异常,非常严重," + formatter.format(new Date()) + ",unbanbensafefanse_dmp\r\n", url);
                              String content1 = this.geterrorprint(e);
                              this.writeErroFile("unbanbensafefanse_dmp", content1, url);
                              resultMap.put("error", "true");
                           }

                           ++sureColumn;
                           if (!tabletemp.equals(tableName)) {
                              ++sureTable;
                           }

                           tabletemp = tableName;
                        } else if (regexByContent.size() > 0 && noaifindValueslist != null) {
                           int columncount = this.getSensitivedmpColumnsByContent(datasystem.getId(), datasystem.getSysname(), schema, columnInfo, i, noaifindValueslist, tableName, rate, hits, regexByContent, patternContentList, tcoreDiscoveryResult_sql, list_table, sensitiveRule, projectid, discoveryTask.getId(), (List)null, (List)null);
                           sureColumn += columncount;
                           if (columncount > 0 && !tabletemp.equals(tableName)) {
                              ++sureTable;
                              tabletemp = tableName;
                           }
                        }

                        ++i;
                     }
                  }
               }

               ++tableIndex;
               ++tableSum;
               this.writeFile("done", tableName + "," + schema + "," + formatter.format(new Date()) + "\r\n", url);
               this.redisService.set(discoveryTask.getId() + "tableSum", tableSum);
            }
         }

         ++schemaIndex;
      }

      HashMap<String, TCoreProjectVersionVO> var148 = null;
      if (this.vlist.size() != 0 && this.vlist.contains("pool" + discoveryTask.getId())) {
         resultMap.put("isstop", "true");
      } else {
         StringBuilder sql = tcoreDiscoveryResult_sql.deleteCharAt(tcoreDiscoveryResult_sql.length() - 1);
         resultMap.put("sureTable", String.valueOf(sureTable));
         resultMap.put("sureColumn", String.valueOf(sureColumn));
         resultMap.put("columnSum", String.valueOf(columnSum));
         resultMap.put("tableCount", String.valueOf(tableCount));

         try {
            this.tcoreDiscoveryResultsRecordDao.saveDiscoveryResults(sql);
            this.saveResultSql(sql, discoveryTask.getResultid());
         } catch (Exception e) {
            e.printStackTrace();
            this.writeFile("errormanage", "插入结果表失败,非常严重," + formatter.format(new Date()) + ",inserttablefail_dmp\r\n", url);
            String content1 = this.geterrorprint(e);
            this.writeErroFile("inserttablefail_dmp", content1, url);
            resultMap.put("error", "true");
         }
      }

      return resultMap;
   }

   public int getSensitivedmpColumnsByContent(String datasourceid, String datasourcename, String schema, ColumnInfoVO columnInfo, int i, List<List<Object>> ObjectValueslist, String tableName, String rate, String hits, List<TcoreTaskFindrule> searchRegexList, List<Pattern> patternList, StringBuilder tcoreDiscoveryResult_sql, List<String> list_table, List<Map<String, Object>> sensitiveRule, String projectid, String taskid, List<String> currdic, List<String> floatdic) {
      int count = 0;
      List<SensitiveColumn> sensitiveColumns = new ArrayList();
      new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (Exception var102) {
      }

      String url = props.getProperty("rateDir");
      String matchurl = url + "match" + File.separator + projectid + File.separator + taskid + File.separator + tableName + File.separator;
      String unmatchedurl = url + "unmatched" + File.separator + projectid + File.separator + taskid + File.separator + tableName + File.separator;
      boolean ischarsetflag = false;
      String ischarset_s = "";
      String ischarset_t = "";
      if (datasourceid != null) {
         TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasourceid);
         if (tCoreDatasystem != null) {
            String ischarset = tCoreDatasystem.getIscharset();
            if (ischarset != null && !"".equals(ischarset) && ischarset.split(",").length == 2) {
               ischarsetflag = true;
               ischarset_s = ischarset.split(",")[0];
               ischarset_t = ischarset.split(",")[1];
            }
         }
      }

      String isrepeatvalue = props.get("isrepeatvalue").toString();
      String isRate = props.get("isRate").toString();
      int matchNum = 0;
      int unmatched = 0;
      StringBuffer matchstr = new StringBuffer();
      StringBuffer unmatchstr = new StringBuffer();
      if ("1".equals(isRate)) {
         matchNum = Integer.parseInt(props.get("rateNum").toString());
         unmatched = matchNum;
      }

      try {
         try {
            Map<Integer, List<String>> columnValueMap = new HashMap();
            Map<Integer, Set<String>> columnDistinctValueMap = new HashMap();
            long rowCount = 0L;
            long nullOrEmptyCount = 0L;
            int matchCurrencyCount = 0;
            boolean isMatchCurrency = false;

            for(int z = 0; z < ObjectValueslist.size(); ++z) {
               if (rowCount == 0L) {
                  columnValueMap.put(i, new ArrayList());
                  columnDistinctValueMap.put(i, new HashSet());
               }

               Object columnValueObj = null;

               try {
                  columnValueObj = ((List)ObjectValueslist.get(z)).get(i);
                  if (!columnInfo.getDecimaldigits().equals("") && !columnInfo.getDecimaldigits().equals("0")) {
                     String fmt = "";

                     for(int j = 0; j < Integer.parseInt(columnInfo.getDecimaldigits()); ++j) {
                        fmt = fmt + "0";
                     }

                     DecimalFormat df = new DecimalFormat("0." + fmt);
                     columnValueObj = df.format(columnValueObj);
                  }
               } catch (Exception var103) {
                  columnValueObj = null;
               }

               if (columnValueObj != null) {
                  String columnValue = columnValueObj.toString();
                  if (columnValueObj instanceof byte[]) {
                     columnValue = "";
                  }

                  if (ischarsetflag) {
                     columnValue = new String(columnValue.getBytes(ischarset_s), ischarset_t);
                     System.out.println(columnValue);
                  }

                  if (!"".equals(columnValue.trim())) {
                     ((List)columnValueMap.get(i)).add(columnValue);
                     ((Set)columnDistinctValueMap.get(i)).add(columnValue);
                  } else {
                     ++nullOrEmptyCount;
                  }
               } else {
                  ++nullOrEmptyCount;
               }

               ++rowCount;
            }

            if (rowCount == 0L) {
               String columnname = columnInfo.getColumnname();
               sensitiveColumns.add(new SensitiveColumn(datasourceid, datasourcename, schema.substring(schema.lastIndexOf("/") + 1), tableName, columnname, rowCount, 0L, 0L));
               byte var112 = 0;
               return var112;
            }

            String columnname = columnInfo.getColumnname();
            long validCount = rowCount - nullOrEmptyCount;
            double distinctCount = (double)((Set)columnDistinctValueMap.get(i)).size();
            SensitiveColumn column = new SensitiveColumn(datasourceid, datasourcename, schema.substring(schema.lastIndexOf("/") + 1), tableName, columnname, rowCount, validCount, (long)distinctCount);
            sensitiveColumns.add(column);
            List<String> columnValues = (List)columnValueMap.get(i);
            if (null == columnValues || columnValues.size() == 0) {
               byte var116 = 0;
               return var116;
            }

            long maxMatchCount = 0L;
            List<String> maxMatchValues = null;
            List<String> maxNotMathValues = null;
            String dataarea_id = "";
            String dataarea_name = "";
            String issure = "0";
            String tschemas = column.getSchema();
            String fields = column.getColumnName();
            String matching = rate;
            String sensitive_id = "";
            String sensitive_name = "";
            String teffe_sampling = "";
            NumberFormat nf = NumberFormat.getPercentInstance();
            Number m = nf.parse(rate);
            int patternIndex = 0;

            for(Pattern pattern : patternList) {
               matchstr.setLength(0);
               unmatchstr.setLength(0);
               if ("1".equals(isRate)) {
                  matchNum = Integer.parseInt(props.get("rateNum").toString());
                  unmatched = matchNum;
               }

               TcoreTaskFindrule searchRegex = (TcoreTaskFindrule)searchRegexList.get(patternIndex++);
               String dataareaid = searchRegex.getDataareaid();
               String regexType = searchRegex.getDataarea();
               String regexName = searchRegex.getRulename();
               String disoverway = searchRegex.getDiscoverway();
               String dictionaryClass = searchRegex.getDictionaryClass();
               String matchingway = searchRegex.getMatchingwaSy();
               int level = 0;
               long matchCount = 0L;
               long nomatchCount = 0L;
               List<String> tempMatchValues = new ArrayList();
               List<String> matchValues = new ArrayList();
               List<String> notMatchValues = new ArrayList();
               Map<String, Integer> namerepeatmap = new HashMap();
               if (pattern.pattern().startsWith("MethodName:")) {
                  String methodName = pattern.pattern().substring(11);
                  int maxLength = -1;
                  if (methodName.contains("MaxLength:")) {
                     if (methodName.contains("Weight:")) {
                        String[] parameters = methodName.split("\\|MaxLength:");
                        if (parameters.length == 2) {
                           methodName = parameters[0];
                           String[] Weight = parameters[1].split("\\|Weight:");
                           maxLength = Integer.parseInt(Weight[0]);

                           try {
                              level = Integer.parseInt(Weight[1]);
                           } catch (Exception var101) {
                              level = 0;
                           }
                        }
                     } else {
                        String[] parameters = methodName.split("\\|MaxLength:");
                        if (parameters.length == 2) {
                           methodName = parameters[0];
                           maxLength = Integer.parseInt(parameters[1]);
                        }
                     }
                  }

                  if (methodName.contains("isCurrency")) {
                     for(String val : columnValues) {
                        if (this.FloatCol(val)) {
                           ++matchCount;
                           matchValues.add(val);
                           tempMatchValues.add(regexType + ":" + val);
                        } else {
                           ++nomatchCount;
                           notMatchValues.add(val);
                        }

                        if (this.isCurrency(val, currdic)) {
                           ++matchCurrencyCount;
                        }
                     }
                  } else {
                     for(String val : columnValues) {
                        if (this.matches(methodName, maxLength, val, level)) {
                           ++matchCount;
                           matchValues.add(val);
                           if ("姓名".equals(regexType)) {
                              Integer integer = (Integer)namerepeatmap.get(val);
                              namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                           }

                           tempMatchValues.add(regexType + ":" + val);
                           if (matchNum > 0) {
                              matchstr.append(val + "\r\n");
                              --matchNum;
                           }
                        } else {
                           ++nomatchCount;
                           notMatchValues.add(val);
                           if (unmatched > 0) {
                              unmatchstr.append(val + "\r\n");
                              --unmatched;
                           }
                        }
                     }
                  }
               } else if ("03".equals(disoverway)) {
                  List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryDictionaryFile(dictionaryClass);

                  for(String val : columnValues) {
                     if (this.dicmatch(list, matchingway, val)) {
                        ++matchCount;
                        matchValues.add(val);
                        if ("姓名".equals(regexType)) {
                           Integer integer = (Integer)namerepeatmap.get(val);
                           namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                        }

                        tempMatchValues.add(regexType + ":" + val);
                        if (matchNum > 0) {
                           matchstr.append(val + "\r\n");
                           --matchNum;
                        }
                     } else {
                        ++nomatchCount;
                        notMatchValues.add(val);
                        if (unmatched > 0) {
                           unmatchstr.append(val + "\r\n");
                           --unmatched;
                        }
                     }
                  }
               } else {
                  for(String val : columnValues) {
                     if (pattern.matcher(val).matches()) {
                        ++matchCount;
                        matchValues.add(val);
                        if ("姓名".equals(regexType)) {
                           Integer integer = (Integer)namerepeatmap.get(val);
                           namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                        }

                        tempMatchValues.add(regexType + ":" + val);
                        if (matchNum > 0) {
                           matchstr.append(val + "\r\n");
                           --matchNum;
                        }
                     } else {
                        ++nomatchCount;
                        notMatchValues.add(val);
                        if (unmatched > 0) {
                           unmatchstr.append(val + "\r\n");
                           --unmatched;
                        }
                     }
                  }
               }

               this.writeFileRefresh(columnname, matchstr.toString(), matchurl);
               this.writeFileRefresh(columnname, unmatchstr.toString(), unmatchedurl);
               boolean isrepeatdata = true;
               if ("姓名".equals(regexType)) {
                  Integer matchValuessize = (int)((double)matchValues.size() * Double.parseDouble(isrepeatvalue));

                  for(Map.Entry<String, Integer> entry : namerepeatmap.entrySet()) {
                     if ((Integer)entry.getValue() > matchValuessize) {
                        isrepeatdata = false;
                        break;
                     }
                  }
               }

               if (columnValues.size() > Integer.parseInt(hits)) {
                  teffe_sampling = hits;
               } else {
                  teffe_sampling = String.valueOf(columnValues.size());
               }

               NumberFormat numberFormat = NumberFormat.getInstance();
               numberFormat.setMaximumFractionDigits(2);
               String result = numberFormat.format((double)((float)matchCount / (float)columnValues.size() * 100.0F));
               matching = result + "%";
               if (matchCurrencyCount - columnValues.size() == 0) {
                  isMatchCurrency = true;
                  matchCurrencyCount = 0;
               }

               if ((double)matchCount / (double)columnValues.size() >= m.doubleValue()) {
                  if (isrepeatdata) {
                     column.setMatchResult(regexType, regexName, (long)matchValues.size(), matchValues, notMatchValues);
                  }

                  String key = schema.substring(schema.lastIndexOf("/") + 1) + "_m" + tableName + "_m" + columnname;
                  HashMap<String, List<String>> keyhash = new HashMap();
                  List<String> matchValuesList = new ArrayList();
                  List<String> notMatchValuesList = new ArrayList();
                  if (matchValues.size() > 100) {
                     matchValuesList.addAll(matchValues.subList(0, 100));
                  } else if (matchValues.size() != 0) {
                     matchValuesList.addAll(matchValues.subList(0, matchValues.size()));
                  }

                  if (notMatchValues.size() > 100) {
                     notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                  } else if (notMatchValues.size() != 0) {
                     notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                  }

                  keyhash.put("matchValues", matchValuesList);
                  keyhash.put("notMatchValues", notMatchValuesList);
                  this.redisService.set(key, keyhash);
                  dataarea_id = dataareaid;
                  dataarea_name = regexType;

                  for(int x = 0; x < sensitiveRule.size(); ++x) {
                     if (dataareaid.equals(((Map)sensitiveRule.get(x)).get("dataarea_id"))) {
                        sensitive_id = (String)((Map)sensitiveRule.get(x)).get("rule_id");
                        sensitive_name = (String)((Map)sensitiveRule.get(x)).get("name");
                     }
                  }

                  ++count;
                  maxMatchCount = matchCount;
                  maxMatchValues = tempMatchValues;
                  maxNotMathValues = notMatchValues;
                  break;
               }

               if (maxMatchCount < matchCount) {
                  maxMatchCount = matchCount;
                  maxMatchValues = tempMatchValues;
                  maxNotMathValues = notMatchValues;
               }
            }

            if (!column.isSensitiveColumn()) {
               if (maxMatchCount > 0L) {
                  column.setMatchCount(maxMatchCount);
                  column.setMatchValues(maxMatchValues);
                  column.setNotMatchValues(maxNotMathValues);
               } else {
                  column.setNotMatchValues(columnValues);
               }
            }

            tcoreDiscoveryResult_sql.append(this.create_tcoreDiscoveryResult_sql("", dataarea_id, dataarea_name, issure, tschemas, sensitive_id, sensitive_name, datasourceid, hits, teffe_sampling, fields, columnInfo.getRemarks(), matching, tableName, list_table));
            if (!isMatchCurrency) {
               for(int j = 0; j < sensitiveColumns.size(); ++j) {
                  if ("价格".equals(((SensitiveColumn)sensitiveColumns.get(j)).getRegexName())) {
                     ((SensitiveColumn)sensitiveColumns.get(j)).setRegexName((String)null);
                     ((SensitiveColumn)sensitiveColumns.get(j)).setRegexType((String)null);
                     ((SensitiveColumn)sensitiveColumns.get(j)).setMatchCount(0L);
                     ((SensitiveColumn)sensitiveColumns.get(j)).setMatchValues((List)null);
                     ((SensitiveColumn)sensitiveColumns.get(j)).setNotMatchValues((List)null);
                  }
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         return count;
      } finally {
         ;
      }
   }

   private String getquotecharacter(String value, String quotecharacter) {
      if (quotecharacter != null) {
         switch (quotecharacter) {
            case "single":
               if (value.startsWith("'") && value.startsWith("'", value.length() - 1)) {
                  if (value.length() > 1) {
                     value = value.substring(1, value.length() - 1);
                  }
               } else {
                  value = "ghca_value_no_marcher";
               }
               break;
            case "double":
               if (value.startsWith("\"") && value.startsWith("\"", value.length() - 1)) {
                  if (value.length() > 1) {
                     value = value.substring(1, value.length() - 1);
                  }
               } else {
                  value = "ghca_value_no_marcher";
               }
               break;
            default:
               if (value.startsWith("'") && value.startsWith("'", value.length() - 1) || value.startsWith("\"") && value.startsWith("\"", value.length() - 1)) {
                  value = "ghca_value_no_marcher";
               }
         }
      }

      return value;
   }

   public HashMap<String, TCoreProjectVersionVO> queryProjectVersion(String projectid, String taskid, String version, String userid) {
      HashMap<String, TCoreProjectVersionVO> list = new HashMap();
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String filepath = "";
      File file = null;
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = props.getProperty("monitorFile");
      if ("all_version".equals(version)) {
         file = new File(props.getProperty("AllVersion"));
         if (file.listFiles() == null || file.listFiles().length <= 0) {
            return list;
         }

         filepath = props.getProperty("AllVersion") + file.listFiles()[0].getName();
      } else if ("project_version".equals(version)) {
         file = new File(props.getProperty("ProjectVersion") + projectid);
         if (file.listFiles() == null || file.listFiles().length <= 0) {
            return list;
         }

         filepath = props.getProperty("ProjectVersion") + projectid + File.separator + file.listFiles()[0].getName();
      } else {
         if ("task_version".equals(version) || StringUtil.isBlank(version)) {
            return list;
         }

         filepath = props.getProperty("TaskVersion") + taskid + File.separator + version;
      }

      InputStreamReader newRead = null;

      try {
         newRead = new InputStreamReader(new FileInputStream(filepath), "GBK");
      } catch (UnsupportedEncodingException e) {
         e.printStackTrace();
         this.writeFile("errormanage", "版本文件转码异常,非常严重," + formatter.format(new Date()) + ",banbenfilecode\r\n", url);
         String content1 = this.geterrorprint(e);
         this.writeErroFile("banbenfilecode", content1, url);
      } catch (FileNotFoundException e) {
         e.printStackTrace();
         this.writeFile("errormanage", "版本文件找不到,非常严重," + formatter.format(new Date()) + ",banbenfileunfindfile\r\n", url);
         String content1 = this.geterrorprint(e);
         this.writeErroFile("banbenfileunfindfile", content1, url);
      }

      BufferedReader newBufferedReader = new BufferedReader(newRead);
      String newInformationLine = "";
      String[] str = null;

      try {
         while((newInformationLine = newBufferedReader.readLine()) != null) {
            TCoreProjectVersionVO tCoreProjectVersionVO = new TCoreProjectVersionVO();
            str = newInformationLine.split(",", -1);
            tCoreProjectVersionVO.setSchemaName(str[0]);
            tCoreProjectVersionVO.setTableName(str[1]);
            tCoreProjectVersionVO.setColumnName(str[2]);
            tCoreProjectVersionVO.setDataareaId(str[3]);
            tCoreProjectVersionVO.setDataareaName(str[4]);
            tCoreProjectVersionVO.setSensitiveId(str[5]);
            tCoreProjectVersionVO.setSensitiveName(str[6]);
            tCoreProjectVersionVO.setIssure(str[7]);
            list.put(str[0] + str[1] + str[2], tCoreProjectVersionVO);
            String[] var40 = null;
         }
      } catch (IOException e) {
         e.printStackTrace();
         this.writeFile("errormanage", "流异常,非常严重," + formatter.format(new Date()) + ",floterror\r\n", url);
         String content1 = this.geterrorprint(e);
         this.writeErroFile("floterror", content1, url);
      } finally {
         try {
            newRead.close();
         } catch (IOException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   private String getQuerySql(String selectDataType, String dbType, String schema, long maxRowCount, String num) {
      String sql = null;
      if (EdbType.DM.toString().equals(dbType)) {
         if (selectDataType.equals("1")) {
            sql = "select {1} from \"" + schema + "\".\"{0}\" where rownum <= " + maxRowCount;
         } else if (selectDataType.equals("2")) {
            sql = "";
         } else if (selectDataType.equals("3")) {
            if (num == null || "".equals(num)) {
               num = "50000";
            }

            sql = "select {1} from (select {1} from \"" + schema + "\".\"{0}\" where rownum < " + num + " order by dbms_random.value) where rownum <= " + maxRowCount;
         }
      } else if (EdbType.ORACLE.toString().equals(dbType)) {
         if (selectDataType.equals("1")) {
            sql = "select {1} from " + schema + ".\"{0}\" where rownum <= " + maxRowCount;
         } else if (selectDataType.equals("2")) {
            sql = "";
         } else if (selectDataType.equals("3")) {
            if (num == null || "".equals(num)) {
               num = "50000";
            }

            sql = "select {1} from (select {1} from " + schema + ".\"{0}\" where rownum < " + num + " order by dbms_random.value) where rownum <= " + maxRowCount;
         }
      } else if (EdbType.DB2.toString().equals(dbType)) {
         if (selectDataType.equals("1")) {
            sql = "select {1} from " + schema + ".\"{0}\" FETCH FIRST " + maxRowCount + " ROWS ONLY";
         } else if (selectDataType.equals("2")) {
            sql = "";
         } else if (selectDataType.equals("3")) {
            sql = "select {1} from " + schema + ".\"{0}\" order by rand() FETCH FIRST " + maxRowCount + " ROWS ONLY";
         }
      } else if (EdbType.INFORMIX.toString().equals(dbType)) {
         if (selectDataType.equals("1")) {
            sql = "select first " + maxRowCount + " {1} from " + schema + ".{0} ";
         } else if (selectDataType.equals("2")) {
            sql = "";
         } else if (selectDataType.equals("3")) {
            sql = "";
         }
      } else if (!EdbType.MYSQL.toString().equals(dbType) && !EdbType.MARIADB.toString().equals(dbType) && !EdbType.RAPIDSDB.toString().equals(dbType) && !EdbType.OCEANBASE.toString().equals(dbType)) {
         if (EdbType.MSSQLSERVER.toString().equals(dbType)) {
            if (selectDataType.equals("1")) {
               sql = "select top " + maxRowCount + " {1} from  " + schema + ".\"{0}\"";
            } else if (selectDataType.equals("2")) {
               sql = "";
            } else if (selectDataType.equals("3")) {
               sql = "select top " + maxRowCount + " {1} from " + schema + ".\"{0}\" order by newid()";
            }
         } else if (!EdbType.HIVE.toString().equals(dbType) && !EdbType.HIVE_TDH.toString().equals(dbType)) {
            if (EdbType.SYBASE.toString().equals(dbType)) {
               if (selectDataType.equals("1")) {
                  sql = " SET ROWCOUNT " + maxRowCount + " SELECT {1} FROM " + schema + ".\"{0}\" SET ROWCOUNT 0";
               } else if (selectDataType.equals("2")) {
                  sql = "";
               } else if (selectDataType.equals("3")) {
                  sql = "set rowcount " + maxRowCount + "  select {1} from " + schema + ".\"{0}\"order by rand(convert(int,row1)+datepart(ms,getdate())) set rowcount 0";
               }
            } else if (EdbType.AS400.toString().equals(dbType)) {
               if (selectDataType.equals("1")) {
                  sql = "select {1} from " + schema + ".\"{0}\" FETCH FIRST " + maxRowCount + " ROWS ONLY";
               } else if (selectDataType.equals("2")) {
                  sql = "";
               } else if (selectDataType.equals("3")) {
                  sql = "select {1} from " + schema + ".\"{0}\" order by rand() FETCH FIRST " + maxRowCount + " ROWS ONLY";
               }
            } else if (EdbType.SYBASE_IQ.toString().equals(dbType)) {
               if (selectDataType.equals("1")) {
                  sql = " SET ROWCOUNT " + maxRowCount + " SELECT {1} FROM " + schema + ".\"{0}\" SET ROWCOUNT 0";
               } else if (selectDataType.equals("2")) {
                  sql = "";
               } else if (selectDataType.equals("3")) {
                  sql = "set rowcount " + maxRowCount + "  select {1} from " + schema + ".\"{0}\"order by rand(convert(int,row1)+datepart(ms,getdate())) set rowcount 0";
               }
            } else if (EdbType.TERADATA.toString().equals(dbType)) {
               if (selectDataType.equals("1")) {
                  sql = " SELECT top " + maxRowCount + " {1} FROM " + schema + ".\"{0}\" ;";
               } else if (selectDataType.equals("2")) {
                  sql = "";
               } else if (selectDataType.equals("3")) {
                  sql = " SELECT {1} FROM " + schema + ".\"{0}\"   sample  " + maxRowCount + " ;";
               }
            } else if (!EdbType.GREENPLUM.toString().equals(dbType) && !EdbType.GAUSS.toString().equals(dbType)) {
               if (EdbType.HANA.toString().equals(dbType)) {
                  if (selectDataType.equals("1")) {
                     sql = "select {1} from " + schema + ".{0}  limit  " + maxRowCount;
                  } else if (selectDataType.equals("2")) {
                     sql = "";
                  } else if (selectDataType.equals("3")) {
                     sql = "";
                  }
               } else if (EdbType.MONGODB.toString().equals(dbType)) {
                  if (selectDataType.equals("1")) {
                     sql = "db.getCollection('" + schema + "').find({}).limit(" + maxRowCount + ")";
                  }
               } else if (EdbType.KINGBASE.toString().equals(dbType)) {
                  if (selectDataType.equals("1")) {
                     sql = "select {1} from  " + schema + ".{0} limit " + maxRowCount;
                  } else if (selectDataType.equals("2")) {
                     sql = "";
                  } else if (selectDataType.equals("3")) {
                     if (num == null || "".equals(num)) {
                        num = "50000";
                     }

                     sql = "select {1} from (select {1} from \"" + schema + "\".\"{0}\" where rownum < " + num + " order by random) where rownum <= " + maxRowCount;
                  }
               } else if (EdbType.POSTGRESQL.toString().equals(dbType)) {
                  if (selectDataType.equals("1")) {
                     sql = "select {1} from  \"" + schema + "\".\"{0}\" limit " + maxRowCount;
                  } else if (selectDataType.equals("2")) {
                     sql = "";
                  } else if (selectDataType.equals("3")) {
                     sql = "select {1} from " + schema + ".{0} order by  now()  limit  " + maxRowCount;
                  }
               }
            } else if (selectDataType.equals("1")) {
               sql = "select {1} from  \"" + schema + "\".\"{0}\" limit " + maxRowCount;
            } else if (selectDataType.equals("2")) {
               sql = "";
            } else if (selectDataType.equals("3")) {
               sql = "select {1} from " + schema + ".{0} order by  now()  limit  " + maxRowCount;
            }
         } else if (selectDataType.equals("1")) {
            sql = "select {1} from " + schema + ".{0} limit " + maxRowCount;
         } else if (selectDataType.equals("2")) {
            sql = "";
         } else if (selectDataType.equals("3")) {
            sql = "select {1} from  " + schema + ".{0} limit " + maxRowCount;
         }
      } else if (selectDataType.equals("1")) {
         sql = "select {1} from  " + schema + ".{0} limit " + maxRowCount;
      } else if (selectDataType.equals("2")) {
         sql = "";
      } else if (selectDataType.equals("3")) {
         sql = "select {1} from " + schema + ".{0} order by rand() limit " + maxRowCount;
      }

      return sql;
   }

   public boolean isSelectData(String hits, int rulesize) {
      return hits != null && Long.parseLong(hits) > 0L && rulesize > 0;
   }

   public String create_tcoreDiscoveryResult_sql(String user, String dataarea_id, String dataarea_name, String issure, String tschemas, String sensitive_id, String sensitive_name, String datasystem_id, String sampling, String teffe_sampling, String fields, String fieldremark, String matching, String table, List<String> list_table) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      TcoreDiscoveryResult tcoreDiscoveryResult = new TcoreDiscoveryResult();
      tcoreDiscoveryResult.setDataarea_id(dataarea_id);
      tcoreDiscoveryResult.setDataarea_name(dataarea_name);
      tcoreDiscoveryResult.setId(UUID.randomUUID().toString());
      tcoreDiscoveryResult.setIssure(issure);
      tcoreDiscoveryResult.setTschemas(tschemas);
      tcoreDiscoveryResult.setSensitive_id(sensitive_id);
      tcoreDiscoveryResult.setSensitive_name(sensitive_name);
      tcoreDiscoveryResult.setTdatasystem_id(datasystem_id);
      tcoreDiscoveryResult.setTsampling(sampling);
      tcoreDiscoveryResult.setTeffe_sampling(teffe_sampling);
      tcoreDiscoveryResult.setTfields(fields);
      tcoreDiscoveryResult.setTfieldremark(fieldremark);
      tcoreDiscoveryResult.setTmatching(matching);
      tcoreDiscoveryResult.setTtables(table);
      tcoreDiscoveryResult.setCorrelation("");
      tcoreDiscoveryResult.setFilestruct("");
      tcoreDiscoveryResult.setFilecontent("");
      return JdbcTool.sql_insert_h(tcoreDiscoveryResult, list_table);
   }

   public void writeFile(String filename, String content, String url) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File writename = new File(url + filename + ".txt");
      File file = new File(url);
      if (!file.exists()) {
         file.mkdirs();
      }

      try {
         writename.createNewFile();
         BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(writename.toString()), true), "GBK"));
         out.write(content);
         out.flush();
         out.close();
      } catch (IOException e) {
         e.printStackTrace();
      }

   }

   public boolean isCurrency(String code, List<String> currdic) {
      boolean result = false;
      result = currdic.contains(code);
      return result;
   }

   private boolean FloatCol(String code) {
      boolean result = false;
      if (StringUtils.isNotBlank(code) && code.contains(".")) {
         Pattern pattern = Pattern.compile("^([1-9]\\d{0,9}|0)([.]?|(\\.\\d{1,2})?)$");
         Matcher match = pattern.matcher(code);
         result = match.matches();
      }

      return result;
   }

   public void writeFileRefresh(String filename, String content, String url) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File writename = new File(url + filename + ".txt");
      File file = new File(url);
      if (!file.exists()) {
         file.mkdirs();
      }

      try {
         writename.createNewFile();
         BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(writename.toString())), "GBK"));
         out.write(content);
         out.flush();
         out.close();
      } catch (IOException e) {
         e.printStackTrace();
      }

   }

   public boolean delFile(String filePath) {
      boolean flag = true;
      if (filePath != null) {
         File file = new File(filePath);
         if (file.exists()) {
            File[] filePaths = file.listFiles();

            for(File f : filePaths) {
               if (f.isFile()) {
                  f.delete();
               }

               if (f.isDirectory()) {
                  String fpath = f.getPath();
                  this.delFile(fpath);
                  f.delete();
               }
            }
         }
      } else {
         flag = false;
      }

      return flag;
   }

   public String geterrorprint(Exception e) {
      StringWriter sw = new StringWriter();
      PrintWriter pw = new PrintWriter(sw);
      e.printStackTrace(pw);
      String content = sw.toString();
      return content;
   }

   public void delDiscoveryResult(String tablename) {
      this.tcoreDiscoveryResultsRecordDao.truncateDiscoveryResults(tablename);
   }

   public void delAssignTableDiscoveryResult(String tablename, String datasystemid, String schema, String ntablename) {
      this.tcoreDiscoveryResultsRecordDao.truncateAssignTableDiscoveryResults(tablename, datasystemid, schema, ntablename);
   }

   public void delDiscoveryDataResult(String taskid) {
      this.tcoreDiscoveryDataResultDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public void onOff(List<String> list) {
      this.vlist = list;
   }

   public void setYearNow() {
      this.yearNow = Calendar.getInstance().get(1);
   }

   public String getNumberOnly(String str) {
      if (null == this.phoneNoReplacePattern) {
         this.phoneNoReplacePattern = Pattern.compile("[^0-9]");
      }

      return this.phoneNoReplacePattern.matcher(str).replaceAll("");
   }

   public boolean isPersonName(String name, int maxLength) {
      name = specialCharactersReplace(name);
      boolean result = false;
      int length = name.length();
      if (length >= 2) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (null == this.allEnglishPattern) {
            this.allEnglishPattern = Pattern.compile("[a-zA-Z\\s\\.\\']+");
         }

         if (this.allChinesePattern.matcher(name).matches()) {
            if (null == this.singleFirstNameList) {
               this.singleFirstNameList = this.tConsoleDictionaryDao.queryValueByTypeCode("1");
               this.doubleFirstNameList = this.tConsoleDictionaryDao.queryValueByTypeCode("2");
            }

            if (this.singleFirstNameList.contains(name.substring(0, 1)) && name.length() <= 3) {
               String lasename = name.substring(name.length() - 1, name.length());
               if (!lasename.equals("省") && !lasename.equals("市") && !lasename.equals("区") && !lasename.equals("县")) {
                  result = true;
               } else {
                  result = false;
               }
            } else if (this.doubleFirstNameList.contains(name.substring(0, 2)) && name.length() <= 4) {
               String lasename = name.substring(name.length() - 1, name.length());
               if (!lasename.equals("省") && !lasename.equals("市") && !lasename.equals("区") && !lasename.equals("县")) {
                  result = true;
               } else {
                  result = false;
               }
            }
         }
      }

      return result;
   }

   public boolean isNationality(String nation, int maxLength) {
      nation = specialCharactersReplace(nation);
      boolean result = false;
      int length = nation.length();
      if (length >= 2) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (null == this.allEnglishPattern) {
            this.allEnglishPattern = Pattern.compile("[a-zA-Z\\s\\.\\']+");
         }

         if (this.allChinesePattern.matcher(nation).matches()) {
            if (null == this.nationality) {
               this.nationality = this.tConsoleDictionaryDao.queryValueByTypeCode("20");
            }

            if (this.nationality.contains(nation)) {
               result = true;
            } else {
               result = false;
            }
         }
      }

      return result;
   }

   public boolean isMarry(String marry, int maxLength) {
      marry = specialCharactersReplace(marry);
      boolean result = false;
      int length = marry.length();
      if (length >= 2) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (this.allChinesePattern.matcher(marry).matches()) {
            if (!marry.equals("已婚") && !marry.equals("未婚") && !marry.equals("离异") && !marry.equals("丧偶")) {
               result = false;
            } else {
               result = true;
            }
         }
      }

      return result;
   }

   public boolean isReligion(String religion, int maxLength) {
      religion = specialCharactersReplace(religion);
      boolean result = false;
      int length = religion.length();
      if (length >= 2) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (this.allChinesePattern.matcher(religion).matches()) {
            if (null == this.religionList) {
               this.religionList = this.tConsoleDictionaryDao.queryValueByTypeCode("21");
            }

            if (this.religionList.contains(religion)) {
               result = true;
            } else {
               result = false;
            }
         }
      }

      return result;
   }

   public boolean isPersonNation(String nation, int maxLength) {
      nation = specialCharactersReplace(nation);
      boolean result = false;
      int length = nation.length();
      if (length >= 2) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (this.allChinesePattern.matcher(nation).matches() && null == this.nationList) {
            this.nationList = this.tConsoleDictionaryDao.queryValueByTypeCode("22");
            if (this.nationList.contains(nation)) {
               result = true;
            } else {
               result = false;
            }
         }
      }

      return result;
   }

   public boolean isPolitical(String politic, int maxLength) {
      politic = specialCharactersReplace(politic);
      boolean result = false;
      int length = politic.length();
      if (null == this.allChinesePattern) {
         this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
      }

      if (this.allChinesePattern.matcher(politic).matches() && null == this.politicList) {
         this.politicList = this.tConsoleDictionaryDao.queryValueByTypeCode("23");
         if (this.politicList.contains(politic)) {
            result = true;
         } else {
            result = false;
         }
      }

      return result;
   }

   public boolean isPassport(String passport, int maxLength) {
      passport = specialCharactersReplace(passport);
      boolean result = false;
      result = IdnoTool.validatePassport(passport);
      return result;
   }

   public boolean isBirthAddress(String address, int maxLength) {
      address = specialCharactersReplace(address);
      boolean result = false;
      int length = address.length();
      if (length >= 3) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (this.allChinesePattern.matcher(address).matches()) {
            String lastname = address.substring(length - 1, length);
            if (lastname.equals("省")) {
               String firstname = address.substring(0, length - 1);
               if (null == this.birthAddress) {
                  this.birthAddress = this.tConsoleDictionaryDao.queryValueByTypeCode("4");
               }

               if (this.birthAddress.contains(firstname)) {
                  result = true;
               } else {
                  result = false;
               }
            }
         }
      }

      return result;
   }

   public boolean Diploma(String diploma, int maxLength) {
      diploma = specialCharactersReplace(diploma);
      boolean result = false;
      diploma = diploma.trim();
      int length = diploma.length();
      if (length == 17) {
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{17}");
         }

         if (this.diplomapattern.matcher(diploma).matches()) {
            if (null == this.diplomaList) {
               this.diplomaList = this.tConsoleDictionaryDao.queryValueByTypeCode("24");
            }

            String firstdiploma = diploma.substring(0, 5);
            String seconddiploma = diploma.substring(5, 6);
            String thirddiploma = diploma.substring(6, 10);
            String forthdiploma = diploma.substring(10, 12);
            if (this.diplomaList.contains(firstdiploma) && (seconddiploma.equals("1") || seconddiploma.equals("2") || seconddiploma.equals("3") || seconddiploma.equals("4") || seconddiploma.equals("5") || seconddiploma.equals("6") || seconddiploma.equals("7")) && Integer.parseInt(thirddiploma) >= 1800 && Integer.parseInt(thirddiploma) <= this.yearNow) {
               if (!forthdiploma.equals("01") && !forthdiploma.equals("02") && !forthdiploma.equals("04") && !forthdiploma.equals("05") && !forthdiploma.equals("06")) {
                  result = false;
               } else {
                  result = true;
               }
            }
         }
      }

      if (length == 18) {
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{18}");
         }

         if (this.diplomapattern.matcher(diploma).matches()) {
            String firstdiploma = diploma.substring(0, 5);
            String seconddiploma = diploma.substring(5, 6);
            String thirddiploma = diploma.substring(6, 10);
            String forthdiploma = diploma.substring(10, 12);
            if (null == this.diplomaList) {
               this.diplomaList = this.tConsoleDictionaryDao.queryValueByTypeCode("24");
            }

            if (this.diplomaList.contains(firstdiploma) && (seconddiploma.equals("1") || seconddiploma.equals("2") || seconddiploma.equals("3") || seconddiploma.equals("4") || seconddiploma.equals("5") || seconddiploma.equals("6") || seconddiploma.equals("7")) && Integer.parseInt(thirddiploma) >= 1800 && Integer.parseInt(thirddiploma) <= this.yearNow) {
               if (!forthdiploma.equals("01") && !forthdiploma.equals("02") && !forthdiploma.equals("04") && !forthdiploma.equals("05") && !forthdiploma.equals("06")) {
                  result = false;
               } else {
                  result = true;
               }
            }
         }
      }

      return result;
   }

   public boolean diplomaNo(String diplomano, int maxLength) {
      diplomano = specialCharactersReplace(diplomano);
      boolean result = false;
      diplomano = diplomano.trim();
      int length = diplomano.length();
      if (length == 16) {
         String firstdiploma = diplomano.substring(0, 5);
         String seconddiploma = diplomano.substring(5, 6);
         String thirddiploma = diplomano.substring(6, 10);
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{16}");
         }

         if (this.diplomapattern.matcher(diplomano).matches()) {
            if (null == this.diplomanoList) {
               this.diplomanoList = this.tConsoleDictionaryDao.queryValueByTypeCode("24");
            }

            if (this.diplomanoList.contains(firstdiploma) && (seconddiploma.equals("2") || seconddiploma.equals("3") || seconddiploma.equals("4"))) {
               if (Integer.parseInt(thirddiploma) >= 1800 && Integer.parseInt(thirddiploma) <= this.yearNow) {
                  result = true;
               } else {
                  result = false;
               }
            }
         }
      }

      return result;
   }

   public boolean SocialNo(String socialno, int maxLength) {
      socialno = specialCharactersReplace(socialno);
      boolean result = false;
      socialno = socialno.trim();
      int length = socialno.length();
      if (length == 10) {
         String socialnoft = socialno.substring(0, 2);
         String socialnosec = socialno.substring(2, 5);
         String socialnolast = socialno.substring(7, 10);
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{10}");
         }

         if (this.diplomapattern.matcher(socialno).matches()) {
            this.socialList = this.tConsoleDictionaryDao.queryValueByTypeCode("25");
            this.socialList1 = this.tConsoleDictionaryDao.queryValueByTypeCode("26");
         }

         if (this.socialList.contains(socialnoft) && this.socialList1.contains(socialnosec)) {
            result = true;
         }
      }

      if (length == 12) {
         String socialnoft = socialno.substring(0, 2);
         String socialnosec = socialno.substring(2, 5);
         String socialnolast = socialno.substring(7, 10);
         String socialnotird1 = socialno.substring(5, 9);
         String socialnolast1 = socialno.substring(9, 12);
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{12}");
         }

         if (this.diplomapattern.matcher(socialno).matches()) {
            this.socialList = this.tConsoleDictionaryDao.queryValueByTypeCode("25");
            this.socialList1 = this.tConsoleDictionaryDao.queryValueByTypeCode("26");
         }

         if (this.socialList.contains(socialnoft) && this.socialList1.contains(socialnosec) && Integer.parseInt(socialnotird1) >= 1800 && Integer.parseInt(socialnotird1) <= this.yearNow) {
            result = true;
         }
      }

      return result;
   }

   public boolean accumulationNo(String accNo, int maxLength) {
      accNo = specialCharactersReplace(accNo);
      boolean result = false;
      accNo = accNo.trim();
      int length = accNo.length();
      String firstNo = accNo.substring(0, 1);
      if (length == 9 && (accNo.startsWith("0") || accNo.startsWith("1"))) {
         result = true;
      }

      if (length == 12) {
         String lastNo = accNo.substring(length - 3, length);
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{12}");
         }

         if (this.diplomapattern.matcher(accNo).matches() && (accNo.startsWith("0") || accNo.startsWith("1")) && (lastNo.equals("205") || lastNo.equals("209"))) {
            result = true;
         }
      }

      return result;
   }

   public boolean isIP4(String ip) {
      ip = specialCharactersReplace(ip);
      boolean result = false;
      if (ip.length() >= 7 && ip.length() <= 15) {
         if (null == this.ip4Pattern) {
            this.ip4Pattern = Pattern.compile("[0-9]{1,3}(\\.[0-9]{1,3}){3}");
         }

         if (this.ip4Pattern.matcher(ip).matches()) {
            String[] ips = ip.split("\\.");
            if (ips.length == 4) {
               int matchCount = 0;

               for(int i = 0; i < 4; ++i) {
                  if (ips[i].startsWith("0")) {
                     if (!"0".equals(ips[i])) {
                        break;
                     }

                     ++matchCount;
                  } else {
                     int num = Integer.parseInt(ips[i]);
                     if (num <= 0 || num > 255) {
                        break;
                     }

                     ++matchCount;
                  }
               }

               if (matchCount == 4) {
                  result = true;
               }
            }
         }
      }

      return result;
   }

   public boolean isIdentifyNo(String idno) {
      idno = specialCharactersReplace(idno);
      boolean result = false;
      idno = idno.trim();
      if (idno.length() == 18) {
         idno = idno.toUpperCase();
         if (null == this.identifyNoPattern) {
            this.identifyNoPattern = Pattern.compile("[0-9]{17}[0-9X]");
         }

         if (this.identifyNoPattern.matcher(idno).matches() && this.checkIdentifyNoFirstSix(idno) && this.checkIdentifyNoDate(idno.substring(6, 14)) && this.getLastNoOfIdentifyNo(idno) == idno.charAt(17)) {
            result = true;
         }
      } else if (idno.length() == 15) {
         Pattern identifyNoPattern15 = Pattern.compile("[0-9]{15}");
         if (identifyNoPattern15.matcher(idno).matches() && this.checkIdentifyNoFirstSix(idno) && this.checkIdentifyNoDate("19" + idno.substring(6, 12))) {
            result = true;
         }
      }

      return result;
   }

   public boolean checkIdentifyNoFirstSix(String idno) {
      idno = specialCharactersReplace(idno);
      boolean result = false;
      if (null == this.firstSixNumList) {
         this.firstSixNumList = this.tConsoleDictionaryDao.queryValueByTypeCode("11");
      }

      if (this.firstSixNumList.contains(idno.substring(0, 6))) {
         result = true;
      }

      return result;
   }

   public boolean checkIdentifyNoDate(String datestr) {
      datestr = specialCharactersReplace(datestr);
      boolean result = false;
      if (null == this.identifyNoDateFormat) {
         this.identifyNoDateFormat = new SimpleDateFormat("yyyyMMdd");
         this.identifyNoDateFormat.setLenient(false);
      }

      try {
         this.identifyNoDateFormat.parse(datestr);
         int year = Integer.parseInt(datestr.substring(0, 4));
         if (year > 1800 && year <= this.yearNow) {
            result = true;
         }
      } catch (ParseException var4) {
      }

      return result;
   }

   public char getLastNoOfIdentifyNo(String idno) {
      idno = specialCharactersReplace(idno);
      int sum = 0;

      for(int i = 0; i < 17; ++i) {
         sum += (idno.charAt(i) - 48) * this.identifyNoFactors[i];
      }

      return this.identifyNoResults[sum % 11];
   }

   public boolean isChineseAddress(String address, int maxLength, int level) {
      address = specialCharactersReplace(address);
      boolean result = false;
      address = address.replaceAll("[^一-龥]", "");
      if (address.length() >= 6) {
         if (null == this.chineseAddressPatternFirstThree) {
            this.chineseAddressPatternFirstThree = Pattern.compile("[\\u4e00-\\u9fa5]{3}.*");
         }

         if (this.chineseAddressPatternFirstThree.matcher(address).matches()) {
            if (null == this.chineseAddressPattern) {
               List<String> list = this.tConsoleDictionaryDao.queryValueByTypeCode("4", "5", "17");
               if (list.size() > 0) {
                  StringBuilder pattern = new StringBuilder();

                  for(String str : list) {
                     pattern.append(str);
                     pattern.append("|");
                  }

                  pattern.deleteCharAt(pattern.length() - 1);
                  this.chineseAddressPattern = Pattern.compile(pattern.toString());
               }
            }

            Matcher matcher = this.chineseAddressPattern.matcher(address);

            int num;
            for(num = 0; matcher.find(); ++num) {
            }

            if (num != 0 && num >= level) {
               result = true;
            }
         }
      }

      return result;
   }

   public boolean isTelephoneNo(String telephoneNo, int maxLength) {
      telephoneNo = specialCharactersReplace(telephoneNo);
      boolean result = false;
      telephoneNo = MobileNumberTool.toHalfAngleDigital(telephoneNo);
      if (telephoneNo.length() >= 7 && telephoneNo.length() <= 25) {
         if (null == this.telephoneNoSimplePattern) {
            this.telephoneNoSimplePattern = Pattern.compile(".*[0-9]{7}");
         }

         if (null == this.isContainsChineseOrEnglish) {
            this.isContainsChineseOrEnglish = Pattern.compile("[一-龥[(A-Za-z)]]");
         }

         if (this.isContainsChineseOrEnglish.matcher(telephoneNo).find()) {
            return result;
         }

         if (this.telephoneNoSimplePattern.matcher(telephoneNo).matches()) {
            String numberOnly = this.getNumberOnly(telephoneNo);
            result = this.checkTelephoneNo(numberOnly);
         }
      }

      return result;
   }

   public boolean checkTelephoneNo(String numberOnly) {
      numberOnly = specialCharactersReplace(numberOnly);
      boolean result = false;
      int length = numberOnly.length();
      if (!StringUtils.isBlank(numberOnly) && !numberOnly.startsWith("19") && !numberOnly.startsWith("20")) {
         if (length >= 7 && length <= 16) {
            if (length <= 8) {
               if (numberOnly.startsWith("1") || numberOnly.startsWith("0")) {
                  return false;
               }

               SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");

               try {
                  format.setLenient(false);
                  format.parse(numberOnly);
                  Calendar cal = Calendar.getInstance();
                  cal.setTime(format.parse(numberOnly));
                  int year = cal.get(1);
                  if (year < 1970 || year > 2050) {
                     result = true;
                  }
               } catch (ParseException var7) {
                  result = true;
               }
            } else if (numberOnly.startsWith("86")) {
               if (length < 12) {
                  return false;
               }

               numberOnly = numberOnly.substring(2, numberOnly.length());
               result = this.checkTelephonearea(numberOnly);
            } else if (numberOnly.startsWith("0086")) {
               if (length < 14) {
                  return false;
               }

               numberOnly = numberOnly.substring(4, numberOnly.length());
               result = this.checkTelephonearea(numberOnly);
            } else {
               result = this.checkTelephonearea(numberOnly);
            }
         }

         return result;
      } else {
         return false;
      }
   }

   public boolean checkTelephonearea(String numberOnly) {
      numberOnly = specialCharactersReplace(numberOnly);
      if (null == this.telephoneNoPattern) {
         List<String> list = this.tConsoleDictionaryDao.queryValueByTypeCode("8");
         if (list.size() > 0) {
            StringBuilder pattern = new StringBuilder();

            for(String str : list) {
               pattern.append(str);
               pattern.append("|");
            }

            pattern.deleteCharAt(pattern.length() - 1);
            this.telephoneNoPattern = Pattern.compile(pattern.toString());
         }
      }

      String iszreo = numberOnly.substring(0, 1);
      boolean result = false;
      if (iszreo.equals("0")) {
         Matcher matcher = this.telephoneNoPattern.matcher(numberOnly.substring(0, 4));
         if (matcher.find()) {
            int realTelephoneNoLength = numberOnly.substring(matcher.group().length()).length();
            if (realTelephoneNoLength == 8 || realTelephoneNoLength == 7) {
               String a = numberOnly.substring(matcher.group().length(), matcher.group().length() + 1);
               if (!a.equals("0") && !a.equals("1")) {
                  result = true;
               }
            }
         }
      } else if (numberOnly.startsWith("1") && !numberOnly.startsWith("10")) {
         Matcher matcher = this.telephoneNoPattern.matcher("0" + numberOnly.substring(0, 3));
         if (matcher.find()) {
            int realTelephoneNoLength = numberOnly.substring(matcher.group().length()).length();
            if (realTelephoneNoLength == 8 || realTelephoneNoLength == 7) {
               String a = numberOnly.substring(matcher.group().length() - 1, matcher.group().length());
               if (!a.equals("0") && !a.equals("1")) {
                  result = true;
               }
            }
         }
      } else {
         result = false;
      }

      return result;
   }

   public boolean isMobilephoneNo(String mobilephoneNo, int maxLength) {
      mobilephoneNo = specialCharactersReplace(mobilephoneNo);
      boolean result = false;
      mobilephoneNo = MobileNumberTool.toHalfAngleDigital(mobilephoneNo);
      if (mobilephoneNo.length() == 11) {
         if (null == this.mobilephoneNoSimplePattern) {
            this.mobilephoneNoSimplePattern = Pattern.compile(".*[0-9]{11}");
         }

         if (this.mobilephoneNoSimplePattern.matcher(mobilephoneNo).matches()) {
            String numberOnly = this.getNumberOnly(mobilephoneNo);
            result = this.checkMobilephoneNo(numberOnly);
         }
      }

      return result;
   }

   public boolean checkMobilephoneNo(String numberOnly) {
      numberOnly = specialCharactersReplace(numberOnly);
      boolean result = false;
      int length = numberOnly.length();
      if (length == 11) {
         if (null == this.firstThreeNoList) {
            this.firstThreeNoList = this.tConsoleDictionaryDao.queryValueByTypeCode("9");
         }

         String firstThreeNo = numberOnly.substring(length - 11, length - 8);
         if (this.firstThreeNoList.contains(firstThreeNo)) {
            result = true;
         }
      }

      return result;
   }

   public boolean isPhoneNo(String phoneNo, int maxLength) {
      phoneNo = specialCharactersReplace(phoneNo);
      boolean result = false;
      phoneNo = MobileNumberTool.toHalfAngleDigital(phoneNo);
      if (phoneNo.length() >= 7 && phoneNo.length() <= 25) {
         if (null == this.phoneNoSimplePattern) {
            this.phoneNoSimplePattern = Pattern.compile(".*[0-9]{7}");
         }

         if (null == this.isContainsChineseOrEnglish) {
            this.isContainsChineseOrEnglish = Pattern.compile("[一-龥[(A-Za-z)]]");
         }

         if (this.isContainsChineseOrEnglish.matcher(phoneNo).find()) {
            return result;
         }

         if (this.phoneNoSimplePattern.matcher(phoneNo).matches()) {
            String numberOnly = this.getNumberOnly(phoneNo);
            result = this.checkMobilephoneNo(numberOnly);
            if (!result) {
               result = this.checkTelephoneNo(numberOnly);
            }
         }
      }

      return result;
   }

   public boolean isemail(String email) {
      email = specialCharactersReplace(email);
      boolean result = false;
      email = email.trim();
      if (email.length() < 6) {
         return result;
      } else {
         String[] emailsuffix = email.split("@");
         if (emailsuffix.length == 2) {
            result = true;
         }

         if (!result) {
            return result;
         } else {
            if (null == this.emailPrefix || null == this.emailSuffix) {
               this.emailPrefix = Pattern.compile("^((?!_\\-\\.)[a-zA-Z0-9]+)([a-zA-Z0-9_\\-\\.]*)");
               this.emailSuffix = Pattern.compile("^((?!\\.$)(?!\\_$)(?!\\-$).)*$");
            }

            if (this.emailPrefix.matcher(emailsuffix[0]).find() && this.emailSuffix.matcher(emailsuffix[0]).matches() && this.emailPrefix.matcher(emailsuffix[1]).find() && this.emailSuffix.matcher(emailsuffix[1]).matches()) {
               result = true;
            } else {
               result = false;
            }

            return result;
         }
      }
   }

   public boolean isCompanyName(String companyName, int maxLength) {
      companyName = specialCharactersReplace(companyName);
      boolean result = false;
      companyName = companyName.trim();
      int length = companyName.length();
      if (length >= 3) {
         result = this.isPersonName(companyName, 4);
         if (result) {
            return false;
         }

         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (null == this.companyNamePattern) {
            List<String> list = this.tConsoleDictionaryDao.queryValueByTypeCode("10");
            if (list.size() > 0) {
               StringBuilder pattern = new StringBuilder();

               for(String str : list) {
                  pattern.append(str);
                  pattern.append("$");
                  pattern.append("|");
               }

               pattern.deleteCharAt(pattern.length() - 1);
               this.companyNamePattern = Pattern.compile(pattern.toString());
            }
         }

         Matcher matcher = this.companyNamePattern.matcher(companyName);
         if (matcher.find()) {
            result = true;
         }
      }

      return result;
   }

   public boolean isShopName(String shopName, int maxLength) {
      shopName = specialCharactersReplace(shopName);
      boolean result = false;
      shopName = shopName.trim();
      int length = shopName.length();
      if (length >= 3) {
         result = this.isPersonName(shopName, 4);
         if (result) {
            return false;
         }

         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (this.allChinesePattern.matcher(shopName).matches()) {
            if (null == this.shopNamePattern) {
               List<String> list = this.tConsoleDictionaryDao.queryValueByTypeCode("10");
               if (list.size() > 0) {
                  StringBuilder pattern = new StringBuilder();

                  for(String str : list) {
                     pattern.append(str);
                     pattern.append("|");
                  }

                  pattern.deleteCharAt(pattern.length() - 1);
                  this.shopNamePattern = Pattern.compile(pattern.toString());
               }
            }

            Matcher matcher = this.shopNamePattern.matcher(shopName);
            if (matcher.find() && matcher.start() > 0 && matcher.end() == length) {
               result = true;
            }

            if (!result) {
               List<String> list = this.tConsoleDictionaryDao.queryValueByTypeCode("16");
               if (list.size() > 0) {
                  StringBuilder pattern = new StringBuilder();

                  for(String str : list) {
                     pattern.append(str);
                     pattern.append("|");
                  }

                  pattern.deleteCharAt(pattern.length() - 1);
                  this.shopNamePattern = Pattern.compile(pattern.toString());
               }

               matcher = this.shopNamePattern.matcher(shopName);
               if (matcher.find()) {
                  result = true;
               }
            }
         }
      }

      return result;
   }

   public boolean isPostCode(String code) {
      code = specialCharactersReplace(code);
      boolean result = false;
      int length = code.trim().length();
      if (length == 6) {
         if (null == this.postCodePattern6) {
            this.postCodePattern6 = Pattern.compile("[0-9]{6}");
         }

         if (this.postCodePattern6.matcher(code).matches()) {
            if (null == this.postCodeList) {
               this.postCodeList = this.tConsoleDictionaryDao.queryValueByTypeCode("13");
            }

            if (this.postCodeList.contains(code)) {
               result = true;
            }
         }
      }

      return result;
   }

   public boolean isPersonOrCompany(String name, int maxLength) {
      name = specialCharactersReplace(name);
      boolean result = false;
      if (name.length() >= 2) {
         result = this.isPersonName(name, 4);
         if (!result) {
            result = this.isCompanyName(name, maxLength);
         }
      }

      return result;
   }

   public boolean isOrganizationCode(String code) {
      code = specialCharactersReplace(code);
      boolean result = false;
      int length = code.length();
      if (length == 9 || length == 10) {
         if (null == this.organizationCodePattern) {
            this.organizationCodePattern = Pattern.compile("[0-9A-Z]{8}[^0-9a-zA-Z]?[0-9X]");
         }

         if (this.organizationCodePattern.matcher(code).matches()) {
            result = this.checkOrganizationCode(code);
         }
      }

      return result;
   }

   public boolean checkOrganizationCode(String code) {
      code = specialCharactersReplace(code);
      boolean result = false;
      String firstEightChars = code.substring(0, 8);
      char lastChar = code.charAt(code.length() - 1);
      int sum = 0;

      for(int i = 0; i < 8; ++i) {
         sum += this.getOrganizationCodeValue(firstEightChars.charAt(i)) * this.factors[i];
      }

      int checkNum = 11 - sum % 11;
      if (checkNum == 10) {
         checkNum = 88;
      } else if (checkNum == 11) {
         checkNum = 48;
      } else {
         checkNum += 48;
      }

      if (checkNum == lastChar) {
         result = true;
      }

      return result;
   }

   public int getOrganizationCodeValue(char oneCode) {
      int result;
      if (oneCode > '9') {
         result = oneCode - 65 + 10;
      } else {
         result = oneCode - 48;
      }

      return result;
   }

   public boolean isCardNo(String cardNo) {
      cardNo = specialCharactersReplace(cardNo);
      boolean result = false;
      int length = cardNo.length();
      if (length >= 16 && length <= 19) {
         if (null == this.cardNoPattern) {
            this.cardNoPattern = Pattern.compile("[0-9]{16,19}");
         }

         if (this.cardNoPattern.matcher(cardNo).matches() && this.checkCardNo(cardNo)) {
            result = true;
         }
      }

      return result;
   }

   public boolean checkCardNo(String cardNo) {
      cardNo = specialCharactersReplace(cardNo);
      boolean result = false;
      if (!StringUtils.isBlank(cardNo) && !cardNo.startsWith("0")) {
         char[] numbers = cardNo.toCharArray();
         int flag = 1;
         int sum = 0;

         for(int i = cardNo.length() - 1; i >= 0; --i) {
            int num = numbers[i] - 48;
            if (flag % 2 == 0) {
               int d = num * 2;
               sum += d;
               if (d > 9) {
                  sum -= 9;
               }
            } else {
               sum += num;
            }

            ++flag;
         }

         if (sum % 10 == 0) {
            result = true;
         }

         return result;
      } else {
         return false;
      }
   }

   public boolean isTrackInfo(String trackInfo) {
      trackInfo = specialCharactersReplace(trackInfo);
      boolean result = false;
      int length = trackInfo.length();
      if (length >= 18) {
         if (null == this.cardNoPattern) {
            this.cardNoPattern = Pattern.compile("[0-9]{16,19}");
         }

         Matcher matcher = this.cardNoPattern.matcher(trackInfo);
         if (matcher.find() && matcher.start() == 0) {
            String cardNo = matcher.group();
            String remaining = trackInfo.substring(matcher.end());
            if (remaining.length() > 1 && remaining.startsWith("=") && this.checkCardNo(cardNo)) {
               result = true;
            }
         }
      }

      return result;
   }

   public boolean isTaxCode(String code) {
      code = specialCharactersReplace(code);
      boolean result = false;
      int length = code.length();
      if (length == 15) {
         if (null == this.taxCodePattern15) {
            this.taxCodePattern15 = Pattern.compile("[0-9]{6}[0-9A-Z]{8}[0-9X]");
         }

         if (this.taxCodePattern15.matcher(code).matches() && this.checkZoneCode(code.substring(0, 6))) {
            result = this.checkOrganizationCode(code.substring(6));
         }
      } else if (length == 20) {
         if (null == this.taxCodePattern20) {
            this.taxCodePattern20 = Pattern.compile("[0-9]{17}[0-9xX][0-9]{2}");
         }

         if (this.taxCodePattern20.matcher(code).matches() && this.checkIdentifyNoFirstSix(code.substring(0, 6))) {
            if ("000".equals(code.substring(15, 18))) {
               result = this.checkIdentifyNoDate("19" + code.substring(6, 12));
            } else if (this.checkIdentifyNoDate(code.substring(6, 14)) && this.getLastNoOfIdentifyNo(code) == code.charAt(17)) {
               result = true;
            }
         }
      }

      return result;
   }

   public boolean checkZoneCode(String code) {
      code = specialCharactersReplace(code);
      boolean result = false;
      if (null == this.zoneCodeList) {
         this.zoneCodeList = this.tConsoleDictionaryDao.queryValueByTypeCode("11");
      }

      if (this.zoneCodeList.contains(code)) {
         result = true;
      }

      return result;
   }

   public boolean isMixedIdentificationCode(String code) {
      code = specialCharactersReplace(code);
      boolean result = false;
      if (StringUtils.isNotBlank(code)) {
         result = this.isBusinessLicenseCode(code);
         if (!result) {
            result = this.isOrganizationCode(code);
         }

         if (!result) {
            result = this.isTaxCode(code);
         }

         if (!result) {
            result = this.isIdentifyNo(code);
         }

         if (!result) {
            result = IdnoTool.validateCardOtherIdno(code);
         }
      }

      return result;
   }

   public boolean isBusinessLicenseCode(String code) {
      code = specialCharactersReplace(code);
      boolean result = false;
      if (null == this.businessLicenseCodePattern) {
         this.businessLicenseCodePattern = Pattern.compile("[a-zA-Z0-9]+");
      }

      if (this.businessLicenseCodePattern.matcher(code).matches() && StringUtils.isNotBlank(code)) {
         if (15 == code.length()) {
            result = isLicense_15(code);
         } else if (18 == code.length()) {
            result = isLicense_18(code);
         }
      }

      return result;
   }

   public static boolean isLicense_15(String businesslicense) {
      businesslicense = specialCharactersReplace(businesslicense);
      boolean reFlg = false;

      try {
         Pattern blicCodePattern = Pattern.compile("[0-9]{15}");
         if (StringUtils.isNotBlank(businesslicense) && blicCodePattern.matcher(businesslicense).matches()) {
            String businesslicensePrex14 = businesslicense.substring(0, 14);
            String businesslicense15 = businesslicense.substring(14, businesslicense.length());
            char[] chars = businesslicensePrex14.toCharArray();
            int[] ints = new int[chars.length];

            for(int i = 0; i < chars.length; ++i) {
               ints[i] = Integer.parseInt(String.valueOf(chars[i]));
            }

            getCheckCode(ints);
            if (businesslicense15.equals(getCheckCode(ints) + "")) {
               reFlg = true;
            }
         }

         return reFlg;
      } catch (Exception var11) {
         reFlg = false;
         System.out.println(">>isLicense15 erro code:" + businesslicense);
         return reFlg;
      } finally {
         ;
      }
   }

   private static int getCheckCode(int[] ints) {
      if (null != ints && ints.length > 1) {
         int ti = 0;
         int si = 0;
         int cj = 0;
         int pj = 10;

         for(int i = 0; i < ints.length; ++i) {
            ti = ints[i];
            pj = cj % 11 == 0 ? 10 : cj % 11;
            si = pj + ti;
            cj = (0 == si % 10 ? 10 : si % 10) * 2;
            if (i == ints.length - 1) {
               pj = cj % 11 == 0 ? 10 : cj % 11;
               return pj == 1 ? 1 : 11 - pj;
            }
         }
      }

      return -1;
   }

   public static boolean isLicense_18(String code) {
      code = specialCharactersReplace(code);
      boolean reFlg = false;

      try {
         String regex = "^([159Y]{1})([1239]{1})([0-9ABCDEFGHJKLMNPQRTUWXY]{6})([0-9ABCDEFGHJKLMNPQRTUWXY]{9})([0-90-9ABCDEFGHJKLMNPQRTUWXY])$";
         if (code.length() == 18 && code.matches(regex)) {
            String str = "0123456789ABCDEFGHJKLMNPQRTUWXY";
            int[] ws = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
            String[] codes = new String[]{code.substring(0, code.length() - 1), code.substring(code.length() - 1, code.length())};
            int sum = 0;

            for(int i = 0; i < 17; ++i) {
               sum += str.indexOf(codes[0].charAt(i)) * ws[i];
            }

            int c18 = 31 - sum % 31;
            if (c18 == 31) {
               c18 = str.indexOf(89);
            } else if (c18 == 30) {
               c18 = str.indexOf(48);
            }

            if (str.charAt(c18) == codes[1].charAt(0)) {
               reFlg = true;
            }
         }

         return reFlg;
      } catch (Exception var11) {
         reFlg = false;
         System.out.println(reFlg + " >>isLicense18 erro code:" + code);
         return reFlg;
      } finally {
         ;
      }
   }

   public static boolean isFace(String url) throws Exception {
      url = specialCharactersReplace(url);
      Process pr = null;
      pr = Runtime.getRuntime().exec("python3 /data/image_mask/facefind/yoloface.py --image " + url + " --method test");
      BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));

      String line;
      while((line = in.readLine()) != null) {
         if ("Yes".equals(line)) {
            return true;
         }
      }

      in.close();
      return false;
   }

   private void saveResultSql(StringBuilder sb, String tablename) {
      String sql = sb.toString();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String path = props.getProperty("ResetResult");
      if (!FileTool.isFileExit(path)) {
         FileTool.createFolder(path);
      }

      String url = props.getProperty("ResetResult") + File.separator + tablename + ".txt";
      File file = new File(url);
      if ((tablename + ".txt").equals(file.getName())) {
         file.delete();
      }

      TxtTool.exportTxt(sql, url, "GBK");
   }

   private void delResultSql(String tablename) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String path = props.getProperty("ResetResult");
      if (!FileTool.isFileExit(path)) {
         FileTool.createFolder(path);
      }

      String url = props.getProperty("ResetResult") + File.separator + tablename + ".sql";
      File file = new File(url);
      if ((tablename + ".sql").equals(file.getName())) {
         file.delete();
      }

   }

   public Map<String, String> getAlldmpTableColumnsByContent(String multiDempFile, int queren, String samplingtype, String aifind, TCoreDatasystem datasystem, List<String> schemas, long maxRowCount, double rate, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo, String datasystemid, String dmptype) {
      return null;
   }

   public void writeErroFile(String filename, String content, String url) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e1) {
         e1.printStackTrace();
      }

      File writename = new File(url + filename + ".txt");
      File file = new File(url);
      if (!file.exists()) {
         file.mkdirs();
      }

      try {
         writename.createNewFile();
         BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(writename.toString()), true), "GBK"));
         out.write(content);
         out.flush();
         out.close();
      } catch (IOException e1) {
         e1.printStackTrace();
      }

   }

   public Map<String, String> getAllCollections(TCoreDatasystem datasystem, List<TcoreDiscoveryColumn> discoveryColumn, String version, List<TcoreTaskFindrule> discoveryRule, TcoreDiscoveryTask discoveryTask, List<Map<String, Object>> sensitiveRule, String projectid, String userid) throws SQLException {
      Map<String, String> resultMap = new HashMap();
      SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = props.getProperty("monitorFile") + projectid + File.separator + discoveryTask.getId() + File.separator;
      String readOneTime = props.getProperty("readCntByOneTime");
      int batcheSize = new Integer(props.getProperty("jdbc_insert_batche_size"));
      String driver = props.getProperty("jdbc.driver");
      String jdbcurl = props.getProperty("jdbc.url");
      String user = props.getProperty("jdbc.user");
      String password = props.getProperty("jdbc.password");
      String task_table = discoveryTask.getResultid();
      TcoreDiscoveryResult tcoreDiscoveryResult = new TcoreDiscoveryResult();
      StringBuilder tcoreDiscoveryResult_sql = new StringBuilder();
      Connection tconnection = null;
      PreparedStatement pstmt = null;
      List<String> list_table = JdbcTool.sql_insert_q(tcoreDiscoveryResult);
      list_table.add("id");
      String sqlBase = JdbcTool.sql_insert_z(list_table, task_table);
      tcoreDiscoveryResult_sql.append(sqlBase);
      String sql1 = "";

      for(int i = 0; i < list_table.size(); ++i) {
         if (i == 0) {
            sql1 = sql1 + "?";
         } else {
            sql1 = sql1 + ",?";
         }
      }

      tcoreDiscoveryResult_sql.append("(");
      tcoreDiscoveryResult_sql.append(sql1);
      tcoreDiscoveryResult_sql.append(")");

      try {
         tconnection = JdbcTool.getConnectionlog(driver, jdbcurl, user, password);
         tconnection.setAutoCommit(false);
      } catch (ClassNotFoundException e3) {
         this.writeFile("errormanage", "本地数据库连接异常,非常严重," + formatter.format(new Date()) + ",connCNFError_db\r\n", url);
         String content = this.geterrorprint(e3);
         this.writeErroFile("connCNFError_db", content, url);
         resultMap.put("error", "true");
         e3.printStackTrace();
      } catch (SQLException e3) {
         this.writeFile("errormanage", "本地数据库连接异常,非常严重," + formatter.format(new Date()) + ",connSQLError_db\r\n", url);
         String content = this.geterrorprint(e3);
         this.writeErroFile("connSQLError_db", content, url);
         resultMap.put("error", "true");
         e3.printStackTrace();
      }

      try {
         pstmt = tconnection.prepareStatement(tcoreDiscoveryResult_sql.toString());
      } catch (SQLException e2) {
         this.writeFile("errormanage", "创建sql失败,非常严重," + formatter.format(new Date()) + ",createresultSQLError_db\r\n", url);
         String content = this.geterrorprint(e2);
         this.writeErroFile("createresultSQLError_db", content, url);
         resultMap.put("error", "true");
         e2.printStackTrace();
      }

      String selectDataType = discoveryTask.getCyfs();
      String hits = discoveryTask.getCys();
      String rate = discoveryTask.getPpl();
      List<TcoreTaskFindrule> regexByNamelist = new ArrayList();
      List<TcoreTaskFindrule> regexByContent = new ArrayList();

      for(int x = 0; x < discoveryRule.size(); ++x) {
         if ("1".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getFlag())) {
            regexByNamelist.add(new TcoreTaskFindrule(((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid(), ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea(), ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename(), ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex(), "", ((TcoreTaskFindrule)discoveryRule.get(x)).getRuleid()));
         } else if ("2".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getFlag())) {
            String discoveryway = "";
            String mixRule = "";
            String mixdataareaid = "";
            String mixdataarea = "";
            String mixrulename = "";
            if (!" ".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway()) && !"undefined".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway()) && ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway() != null && !"01".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
               if ("03".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
                  discoveryway = ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway();
                  List<TConsoleSearchregex> tConsoleSearchregexList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("name", ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename())});

                  for(int u = 0; u < tConsoleSearchregexList.size(); ++u) {
                     TcoreTaskFindrule tcoreTaskFindrule = new TcoreTaskFindrule();
                     tcoreTaskFindrule.setRegex(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getRegex());
                     tcoreTaskFindrule.setDataareaid(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDataarea_id());
                     tcoreTaskFindrule.setDataarea(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getType());
                     tcoreTaskFindrule.setRulename(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getName());
                     tcoreTaskFindrule.setDiscoverway(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDiscoverway());
                     tcoreTaskFindrule.setDictionaryClass(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getDictionaryClass());
                     tcoreTaskFindrule.setMatchingwaSy(((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getMatchingway());
                     regexByContent.add(tcoreTaskFindrule);
                  }
               } else if ("02".equals(((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway())) {
                  StringBuffer buf = new StringBuffer();
                  StringBuffer bufDataarea = new StringBuffer();
                  StringBuffer bufDataareaid = new StringBuffer();
                  StringBuffer bufRulename = new StringBuffer();
                  discoveryway = ((TcoreTaskFindrule)discoveryRule.get(x)).getDiscoverway();
                  List<TConsoleSearchregex> tConsoleSearchregexList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("name", ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename())});

                  for(int u = 0; u < tConsoleSearchregexList.size(); ++u) {
                     List<TCoreDataFileGroup> tCoreDataFileGroupList = this.tCoreDataFileGroupDao.queryAll(new Criterion[]{Restrictions.eq("searchregexid", ((TConsoleSearchregex)tConsoleSearchregexList.get(u)).getId())});

                     for(int i = 0; i < tCoreDataFileGroupList.size(); ++i) {
                        List<TConsoleSearchregex> tConsoleSearchregexList1 = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("type", ((TCoreDataFileGroup)tCoreDataFileGroupList.get(i)).getDatafilename())});

                        for(int z = 0; z < tConsoleSearchregexList1.size(); ++z) {
                           if ("1".equals(((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getDefaulttype())) {
                              String a = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getRegex();
                              String b = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getType();
                              String c = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getDataarea_id();
                              String d = ((TConsoleSearchregex)tConsoleSearchregexList1.get(z)).getName();
                              buf.append("_#_" + a);
                              bufRulename.append("_#_" + d);
                              bufDataareaid.append("_#_" + c);
                              bufDataarea.append("_#_" + b);
                           }
                        }
                     }
                  }

                  buf.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex());
                  bufDataarea.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea());
                  bufDataareaid.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid());
                  bufRulename.append("_#_" + ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename());
                  mixRule = buf.toString();
                  mixdataareaid = bufDataareaid.toString();
                  mixdataarea = bufDataarea.toString();
                  mixrulename = bufRulename.toString();
                  String[] regexlist = mixRule.split("_#_");

                  for(int i = 0; i < regexlist.length; ++i) {
                     TcoreTaskFindrule tcoreTaskFindrule = new TcoreTaskFindrule();
                     tcoreTaskFindrule.setRegex(mixRule.split("_#_")[i]);
                     tcoreTaskFindrule.setDataareaid(mixdataareaid.split("_#_")[i]);
                     tcoreTaskFindrule.setDataarea(mixdataarea.split("_#_")[i]);
                     tcoreTaskFindrule.setDataarea(mixrulename.split("_#_")[i]);
                     tcoreTaskFindrule.setMixdataarea(((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea());
                     tcoreTaskFindrule.setDiscoverway("02");
                     regexByContent.add(tcoreTaskFindrule);
                  }
               }
            } else {
               discoveryway = " ";
               mixRule = ((TcoreTaskFindrule)discoveryRule.get(x)).getRegex();
               mixdataareaid = ((TcoreTaskFindrule)discoveryRule.get(x)).getDataareaid();
               mixdataarea = ((TcoreTaskFindrule)discoveryRule.get(x)).getDataarea();
               mixrulename = ((TcoreTaskFindrule)discoveryRule.get(x)).getRulename();
               regexByContent.add(new TcoreTaskFindrule(mixdataareaid, mixdataarea, mixrulename, mixRule, discoveryway, ((TcoreTaskFindrule)discoveryRule.get(x)).getRuleid()));
            }
         }
      }

      String auth = datasystem.getIstargetdb();
      boolean flag = false;
      if ("on".equals(auth)) {
         flag = true;
      }

      MongoClient client = null;

      try {
         client = MongodbTool.connect(datasystem.getDbservername(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), flag);
      } catch (Exception e) {
         this.writeFile("errormanage", "mongodb连接异常,非常严重," + formatter.format(new Date()) + ",MongoDB_connect\r\n", url);
         String content = this.geterrorprint(e);
         this.writeErroFile("MongoDB_connect", content, url);
         e.printStackTrace();
      }

      if (client == null) {
         String content = "错误信息:" + datasystem.getDbip() + ",这个IP地址连接失败";
         this.writeFile("errormanage", "执行失败,非常严重," + formatter.format(new Date()) + ",connError_db\r\n", url);
         this.writeErroFile("connError_db", content, url);
         resultMap.put("error", "true");
         return null;
      } else {
         boolean isSelectData = this.isSelectData(hits, discoveryRule.size());
         String dbType = datasystem.getDbtype();
         CacheUtil.delCacheValue("taskstatus_" + discoveryTask.getId());
         long schemaIndex = 1L;
         int sureTable = 0;
         int sureColumn = 0;
         int tableSum = 0;
         int tableCount = discoveryColumn.size();
         int columnSum = 0;
         int cnt = 0;
         int cnt_correlation = 0;
         boolean result = false;
         CacheUtil.put(discoveryTask.getId() + "tableCount", tableCount);
         CacheUtil.delCacheValue("taskstatus_" + discoveryTask.getId());
         CacheUtil.delCacheValue("TdataDiscoveryIntelligence_list");
         CacheUtil.delCacheValue("TdataDiscoveryIntelligence_placeList");
         CacheUtil.delCacheValue("TdataDiscoveryIntelligence_columnNo");
         HashMap<String, List<String>> scMap = new HashMap();
         List<String> schemaslist = new ArrayList();

         for(int i = 0; i < discoveryColumn.size(); ++i) {
            List<String> tableLst = new ArrayList();
            String sc = ((TcoreDiscoveryColumn)discoveryColumn.get(i)).getTschema();
            if (null == scMap.get(sc)) {
               tableLst.add(((TcoreDiscoveryColumn)discoveryColumn.get(i)).getTablename());
               scMap.put(sc, tableLst);
               schemaslist.add(sc);
            } else {
               tableLst = (List)scMap.get(sc);
               tableLst.add(((TcoreDiscoveryColumn)discoveryColumn.get(i)).getTablename());
               scMap.put(sc, tableLst);
            }
         }

         List<Pattern> patternNameList = new ArrayList();
         List<Pattern> patternContentList = new ArrayList();

         for(TcoreTaskFindrule searchRegex : regexByNamelist) {
            patternNameList.add(Pattern.compile(searchRegex.getRegex()));
         }

         for(TcoreTaskFindrule searchRegex : regexByContent) {
            patternContentList.add(Pattern.compile(searchRegex.getRegex()));
         }

         for(String schema : schemaslist) {
            List<String> allTableListOfSchema = (List)scMap.get(schema);
            long tableIndex = 1L;
            String tabletemp = "";

            for(String tableName : allTableListOfSchema) {
               String columnameliststr = "";
               int placeNo = 0;
               Map<String, String> map = new HashMap();

               try {
                  map = MongodbTool.findAll(client, schema, tableName);
               } catch (Exception e1) {
                  this.writeFile("errormanage", "获取集合" + tableName + "内容失败,非常严重," + formatter.format(new Date()) + ",MongoDB_collection\r\n", url);
                  String content = this.geterrorprint(e1);
                  this.writeErroFile("MongoDB_collection", content, url);
                  e1.printStackTrace();
               }

               String content = (String)map.get("content");
               if (content.length() > 0) {
                  content = "[" + content.substring(0, content.length() - 1) + "]";
               }

               Map<String, List<String>> wjList = new HashMap();
               if (this.vlist.size() != 0 && this.vlist.contains("pool" + discoveryTask.getId())) {
                  break;
               }

               if (content.length() > 0) {
                  try {
                     ReadJsonTool.parseJSON2Map(wjList, content, "");
                  } catch (Exception e) {
                     e.printStackTrace();
                  }
               }

               ++tableIndex;
               ++tableSum;
               columnSum += wjList.size();
               this.writeFile("done", tableName + "," + schema + "," + formatter.format(new Date()) + "\r\n", url);
               this.redisService.set(discoveryTask.getId() + "tableSum", tableSum);
               if (wjList.size() > 0) {
                  int columncount = this.getNosqlSensitiveColumnsByContent(datasystem.getId(), datasystem.getSysname(), wjList, schema, rate, hits, regexByContent, patternContentList, sensitiveRule, projectid, discoveryTask.getId(), "none", isSelectData, tableName, pstmt, cnt, batcheSize, tconnection);
                  ++cnt;
                  sureColumn += columncount;
                  if (columncount > 0 && !tabletemp.equals(tableName)) {
                     ++sureTable;
                     tabletemp = tableName;
                  }
               } else {
                  try {
                     pstmt.setObject(1, datasystem.getId());
                     pstmt.setObject(2, schema);
                     pstmt.setObject(3, tableName);
                     pstmt.setObject(4, "");
                     pstmt.setObject(5, "");
                     pstmt.setObject(6, hits);
                     pstmt.setObject(7, "0");
                     pstmt.setObject(8, "0%");
                     pstmt.setObject(9, "");
                     pstmt.setObject(10, "");
                     pstmt.setObject(11, "");
                     pstmt.setObject(12, "");
                     pstmt.setObject(13, "0");
                     pstmt.setObject(14, "");
                     pstmt.setObject(15, "3");
                     pstmt.setObject(16, "");
                     pstmt.setObject(17, UUID.randomUUID().toString());
                     pstmt.addBatch();
                     ++cnt;
                     if (cnt % batcheSize == 0) {
                        long useTime1 = System.currentTimeMillis();
                        pstmt.executeBatch();
                        pstmt.clearBatch();
                        tconnection.commit();
                        long useTime2 = System.currentTimeMillis();
                        System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                     }
                  } catch (SQLException e) {
                     this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",pilinagew_bendi\r\n", url);
                     String content1 = this.geterrorprint(e);
                     this.writeErroFile("pilinagew_bendi", content1, url);
                     e.printStackTrace();
                  }
               }
            }

            ++schemaIndex;
         }

         try {
            pstmt.executeBatch();
            tconnection.commit();
            pstmt.close();
            tconnection.close();
         } catch (SQLException e) {
            this.writeFile("errormanage", "批处理失败,非常严重," + formatter.format(new Date()) + ",endpilinagfaild_db\r\n", url);
            String content = this.geterrorprint(e);
            this.writeErroFile("endpilinagfaild_db", content, url);
            resultMap.put("error", "true");
            e.printStackTrace();
         }

         SqlFileTool.exportSql(discoveryTask.getResultid());
         if (this.vlist.size() != 0 && this.vlist.contains("pool" + discoveryTask.getId())) {
            resultMap.put("isstop", "true");
         } else {
            resultMap.put("sureTable", String.valueOf(sureTable));
            resultMap.put("sureColumn", String.valueOf(sureColumn));
            resultMap.put("columnSum", String.valueOf(columnSum));
            resultMap.put("tableCount", String.valueOf(tableCount));
         }

         return resultMap;
      }
   }

   public static String specialCharactersReplace(String name) {
      String newname = name.replaceAll(" ", "");
      return newname;
   }

   public String delparentheses(String type) {
      if (null == type) {
         return "";
      } else if (type.indexOf("(") == -1) {
         return type;
      } else {
         type = type.indexOf("(") == -1 ? type : type.substring(0, type.indexOf("(")) + type.substring(type.indexOf(")") + 1, type.length());
         return this.delparentheses(type);
      }
   }

   public boolean isticket(String ticket, int maxLength) {
      boolean result = false;
      ticket = ticket.trim();
      if (null == this.phoneNoReplacePattern) {
         this.phoneNoReplacePattern = Pattern.compile("[^0-9]");
      }

      Matcher isnum = this.phoneNoReplacePattern.matcher(ticket);
      if (isnum.find()) {
         return false;
      } else {
         if (ticket.length() == 13) {
            if (null == this.ticketList) {
               this.ticketList = this.tConsoleDictionaryDao.queryValueByTypeCode("29");
            }

            if (this.ticketList.contains(ticket.substring(0, 3))) {
               result = true;
            }
         }

         return result;
      }
   }

   public void init() {
      this.zoneCodeList = null;
      this.singleFirstNameList = null;
      this.doubleFirstNameList = null;
      this.firstSixNumList = null;
      this.chineseAddressPattern = null;
      this.telephoneNoPattern = null;
      this.firstThreeNoList = null;
      this.companyNamePattern = null;
      this.shopNamePattern = null;
      this.postCodeList = null;
      this.ticketList = null;
      this.nationality = null;
      this.religionList = null;
      this.nationList = null;
      this.politicList = null;
      this.birthAddress = null;
      this.diplomapattern = null;
      this.diplomaList = null;
      this.diplomanoList = null;
      this.socialList = null;
      this.socialList1 = null;
   }

   public void deleteDirectory(String sPath) {
      if (!sPath.endsWith(File.separator)) {
         sPath = sPath + File.separator;
      }

      File dirFile = new File(sPath);
      if (dirFile.isDirectory()) {
         File[] files = dirFile.listFiles();

         for(int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
               File pic = new File(files[i].getAbsolutePath());
               if (pic.isFile() && pic.exists()) {
                  pic.delete();
               }
            }
         }
      }

   }

   public int getSensitiveColumnsByContentOfEs(String datasourceid, String datasourcename, String schema, Map<String, ArrayList> tableData, String tableName, String rate, String hits, List<TcoreTaskFindrule> searchRegexList, List<Pattern> patternList, String tcoreDiscoveryResult_sql, List<String> list_table, List<Map<String, Object>> sensitiveRule, String projectid, String taskid, PreparedStatement pstmt, int cnt, int batcheSize, Connection tconnection, boolean isIntelligence, int placeNo, String version, Map<String, String> remarkmap) {
      int count = 0;
      new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = props.getProperty("rateDir");
      String matchurl = url + "match" + File.separator + projectid + File.separator + taskid + File.separator + schema + File.separator + tableName + File.separator;
      String unmatchedurl = url + "unmatched" + File.separator + projectid + File.separator + taskid + File.separator + schema + File.separator + tableName + File.separator;
      String isrepeatvalue = props.get("isrepeatvalue").toString();
      String isRate = props.get("isRate").toString();
      int matchNum = 0;
      int unmatched = 0;
      int columnNo = 0;
      String cph = "湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领A-Z]{1}[A-Z]{1}[A-Z0-9]{4}[A-Z0-9挂学警港澳]{1}$";
      StringBuffer matchstr = new StringBuffer();
      StringBuffer unmatchstr = new StringBuffer();
      if ("1".equals(isRate)) {
         matchNum = Integer.parseInt(props.get("rateNum").toString());
         unmatched = matchNum;
      }

      try {
         Map<String, List<String>> columnValueMap = new HashMap();
         Map<String, Set<String>> columnDistinctValueMap = new HashMap();
         Map<String, List<String>> columnAllValueMap = new HashMap();
         int columnCount = tableData.size();
         long rowCount = 0L;
         Map<String, Long> nullOrEmptyCount = new HashMap();
         List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList = this.tCoreEncryptionTypeFieldDao.getTCoreEncryptionTypeField(tableName, schema, datasourceid);
         new ArrayList();
         new TCoreEncryption();
         new TCoreSecretkey();
         HashMap<String, String> fieldSecretMap = new HashMap();
         HashMap<String, String> fieldtypeMap = new HashMap();
         HashMap<String, String> isLikeMap = new HashMap();
         HashMap<String, String> keepFirstMap = new HashMap();
         HashMap<String, String> encDigitMap = new HashMap();
         HashMap<String, String> twoindexmap = new HashMap();

         for(TCoreEncryptionTypeField t : tCoreEncryptionTypeFieldList) {
            if ("5".equals(t.getFlag())) {
               TCoreSecretkey secretKey = (TCoreSecretkey)this.tCoreSecretkeyDao.get(t.getEncryption_secretkey_id());
               fieldSecretMap.put(t.getTable_field_id(), secretKey.getSectet_key_value());
               isLikeMap.put(t.getTable_field_id(), t.getIslike());
               keepFirstMap.put(t.getTable_field_id(), t.getKeepfirst());
               encDigitMap.put(t.getTable_field_id(), t.getEncdigit());
               twoindexmap.put(t.getTable_field_id(), t.getTwoindex());
               TCoreEncryption tCoreEncryption = (TCoreEncryption)this.tCoreEncryptionDao.get(secretKey.getEncryption_id());
               String encryption_type = tCoreEncryption.getEncryption_type();
               fieldtypeMap.put(t.getTable_field_id(), encryption_type);
            }
         }

         for(Map.Entry<String, ArrayList> entry : tableData.entrySet()) {
            String key = (String)entry.getKey();
            ArrayList valueList = (ArrayList)entry.getValue();
            if (valueList != null) {
               columnValueMap.put(key, new ArrayList());
               columnDistinctValueMap.put(key, new HashSet());
               columnAllValueMap.put(key, new ArrayList());
               nullOrEmptyCount.put(key, 0L);

               for(int i = 0; i < valueList.size(); ++i) {
                  Object columnValueObj = null;
                  columnValueObj = valueList.get(i);
                  if (columnValueObj != null) {
                     String columnValue = columnValueObj.toString();
                     if (fieldSecretMap.containsKey(key)) {
                        if (columnValue != null) {
                           String fieldSecretKey = (String)fieldSecretMap.get(key);
                           String encryptionType = (String)fieldtypeMap.get(key);
                           columnValue = EncProvider.decryptEcb(encryptionType, fieldSecretKey, columnValue, (String)isLikeMap.get(key), (String)keepFirstMap.get(key), (String)encDigitMap.get(key), (String)twoindexmap.get(key));
                        } else {
                           columnValue = null;
                        }
                     }

                     if (columnValueObj instanceof ArrayList) {
                        columnValue = "";
                     }

                     if (!"".equals(columnValue.trim())) {
                        ((List)columnValueMap.get(key)).add(columnValue);
                        ((Set)columnDistinctValueMap.get(key)).add(columnValue);
                     } else {
                        nullOrEmptyCount.put(key, (Long)nullOrEmptyCount.get(key) + 1L);
                     }

                     ((List)columnAllValueMap.get(key)).add(columnValue);
                  } else {
                     nullOrEmptyCount.put(key, (Long)nullOrEmptyCount.get(key) + 1L);
                     ((List)columnAllValueMap.get(key)).add(null);
                  }

                  ++rowCount;
               }
            }
         }

         if (rowCount > 0L) {
            for(Map.Entry<String, ArrayList> fieldEntry : tableData.entrySet()) {
               String columnname = (String)fieldEntry.getKey();
               List<String> columnValues = new ArrayList();
               SensitiveColumn column;
               if (fieldEntry.getValue() != null) {
                  long validCount = rowCount - (nullOrEmptyCount.get(columnname) == null ? 0L : (Long)nullOrEmptyCount.get(columnname));
                  double distinctCount = (double)((Set)columnDistinctValueMap.get(columnname)).size();
                  column = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, validCount, (long)distinctCount);
                  columnValues = (List)columnValueMap.get(columnname);
                  List dataarea_id = (List)columnAllValueMap.get(columnname);
               } else {
                  column = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, 0L, 0L);
               }

               long maxMatchCount = 0L;
               List<String> maxMatchValues = null;
               List<String> maxNotMathValues = null;
               String dataarea_id = "";
               String dataarea_name = "";
               String issure = "0";
               String tschemas = column.getSchema();
               String fields = column.getColumnName();
               String fieldremark = (String)remarkmap.get(column.getColumnName());
               String matching = rate;
               String sensitive_id = "";
               String sensitive_name = "";
               String teffe_sampling = "";
               NumberFormat nf = NumberFormat.getInstance();
               Number m = nf.parse(rate);
               if (null != columnValues && columnValues.size() != 0 && fieldEntry.getValue() != null) {
                  int patternIndex = 0;

                  for(Pattern pattern : patternList) {
                     matchstr.setLength(0);
                     unmatchstr.setLength(0);
                     if ("1".equals(isRate)) {
                        matchNum = Integer.parseInt(props.get("rateNum").toString());
                        unmatched = matchNum;
                     }

                     TcoreTaskFindrule searchRegex = (TcoreTaskFindrule)searchRegexList.get(patternIndex++);
                     String dataareaid = searchRegex.getDataareaid();
                     String regexType = searchRegex.getDataarea();
                     String ruleid = searchRegex.getRuleid();
                     String regexName = searchRegex.getRulename();
                     String disoverway = searchRegex.getDiscoverway();
                     String dictionaryClass = searchRegex.getDictionaryClass();
                     String matchingway = searchRegex.getMatchingwaSy();
                     String mixdataarea = searchRegex.getMixdataarea();
                     int level = 0;
                     long matchCount = 0L;
                     long nomatchCount = 0L;
                     List<String> tempMatchValues = new ArrayList();
                     List<String> matchValues = new ArrayList();
                     List<String> notMatchValues = new ArrayList();
                     Map<String, Integer> namerepeatmap = new HashMap();
                     if (pattern.pattern().startsWith("MethodName:")) {
                        String methodName = pattern.pattern().substring(11);
                        int maxLength = -1;
                        if (methodName.contains("MaxLength:")) {
                           if (methodName.contains("Weight:")) {
                              String[] parameters = methodName.split("\\|MaxLength:");
                              if (parameters.length == 2) {
                                 methodName = parameters[0];
                                 String[] Weight = parameters[1].split("\\|Weight:");
                                 maxLength = Integer.parseInt(Weight[0]);

                                 try {
                                    level = Integer.parseInt(Weight[1]);
                                 } catch (Exception var114) {
                                    level = 0;
                                 }
                              }
                           } else {
                              String[] parameters = methodName.split("\\|MaxLength:");
                              if (parameters.length == 2) {
                                 methodName = parameters[0];
                                 maxLength = Integer.parseInt(parameters[1]);
                              }
                           }
                        }

                        for(String val : columnValues) {
                           if (this.matches(methodName, maxLength, val, level)) {
                              ++matchCount;
                              matchValues.add(val);
                              if ("姓名".equals(regexType)) {
                                 Integer integer = (Integer)namerepeatmap.get(val);
                                 namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                              }

                              tempMatchValues.add(regexType + ":" + val);
                              if (matchNum > 0) {
                                 matchstr.append(val + "\r\n");
                                 --matchNum;
                              }
                           } else {
                              ++nomatchCount;
                              notMatchValues.add(val);
                              if (unmatched > 0) {
                                 unmatchstr.append(val + "\r\n");
                                 --unmatched;
                              }
                           }
                        }
                     } else if ("03".equals(disoverway)) {
                        List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryDictionaryFile(dictionaryClass);

                        for(String val : columnValues) {
                           if (this.dicmatch(list, matchingway, val)) {
                              ++matchCount;
                              matchValues.add(val);
                              if ("姓名".equals(regexType)) {
                                 Integer integer = (Integer)namerepeatmap.get(val);
                                 namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                              }

                              tempMatchValues.add(regexType + ":" + val);
                              if (matchNum > 0) {
                                 matchstr.append(val + "\r\n");
                                 --matchNum;
                              }
                           } else {
                              ++nomatchCount;
                              notMatchValues.add(val);
                              if (unmatched > 0) {
                                 unmatchstr.append(val + "\r\n");
                                 --unmatched;
                              }
                           }
                        }
                     } else {
                        for(String val : columnValues) {
                           if (pattern.matcher(val).matches()) {
                              ++matchCount;
                              matchValues.add(val);
                              if ("姓名".equals(regexType)) {
                                 Integer integer = (Integer)namerepeatmap.get(val);
                                 namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                              }

                              tempMatchValues.add(regexType + ":" + val);
                              if (matchNum > 0) {
                                 matchstr.append(val + "\r\n");
                                 --matchNum;
                              }
                           } else {
                              ++nomatchCount;
                              notMatchValues.add(val);
                              if (unmatched > 0) {
                                 unmatchstr.append(val + "\r\n");
                                 --unmatched;
                              }
                           }
                        }
                     }

                     if (matchstr.length() > 0) {
                        this.writeFileRefresh(columnname, matchstr.toString(), matchurl);
                     } else {
                        this.writeFileRefresh(columnname, "", matchurl);
                     }

                     if (unmatchstr.length() > 0) {
                        this.writeFileRefresh(columnname, unmatchstr.toString(), unmatchedurl);
                     } else {
                        this.writeFileRefresh(columnname, "", unmatchedurl);
                     }

                     boolean isrepeatdata = true;
                     if ("姓名".equals(regexType)) {
                        Integer matchValuessize = (int)((double)matchValues.size() * Double.parseDouble(isrepeatvalue));

                        for(Map.Entry<String, Integer> entry : namerepeatmap.entrySet()) {
                           if ((Integer)entry.getValue() > matchValuessize) {
                              isrepeatdata = false;
                              break;
                           }
                        }
                     }

                     if (columnValues.size() > Integer.parseInt(hits)) {
                        teffe_sampling = hits;
                     } else {
                        teffe_sampling = String.valueOf(columnValues.size());
                     }

                     NumberFormat numberFormat = NumberFormat.getInstance();
                     numberFormat.setMaximumFractionDigits(2);
                     String result = numberFormat.format((double)((float)matchCount / (float)columnValues.size() * 100.0F));
                     matching = result + "%";
                     if ((double)matchCount / (double)columnValues.size() >= m.doubleValue() / (double)100.0F) {
                        if (isrepeatdata) {
                           column.setMatchResult(regexType, regexName, (long)matchValues.size(), matchValues, notMatchValues);
                        }

                        (new StringBuilder()).append(schema).append("_m").append(tableName).append("_m").append(columnname).toString();
                        HashMap<String, List<String>> keyhash = new HashMap();
                        List<String> matchValuesList = new ArrayList();
                        List<String> notMatchValuesList = new ArrayList();
                        if (matchValues.size() > 100) {
                           matchValuesList.addAll(matchValues.subList(0, 100));
                        } else if (matchValues.size() != 0) {
                           matchValuesList.addAll(matchValues.subList(0, matchValues.size()));
                        }

                        if (notMatchValues.size() > 100) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                        } else if (notMatchValues.size() != 0) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                        }

                        keyhash.put("matchValues", matchValuesList);
                        keyhash.put("notMatchValues", notMatchValuesList);
                        dataarea_id = dataareaid;
                        dataarea_name = regexType;
                        if (disoverway == "02") {
                           dataarea_name = mixdataarea;
                        }

                        for(int x = 0; x < sensitiveRule.size(); ++x) {
                           if (dataareaid.equals(((Map)sensitiveRule.get(x)).get("dataarea_id"))) {
                              sensitive_id = ((Map)sensitiveRule.get(x)).get("rule_id").toString();
                              sensitive_name = ((Map)sensitiveRule.get(x)).get("name").toString();
                           }
                        }

                        ++count;
                        if (!isIntelligence || !pattern.pattern().startsWith("MethodName:") || !pattern.pattern().substring(11).contains("isPersonName") && !pattern.pattern().substring(11).contains("isMobilephoneNo") && !pattern.pattern().substring(11).contains("isIdentifyNo") && !pattern.pattern().substring(11).contains("isCardNo") && !pattern.pattern().substring(11).contains(cph)) {
                           break;
                        }

                        List<String> placeList = (List)CacheUtil.getCacheValue("TdataDiscoveryIntelligence_placeList_" + tableName);
                        if (placeList != null) {
                           placeList.add(String.valueOf(columnNo));
                        }

                        CacheUtil.put("TdataDiscoveryIntelligence_placeList_" + tableName, placeList);
                        break;
                     }

                     if (maxMatchCount < matchCount) {
                        maxMatchCount = matchCount;
                        maxMatchValues = tempMatchValues;
                        maxNotMathValues = notMatchValues;
                     }
                  }

                  if (!column.isSensitiveColumn()) {
                     if (maxMatchCount > 0L) {
                        column.setMatchCount(maxMatchCount);
                        column.setMatchValues(maxMatchValues);
                        column.setNotMatchValues(maxNotMathValues);
                     } else {
                        column.setNotMatchValues(columnValues);
                     }
                  }

                  pstmt.setObject(1, datasourceid);
                  pstmt.setObject(2, tschemas);
                  pstmt.setObject(3, tableName);
                  pstmt.setObject(4, fields);
                  pstmt.setObject(5, fieldremark);
                  pstmt.setObject(6, hits);
                  pstmt.setObject(7, teffe_sampling);
                  pstmt.setObject(8, matching);
                  pstmt.setObject(9, dataarea_id);
                  pstmt.setObject(10, dataarea_name);
                  pstmt.setObject(11, sensitive_id);
                  pstmt.setObject(12, sensitive_name);
                  pstmt.setObject(13, issure);
                  pstmt.setObject(14, "");
                  pstmt.setObject(15, "");
                  pstmt.setObject(16, "");
                  pstmt.setObject(17, UUID.randomUUID().toString());
                  pstmt.addBatch();
                  if (cnt % batcheSize == 0) {
                     long useTime1 = System.currentTimeMillis();
                     pstmt.executeBatch();
                     pstmt.clearBatch();
                     tconnection.commit();
                     long useTime2 = System.currentTimeMillis();
                     System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                  }
               } else {
                  pstmt.setObject(1, datasourceid);
                  pstmt.setObject(2, tschemas);
                  pstmt.setObject(3, tableName);
                  pstmt.setObject(4, fields);
                  pstmt.setObject(5, fieldremark);
                  pstmt.setObject(6, hits);
                  pstmt.setObject(7, "0");
                  pstmt.setObject(8, "0%");
                  pstmt.setObject(9, dataarea_id);
                  pstmt.setObject(10, dataarea_name);
                  pstmt.setObject(11, sensitive_id);
                  pstmt.setObject(12, sensitive_name);
                  pstmt.setObject(13, issure);
                  pstmt.setObject(14, "");
                  pstmt.setObject(15, "");
                  pstmt.setObject(16, "");
                  pstmt.setObject(17, UUID.randomUUID().toString());
                  pstmt.addBatch();
               }
            }

            return count;
         } else {
            for(Map.Entry<String, ArrayList> entry : tableData.entrySet()) {
               String columnname = (String)entry.getKey();

               try {
                  pstmt.setObject(1, datasourceid);
                  pstmt.setObject(2, schema);
                  pstmt.setObject(3, tableName);
                  pstmt.setObject(4, columnname);
                  pstmt.setObject(5, "");
                  pstmt.setObject(6, "0");
                  pstmt.setObject(7, "0");
                  pstmt.setObject(8, "0%");
                  pstmt.setObject(9, "");
                  pstmt.setObject(10, "");
                  pstmt.setObject(11, "");
                  pstmt.setObject(12, "");
                  pstmt.setObject(13, "0");
                  pstmt.setObject(14, "");
                  pstmt.setObject(15, "");
                  pstmt.setObject(16, "");
                  pstmt.setObject(17, UUID.randomUUID().toString());
                  pstmt.addBatch();
                  ++cnt;
                  if (cnt % batcheSize == 0) {
                     long useTime1 = System.currentTimeMillis();
                     pstmt.executeBatch();
                     pstmt.clearBatch();
                     tconnection.commit();
                     long useTime2 = System.currentTimeMillis();
                     System.out.println(cnt + "条数据，提交sql处理时间：" + (useTime2 - useTime1));
                  }
               } catch (SQLException e) {
                  e.printStackTrace();

                  try {
                     tconnection.rollback();
                  } catch (SQLException ex) {
                     ex.printStackTrace();
                  }
               }
            }

            boolean var122 = false;
            return count;
         }
      } catch (Exception e) {
         this.tdataDiscoveryService.updateTaskstatus(taskid, "2", version);
         e.printStackTrace();
         return count;
      } finally {
         ;
      }
   }
}
