package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.TCoreReleasecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.chars.TCoreChartsEightDao;
import com.chenyang.nse.bussiness.dao.table.core.chars.TCoreChartsFiveDao;
import com.chenyang.nse.bussiness.dao.table.core.chars.TCoreChartsFourDao;
import com.chenyang.nse.bussiness.dao.table.core.chars.TCoreChartsOneDao;
import com.chenyang.nse.bussiness.dao.table.core.chars.TCoreChartsSevenDao;
import com.chenyang.nse.bussiness.dao.table.core.chars.TCoreChartsSixDao;
import com.chenyang.nse.bussiness.dao.table.core.chars.TCoreChartsThreeDao;
import com.chenyang.nse.bussiness.dao.table.core.chars.TCoreChartsTwoDao;
import com.chenyang.nse.bussiness.dao.table.core.project.TCoreProjectDao;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsersys;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsEight;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsFive;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsFour;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsOne;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsSeven;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsSix;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsThree;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsTwo;
import com.chenyang.nse.bussiness.entity.orm.table.core.project.TCoreProjectInfo;
import com.chenyang.nse.bussiness.entity.vo.Releasecolumn;
import com.chenyang.nse.bussiness.service.console.UserService;
import com.chenyang.nse.bussiness.service.core.CoreProjectService;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CoreProjectServiceImpl implements CoreProjectService {
   @Autowired
   private TCoreProjectDao tCoreProjectDao;
   @Autowired
   private HttpServletRequest request;
   @Autowired
   private UserService userService;
   @Autowired
   private TCoreChartsOneDao tCoreChartsOneDao;
   @Autowired
   private TCoreChartsTwoDao tCoreChartsTwoDao;
   @Autowired
   private TCoreChartsThreeDao tCoreChartsThreeDao;
   @Autowired
   private TCoreChartsFourDao tCoreChartsFourDao;
   @Autowired
   private TCoreChartsFiveDao tCoreChartsFiveDao;
   @Autowired
   private TCoreChartsSixDao tCoreChartsSixDao;
   @Autowired
   private TCoreChartsSevenDao tCoreChartsSevenDao;
   @Autowired
   private TCoreChartsEightDao tCoreChartsEightDao;
   @Autowired
   private TCoreReleasecolumnDao tCoreReleasecolumnDao;

   public List<TCoreProjectInfo> query(String flag) {
      new ArrayList();
      List<TCoreProjectInfo> list;
      if (StringTool.emptyOrNull(flag)) {
         list = this.tCoreProjectDao.queryAll(Order.desc("createtime"), new Criterion[0]);
      } else {
         list = this.tCoreProjectDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("flag", flag)});
      }

      Object obj = this.request.getSession().getAttribute("loginUser");
      LoginUser loginUser = null;
      if (obj != null) {
         loginUser = (LoginUser)obj;
      }

      List<TBaseUsersys> userSysLst = this.userService.queryusersysbyuserid(loginUser.getTsysUser().getId());
      Map<String, String> sysMap = new HashMap();

      for(TBaseUsersys usrsys : userSysLst) {
         sysMap.put(usrsys.getSysid(), "");
      }

      List<TCoreProjectInfo> reList = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         if (sysMap.containsKey(((TCoreProjectInfo)list.get(i)).getId())) {
            reList.add(list.get(i));
         }
      }

      return reList;
   }

   public List<TCoreProjectInfo> queryAll(PageInfo pageInfo, String projectname) {
      return this.tCoreProjectDao.queryByPageInfo(pageInfo, Order.desc("updatetime"), new Criterion[]{Restrictions.like("projectname", projectname + "%")});
   }

   public List<TCoreProjectInfo> queryById(String id) {
      Criterion criterion = Restrictions.eq("id", id);
      return this.tCoreProjectDao.queryAll(new Criterion[]{criterion});
   }

   public void removeAllChat(String projectname) {
      SimpleExpression ca = Restrictions.eq("projectid", projectname);
      this.tCoreChartsOneDao.remove(new Criterion[]{ca});
      this.tCoreChartsTwoDao.remove(new Criterion[]{ca});
      this.tCoreChartsThreeDao.remove(new Criterion[]{ca});
      this.tCoreChartsFourDao.remove(new Criterion[]{ca});
      this.tCoreChartsFiveDao.remove(new Criterion[]{ca});
      this.tCoreChartsSixDao.remove(new Criterion[]{ca});
      this.tCoreChartsSevenDao.remove(new Criterion[]{ca});
      this.tCoreChartsEightDao.remove(new Criterion[]{ca});
   }

   public List<Releasecolumn> queryTcoreReleasecolumn(String projectid, String table) {
      return this.tCoreReleasecolumnDao.queryTcoreReleasecolumn(projectid, table);
   }

   public void save(TCoreProjectInfo tCoreProjectInfo) {
      this.tCoreProjectDao.save(tCoreProjectInfo);
   }

   public void remove(String id) {
      this.tCoreProjectDao.removeById(id);
   }

   public void createsqlstr(StringBuilder sql) {
      this.tCoreProjectDao.createsqlstr(sql);
   }

   public void saveTCoreChartsOne(TCoreChartsOne tCoreChartsOne) {
      this.tCoreChartsOneDao.save(tCoreChartsOne);
   }

   public void saveTCoreChartsTwo(TCoreChartsTwo tCoreChartsTwo) {
      this.tCoreChartsTwoDao.save(tCoreChartsTwo);
   }

   public void saveTCoreChartsThree(TCoreChartsThree tCoreChartsThree) {
      this.tCoreChartsThreeDao.save(tCoreChartsThree);
   }

   public void saveTCoreChartsFour(TCoreChartsFour tCoreChartsFour) {
      this.tCoreChartsFourDao.save(tCoreChartsFour);
   }

   public void saveTCoreChartsFive(TCoreChartsFive tCoreChartsFive) {
      this.tCoreChartsFiveDao.save(tCoreChartsFive);
   }

   public void saveTCoreChartsSix(TCoreChartsSix tCoreChartsSix) {
      this.tCoreChartsSixDao.save(tCoreChartsSix);
   }

   public void saveTCoreChartsSeven(TCoreChartsSeven tCoreChartsSeven) {
      this.tCoreChartsSevenDao.save(tCoreChartsSeven);
   }

   public void saveTCoreChartsEight(TCoreChartsEight tCoreChartseight) {
      this.tCoreChartsEightDao.save(tCoreChartseight);
   }

   public List<TCoreProjectInfo> queryAll() {
      return this.tCoreProjectDao.queryAll();
   }

   public List<TCoreChartsTwo> queryTCoreChartsTwo(List<String> projectidlist) {
      return this.tCoreChartsTwoDao.queryAll(new Criterion[]{Restrictions.in("projectid", projectidlist)});
   }

   public List<TCoreChartsThree> queryTCoreChartsThree(List<String> projectidlist) {
      return this.tCoreChartsThreeDao.queryAll(new Criterion[]{Restrictions.in("projectid", projectidlist)});
   }

   public List<TCoreChartsFour> queryTCoreChartsFour(List<String> projectidlist) {
      return this.tCoreChartsFourDao.queryAll(new Criterion[]{Restrictions.in("projectid", projectidlist)});
   }

   public List<TCoreChartsFive> queryTCoreChartsFive(List<String> projectidlist) {
      return this.tCoreChartsFiveDao.queryAll(new Criterion[]{Restrictions.in("projectid", projectidlist)});
   }

   public List<TCoreChartsSix> queryTCoreChartsSix(List<String> projectidlist) {
      return this.tCoreChartsSixDao.queryAll(new Criterion[]{Restrictions.in("projectid", projectidlist)});
   }

   public List<TCoreChartsOne> queryTCoreChartsOne(List<String> projectidlist) {
      return this.tCoreChartsOneDao.queryAll(new Criterion[]{Restrictions.in("projectid", projectidlist)});
   }

   public void removeByProjectid(String projectid) {
      this.tCoreChartsOneDao.remove(new Criterion[]{Restrictions.eq("projectid", projectid)});
      this.tCoreChartsTwoDao.remove(new Criterion[]{Restrictions.eq("projectid", projectid)});
      this.tCoreChartsThreeDao.remove(new Criterion[]{Restrictions.eq("projectid", projectid)});
      this.tCoreChartsFourDao.remove(new Criterion[]{Restrictions.eq("projectid", projectid)});
      this.tCoreChartsFiveDao.remove(new Criterion[]{Restrictions.eq("projectid", projectid)});
      this.tCoreChartsSixDao.remove(new Criterion[]{Restrictions.eq("projectid", projectid)});
      this.tCoreChartsSevenDao.remove(new Criterion[]{Restrictions.eq("projectid", projectid)});
      this.tCoreChartsEightDao.remove(new Criterion[]{Restrictions.eq("projectid", projectid)});
   }

   public List<TCoreChartsEight> queryTCoreChartsEight(List<String> projectidlist) {
      return this.tCoreChartsEightDao.queryAll(new Criterion[]{Restrictions.in("projectid", projectidlist)});
   }

   public List<TCoreChartsSeven> queryTCoreChartsSeven(List<String> projectidlist) {
      return this.tCoreChartsSevenDao.queryAll(new Criterion[]{Restrictions.in("projectid", projectidlist)});
   }

   public void update(TCoreProjectInfo tCoreProjectInfo) {
      this.tCoreProjectDao.saveOrUpdate(tCoreProjectInfo);
   }

   public TCoreProjectInfo queryProjectByProjectId(String projectid) {
      return (TCoreProjectInfo)this.tCoreProjectDao.queryUnique(new Criterion[]{Restrictions.eq("realprojectname", projectid)});
   }

   public List<TCoreProjectInfo> queryByName(String projectname) {
      return this.tCoreProjectDao.queryAll(new Criterion[]{Restrictions.eq("projectname", projectname)});
   }
}
