package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.view.TNumDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.view.TNumDescriptionDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.view.TNumProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.view.TNumSchemaDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.view.TNumTableDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TNumDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TNumDescription;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TNumProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TNumSchema;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TNumTable;
import com.chenyang.nse.bussiness.service.core.DataScopeCharsService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DataScopeCharsServiceImpl implements DataScopeCharsService {
   @Autowired
   private TNumProjectDao tNumProjectDao;
   @Autowired
   private TNumDescriptionDao tNumDescriptionDao;
   @Autowired
   private TNumDatasystemDao tNumDatasystemDao;
   @Autowired
   private TNumSchemaDao tNumSchemaDao;
   @Autowired
   private TNumTableDao tNumTableDao;
   @Autowired
   private RedisService redisService;

   public List<TNumProject> getProjectlistRuleReport(PageInfo pageInfo, String project_name, String type) {
      List<TNumProject> list = this.tNumProjectDao.queryByPageInfo(pageInfo, Order.asc("project_name"), new Criterion[]{Restrictions.eq("description_type", type), Restrictions.like("project_name", "%" + project_name + "%")});
      return list;
   }

   public List<TNumDescription> getDescriptionlistRuleReport(PageInfo pageInfo, String project_name, String description_name, String type) {
      new ArrayList();
      List list;
      if ("null".equals(project_name)) {
         list = this.tNumDescriptionDao.queryByPageInfo(pageInfo, Order.asc("description_name"), new Criterion[]{Restrictions.eq("description_type", type)});
      } else {
         list = this.tNumDescriptionDao.queryByPageInfo(pageInfo, Order.asc("description_name"), new Criterion[]{Restrictions.eq("project_name", project_name), Restrictions.eq("description_type", type), Restrictions.like("description_name", "%" + description_name + "%")});
      }

      return list;
   }

   public List<TNumDatasystem> getDatasystemlistRuleReport(PageInfo pageInfo, String project_name, String description_name, String datasystem_name, String type) {
      new ArrayList();
      List list;
      if ("null".equals(project_name)) {
         list = this.tNumDatasystemDao.queryByPageInfo(pageInfo, Order.asc("datasystem_name"), new Criterion[]{Restrictions.eq("description_name", description_name), Restrictions.eq("description_type", type), Restrictions.like("datasystem_name", "%" + datasystem_name + "%")});
      } else {
         list = this.tNumDatasystemDao.queryByPageInfo(pageInfo, Order.asc("datasystem_name"), new Criterion[]{Restrictions.eq("project_name", project_name), Restrictions.eq("description_name", description_name), Restrictions.eq("description_type", type), Restrictions.like("datasystem_name", "%" + datasystem_name + "%")});
      }

      return list;
   }

   public List<TNumSchema> getSchemalistRuleReport(PageInfo pageInfo, String project_name, String description_name, String datasystem_name, String schema_name, String type) {
      new ArrayList();
      List list;
      if ("null".equals(project_name)) {
         list = this.tNumSchemaDao.queryByPageInfo(pageInfo, Order.asc("schema_name"), new Criterion[]{Restrictions.eq("description_name", description_name), Restrictions.eq("datasystem_name", datasystem_name), Restrictions.eq("description_type", type), Restrictions.like("schema_name", "%" + schema_name + "%")});
      } else {
         list = this.tNumSchemaDao.queryByPageInfo(pageInfo, Order.asc("schema_name"), new Criterion[]{Restrictions.eq("project_name", project_name), Restrictions.eq("description_name", description_name), Restrictions.eq("datasystem_name", datasystem_name), Restrictions.eq("description_type", type), Restrictions.like("schema_name", "%" + schema_name + "%")});
      }

      return list;
   }

   public List<TNumTable> getTablelistRuleReport(PageInfo pageInfo, String project_name, String description_name, String datasystem_name, String schema_name, String table_name, String type) {
      new ArrayList();
      List list;
      if ("null".equals(project_name)) {
         list = this.tNumTableDao.queryByPageInfo(pageInfo, Order.asc("table_name"), new Criterion[]{Restrictions.eq("description_name", description_name), Restrictions.eq("datasystem_name", datasystem_name), Restrictions.eq("schema_name", schema_name), Restrictions.eq("description_type", type), Restrictions.like("table_name", "%" + table_name + "%")});
      } else {
         list = this.tNumTableDao.queryByPageInfo(pageInfo, Order.asc("table_name"), new Criterion[]{Restrictions.eq("project_name", project_name), Restrictions.eq("description_name", description_name), Restrictions.eq("datasystem_name", datasystem_name), Restrictions.eq("schema_name", schema_name), Restrictions.eq("description_type", type), Restrictions.like("table_name", "%" + table_name + "%")});
      }

      return list;
   }
}
