package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.console.engine.TConsoleEnginePropertyDao;
import com.chenyang.nse.bussiness.dao.table.console.engine.TConsoleEnginePropertyvalueDao;
import com.chenyang.nse.bussiness.dao.table.console.engine.TConsoleEngineTypeDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.engine.TConsoleEnginePropertyvalue;
import com.chenyang.nse.bussiness.entity.orm.table.console.engine.TConsoleEngineType;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.vo.engine.EnginePropertyVO;
import com.chenyang.nse.bussiness.service.core.EngineService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EngineServiceImpl implements EngineService {
   @Autowired
   private TConsoleEngineTypeDao tConsoleEngineTypeDao;
   @Autowired
   private TConsoleEnginePropertyDao tConsoleEnginePropertyDao;
   @Autowired
   private TConsoleEnginePropertyvalueDao tTConsoleEnginePropertyvalueDao;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;

   public void save(TCoreEngine engine) {
      if ("".equals(engine.getId().trim())) {
         engine.setId((String)null);
      }

      this.tCoreEngineDao.saveOrUpdate(engine);
      this.tTConsoleEnginePropertyvalueDao.remove(new Criterion[]{Restrictions.eq("engineid", engine.getId())});

      for(EnginePropertyVO item : engine.getEngineproperty()) {
         this.tTConsoleEnginePropertyvalueDao.save(new TConsoleEnginePropertyvalue(item.getPropertyid(), item.getPropertyvalue(), engine.getId()));
      }

   }

   public void remove(String id) {
      this.tTConsoleEnginePropertyvalueDao.remove(new Criterion[]{Restrictions.eq("engineid", id)});
      this.tCoreEngineDao.removeById(id);
   }

   public String testConnect(String engineid) {
      return null;
   }

   public List<TCoreEngine> queryAllEngine() {
      List<TCoreEngine> list = this.tCoreEngineDao.queryAll();

      for(TCoreEngine item : list) {
         TConsoleEngineType enginetype = (TConsoleEngineType)this.tConsoleEngineTypeDao.get(item.getEnginetypeid());
         item.setEnginetype(enginetype);
         List<EnginePropertyVO> propertylist = this.engineDao.queryEngineProperty(item.getId());
         item.setEngineproperty(propertylist);
      }

      return list;
   }

   public TCoreEngine queryEngineById(String engineid) {
      TCoreEngine engine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      TConsoleEngineType enginetype = (TConsoleEngineType)this.tConsoleEngineTypeDao.get(engine.getEnginetypeid());
      engine.setEnginetype(enginetype);
      List<EnginePropertyVO> propertylist = this.engineDao.queryEngineProperty(engine.getId());
      engine.setEngineproperty(propertylist);
      return engine;
   }

   public List<EnginePropertyVO> queryPropertyValue(String engineid) {
      List<EnginePropertyVO> propertylist = this.engineDao.queryEngineProperty(engineid);
      return propertylist;
   }
}
