package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.console.mapping.TConsoleDatamappingInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreFileSysGroupDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructureDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructureGroupDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurespliterDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurewidthDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingFilesystemDao;
import com.chenyang.nse.bussiness.dto.FilestructureDTO;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreFileSysGroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructureGroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurespliter;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurewidth;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingFilesystem;
import com.chenyang.nse.bussiness.entity.param.filesystem.DemoFileImportParam;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.enumeration.file.ColumnType;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import com.chenyang.nse.bussiness.service.core.FileSystemService;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FileSystemServiceImpl implements FileSystemService {
   private static final Logger logger = LoggerFactory.getLogger(FileSystemServiceImpl.class);
   @Autowired
   private TCoreFileStructurecolumnDao tCoreFileStructurecolumnDao;
   @Autowired
   private TCoreFileStructureDao tCoreFileStructureDao;
   @Autowired
   private TCoreFileSysGroupDao tCoreFileSysGroupDao;
   @Autowired
   private TCoreFileStructurespliterDao tCoreFileStructurespliterDao;
   @Autowired
   private TCoreFileStructurewidthDao tCoreFileStructurewidthDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreMaskingFilesystemDao tCoreMaskingFilesystemDao;
   @Autowired
   private TConsoleDatamappingInfoDao tConsoleDatamappingInfoDao;
   @Autowired
   private TCoreFileStructureGroupDao tCoreFileStructureGroupDao;
   @Autowired
   private DesensitizationDataMappingService desensitizationdataMappingService;
   @Autowired
   private SessionFactory sessionFactory;

   public Connection getConnectionByDataSystemId(String datasystemid) {
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
      String dbcode = datasystem.getDbtype();
      String ip = datasystem.getDbip();
      String port = datasystem.getDbport();
      String servername = datasystem.getDbservername();
      String url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername);
      String username = datasystem.getUsername();
      String password = AesTool.decrypt(datasystem.getPassword(), "ghca");
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      Connection conn = JdbcTool.getConnection(driver, url, username, password);
      return conn;
   }

   public void addFileStructure(FilestructureDTO filestructureDTO) {
      TCoreFileStructure tCoreFileStructure = new TCoreFileStructure();
      tCoreFileStructure.setFilestructurename(String.valueOf(filestructureDTO.getFilestructure().getFilestructurename()));
      tCoreFileStructure.setFilestructuregroup(String.valueOf(filestructureDTO.getFilestructure().getFilestructuregroup()));
      tCoreFileStructure.setCodepage(String.valueOf(filestructureDTO.getFilestructure().getCodepage()));
      tCoreFileStructure.setSkiprows(String.valueOf(filestructureDTO.getFilestructure().getSkiprows()));
      tCoreFileStructure.setFlag("0");
      String splitertype = filestructureDTO.getFilestructure().getSplitertype();
      tCoreFileStructure.setSplitertype(splitertype);
      List<TCoreFileStructureGroup> groups = this.tCoreFileStructureGroupDao.queryAll();
      boolean bool = groups.stream().anyMatch((a) -> a.getGroupname().equals(filestructureDTO.getFilestructure().getFilestructuregroup()));
      if (!bool) {
         TCoreFileStructureGroup group = new TCoreFileStructureGroup();
         group.setGroupname(filestructureDTO.getFilestructure().getFilestructuregroup());
         this.tCoreFileStructureGroupDao.save(group);
      }

      this.tCoreFileStructureDao.save(tCoreFileStructure);
      String filestructureid = tCoreFileStructure.getId();
      if (splitertype.equals("0")) {
         TCoreFileStructurespliter tCoreFileStructurespliter = new TCoreFileStructurespliter();
         tCoreFileStructurespliter.setDelimiters(String.valueOf(filestructureDTO.getFilestructurespliter().getDelimiters()));
         tCoreFileStructurespliter.setConsecdelimitersasone(String.valueOf(filestructureDTO.getFilestructurespliter().getConsecdelimitersasone()));
         tCoreFileStructurespliter.setMultidelimitersasand(String.valueOf(filestructureDTO.getFilestructurespliter().getMultidelimitersasand()));
         tCoreFileStructurespliter.setQuotecharacter(String.valueOf(filestructureDTO.getFilestructurespliter().getQuotecharacter()));
         tCoreFileStructurespliter.setRowdelimiter(String.valueOf(filestructureDTO.getFilestructurespliter().getRowdelimiter()));
         tCoreFileStructurespliter.setEscapecharacter(String.valueOf(filestructureDTO.getFilestructurespliter().getEscapecharacter()));
         tCoreFileStructurespliter.setKeepescapechar(String.valueOf(filestructureDTO.getFilestructurespliter().getKeepescapechar()));
         tCoreFileStructurespliter.setDelimiterencoding(String.valueOf(filestructureDTO.getFilestructurespliter().getDelimiterencoding()));
         tCoreFileStructurespliter.setFilestructureid(filestructureid);
         this.tCoreFileStructurespliterDao.save(tCoreFileStructurespliter);
      } else {
         TCoreFileStructurewidth tCoreFileStructurewidth = new TCoreFileStructurewidth();
         tCoreFileStructurewidth.setNullchartype(String.valueOf(filestructureDTO.getFilestructurewidth().getNullchartype()));
         tCoreFileStructurewidth.setNullcharacter(String.valueOf(filestructureDTO.getFilestructurewidth().getNullcharacter()));
         tCoreFileStructurewidth.setRepeatable(String.valueOf(filestructureDTO.getFilestructurewidth().getRepeatable()));
         tCoreFileStructurewidth.setPadbytes(String.valueOf(filestructureDTO.getFilestructurewidth().getPadbytes()));
         tCoreFileStructurewidth.setLinesequential(String.valueOf(filestructureDTO.getFilestructurewidth().getLinesequential()));
         tCoreFileStructurewidth.setShiftsensitivedata(String.valueOf(filestructureDTO.getFilestructurewidth().getShiftsensitivedata()));
         tCoreFileStructurewidth.setStriptrailingblanks(String.valueOf(filestructureDTO.getFilestructurewidth().getStriptrailingblanks()));
         tCoreFileStructurewidth.setFilestructureid(filestructureid);
         this.tCoreFileStructurewidthDao.save(tCoreFileStructurewidth);
      }

      List<TCoreFileStructurecolumn> structureColumnDTOList = filestructureDTO.getFilestructurecolumn();

      for(int i = 0; i < structureColumnDTOList.size(); ++i) {
         TCoreFileStructurecolumn structureColumnDTO = (TCoreFileStructurecolumn)structureColumnDTOList.get(i);
         TCoreFileStructurecolumn tCoreFileStructurecolumn = new TCoreFileStructurecolumn();
         tCoreFileStructurecolumn.setColumnindex(i + 1);
         tCoreFileStructurecolumn.setColumnname(structureColumnDTO.getColumnname());
         tCoreFileStructurecolumn.setColumntype(structureColumnDTO.getColumntype());
         tCoreFileStructurecolumn.setColumnaccuracy(structureColumnDTO.getColumnaccuracy());
         tCoreFileStructurecolumn.setColumndecimal(structureColumnDTO.getColumndecimal());
         tCoreFileStructurecolumn.setColumnnotnull(structureColumnDTO.getColumnnotnull());
         tCoreFileStructurecolumn.setKeytype(structureColumnDTO.getKeytype());
         tCoreFileStructurecolumn.setColumnformat(structureColumnDTO.getColumnformat());
         tCoreFileStructurecolumn.setFilestructureid(filestructureid);
         tCoreFileStructurecolumn.setColumnwidth(structureColumnDTO.getColumnwidth());
         this.tCoreFileStructurecolumnDao.save(tCoreFileStructurecolumn);
      }

   }

   public void addFileStructure(DemoFileImportParam param) {
      TCoreFileStructure filestructure = param.getFilestructure();
      filestructure.setFlag("0");
      this.tCoreFileStructureDao.save(filestructure);
      if (filestructure.getSplitertype().equals("0")) {
         TCoreFileStructurespliter filestructurespliter = param.getFilestructurespliter();
         filestructurespliter.setFilestructureid(filestructure.getId());
         this.tCoreFileStructurespliterDao.save(filestructurespliter);
      } else if (filestructure.getSplitertype().equals("1")) {
         TCoreFileStructurewidth filestructurewidth = param.getFilestructurewidth();
         filestructurewidth.setFilestructureid(filestructure.getId());
         this.tCoreFileStructurewidthDao.save(filestructurewidth);
      }

      for(TCoreFileStructurecolumn item : param.getFilestructurecolumn()) {
         item.setFilestructureid(filestructure.getId());
         this.tCoreFileStructurecolumnDao.save(item);
      }

   }

   public void dbInputFileStructure(Map<String, String> map) {
      logger.info("数据库导入文件结构 -- start");
      int tablelength = Integer.parseInt((String)map.get("tablelength"));
      String dbtype = (String)map.get("dbtype");
      if ("MARIADB".equals(map.get("dbtype"))) {
         map.replace("dbtype", "MYSQL");
         dbtype = "MYSQL";
      }

      String columnformat = (String)map.get("columnformat");

      for(int i = 0; i < tablelength; ++i) {
         TCoreFileStructure tCoreFileStructure = new TCoreFileStructure();
         tCoreFileStructure.setFilestructurename((String)map.get("prefixname") + (String)map.get("tablename" + i) + (String)map.get("suffixname"));
         tCoreFileStructure.setFilestructuregroup((String)map.get("filestructuregroup"));
         tCoreFileStructure.setCodepage((String)map.get("codepage"));
         tCoreFileStructure.setSkiprows((String)map.get("skiprows"));
         tCoreFileStructure.setFlag("0");
         String splitertype = (String)map.get("splitertype");
         tCoreFileStructure.setSplitertype(splitertype);
         this.tCoreFileStructureDao.save(tCoreFileStructure);
         if (splitertype.equals("0")) {
            TCoreFileStructurespliter tCoreFileStructurespliter = new TCoreFileStructurespliter();
            tCoreFileStructurespliter.setDelimiters((String)map.get("delimiters"));
            tCoreFileStructurespliter.setConsecdelimitersasone((String)map.get("consecdelimitersasone"));
            tCoreFileStructurespliter.setMultidelimitersasand((String)map.get("multidelimitersasand"));
            tCoreFileStructurespliter.setQuotecharacter((String)map.get("quotecharacter"));
            tCoreFileStructurespliter.setRowdelimiter((String)map.get("rowdelimiter"));
            tCoreFileStructurespliter.setEscapecharacter((String)map.get("escapecharacter"));
            tCoreFileStructurespliter.setKeepescapechar((String)map.get("keepescapechar"));
            tCoreFileStructurespliter.setFilestructureid(tCoreFileStructure.getId());
            this.tCoreFileStructurespliterDao.save(tCoreFileStructurespliter);
         } else {
            TCoreFileStructurewidth tCoreFileStructurewidth = new TCoreFileStructurewidth();
            tCoreFileStructurewidth.setNullchartype((String)map.get("nullchartype"));
            tCoreFileStructurewidth.setNullcharacter((String)map.get("nullcharacter"));
            tCoreFileStructurewidth.setRepeatable((String)map.get("repeatable"));
            tCoreFileStructurewidth.setPadbytes((String)map.get("padbytes"));
            tCoreFileStructurewidth.setLinesequential((String)map.get("linesequential"));
            tCoreFileStructurewidth.setShiftsensitivedata((String)map.get("shiftsensitivedata"));
            tCoreFileStructurewidth.setStriptrailingblanks((String)map.get("striptrailingblanks"));
            tCoreFileStructurewidth.setFilestructureid(tCoreFileStructure.getId());
            this.tCoreFileStructurewidthDao.save(tCoreFileStructurewidth);
         }

         Connection conn = this.getConnectionByDataSystemId((String)map.get("datasystemid"));
         List<ColumnInfoVO> cilist = JdbcTool.getColumnInfoVO(conn, (String)map.get("schema"), (String)map.get("tablename" + i));
         JdbcTool.closeConnection(conn);
         List<Map<String, String>> mappingInfo = this.desensitizationdataMappingService.getDatamappingInfo(EdataMappingType.getFlagByName(dbtype), "10");

         for(int j = 0; j < cilist.size(); ++j) {
            TCoreFileStructurecolumn tCoreFileStructurecolumn = new TCoreFileStructurecolumn();
            tCoreFileStructurecolumn.setColumnindex(j + 1);
            tCoreFileStructurecolumn.setColumnname(((ColumnInfoVO)cilist.get(j)).getColumnname());

            label113:
            for(int k = 0; k < mappingInfo.size(); ++k) {
               if (((ColumnInfoVO)cilist.get(j)).getTypename().equalsIgnoreCase((String)((Map)mappingInfo.get(k)).get("sourcefieldname"))) {
                  switch ((String)((Map)mappingInfo.get(k)).get("targetfieldname")) {
                     case "ntext":
                     case "text":
                     case "binary":
                     case "image":
                        tCoreFileStructurecolumn.setColumntype("string");
                        break label113;
                     case "decimal":
                     case "real":
                        tCoreFileStructurecolumn.setColumntype("number");
                        break label113;
                     case "integer":
                     case "small integer":
                        tCoreFileStructurecolumn.setColumntype("int");
                        break label113;
                     case "date/time":
                        tCoreFileStructurecolumn.setColumntype("datetime");
                        break label113;
                     default:
                        tCoreFileStructurecolumn.setColumntype((String)((Map)mappingInfo.get(k)).get("targetfieldname"));
                        break label113;
                  }
               }
            }

            tCoreFileStructurecolumn.setColumnaccuracy(((ColumnInfoVO)cilist.get(j)).getColumnsize());
            tCoreFileStructurecolumn.setColumndecimal(((ColumnInfoVO)cilist.get(j)).getDecimaldigits() != null && !((ColumnInfoVO)cilist.get(j)).getDecimaldigits().equals("") ? ((ColumnInfoVO)cilist.get(j)).getDecimaldigits() : "0");
            if (tCoreFileStructurecolumn.getColumntype().equals(ColumnType.DATETIME.getName())) {
               tCoreFileStructurecolumn.setColumnformat(columnformat);
               int len = columnformat.length();
               if (columnformat.contains("24")) {
                  len -= 2;
               }

               if (columnformat.contains("MS")) {
                  ++len;
               }

               if (columnformat.contains("US")) {
                  len += 4;
               }

               if (columnformat.contains("NS")) {
                  len += 7;
               }

               tCoreFileStructurecolumn.setColumnaccuracy(columnformat == null ? "0" : String.valueOf(len));
               tCoreFileStructurecolumn.setColumndecimal("0");
            }

            tCoreFileStructurecolumn.setKeytype(((ColumnInfoVO)cilist.get(j)).getPrimarykey().equals("0") ? "NO" : "YES");
            if (tCoreFileStructurecolumn.getKeytype().equals("YES")) {
               tCoreFileStructurecolumn.setColumnnotnull("YES");
            } else {
               tCoreFileStructurecolumn.setColumnnotnull("YES");
            }

            tCoreFileStructurecolumn.setFilestructureid(tCoreFileStructure.getId());
            this.tCoreFileStructurecolumnDao.save(tCoreFileStructurecolumn);
         }
      }

      logger.info("数据库导入文件结构 -- end");
   }

   public void removeFileStructure(String id) {
      TCoreFileStructure tCoreFileStructure = (TCoreFileStructure)this.tCoreFileStructureDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
      String splitertype = tCoreFileStructure.getSplitertype();
      this.tCoreFileStructureDao.removeById(id);
      if (splitertype.equals("0")) {
         this.tCoreFileStructurespliterDao.remove(new Criterion[]{Restrictions.eq("filestructureid", id)});
      } else {
         this.tCoreFileStructurewidthDao.remove(new Criterion[]{Restrictions.eq("filestructureid", id)});
      }

      this.tCoreFileStructurecolumnDao.remove(new Criterion[]{Restrictions.eq("filestructureid", id)});
   }

   public void modifyFileStructure(Map<String, String> map) {
      TCoreFileStructure tCoreFileStructure = new TCoreFileStructure();
      tCoreFileStructure.setId((String)map.get("id"));
      tCoreFileStructure.setSplitertype((String)map.get("splitertype"));
      tCoreFileStructure.setFilestructurename((String)map.get("filestructurename"));
      tCoreFileStructure.setFilestructuregroup((String)map.get("filestructuregroup"));
      tCoreFileStructure.setCodepage((String)map.get("codepage"));
      tCoreFileStructure.setSkiprows((String)map.get("skiprows"));
      tCoreFileStructure.setFlag("0");
      this.tCoreFileStructureDao.saveOrUpdate(tCoreFileStructure);
      if (tCoreFileStructure.getSplitertype().equals("0")) {
         TCoreFileStructurespliter tCoreFileStructurespliter = new TCoreFileStructurespliter();
         tCoreFileStructurespliter.setId((String)map.get("structurespliterid"));
         tCoreFileStructurespliter.setDelimiters((String)map.get("delimiters"));
         tCoreFileStructurespliter.setConsecdelimitersasone((String)map.get("consecdelimitersasone"));
         tCoreFileStructurespliter.setMultidelimitersasand((String)map.get("multidelimitersasand"));
         tCoreFileStructurespliter.setQuotecharacter((String)map.get("quotecharacter"));
         tCoreFileStructurespliter.setRowdelimiter((String)map.get("rowdelimiter"));
         tCoreFileStructurespliter.setEscapecharacter((String)map.get("escapecharacter"));
         tCoreFileStructurespliter.setKeepescapechar((String)map.get("keepescapechar"));
         tCoreFileStructurespliter.setDelimiterencoding((String)map.get("delimiterencoding"));
         tCoreFileStructurespliter.setFilestructureid(tCoreFileStructure.getId());
         this.tCoreFileStructurespliterDao.saveOrUpdate(tCoreFileStructurespliter);
      } else {
         TCoreFileStructurewidth tCoreFileStructurewidth = new TCoreFileStructurewidth();
         tCoreFileStructurewidth.setId((String)map.get("structurewidthid"));
         tCoreFileStructurewidth.setNullchartype((String)map.get("nullchartype"));
         tCoreFileStructurewidth.setNullcharacter((String)map.get("nullcharacter"));
         tCoreFileStructurewidth.setRepeatable((String)map.get("repeatable"));
         tCoreFileStructurewidth.setPadbytes((String)map.get("padbytes"));
         tCoreFileStructurewidth.setLinesequential((String)map.get("linesequential"));
         tCoreFileStructurewidth.setShiftsensitivedata((String)map.get("shiftsensitivedata"));
         tCoreFileStructurewidth.setStriptrailingblanks((String)map.get("striptrailingblanks"));
         tCoreFileStructurewidth.setFilestructureid(tCoreFileStructure.getId());
         this.tCoreFileStructurewidthDao.saveOrUpdate(tCoreFileStructurewidth);
      }

      int columnSize = Integer.parseInt((String)map.get("columnSize"));
      this.tCoreFileStructurecolumnDao.remove(new Criterion[]{Restrictions.eq("filestructureid", tCoreFileStructure.getId())});

      for(int i = 0; i < columnSize; ++i) {
         TCoreFileStructurecolumn tCoreFileStructurecolumn = new TCoreFileStructurecolumn();
         tCoreFileStructurecolumn.setColumnaccuracy((String)map.get("structureColumn[" + i + "][columnaccuracy]"));
         tCoreFileStructurecolumn.setColumndecimal((String)map.get("structureColumn[" + i + "][columndecimal]"));
         tCoreFileStructurecolumn.setColumnindex(i + 1);
         tCoreFileStructurecolumn.setColumnname((String)map.get("structureColumn[" + i + "][columnname]"));
         tCoreFileStructurecolumn.setColumnnotnull((String)map.get("structureColumn[" + i + "][columnnotnull]"));
         tCoreFileStructurecolumn.setColumntype((String)map.get("structureColumn[" + i + "][columntype]"));
         tCoreFileStructurecolumn.setKeytype((String)map.get("structureColumn[" + i + "][keytype]"));
         tCoreFileStructurecolumn.setColumnformat((String)map.get("structureColumn[" + i + "][columnformat]"));
         tCoreFileStructurecolumn.setFilestructureid(tCoreFileStructure.getId());
         this.tCoreFileStructurecolumnDao.save(tCoreFileStructurecolumn);
      }

   }

   public List<TCoreFileStructure> queryFileStructure() {
      List<TCoreFileStructure> list = this.tCoreFileStructureDao.queryGroupFileList();
      return list;
   }

   public TCoreFileStructure getInfoByPk(String id) {
      TCoreFileStructure tfs = (TCoreFileStructure)this.tCoreFileStructureDao.queryUnique(new Criterion[]{Restrictions.eq("id", id), Restrictions.eq("flag", "0")});
      return tfs;
   }

   public List<TCoreFileStructure> queryRepeatName(String[] filestructurename, String filestructuregroup) {
      List<TCoreFileStructure> list = null;

      for(String str : filestructurename) {
         list = this.tCoreFileStructureDao.queryAll(new Criterion[]{Restrictions.eq("filestructurename", str), Restrictions.eq("filestructuregroup", filestructuregroup), Restrictions.eq("flag", "0")});
         if (list.size() > 0) {
            break;
         }
      }

      return list;
   }

   public TCoreFileStructurespliter queryFileStructureSpliter(String filestructureid) {
      TCoreFileStructurespliter tCoreFileStructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", filestructureid)});
      return tCoreFileStructurespliter;
   }

   public TCoreFileStructurewidth queryFileStructureWidth(String filestructureid) {
      TCoreFileStructurewidth tCoreFileStructurewidth = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", filestructureid)});
      return tCoreFileStructurewidth;
   }

   public List<TCoreFileStructurecolumn> queryFileStructureColumn(String structureid) {
      List<TCoreFileStructurecolumn> list = this.tCoreFileStructurecolumnDao.queryAll("columnindex", true, new Criterion[]{Restrictions.eq("filestructureid", structureid)});
      return list;
   }

   public List<TCoreFileStructurecolumn> queryFileStructureColumnSearch(String structureid, String datatypes) {
      new ArrayList();
      List list;
      if (datatypes != null && !"all".equals(datatypes) && !"".equals(datatypes)) {
         list = this.tCoreFileStructurecolumnDao.queryAll("columnindex", true, new Criterion[]{Restrictions.eq("filestructureid", structureid), Restrictions.eq("columntype", datatypes)});
      } else {
         list = this.tCoreFileStructurecolumnDao.queryAll("columnindex", true, new Criterion[]{Restrictions.eq("filestructureid", structureid)});
      }

      return list;
   }

   public List<ComboboxVO> queryGroupnameBySysid(String filesourceid) {
      List<TCoreFileSysGroup> gnlist = this.tCoreFileSysGroupDao.queryAll(new Criterion[]{Restrictions.eq("systemid", filesourceid)});
      List<ComboboxVO> list = new ArrayList();

      for(TCoreFileSysGroup gn : gnlist) {
         ComboboxVO c = new ComboboxVO(gn.getFilegroupid());
         list.add(c);
      }

      return list;
   }

   public List<TCoreFileStructure> queryStructureByGroup(String groupname, String tableNamePattern) {
      List<TCoreFileStructure> list = this.tCoreFileStructureDao.queryAll(new Criterion[]{Restrictions.eq("filestructuregroup", groupname), Restrictions.eq("flag", "0"), Restrictions.like("filestructurename", tableNamePattern, MatchMode.ANYWHERE)});
      return list;
   }

   public List<TCoreMaskingFilesystem> queryMaskingTaskStructure(String structureid) {
      List<TCoreMaskingFilesystem> list = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("structureid", structureid)});
      return list;
   }

   public void dataWidthDouble(String structureid, String strtype) {
      this.tCoreFileStructurecolumnDao.dataWidthDouble(structureid, strtype);
   }

   public List<ComboboxVO> queryGroupname() {
      List<String> gnlist = this.tCoreFileStructureDao.queryDistinctGroupname();
      List<ComboboxVO> list = new ArrayList();

      for(String gn : gnlist) {
         ComboboxVO c = new ComboboxVO(gn);
         list.add(c);
      }

      return list;
   }

   public void saveFileStructureGroup(TCoreFileStructureGroup group) {
      if (group.getId() != null && !group.getId().equals("")) {
         TCoreFileStructureGroup tCoreFileStructureGroup = (TCoreFileStructureGroup)this.tCoreFileStructureGroupDao.get(group.getId());
         this.tCoreFileStructureDao.updateFileStructureGroup(group.getGroupname(), tCoreFileStructureGroup.getGroupname());
      }

      Session session = this.sessionFactory.getCurrentSession();
      session.flush();
      session.clear();
      group.setFlag("0");
      this.tCoreFileStructureGroupDao.saveOrUpdate(group);
   }

   public Boolean checkRepeatGroupName(String groupname) {
      return this.tCoreFileStructureGroupDao.queryAll(new Criterion[]{Restrictions.eq("groupname", groupname)}).size() == 0 ? true : false;
   }

   public void delFileStructureGroup(String groupid, String groupname) {
      this.tCoreFileStructureGroupDao.remove(new Criterion[]{Restrictions.eq("id", groupid)});
      this.tCoreFileStructureDao.remove(new Criterion[]{Restrictions.eq("filestructuregroup", groupname)});
      this.tCoreFileSysGroupDao.remove(new Criterion[]{Restrictions.eq("filegroupid", groupname)});
   }
}
