package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.core.TCoreFirstPageDataDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserroleDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSearchregexDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.project.TCoreProjectDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserrole;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataScope;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasourceSchema;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreFirstPageData;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.duty.UserJoinFieldInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreFieldSensitive;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.service.core.FirstPageDataService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.QueryBloodTool;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FirstPageDataServiceImpl implements FirstPageDataService {
   @Autowired
   private TCoreFirstPageDataDao firstPageDataDao;
   @Autowired
   private TConsoleSearchregexDao tConsoleSearchregexDao;
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private TCoreProjectDao tCoreProjectDao;
   @Autowired
   private TCoreDataProjectDao tCoreDataProjectDao;
   @Autowired
   private TBaseUserroleDao tBaseUserroleDao;

   public void save(String projectid) {
      this.firstPageDataDao.remove(new Criterion[0]);
      TCoreFirstPageData projectBlood = this.getProjectBlood(projectid);
      projectBlood.setProject_id(projectid);
      this.firstPageDataDao.save(projectBlood);
   }

   public static BigInteger doubleToScaledInteger(double d) {
      BigDecimal bd = new BigDecimal(d);
      return bd.toBigIntegerExact();
   }

   public Map<String, Object> queryFirst() {
      Map<String, Object> retMap = new HashMap();
      List<TCoreFirstPageData> queryDataList = this.firstPageDataDao.queryAll();
      List<Map<String, Object>> list1 = new ArrayList();
      queryDataList.forEach((datax) -> {
         Map<String, Object> map = new HashMap();
         map.put("projectname", datax.getProject_name());
         map.put("tablecount", datax.getTable_num());
         map.put("masking_table_num", datax.getMasking_table_num());
         list1.add(map);
      });
      List<Map<String, Object>> list2 = new ArrayList();
      List<TCoreFirstPageData> subDataList = this.firstPageDataDao.queryAll();
      subDataList = (List)queryDataList.stream().sorted(Comparator.comparing(TCoreFirstPageData::getMasking_field_num)).limit(10L).collect(Collectors.toList());
      subDataList.forEach((datax) -> {
         Map<String, Object> map = new HashMap();
         map.put("projectname", datax.getProject_name());
         map.put("masking_field_num", datax.getMasking_field_num());
         list2.add(map);
      });
      List<Map<String, Object>> list3 = new ArrayList();
      subDataList = (List)queryDataList.stream().sorted(Comparator.comparing(TCoreFirstPageData::getMasking_field_num)).limit(10L).collect(Collectors.toList());
      subDataList.forEach((datax) -> {
         Map<String, Object> map = new HashMap();
         map.put("projectname", datax.getProject_name());
         map.put("masking_field_num", datax.getMasking_field_num());
         list3.add(map);
      });
      List<Map<String, Object>> list4 = new ArrayList();
      subDataList = (List)queryDataList.stream().sorted(Comparator.comparing(TCoreFirstPageData::getMasking_field_num)).limit(4L).collect(Collectors.toList());
      subDataList.forEach((datax) -> {
         Map<String, Object> map = new HashMap();
         map.put("projectname", datax.getProject_name());
         map.put("field_num", datax.getField_num());
         map.put("masking_field_num", datax.getMasking_field_num());
         list4.add(map);
      });
      List<Map<String, Object>> list5 = new ArrayList();
      BigInteger totalTableNum = new BigInteger("0");
      BigInteger totalMaskingTableNum = new BigInteger("0");
      BigInteger totalProjectNum = new BigInteger("0");
      Map<String, Object> map = new HashMap();

      for(TCoreFirstPageData data : queryDataList) {
         totalTableNum = new BigInteger(totalTableNum.add(data.getTable_num()).toString());
         totalMaskingTableNum = new BigInteger(totalMaskingTableNum.add(data.getMasking_table_num()).toString());
         totalProjectNum = new BigInteger(totalProjectNum.add(new BigInteger("1")).toString());
      }

      map.put("totalTableNum", totalTableNum);
      map.put("totalMaskingTableNum", totalMaskingTableNum);
      map.put("totalProjectNum", totalProjectNum);
      list5.add(map);
      List<Map<String, Object>> list6 = new ArrayList();
      BigInteger sumTableNum = new BigInteger("0");
      BigInteger sumMaskingTableNum = new BigInteger("0");
      Map<String, Object> map6 = new HashMap();

      for(TCoreFirstPageData data : queryDataList) {
         sumTableNum = new BigInteger(sumTableNum.add(data.getTable_num()).toString());
         sumMaskingTableNum = new BigInteger(sumMaskingTableNum.add(data.getMasking_table_num()).toString());
      }

      map6.put("totalTableNum", sumTableNum);
      map6.put("totalMaskingTableNum", sumMaskingTableNum);
      list6.add(map6);
      List<TConsoleSearchregex> list7 = this.tConsoleSearchregexDao.queryAll();
      retMap.put("list1", list1);
      retMap.put("list2", list2);
      retMap.put("list3", list3);
      retMap.put("list4", list4);
      retMap.put("list5", list5);
      retMap.put("list6", list6);
      retMap.put("list7", list7);
      return retMap;
   }

   public Map<String, Object> queryBlood(String project_id) {
      Map<String, Object> firstPageData = null;
      Map<String, Object> retMap = new HashMap();
      List<Map<String, Object>> queryDataList = this.firstPageDataDao.queryByProjectId(project_id);
      if (queryDataList.size() > 0) {
         firstPageData = (Map)queryDataList.get(0);
         List<Map<String, Object>> busiDutyList = this.firstPageDataDao.queryDutyByType(project_id, "1");
         List<Map<String, Object>> techDutyList = this.firstPageDataDao.queryDutyByType(project_id, "2");
         retMap.put("firstPageData", firstPageData);
         retMap.put("busiDutyList", busiDutyList);
         retMap.put("techDutyList", techDutyList);
      }

      return retMap;
   }

   public Map<String, Object> queryBlood2(String project_id, String datasystemid, String schemaname, String tablename) {
      Map<String, Object> dataMap = new HashMap();
      List<UserJoinFieldInfo> dutyInfoList = this.firstPageDataDao.queryDutyInfoList(project_id, datasystemid, schemaname, tablename);
      List<String> dutyUserIdList = new ArrayList();

      for(UserJoinFieldInfo userinfo : dutyInfoList) {
         if (userinfo.getJointype().equals("2")) {
            dutyUserIdList.add(userinfo.getJoinid());
         } else {
            for(TBaseUserrole tBaseUserrole : this.tBaseUserroleDao.queryAll(new Criterion[]{Restrictions.eq("roleid", userinfo.getJoinid())})) {
               dutyUserIdList.add(tBaseUserrole.getUserid());
            }
         }
      }

      dutyUserIdList = (List)dutyUserIdList.stream().distinct().collect(Collectors.toList());
      dataMap.put("firstPageData", dutyUserIdList.size());
      List<Map<String, Object>> busiDutyList = this.firstPageDataDao.queryDutyByTypeOfTable(project_id, "1");
      List<Map<String, Object>> techDutyList = this.firstPageDataDao.queryDutyByTypeOfTable(project_id, "2");
      dataMap.put("busiDutyList", busiDutyList.stream().distinct().collect(Collectors.toList()));
      dataMap.put("techDutyList", techDutyList.stream().distinct().collect(Collectors.toList()));
      Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
      List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schemaname, tablename);
      dataMap.put("columnSize", list.size());
      TCoreDataProject coreProjectInfo = (TCoreDataProject)this.tCoreDataProjectDao.queryUnique(new Criterion[]{Restrictions.eq("id", project_id)});
      dataMap.put("systemName", coreProjectInfo.getProject());
      List<Map<String, Object>> scopeList = this.firstPageDataDao.queryScope(project_id, datasystemid, schemaname, tablename);
      if (scopeList.size() > 0) {
         dataMap.put("scopeNum", ((Map)scopeList.get(0)).get("num"));
      }

      List<Map<String, Object>> sensitiveList = this.firstPageDataDao.querySensitive(datasystemid, schemaname, tablename);
      if (sensitiveList.size() > 0) {
         dataMap.put("sensitiveName", ((Map)sensitiveList.get(0)).get("sensitive_name"));
      } else {
         dataMap.put("sensitiveName", "");
      }

      return dataMap;
   }

   public Map<String, Object> queryBlood3(String duty_id) {
      Map<String, Object> dataMap = new HashMap();
      List<Map<String, Object>> authSystemList = this.firstPageDataDao.queryAuthSystemByUser(duty_id);
      if (authSystemList.size() > 0) {
         dataMap.put("systemList", ((Map)authSystemList.get(0)).get("authnum"));
      } else {
         dataMap.put("systemList", 0);
      }

      List<Map<String, Object>> authTableList = this.firstPageDataDao.queryAuthTableByUser(duty_id);
      if (authTableList.size() > 0) {
         dataMap.put("tableList", ((Map)authTableList.get(0)).get("authnum"));
      } else {
         dataMap.put("tableList", 0);
      }

      List<Map<String, Object>> busiDutyList = this.firstPageDataDao.queryDutyByUser(duty_id, "1");
      List<Map<String, Object>> techDutyList = this.firstPageDataDao.queryDutyByUser(duty_id, "2");
      dataMap.put("busiDutyList", busiDutyList);
      dataMap.put("techDutyList", techDutyList);
      return dataMap;
   }

   public Map<String, Object> queryBlood4(String group_id) {
      Map<String, Object> dataMap = new HashMap();
      List<Map<String, Object>> projectList = this.firstPageDataDao.queryByUserGroup(group_id);
      dataMap.put("projectList", projectList);
      return dataMap;
   }

   public TCoreFirstPageData getProjectBlood(String projectid) {
      TCoreFirstPageData tCoreFirstPageData = new TCoreFirstPageData();
      double tableNum = (double)0.0F;
      double fieldNum = (double)0.0F;

      for(TCoreDatasourceSchema schema : this.firstPageDataDao.querySchemasByProjectId(projectid, (String)null)) {
         List<TCoreDatasystem> systemList = this.firstPageDataDao.getDataSourceDetail(schema.getOsdsid());
         Connection connection = JdbcTool.getConnection((TCoreDatasystem)systemList.get(0));
         tableNum += QueryBloodTool.getTabelNum((TCoreDatasystem)systemList.get(0), connection, schema.getSchemaname(), schema.getDbtype());
         fieldNum += QueryBloodTool.getColumnNum((TCoreDatasystem)systemList.get(0), connection, schema.getSchemaname(), schema.getDbtype());
      }

      tCoreFirstPageData.setProject_name(((TCoreDataProject)this.tCoreDataProjectDao.queryUnique(new Criterion[]{Restrictions.eq("id", projectid)})).getProject());
      tCoreFirstPageData.setTable_num(doubleToScaledInteger(tableNum));
      tCoreFirstPageData.setField_num(doubleToScaledInteger(fieldNum));
      List<TCoreFieldSensitive> sensitiveFiledList = this.firstPageDataDao.querySensitiveFiledList(projectid, (String)null);
      double senFieldNum = (double)sensitiveFiledList.size();
      tCoreFirstPageData.setSensitive_field_num(doubleToScaledInteger(senFieldNum));
      List<TCoreDataScope> scopeList = this.firstPageDataDao.queryScopeList(projectid);
      double scopeNum = (double)scopeList.size();
      tCoreFirstPageData.setScope_num(doubleToScaledInteger(scopeNum));
      double auth_user_num = (double)0.0F;
      List<UserJoinFieldInfo> dutyInfoList = this.firstPageDataDao.queryDutyInfoList(projectid, (String)null, (String)null, (String)null);
      List<String> dutyUserIdList = new ArrayList();

      for(UserJoinFieldInfo userinfo : dutyInfoList) {
         if (userinfo.getJointype().equals("2")) {
            ++auth_user_num;
            dutyUserIdList.add(userinfo.getJoinid());
         }
      }

      for(int i = 0; i < dutyInfoList.size(); ++i) {
         if (((UserJoinFieldInfo)dutyInfoList.get(i)).getJointype().equals("1")) {
            List<TBaseUserrole> userListInRole = this.firstPageDataDao.queryUserListInRole(((UserJoinFieldInfo)dutyInfoList.get(i)).getJoinid());
            auth_user_num += (double)userListInRole.size();

            for(int j = 0; j < userListInRole.size(); ++j) {
               for(int k = 0; k < dutyUserIdList.size(); ++k) {
                  if (((TBaseUserrole)userListInRole.get(j)).getUserid().equals(dutyUserIdList.get(k))) {
                     --auth_user_num;
                  }
               }
            }
         }
      }

      tCoreFirstPageData.setAuth_user_num(doubleToScaledInteger(auth_user_num));
      return tCoreFirstPageData;
   }
}
