package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.MaskingRuleDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataAreaDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleVoDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleinfoDao;
import com.chenyang.nse.bussiness.engine.ghca.webservice.DesensitizationEngineInterfaceImpl;
import com.chenyang.nse.bussiness.engine.ghca.webservice.DesensitizationEngineInterfaceImplService;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreSensitiveregexVO;
import com.chenyang.nse.bussiness.entity.vo.maskingrule.MaskingInfoRuleVO;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.MaskingRuleService;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MaskingRuleServiceImpl implements MaskingRuleService {
   @Autowired
   private TCoreMaskingRuleDao tCoreMaskingRuleDao;
   @Autowired
   private TCoreMaskingRuleinfoDao tCoreMaskingRuleinfoDao;
   @Autowired
   private MaskingRuleDao maskingRuleDao;
   @Autowired
   private TCoreDataAreaDao tCoreDataAreaDao;
   @Autowired
   private TCoreMaskingRuleVoDao tCoreMaskingRuleVoDao;
   @Autowired
   private OperationService operationService;

   public List<String> queryRuleGroup() {
      List<String> list = this.tCoreMaskingRuleDao.queryRuleGroup();
      return list;
   }

   public DataGridVO<TCoreMaskingRule> queryRule(PageInfo pageInfo) {
      List<TCoreMaskingRule> list = this.tCoreMaskingRuleDao.queryByPageInfo(pageInfo, Order.asc("rulegroupname"));
      DataGridVO<TCoreMaskingRule> vo = new DataGridVO<TCoreMaskingRule>(pageInfo.getCount(), list);
      return vo;
   }

   public void save(TCoreMaskingRule rule) {
      if (rule.getId() != null && !"".equals(rule.getId())) {
         TCoreMaskingRule temp = (TCoreMaskingRule)this.tCoreMaskingRuleDao.get(rule.getId());
         temp.setRulegroupname(rule.getRulegroupname());
         temp.setRulename(rule.getRulename());
         temp.setRuledemo(rule.getRuledemo());
         this.tCoreMaskingRuleDao.saveOrUpdate(temp);
      } else {
         long count = this.tCoreMaskingRuleDao.count(new Criterion[]{Restrictions.eq("rulegroupname", rule.getRulegroupname())});
         if (count == 0L) {
            rule.setFlag("1");
         } else {
            rule.setFlag("0");
         }

         this.tCoreMaskingRuleDao.save(rule);
      }

   }

   public void remove(String ruleid) {
      this.tCoreMaskingRuleinfoDao.removeById(ruleid);
   }

   public TCoreMaskingRule queryRuleById(String ruleid) {
      TCoreMaskingRule rule = (TCoreMaskingRule)this.tCoreMaskingRuleDao.get(ruleid);
      return rule;
   }

   public List<TCoreMaskingRule> queryRuleByGroupName(String groupname) {
      List<TCoreMaskingRule> list = this.tCoreMaskingRuleDao.queryRuleByGroupName(groupname);
      return list;
   }

   public DataGridVO<MaskingInfoRuleVO> queryInfoRule(PageInfo pageInfo) {
      long count = this.tCoreMaskingRuleDao.count();
      pageInfo.setCount(count);
      List<MaskingInfoRuleVO> list = this.maskingRuleDao.queryInfoRule(pageInfo);
      DataGridVO<MaskingInfoRuleVO> vo = new DataGridVO<MaskingInfoRuleVO>(count, list);
      return vo;
   }

   public void saveRuleInfo(TCoreMaskingRuleinfo ruleinfo, String username, String dataarea) {
      String dataareaid = "";
      if (this.tCoreDataAreaDao.queryDataareaid(dataarea).size() > 0) {
         dataareaid = (String)this.tCoreDataAreaDao.queryDataareaid(dataarea).get(0);
      }

      if (dataareaid != null && !"".equals(dataareaid) && !"null".equals(ruleinfo.getId())) {
         ruleinfo.setDataarea_id(dataareaid);
      } else {
         TCoreDataArea tCoreDataArea = new TCoreDataArea();
         tCoreDataArea.setDataarea(dataarea);
         tCoreDataArea.setCreatetime(new Date());
         tCoreDataArea.setCreateuser(username);
         this.tCoreDataAreaDao.save(tCoreDataArea);
         ruleinfo.setDataarea_id(tCoreDataArea.getId());
      }

      String o = this.tCoreMaskingRuleinfoDao.updatedef(dataareaid);
      if (!"1".equals(ruleinfo.getDefaulttype())) {
         ruleinfo.setDefaulttype("0");
      }

      if ("f".equals(o)) {
         ruleinfo.setDefaulttype("1");
      }

      TConsoleLog record = new TConsoleLog();
      if (ruleinfo.getId() != null && !"".equals(ruleinfo.getId()) && !"null".equals(ruleinfo.getId())) {
         this.tCoreMaskingRuleinfoDao.saveOrUpdate(ruleinfo);
         record.setLogmessage("编辑脱敏规则");
      } else {
         this.tCoreMaskingRuleinfoDao.save(ruleinfo);
         record.setLogmessage("新增脱敏规则");
      }

      record.setModule("数据域模块");
      record.setOperationObject(ruleinfo.getName());
      record.setOperationtime(new Date());
      record.setUser(username);
      this.operationService.add(record);

      try {
         DesensitizationEngineInterfaceImplService engineInterfaceImplService = new DesensitizationEngineInterfaceImplService();
         DesensitizationEngineInterfaceImpl engineInterfaceImpl = (DesensitizationEngineInterfaceImpl)engineInterfaceImplService.getPort(DesensitizationEngineInterfaceImpl.class);
         String er = engineInterfaceImpl.executeMappletDesignerSerialize(ruleinfo.getMappletname());
         System.out.println("result is " + er);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public TCoreMaskingRuleinfo queryInfoRuleById(String id) {
      return (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.get(id);
   }

   public List<TCoreMaskingRule> queryRuleByFlag() {
      return this.tCoreMaskingRuleDao.queryAll(new Criterion[]{Restrictions.eq("flag", "1")});
   }

   public void setDefault(String ruleid) {
      TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.get(ruleid);
      TCoreMaskingRuleinfo temp = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("dataarea_id", rule.getDataarea_id()), Restrictions.eq("defaulttype", "1")});
      if (temp != null) {
         temp.setDefaulttype("0");
         this.tCoreMaskingRuleinfoDao.saveOrUpdate(temp);
      }

      rule.setDefaulttype("1");
      this.tCoreMaskingRuleinfoDao.saveOrUpdate(rule);
   }

   public List<TCoreMaskingRule> queryMaskingRule() {
      List<TCoreMaskingRule> list = this.tCoreMaskingRuleDao.queryAll("rulegroupname", true);
      return list;
   }

   public List<TCoreSensitiveregexVO> querySensitiveregex(String dataarea, String rulename, PageInfo pageInfo) {
      List<TCoreSensitiveregexVO> list = this.tCoreMaskingRuleDao.querySensitiveregexList(dataarea, rulename, pageInfo);
      return list;
   }

   public List<TCoreSensitiveregexVO> querySensitiveregex(String dataarea, String rulename) {
      List<TCoreSensitiveregexVO> list = this.tCoreMaskingRuleDao.querySensitiveregexList(dataarea, rulename);
      return list;
   }

   public List<TCoreSensitiveregexVO> querySensitiveregexByid(String id) {
      List<TCoreSensitiveregexVO> list = this.tCoreMaskingRuleVoDao.querySensitiveregexByid(id);
      return list;
   }

   public boolean checkNameExit(String name) {
      Criterion criterion = Restrictions.eq("name", name);
      return this.tCoreMaskingRuleinfoDao.count(new Criterion[]{criterion}) > 0L;
   }

   public int queryRuleCount(String dataareaId) {
      return this.tCoreMaskingRuleinfoDao.queryRuleCount(dataareaId);
   }

   public void removeDataarea(String dataareaId) {
      this.tCoreDataAreaDao.remove(new Criterion[]{Restrictions.eq("id", dataareaId)});
   }

   public void setOtherDefault(String id) {
      List<TCoreMaskingRuleinfo> temp = this.tCoreMaskingRuleinfoDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", id)});
      if (!temp.isEmpty()) {
         ((TCoreMaskingRuleinfo)temp.get(0)).setDefaulttype("1");
         this.tCoreMaskingRuleinfoDao.saveOrUpdate(temp.get(0));
      }

   }
}
