package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.console.mapping.TConsoleDatamappingInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfFileDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfFilecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfTableDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfTablecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfTaskDao;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfFilecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTask;
import com.chenyang.nse.bussiness.entity.param.maskingself.ColumnInfoParam;
import com.chenyang.nse.bussiness.entity.param.maskingself.SaveSelfParam;
import com.chenyang.nse.bussiness.entity.param.maskingself.TableInfoParam;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.EmaskingDirection;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.enumeration.file.ColumnType;
import com.chenyang.nse.bussiness.enumeration.file.DateFormat;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.MaskingSelfTaskService;
import com.chenyang.nse.bussiness.service.info.InfoSelfService;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class MaskingSelfTaskServiceImpl implements MaskingSelfTaskService {
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private TCoreMaskingselfTaskDao tCoreMaskingselfTaskDao;
   @Autowired
   private TCoreMaskingselfTableDao tCoreMaskingselfTableDao;
   @Autowired
   private TCoreMaskingselfTablecolumnDao tCoreMaskingselfTablecolumnDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private TCoreMaskingRuleDao tCoreMaskingRuleDao;
   @Autowired
   private TCoreMaskingselfFileDao tCoreMaskingselfFileDao;
   @Autowired
   private TCoreMaskingselfFilecolumnDao tCoreMaskingselfFilecolumnDao;
   @Autowired
   private TConsoleDatamappingInfoDao tConsoleDatamappingInfoDao;
   @Autowired
   private InfoSelfService infoSelfService;
   @Autowired
   private OperationService operationService;

   public Connection getConnectionByDataSystemId(String datasystemid) {
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
      String dbcode = datasystem.getDbtype();
      String ip = datasystem.getDbip();
      String port = datasystem.getDbport();
      String servername = datasystem.getDbservername();
      String server = datasystem.getServername();
      String url = "";
      switch (datasystem.getDbtype()) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server);
            break;
         default:
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername);
      }

      String username = datasystem.getUsername();
      String password = "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword();
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      Connection conn = JdbcTool.getConnection(driver, url, username, password);
      return conn;
   }

   public List<TCoreMaskingselfTask> queryTask(String engineid, String taskname, PageInfo pageInfo) {
      long count = this.tCoreMaskingselfTaskDao.count(new Criterion[]{Restrictions.eq("engineid", engineid)});
      pageInfo.setCount(count);
      List<TCoreMaskingselfTask> list = this.tCoreMaskingselfTaskDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{Restrictions.eq("engineid", engineid), Restrictions.like("taskname", taskname, MatchMode.ANYWHERE).ignoreCase()});
      return list;
   }

   public void removeTask(String taskid) {
      this.tCoreMaskingselfTablecolumnDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      this.tCoreMaskingselfTableDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});

      for(TCoreMaskingselfFile t : this.tCoreMaskingselfFileDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid)})) {
         this.tCoreMaskingselfFilecolumnDao.remove(new Criterion[]{Restrictions.eq("fileid", t.getId())});
      }

      this.tCoreMaskingselfFileDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      this.tCoreMaskingselfTaskDao.removeById(taskid);
   }

   public Map<String, Object> queryTaskDetail(String taskid) {
      Map<String, Object> map = new HashMap();
      TCoreMaskingselfTask tCoreMaskingselfTask = (TCoreMaskingselfTask)this.tCoreMaskingselfTaskDao.get(taskid);
      map.put("taskname", tCoreMaskingselfTask.getTaskname());
      map.put("fdname", tCoreMaskingselfTask.getFdname());
      TCoreEngine tCoreEngine = (TCoreEngine)this.tCoreEngineDao.get(tCoreMaskingselfTask.getEngineid());
      map.put("enginename", tCoreEngine.getEnginename());
      return map;
   }

   public Map<String, Object> queryTaskDetailInfo(String taskid, String datadirection) {
      Map<String, Object> map = new HashMap();
      List<TCoreMaskingselfTable> list = this.tCoreMaskingselfTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", datadirection)});
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(((TCoreMaskingselfTable)list.get(0)).getDatasystemid());
      map.put("sysname", tCoreDatasystem.getSysname());
      map.put("schema", ((TCoreMaskingselfTable)list.get(0)).getDbschema());
      if (datadirection.equals(EmaskingDirection.DATA_SOURCE.getFlag())) {
         List<Object> clist = new ArrayList();

         for(int i = 0; i < list.size(); ++i) {
            Map<String, String> c = new HashMap();
            c.put("name", ((TCoreMaskingselfTable)list.get(i)).getTablename());
            c.put("id", ((TCoreMaskingselfTable)list.get(i)).getId());
            clist.add(c);
         }

         map.put("list", clist);
      }

      return map;
   }

   public List<Map<String, Object>> querymultitable(String sourceid) {
      List<Map<String, Object>> list = new ArrayList();
      List<TCoreMaskingselfTablecolumn> slist = this.tCoreMaskingselfTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("tableid", sourceid)});

      for(int i = 0; i < slist.size(); ++i) {
         Map<String, Object> map = new HashMap();
         map.put("sprimarykey", ((TCoreMaskingselfTablecolumn)slist.get(i)).getPrimarykey());
         map.put("sforeignkey", ((TCoreMaskingselfTablecolumn)slist.get(i)).getForeignkey());
         map.put("scolumnname", ((TCoreMaskingselfTablecolumn)slist.get(i)).getColumnname());
         map.put("scolumntype", ((TCoreMaskingselfTablecolumn)slist.get(i)).getColumntype());
         map.put("scolumnlength", ((TCoreMaskingselfTablecolumn)slist.get(i)).getColumnlength());
         map.put("scolumnscale", ((TCoreMaskingselfTablecolumn)slist.get(i)).getColumnscale());
         if (!((TCoreMaskingselfTablecolumn)slist.get(i)).getRuleid().equals("")) {
            TCoreMaskingRule tCoreMaskingRule = (TCoreMaskingRule)this.tCoreMaskingRuleDao.get(((TCoreMaskingselfTablecolumn)slist.get(i)).getRuleid());
            map.put("rulename", tCoreMaskingRule.getRulename());
         } else {
            map.put("rulename", "");
         }

         list.add(map);
      }

      return list;
   }

   public TCoreMaskingselfTask queryEngineMaskingTaskByTaskName(String engineid, String taskname) {
      List<TCoreMaskingselfTask> list = this.tCoreMaskingselfTaskDao.queryAll(new Criterion[]{Restrictions.eq("engineid", engineid), Restrictions.eq("taskname", taskname)});
      return list != null && list.size() > 0 ? (TCoreMaskingselfTask)list.get(0) : null;
   }

   public TCoreMaskingselfTask queryMaskingTaskByID(String taskid) {
      TCoreMaskingselfTask tCoreMaskingselfTask = (TCoreMaskingselfTask)this.tCoreMaskingselfTaskDao.get(taskid);
      return tCoreMaskingselfTask;
   }

   public List<TCoreMaskingselfTable> queryMaskingTable(String taskid, String direction) {
      List<TCoreMaskingselfTable> list = this.tCoreMaskingselfTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", direction)});
      return list;
   }

   public List<ColumnInfo> queryTableColumName(String taskid, String sourceid) {
      new ArrayList();
      List<TCoreMaskingselfTable> table = this.tCoreMaskingselfTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", sourceid), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});
      if (table.size() == 0) {
         return null;
      } else {
         TCoreMaskingselfTable tCoreMaskingselfTable = (TCoreMaskingselfTable)table.get(0);
         String id = tCoreMaskingselfTable.getDatasystemid();
         Connection conn = this.dataSystemService.getConnectionByDataSystemId(id);
         String schemaname = tCoreMaskingselfTable.getDbschema();
         List<ColumnInfo> columnnamelist = JdbcTool.getAllColumnInfo(conn, schemaname, sourceid);

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return columnnamelist;
      }
   }

   public Map<String, Object> queryMultiDBSourceMapping(String taskid, String[] tablename) {
      Map<String, Object> map = new HashMap();

      for(String str : tablename) {
         List<Map<String, String>> list = this.tCoreMaskingselfTaskDao.queryMultiDBSourceMapping(taskid, str);
         List<Map<String, String>> qlist = new ArrayList();

         for(int i = 0; i < list.size(); ++i) {
            Map<String, String> qmap = new HashMap();
            qmap.put("columnname", (list.get(i)).get("columnname"));
            qmap.put("columnsize", (list.get(i)).get("columnlength"));
            qmap.put("datatype", (list.get(i)).get("columntype"));
            qmap.put("decimaldigits", (list.get(i)).get("columnscale"));
            qmap.put("isnullable", (list.get(i)).get("judgenull"));
            qmap.put("maskingruleid", (list.get(i)).get("ruleid"));
            qmap.put("maskingrulename", (list.get(i)).get("rulename"));
            qmap.put("nullable", (list.get(i)).get("judgenull"));
            qmap.put("primarykey", (list.get(i)).get("primarykey"));
            qmap.put("regextype", (list.get(i)).get("regextype"));
            qmap.put("remarks", (list.get(i)).get("remarks"));
            qmap.put("typename", (list.get(i)).get("columntype"));
            qmap.put("foreignkey", (list.get(i)).get("foreignkey"));
            qlist.add(qmap);
         }

         Map<String, Object> rows = new HashMap();
         rows.put("rows", qlist);
         map.put(str, rows);
      }

      return map;
   }

   public List<TCoreMaskingselfTask> querytasklist(String engineid, String taskname) {
      List<TCoreMaskingselfTask> list = this.tCoreMaskingselfTaskDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("engineid", engineid), Restrictions.like("taskname", "%" + taskname + "%")});
      return list;
   }

   public ResultVO addAndModifyMaskingTask(SaveSelfParam ssp) {
      ResultVO rv = new ResultVO("创建失败", false);
      boolean isTaskId = ssp.getTaskId() != null;
      TCoreMaskingselfTask tCoreMaskingselfTask = null;

      try {
         tCoreMaskingselfTask = new TCoreMaskingselfTask();
         if (isTaskId) {
            tCoreMaskingselfTask.setId(ssp.getTaskId());
         }

         tCoreMaskingselfTask.setTaskname(ssp.getTaskName());
         tCoreMaskingselfTask.setCreatetime(new Date());
         tCoreMaskingselfTask.setFdname(ssp.getFdName());
         tCoreMaskingselfTask.setEngineid(ssp.getEngineId());
         tCoreMaskingselfTask.setNote(ssp.getTaskNote());
         tCoreMaskingselfTask.setUserid(ssp.getUserId());
         tCoreMaskingselfTask.setInserttype(ssp.getInsertType());
         this.tCoreMaskingselfTaskDao.saveOrUpdate(tCoreMaskingselfTask);
      } catch (Exception e) {
         e.printStackTrace();
         TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
         rv.setMessage("任务信息错误");
         return rv;
      }

      if (isTaskId) {
         try {
            this.tCoreMaskingselfTablecolumnDao.remove(new Criterion[]{Restrictions.eq("taskid", tCoreMaskingselfTask.getId())});
            this.tCoreMaskingselfTableDao.remove(new Criterion[]{Restrictions.eq("taskid", tCoreMaskingselfTask.getId())});

            for(TCoreMaskingselfFile t : this.tCoreMaskingselfFileDao.queryAll(new Criterion[]{Restrictions.eq("taskid", tCoreMaskingselfTask.getId())})) {
               this.tCoreMaskingselfFilecolumnDao.remove(new Criterion[]{Restrictions.eq("fileid", t.getId())});
            }

            this.tCoreMaskingselfFileDao.remove(new Criterion[]{Restrictions.eq("taskid", tCoreMaskingselfTask.getId())});
         } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            rv.setMessage("清除旧数据错误");
            return rv;
         }
      }

      String uuid = UUID.randomUUID().toString();

      for(int i = 0; i < ssp.getTableInfo().size(); ++i) {
         TCoreMaskingselfTable tCoreMaskingselfTable = null;

         try {
            tCoreMaskingselfTable = new TCoreMaskingselfTable();
            tCoreMaskingselfTable.setDatadirection(EmaskingDirection.DATA_SOURCE.getFlag());
            tCoreMaskingselfTable.setDatasystemid(ssp.getSystemId());
            tCoreMaskingselfTable.setDbschema(ssp.getSchema());
            tCoreMaskingselfTable.setTablename(((TableInfoParam)ssp.getTableInfo().get(i)).getTableName());
            tCoreMaskingselfTable.setTaskid(tCoreMaskingselfTask.getId());
            tCoreMaskingselfTable.setMappingkey(uuid + i);
            this.tCoreMaskingselfTableDao.save(tCoreMaskingselfTable);
         } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            rv.setMessage("表信息错误");
            return rv;
         }

         try {
            for(int j = 0; j < ((TableInfoParam)ssp.getTableInfo().get(i)).getColumnInfo().size(); ++j) {
               ColumnInfoParam cip = (ColumnInfoParam)((TableInfoParam)ssp.getTableInfo().get(i)).getColumnInfo().get(j);
               TCoreMaskingselfTablecolumn tCoreMaskingselfTablecolumn = new TCoreMaskingselfTablecolumn();
               tCoreMaskingselfTablecolumn.setColumnindex(j);
               tCoreMaskingselfTablecolumn.setMappingkey(uuid + i + j);
               tCoreMaskingselfTablecolumn.setTableid(tCoreMaskingselfTable.getId());
               tCoreMaskingselfTablecolumn.setTaskid(tCoreMaskingselfTask.getId());
               tCoreMaskingselfTablecolumn.setPrimarykey(cip.getPrimarykey());
               tCoreMaskingselfTablecolumn.setForeignkey(cip.getForeignkey());
               tCoreMaskingselfTablecolumn.setColumnname(cip.getColumnname());
               tCoreMaskingselfTablecolumn.setColumntype(cip.getTypename());
               tCoreMaskingselfTablecolumn.setColumnlength(cip.getColumnsize() == null ? "" : cip.getColumnsize());
               tCoreMaskingselfTablecolumn.setColumnscale(cip.getDecimaldigits() == null ? "" : cip.getDecimaldigits());
               tCoreMaskingselfTablecolumn.setJudgenull(cip.getIsnullable());
               tCoreMaskingselfTablecolumn.setRuleid(cip.getMaskingruleid() == null ? "" : cip.getMaskingruleid());
               tCoreMaskingselfTablecolumn.setRulename(cip.getMaskingrulename());
               tCoreMaskingselfTablecolumn.setRegextype(cip.getRegextype());
               tCoreMaskingselfTablecolumn.setRemarks(cip.getRemarks());
               tCoreMaskingselfTablecolumn.setDatadirection(EmaskingDirection.DATA_SOURCE.getFlag());
               this.tCoreMaskingselfTablecolumnDao.save(tCoreMaskingselfTablecolumn);
            }
         } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            rv.setMessage("字段信息错误");
            return rv;
         }
      }

      if (tCoreMaskingselfTask.getInserttype().equals("0")) {
         List<Map<String, String>> mappingInfo = null;

         try {
            mappingInfo = this.tConsoleDatamappingInfoDao.getDatamappingInfo(EdataMappingType.getFlagByName(ssp.getDbType()), EdataMappingType.FILESYSTEM.getFlag());
         } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            rv.setMessage("获取字段类型错误");
            return rv;
         }

         for(int i = 0; i < ssp.getTableInfo().size(); ++i) {
            TCoreMaskingselfFile tCoreMaskingselfFile = null;

            try {
               tCoreMaskingselfFile = new TCoreMaskingselfFile();
               tCoreMaskingselfFile.setTaskid(tCoreMaskingselfTask.getId());
               tCoreMaskingselfFile.setMappingkey(uuid + i);
               this.tCoreMaskingselfFileDao.save(tCoreMaskingselfFile);
            } catch (Exception e) {
               e.printStackTrace();
               TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
               rv.setMessage("文件信息错误");
               return rv;
            }

            try {
               for(int j = 0; j < ((TableInfoParam)ssp.getTableInfo().get(i)).getColumnInfo().size(); ++j) {
                  ColumnInfoParam cip = (ColumnInfoParam)((TableInfoParam)ssp.getTableInfo().get(i)).getColumnInfo().get(j);
                  TCoreMaskingselfFilecolumn tCoreMaskingselfFilecolumn = new TCoreMaskingselfFilecolumn();
                  tCoreMaskingselfFilecolumn.setColumnname(cip.getColumnname());

                  for(int k = 0; k < mappingInfo.size(); ++k) {
                     if (cip.getTypename().equals(((Map)mappingInfo.get(k)).get("sourcefieldname"))) {
                        tCoreMaskingselfFilecolumn.setColumntype((String)((Map)mappingInfo.get(k)).get("targetfieldname"));
                        break;
                     }
                  }

                  if (tCoreMaskingselfFilecolumn.getColumntype().equals(ColumnType.DATETIME.getName())) {
                     tCoreMaskingselfFilecolumn.setColumnformat(DateFormat.FORMAT_06.getName());
                  }

                  tCoreMaskingselfFilecolumn.setColumnaccuracy(cip.getColumnsize());
                  tCoreMaskingselfFilecolumn.setColumndecimal(cip.getDecimaldigits() == "" ? "0" : cip.getDecimaldigits());
                  tCoreMaskingselfFilecolumn.setKeytype(cip.getPrimarykey().equals("0") ? "NO" : "YES");
                  if (tCoreMaskingselfFilecolumn.getKeytype().equals("YES")) {
                     tCoreMaskingselfFilecolumn.setColumnnotnull("YES");
                  } else {
                     tCoreMaskingselfFilecolumn.setColumnnotnull(cip.getIsnullable());
                  }

                  tCoreMaskingselfFilecolumn.setMappingkey(uuid + i + j);
                  tCoreMaskingselfFilecolumn.setColumnindex(j);
                  tCoreMaskingselfFilecolumn.setRuleid(cip.getMaskingruleid() == null ? "" : cip.getMaskingruleid());
                  tCoreMaskingselfFilecolumn.setFileid(tCoreMaskingselfFile.getId());
                  this.tCoreMaskingselfFilecolumnDao.save(tCoreMaskingselfFilecolumn);
               }
            } catch (Exception e) {
               e.printStackTrace();
               TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
               rv.setMessage("库与文件字段类型错误");
               return rv;
            }
         }
      }

      for(int i = 0; i < ssp.getTableInfo().size(); ++i) {
         TCoreMaskingselfTable tCoreMaskingselfTable = null;

         try {
            tCoreMaskingselfTable = new TCoreMaskingselfTable();
            tCoreMaskingselfTable.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
            tCoreMaskingselfTable.setDatasystemid(ssp.getSystemId());
            tCoreMaskingselfTable.setDbschema(ssp.getSchema());
            tCoreMaskingselfTable.setTablename(((TableInfoParam)ssp.getTableInfo().get(i)).getTableName());
            tCoreMaskingselfTable.setTaskid(tCoreMaskingselfTask.getId());
            tCoreMaskingselfTable.setMappingkey(uuid + i);
            this.tCoreMaskingselfTableDao.save(tCoreMaskingselfTable);
         } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            rv.setMessage("表信息错误");
            return rv;
         }

         try {
            for(int j = 0; j < ((TableInfoParam)ssp.getTableInfo().get(i)).getColumnInfo().size(); ++j) {
               ColumnInfoParam cip = (ColumnInfoParam)((TableInfoParam)ssp.getTableInfo().get(i)).getColumnInfo().get(j);
               TCoreMaskingselfTablecolumn tCoreMaskingselfTablecolumn = new TCoreMaskingselfTablecolumn();
               tCoreMaskingselfTablecolumn.setColumnindex(j);
               tCoreMaskingselfTablecolumn.setMappingkey(uuid + i + j);
               tCoreMaskingselfTablecolumn.setTableid(tCoreMaskingselfTable.getId());
               tCoreMaskingselfTablecolumn.setTaskid(tCoreMaskingselfTask.getId());
               tCoreMaskingselfTablecolumn.setPrimarykey(cip.getPrimarykey());
               tCoreMaskingselfTablecolumn.setForeignkey(cip.getForeignkey());
               tCoreMaskingselfTablecolumn.setColumnname(cip.getColumnname());
               tCoreMaskingselfTablecolumn.setColumntype(cip.getTypename());
               tCoreMaskingselfTablecolumn.setColumnlength(cip.getColumnsize() == null ? "" : cip.getColumnsize());
               tCoreMaskingselfTablecolumn.setColumnscale(cip.getDecimaldigits() == null ? "" : cip.getDecimaldigits());
               tCoreMaskingselfTablecolumn.setJudgenull(cip.getIsnullable());
               tCoreMaskingselfTablecolumn.setRuleid(cip.getMaskingruleid() == null ? "" : cip.getMaskingruleid());
               tCoreMaskingselfTablecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
               this.tCoreMaskingselfTablecolumnDao.save(tCoreMaskingselfTablecolumn);
            }
         } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            rv.setMessage("字段信息错误");
            return rv;
         }
      }

      try {
         this.infoSelfService.generateTask(tCoreMaskingselfTask, tCoreMaskingselfTask.getUserid());
      } catch (Exception e) {
         e.printStackTrace();
         TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
         rv.setMessage("请检查引擎连通性");
         return rv;
      }

      TConsoleLog record = new TConsoleLog();
      String username = ssp.getUsername();
      record.setModule("本库脱敏");
      record.setOperationtime(new Date());
      record.setUser(username);
      if (!isTaskId) {
         record.setLogmessage("新增本库脱敏任务");
      } else {
         record.setLogmessage("编辑本库脱敏任务");
      }

      this.operationService.add(record);
      rv.setMessage("创建成功");
      rv.setResult(true);
      return rv;
   }

   public int getCountTable(String taskid) {
      int count = (int)this.tCoreMaskingselfTableDao.count(new Criterion[]{Restrictions.eq("taskid", taskid)});
      return count;
   }
}
