package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.core.MaskingTaskDao;
import com.chenyang.nse.bussiness.dao.table.console.mapping.TConsoleDatamappingInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreMaskingruleDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreParameterDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSensitivecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtaskDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructureDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurespliterDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurewidthDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingDetailrecordDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingFilecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingFilesystemDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingHiveDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingHivecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTableDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTablecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTaskDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTaskrecordDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfTaskDao;
import com.chenyang.nse.bussiness.dao.table.core.scheduler.TCoreSchedulerRelationDao;
import com.chenyang.nse.bussiness.dao.table.core.temporary.TCoreMonitorTemporaryDao;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LoginWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LogoutWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetSessionStatisticsWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetWorkflowLogWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.SessionBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.InfoExecUtil;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreParameter;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurespliter;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurewidth;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingDetailrecord;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingFilecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingFilesystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingHive;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingHivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTaskrecord;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.scheduler.TCoreSchedulerRelation;
import com.chenyang.nse.bussiness.entity.orm.table.core.temporary.TCoreMonitorTemporary;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.TreeGridSensitiveDataVO;
import com.chenyang.nse.bussiness.entity.vo.file.TCoreFileStructurecolumnVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TCoreMaskingFilesystemVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TCoreMaskingHivecolumnVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TCoreMaskingTablecolumnVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TCoreMaskingTaskVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TaskRecordVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.EmaskingDirection;
import com.chenyang.nse.bussiness.enumeration.EmaskingTaskType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.enumeration.file.ColumnType;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.service.info.InfoService;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.TeradataTool;
import com.chenyang.nse.bussiness.tools.net.FtpTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.string.PasswordEncryptTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class MaskingTaskServiceImpl implements MaskingTaskService {
   private static final String engineId = "402881e65a646d5d015a6471edf60000";
   @Autowired
   private MaskingTaskDao maskingTaskDao;
   @Autowired
   private TCoreMaskingruleDao tCoreMaskingruleDao;
   @Autowired
   private TCoreParameterDao tCoreParameterDao;
   @Autowired
   private TCoreSensitivecolumnDao tCoreSensitivecolumnDao;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private TCoreMaskingTaskDao tCoreMaskingTaskDao;
   @Autowired
   private TCoreMaskingTableDao tCoreMaskingTableDao;
   @Autowired
   private TCoreMaskingTablecolumnDao tCoreMaskingTablecolumnDao;
   @Autowired
   private TCoreMaskingFilesystemDao tCoreMaskingFilesystemDao;
   @Autowired
   private TCoreMaskingFilecolumnDao tCoreMaskingFilecolumnDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreMonitorTemporaryDao tCoreMonitorTemporaryDao;
   @Autowired
   private TCoreFileStructurecolumnDao tCoreFileStructurecolumnDao;
   @Autowired
   private TCoreFileStructureDao tCoreFileStructureDao;
   @Autowired
   private TCoreFileStructurespliterDao tCoreFileStructurespliterDao;
   @Autowired
   private TCoreFileStructurewidthDao tCoreFileStructurewidthDao;
   @Autowired
   private TCoreMaskingTaskrecordDao tCoreMaskingTaskrecordDao;
   @Autowired
   private TCoreMaskingDetailrecordDao tCoreMaskingDetailrecordDao;
   @Autowired
   private TCoreMaskingHiveDao tCoreMaskingHiveDao;
   @Autowired
   private TCoreMaskingHivecolumnDao tCoreMaskingHivecolumnDao;
   @Autowired
   private TConsoleDatamappingInfoDao tConsoleDatamappingInfoDao;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private InfoService infoService;
   @Autowired
   private TCoreSchedulerRelationDao tCoreSchedulerRelationDao;
   @Autowired
   private TCoreMaskingselfTaskDao tCoreMaskingselfTaskDao;
   @Autowired
   private OperationService operationService;
   @Autowired
   private DesensitizationtaskDao desensitizationtaskDao;

   public TCoreMaskingTask queryMaskingTaskById(String id) {
      return (TCoreMaskingTask)this.tCoreMaskingTaskDao.get(id);
   }

   public TCoreMaskingRule queryMaskingRuleById(String id) {
      TCoreMaskingRule rule = (TCoreMaskingRule)this.tCoreMaskingruleDao.get(id);
      return rule;
   }

   public TCoreMaskingTask queryTaskByName(String taskname) {
      List<TCoreMaskingTask> list = this.tCoreMaskingTaskDao.queryAll(new Criterion[]{Restrictions.eq("taskname", taskname)});
      return list != null && list.size() > 0 ? (TCoreMaskingTask)list.get(0) : null;
   }

   public TCoreMaskingTask queryEngineMaskingTaskByTaskName(String engineid, String taskname) {
      List<TCoreMaskingTask> list = this.tCoreMaskingTaskDao.queryAll(new Criterion[]{Restrictions.eq("engineid", engineid), Restrictions.eq("taskname", taskname)});
      return list != null && list.size() > 0 ? (TCoreMaskingTask)list.get(0) : null;
   }

   public List<TCoreParameter> queryParameterByMaskingTableId(String maskingtableid) {
      return this.tCoreParameterDao.queryAll(new Criterion[]{Restrictions.eq("maskingtablemappingid", maskingtableid)});
   }

   public void modifyTask(TCoreMaskingTask task) {
      this.tCoreMaskingTaskDao.saveOrUpdate(task);
   }

   public TCoreMaskingTask queryTaskByTname(String tname) {
      List<TCoreMaskingTask> list = this.tCoreMaskingTaskDao.queryAll(new Criterion[]{Restrictions.eq("tname", tname)});
      return list != null && list.size() > 0 ? (TCoreMaskingTask)list.get(0) : null;
   }

   public List<TCoreMaskingTask> queryAllTask() {
      return this.tCoreMaskingTaskDao.queryAll();
   }

   public List<TreeGridSensitiveDataVO> querySensitiveColumnsByGroupId(String groupId) {
      List<TreeGridSensitiveDataVO> result = new ArrayList();
      List<TCoreSensitivecolumn> list = this.maskingTaskDao.querySensitiveColumnsByGroupId(groupId);
      if (list != null && list.size() > 0) {
         Map<String, TreeGridSensitiveDataVO> dataSystemMap = new HashMap();

         for(TCoreSensitivecolumn column : list) {
            Map<String, TreeGridSensitiveDataVO> schemaMap = null;
            Map<String, TreeGridSensitiveDataVO> tableMap = null;
            TreeGridSensitiveDataVO dataSystemVO = null;
            TreeGridSensitiveDataVO schemaVO = null;
            TreeGridSensitiveDataVO tableVO = null;
            TreeGridSensitiveDataVO columnVO = null;
            String dataSystemId = column.getDatasourceid();
            if (!dataSystemMap.containsKey(dataSystemId)) {
               dataSystemVO = new TreeGridSensitiveDataVO(dataSystemId, column.getDatasourcename(), "DATASYSTEM", "icon-db", true);
               result.add(dataSystemVO);
               dataSystemMap.put(dataSystemId, dataSystemVO);
            } else {
               dataSystemVO = (TreeGridSensitiveDataVO)dataSystemMap.get(dataSystemId);
            }

            schemaMap = dataSystemVO.getChildrenMap();
            String schema = column.getTschema();
            if (!schemaMap.containsKey(schema)) {
               schemaVO = new TreeGridSensitiveDataVO(PasswordEncryptTool.generatePassword(dataSystemId + schema), schema, "SCHEMA", "icon-folder", true);
               dataSystemVO.getChildren().add(schemaVO);
               schemaMap.put(schema, schemaVO);
            } else {
               schemaVO = (TreeGridSensitiveDataVO)schemaMap.get(schema);
            }

            tableMap = schemaVO.getChildrenMap();
            String tableName = column.getTablename();
            if (!tableMap.containsKey(tableName)) {
               tableVO = new TreeGridSensitiveDataVO(PasswordEncryptTool.generatePassword(dataSystemId + schema + tableName), tableName, "TABLE", "icon-table", false);
               tableVO.setChildren(new ArrayList());
               schemaVO.getChildren().add(tableVO);
               tableMap.put(tableName, tableVO);
            } else {
               tableVO = (TreeGridSensitiveDataVO)tableMap.get(tableName);
            }

            columnVO = new TreeGridSensitiveDataVO(column.getId(), column.getColumnname(), "COLUMN", "icon-column", false);
            columnVO.setRuleId(column.getRuleid());
            columnVO.setRuleName(column.getRulename());
            columnVO.setRegexType(column.getRegextype());
            tableVO.getChildren().add(columnVO);
         }

         for(TreeGridSensitiveDataVO dataSystem : result) {
            dataSystem.setChildrenMap((Map)null);

            for(TreeGridSensitiveDataVO schema : dataSystem.getChildren()) {
               schema.setChildrenMap((Map)null);
            }
         }
      }

      return result;
   }

   public TCoreSensitivecolumn getSensitiveColumn(String datasystemid, String schema, String table, String column) {
      List<TCoreSensitivecolumn> list = this.tCoreSensitivecolumnDao.queryAll(new Criterion[]{Restrictions.eq("datasourceid", datasystemid), Restrictions.eq("schema", schema), Restrictions.eq("tablename", table), Restrictions.eq("columnname", column)});
      return list != null && list.size() > 0 ? (TCoreSensitivecolumn)list.get(0) : null;
   }

   public List<TCoreMaskingDetailrecord> querytablerecord(String recordid) {
      List<TCoreMaskingDetailrecord> record = this.tCoreMaskingDetailrecordDao.queryAll(new Criterion[]{Restrictions.eq("taskrecordid", recordid)});
      return record;
   }

   public List<TaskRecordVO> querytaskrecord(String taskid) {
      List<TaskRecordVO> list = this.tCoreMaskingTaskrecordDao.getTaskRecord(taskid);
      return list;
   }

   public int getLines(String targetname) {
      int k = 0;

      try {
         InputStream is = new FileInputStream(targetname);

         for(BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is)); tBufferedReader.readLine() != null; ++k) {
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return k + 1;
   }

   public void removeNoNameTask(String engineid) {
   }

   public void removeTask(String taskid) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingTaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String xmlsPath = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname();
      FileTool.delFolder(xmlsPath);
      TCoreMaskingTask tCoreMaskingTask = (TCoreMaskingTask)this.tCoreMaskingTaskDao.queryUnique(new Criterion[]{Restrictions.eq("id", taskid)});
      String flag = tCoreMaskingTask.getFlag();
      String[] nflag = StringUtils.split(flag, "-");
      String sourcetype = nflag[0];
      String targettype = nflag[1];
      if (sourcetype.equals(EmaskingTaskType.DB.getFlag())) {
         List<TCoreMaskingTable> list = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});

         for(int i = 0; i < list.size(); ++i) {
            this.tCoreMaskingTablecolumnDao.remove(new Criterion[]{Restrictions.eq("tableid", ((TCoreMaskingTable)list.get(i)).getId())});
         }

         this.tCoreMaskingTableDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});
      } else if (sourcetype.equals(EmaskingTaskType.FILE.getFlag())) {
         List<TCoreMaskingFilesystem> list = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});

         for(int i = 0; i < list.size(); ++i) {
            this.tCoreMaskingFilecolumnDao.remove(new Criterion[]{Restrictions.eq("filesystemid", ((TCoreMaskingFilesystem)list.get(i)).getId())});
         }

         this.tCoreMaskingFilesystemDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});
      } else if (sourcetype.equals(EmaskingTaskType.HIVE.getFlag())) {
         List<TCoreMaskingHive> list = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});

         for(int i = 0; i < list.size(); ++i) {
            this.tCoreMaskingHivecolumnDao.remove(new Criterion[]{Restrictions.eq("tableid", ((TCoreMaskingHive)list.get(i)).getId())});
         }

         this.tCoreMaskingHiveDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});
      }

      if (targettype.equals(EmaskingTaskType.DB.getFlag())) {
         List<TCoreMaskingTable> list = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});

         for(int i = 0; i < list.size(); ++i) {
            this.tCoreMaskingTablecolumnDao.remove(new Criterion[]{Restrictions.eq("tableid", ((TCoreMaskingTable)list.get(i)).getId())});
         }

         this.tCoreMaskingTableDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});
      } else if (targettype.equals(EmaskingTaskType.FILE.getFlag())) {
         List<TCoreMaskingFilesystem> list = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});

         for(int i = 0; i < list.size(); ++i) {
            if (tCoreMaskingTask.getTasktype().equals("multi") && sourcetype.equals(EmaskingTaskType.DB.getFlag())) {
               TCoreFileStructure tCoreFileStructure = (TCoreFileStructure)this.tCoreFileStructureDao.queryUnique(new Criterion[]{Restrictions.eq("id", ((TCoreMaskingFilesystem)list.get(i)).getStructureid())});
               if (tCoreFileStructure != null) {
                  if (tCoreFileStructure.getSplitertype().equals("0")) {
                     this.tCoreFileStructurespliterDao.remove(new Criterion[]{Restrictions.eq("filestructureid", tCoreFileStructure.getId())});
                  } else if (tCoreFileStructure.getSplitertype().equals("1")) {
                     this.tCoreFileStructurewidthDao.remove(new Criterion[]{Restrictions.eq("filestructureid", tCoreFileStructure.getId())});
                  }

                  this.tCoreFileStructurecolumnDao.remove(new Criterion[]{Restrictions.eq("filestructureid", tCoreFileStructure.getId())});
                  this.tCoreFileStructureDao.removeById(tCoreFileStructure.getId());
               }
            }

            this.tCoreMaskingFilecolumnDao.remove(new Criterion[]{Restrictions.eq("filesystemid", ((TCoreMaskingFilesystem)list.get(i)).getId())});
         }

         this.tCoreMaskingFilesystemDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});
      } else if (targettype.equals(EmaskingTaskType.HIVE.getFlag())) {
         List<TCoreMaskingHive> list = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});

         for(int i = 0; i < list.size(); ++i) {
            this.tCoreMaskingHivecolumnDao.remove(new Criterion[]{Restrictions.eq("tableid", ((TCoreMaskingHive)list.get(i)).getId())});
         }

         this.tCoreMaskingHiveDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});
      }

      List<TCoreMaskingTaskrecord> trlist = this.tCoreMaskingTaskrecordDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid)});
      if (!trlist.isEmpty()) {
         this.tCoreMaskingDetailrecordDao.remove(new Criterion[]{Restrictions.eq("taskrecordid", ((TCoreMaskingTaskrecord)trlist.get(0)).getId())});
         this.tCoreMaskingTaskrecordDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      }

      this.tCoreMaskingTaskDao.removeById(taskid);
   }

   public List<TCoreMaskingTask> queryTask(String engineid, String taskname, PageInfo pageInfo) {
      long count = this.tCoreMaskingTaskDao.count(new Criterion[]{Restrictions.eq("engineid", engineid), Restrictions.ne("flag", EmaskingTaskType.SUB_TO_DB.getFlag())});
      pageInfo.setCount(count);
      List<TCoreMaskingTask> list = this.tCoreMaskingTaskDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{Restrictions.eq("engineid", engineid), Restrictions.ne("flag", EmaskingTaskType.SUB_TO_DB.getFlag()), Restrictions.like("taskname", taskname, MatchMode.ANYWHERE).ignoreCase()});
      return list;
   }

   public List<TCoreMaskingTask> queryTaskList(String engineid, String taskname) {
      List<TCoreMaskingTask> list = this.tCoreMaskingTaskDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("engineid", engineid), Restrictions.like("taskname", taskname, MatchMode.ANYWHERE).ignoreCase()});
      return list;
   }

   public List<TCoreMaskingTask> queryTaskList(String taskid) {
      List<TCoreMaskingTask> list = this.tCoreMaskingTaskDao.queryAll(new Criterion[]{Restrictions.eq("id", taskid)});
      return list;
   }

   public List<TCoreMonitorTemporary> queryTasktmpo(String taskid, String groupid, PageInfo pageInfo, int indexrow) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingTaskDao.get(taskid);
      TCoreMaskingselfTask t = null;
      TCoreEngine tengine;
      if (task == null) {
         t = (TCoreMaskingselfTask)this.tCoreMaskingselfTaskDao.get(taskid);
         tengine = (TCoreEngine)this.tCoreEngineDao.get(t.getEngineid());
      } else {
         tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      }

      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      List<TCoreMonitorTemporary> list = this.tCoreMonitorTemporaryDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{Restrictions.eq("groupid", Long.parseLong(groupid))});
      List<TCoreMonitorTemporary> rtnList = new ArrayList();
      if (indexrow == 0) {
         try {
            String sessionID = LoginWebService.returnStatus(info);

            for(TCoreMonitorTemporary tCoreMonitorTemporary : list) {
               String status = MultiGetSessionStatisticsWebService.returnStatusOnly(sessionID, info, "wf_" + tCoreMonitorTemporary.getWfname(), "mp_" + tCoreMonitorTemporary.getWfname(), task.getFdname());
               if ("SUCCEEDED".equals(status)) {
                  tCoreMonitorTemporary.setFlag("1");
               } else if ("FAILED".equals(status)) {
                  tCoreMonitorTemporary.setFlag("2");
               } else if ("STOPPED".equals(status)) {
                  tCoreMonitorTemporary.setFlag("3");
               } else {
                  tCoreMonitorTemporary.setFlag("4");
               }

               rtnList.add(tCoreMonitorTemporary);
            }

            LogoutWebService.returnStatus(sessionID, info);
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else {
         rtnList = list;
      }

      return rtnList;
   }

   public List<TCoreMonitorTemporary> queryTasktmpoNew(String taskid, String groupid, PageInfo pageInfo, int indexrow) {
      Desensitizationtask task = (Desensitizationtask)this.desensitizationtaskDao.get(taskid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue("402881e65a646d5d015a6471edf60000");
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      List<TCoreMonitorTemporary> list = this.tCoreMonitorTemporaryDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{Restrictions.eq("groupid", Long.parseLong(groupid))});
      List<TCoreMonitorTemporary> rtnList = new ArrayList();
      if (indexrow == 0) {
         try {
            String sessionID = LoginWebService.returnStatus(info);

            for(TCoreMonitorTemporary tCoreMonitorTemporary : list) {
               String status = MultiGetSessionStatisticsWebService.returnStatusOnly(sessionID, info, "wf_" + tCoreMonitorTemporary.getWfname(), "mp_" + tCoreMonitorTemporary.getWfname(), task.getFoldername());
               if ("SUCCEEDED".equals(status)) {
                  tCoreMonitorTemporary.setFlag("1");
               } else if ("FAILED".equals(status)) {
                  tCoreMonitorTemporary.setFlag("2");
               } else if ("STOPPED".equals(status)) {
                  tCoreMonitorTemporary.setFlag("3");
               } else {
                  tCoreMonitorTemporary.setFlag("4");
               }

               rtnList.add(tCoreMonitorTemporary);
            }

            LogoutWebService.returnStatus(sessionID, info);
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else {
         rtnList = list;
      }

      return rtnList;
   }

   public List<TCoreMonitorTemporary> queryTasktmpoCoreIndex(String taskid) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingTaskDao.get(taskid);
      TCoreMaskingselfTask t = null;
      TCoreEngine tengine;
      if (task == null) {
         t = (TCoreMaskingselfTask)this.tCoreMaskingselfTaskDao.get(taskid);
         tengine = (TCoreEngine)this.tCoreEngineDao.get(t.getEngineid());
      } else {
         tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      }

      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      List<TCoreMonitorTemporary> list = this.tCoreMonitorTemporaryDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("taskid", taskid)});
      if (list != null && list.size() > 0) {
         for(int i = 0; i < list.size(); ++i) {
            String col = "";

            try {
               if (task == null) {
                  col = InfoExecUtil.executMonitor(info.getPmcmdexepath(), t.getFdname(), "wf_" + ((TCoreMonitorTemporary)list.get(i)).getWfname(), "s_M_mp_" + ((TCoreMonitorTemporary)list.get(i)).getWfname(), info.getUsername(), info.getPassword(), info.getInteservicename(), info.getDomainname(), ((TCoreMonitorTemporary)list.get(i)).getRunid());
               } else {
                  col = InfoExecUtil.executMonitor(info.getPmcmdexepath(), task.getFdname(), "wf_" + ((TCoreMonitorTemporary)list.get(i)).getWfname(), "s_M_mp_" + ((TCoreMonitorTemporary)list.get(i)).getWfname(), info.getUsername(), info.getPassword(), info.getInteservicename(), info.getDomainname(), ((TCoreMonitorTemporary)list.get(i)).getRunid());
               }
            } catch (Exception e) {
               e.printStackTrace();
            }

            NumberFormat nt = NumberFormat.getPercentInstance();
            nt.setMinimumFractionDigits(0);
            if (((TCoreMonitorTemporary)list.get(i)).getDatacount() > 0 && !"".equals(col) && col != null) {
               float b = (float)Long.parseLong(col) / (float)((TCoreMonitorTemporary)list.get(i)).getDatacount();
               String s = nt.format((double)b);
               ((TCoreMonitorTemporary)list.get(i)).setJdbar(s);
            } else {
               ((TCoreMonitorTemporary)list.get(i)).setJdbar("100%");
            }
         }
      }

      return list;
   }

   public boolean stopwork(String taskid) {
      boolean flag = false;
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingTaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      List<TCoreMonitorTemporary> list = this.tCoreMonitorTemporaryDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("taskid", taskid)});
      if (list != null && list.size() > 0) {
         for(int i = 0; i < list.size(); ++i) {
            String col = "";

            try {
               col = InfoExecUtil.executResult(info.getPmcmdexepath(), task.getFdname(), "wf_" + ((TCoreMonitorTemporary)list.get(i)).getWfname(), "s_M_mp_" + ((TCoreMonitorTemporary)list.get(i)).getWfname(), info.getUsername(), info.getPassword(), info.getInteservicename(), info.getDomainname(), ((TCoreMonitorTemporary)list.get(i)).getRunid());
            } catch (Exception var11) {
               flag = false;
            }

            if (col == "RUNNING") {
               flag = true;
            }
         }
      }

      return flag;
   }

   public TCoreMaskingTable queryTableByTaskId(String taskid) {
      TCoreMaskingTable table = (TCoreMaskingTable)this.tCoreMaskingTableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", "1")});
      return table;
   }

   public InfoProperty getInfoProperty(TCoreMaskingTask task) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      return info;
   }

   public InfoProperty getInfoPropertySelf(TCoreMaskingselfTask task) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      return info;
   }

   public Connection getConnectionByDataSystemId(String datasystemid) {
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
      String dbcode = datasystem.getDbtype();
      String ip = datasystem.getDbip();
      String port = datasystem.getDbport();
      String servername = datasystem.getDbservername();
      String server = datasystem.getServername();
      String url = "";
      switch (datasystem.getDbtype()) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server);
            break;
         case "TERADATA":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server, datasystem.getPagecode());
            break;
         default:
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername);
      }

      String username = datasystem.getUsername();
      String password = "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword();
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
         Connection conn = JdbcTool.getKerberosConn(url + ";principal=" + datasystem.getPrincipal(), driver, datasystem.getLoginprincipal(), datasystem.getXmlpath());
         return conn;
      } else if (dbcode.equals("RAPIDSDB")) {
         Connection conn = JdbcTool.getConnection(driver, url, username, "");
         return conn;
      } else {
         Connection conn = JdbcTool.getConnection(driver, url, username, password);
         return conn;
      }
   }

   public List<TCoreDatasystem> queryFTP() {
      List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.eq("dbtype", "FTP")});
      return list;
   }

   public TCoreMaskingTask queryMaskingTaskByID(String taskid) {
      TCoreMaskingTask tCoreMaskingTask = (TCoreMaskingTask)this.tCoreMaskingTaskDao.queryUnique(new Criterion[]{Restrictions.eq("id", taskid)});
      return tCoreMaskingTask;
   }

   public TCoreMaskingTaskVO queryMaskingTaskVOByID(String taskid) {
      List<TCoreMaskingTaskVO> list = this.tCoreMaskingTaskDao.queryMaskingTaskVOByID(taskid);
      return (TCoreMaskingTaskVO)list.get(0);
   }

   public Map<String, Object> queryTaskDetailInfo(String taskid, String datadirection, String flag, String tasktype) {
      Map<String, Object> map = new HashMap();
      if (EmaskingTaskType.DB.getFlag().equals(flag)) {
         List<TCoreMaskingTable> list = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", datadirection)});
         TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(((TCoreMaskingTable)list.get(0)).getDatasystemid());
         map.put("sysname", tCoreDatasystem.getSysname());
         map.put("schema", ((TCoreMaskingTable)list.get(0)).getDbschema());
         if (tasktype.equals("single") || datadirection.equals(EmaskingDirection.DATA_SOURCE.getFlag())) {
            List<Object> clist = new ArrayList();

            for(int i = 0; i < list.size(); ++i) {
               Map<String, String> c = new HashMap();
               c.put("name", ((TCoreMaskingTable)list.get(i)).getTablename());
               c.put("id", ((TCoreMaskingTable)list.get(i)).getId());
               clist.add(c);
            }

            map.put("list", clist);
         }
      } else if (EmaskingTaskType.FILE.getFlag().equals(flag)) {
         List<TCoreMaskingFilesystemVO> list = this.tCoreMaskingFilesystemDao.queryMaskingFilesystemVO(taskid, datadirection);
         map.put("structuregroup", ((TCoreMaskingFilesystemVO)list.get(0)).getFilestructuregroup());
         map.put("location", ((TCoreMaskingFilesystemVO)list.get(0)).getLocation());
         map.put("directory", ((TCoreMaskingFilesystemVO)list.get(0)).getDirectory());
         if (((TCoreMaskingFilesystemVO)list.get(0)).getLocation().equals("1")) {
            map.put("ftpname", ((TCoreMaskingFilesystemVO)list.get(0)).getSysname());
         }

         if (tasktype.equals("single") || !datadirection.equals("1")) {
            List<Object> clist = new ArrayList();

            for(int i = 0; i < list.size(); ++i) {
               Map<String, String> c = new HashMap();
               c.put("id", ((TCoreMaskingFilesystemVO)list.get(i)).getId());
               c.put("name", ((TCoreMaskingFilesystemVO)list.get(i)).getFilestructurename());
               clist.add(c);
            }

            map.put("list", clist);
         }
      } else if (EmaskingTaskType.HIVE.getFlag().equals(flag)) {
         List<TCoreMaskingHive> list = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", datadirection)});
         TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(((TCoreMaskingHive)list.get(0)).getDatasystemid());
         map.put("sysname", tCoreDatasystem.getSysname());
         map.put("schema", ((TCoreMaskingHive)list.get(0)).getDbschema());
         if (tasktype.equals("single") || datadirection.equals(EmaskingDirection.DATA_SOURCE.getFlag())) {
            List<Object> clist = new ArrayList();

            for(int i = 0; i < list.size(); ++i) {
               Map<String, String> c = new HashMap();
               c.put("name", ((TCoreMaskingHive)list.get(i)).getTablename());
               c.put("id", ((TCoreMaskingHive)list.get(i)).getId());
               clist.add(c);
            }

            map.put("list", clist);
         }
      }

      return map;
   }

   public List<Map<String, Object>> querySingleTable(String sourceid, String sourceflag, String targetid, String targetflag) {
      List<Map<String, Object>> list = new ArrayList();
      if (EmaskingTaskType.DB.getFlag().equals(sourceflag)) {
         List<TCoreMaskingTablecolumnVO> slist = this.tCoreMaskingTableDao.queryMaskingTablecolumnVO(sourceid);
         if (EmaskingTaskType.DB.getFlag().equals(targetflag)) {
            List<TCoreMaskingTablecolumnVO> tlist = this.tCoreMaskingTableDao.queryMaskingTablecolumnVO(targetid);

            for(int i = 0; i < slist.size(); ++i) {
               Map<String, Object> map = new HashMap();
               map.put("sprimarykey", ((TCoreMaskingTablecolumnVO)slist.get(i)).getPrimarykey());
               map.put("scolumnname", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnname());
               map.put("scolumntype", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumntype());
               map.put("scolumnlength", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnlength());
               map.put("scolumnscale", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnscale());
               map.put("rulename", ((TCoreMaskingTablecolumnVO)slist.get(i)).getMaskingrulename());
               map.put("tprimarykey", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getPrimarykey());
               map.put("tcolumnname", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumnname());
               map.put("tcolumntype", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumntype());
               map.put("tcolumnlength", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumnlength());
               map.put("tcolumnscale", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumnscale());
               list.add(map);
            }
         } else if (EmaskingTaskType.FILE.getFlag().equals(targetflag)) {
            List<TCoreFileStructurecolumnVO> tlist = this.tCoreMaskingFilesystemDao.queryFileStructurecolumnVO(targetid);

            for(int i = 0; i < slist.size(); ++i) {
               Map<String, Object> map = new HashMap();
               map.put("sprimarykey", ((TCoreMaskingTablecolumnVO)slist.get(i)).getPrimarykey());
               map.put("scolumnname", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnname());
               map.put("scolumntype", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumntype());
               map.put("scolumnlength", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnlength());
               map.put("scolumnscale", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnscale());
               map.put("rulename", ((TCoreMaskingTablecolumnVO)slist.get(i)).getMaskingrulename());
               map.put("tprimarykey", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumnindex());
               map.put("tcolumnname", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumnname());
               map.put("tcolumntype", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumntype());
               map.put("tcolumnlength", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumnaccuracy());
               map.put("tcolumnscale", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumndecimal());
               list.add(map);
            }
         } else if (EmaskingTaskType.HIVE.getFlag().equals(targetflag)) {
            List<TCoreMaskingHivecolumnVO> tlist = this.tCoreMaskingHiveDao.queryMaskingHivecolumnVO(targetid);

            for(int i = 0; i < slist.size(); ++i) {
               Map<String, Object> map = new HashMap();
               map.put("sprimarykey", ((TCoreMaskingTablecolumnVO)slist.get(i)).getPrimarykey());
               map.put("scolumnname", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnname());
               map.put("scolumntype", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumntype());
               map.put("scolumnlength", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnlength());
               map.put("scolumnscale", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnscale());
               map.put("rulename", ((TCoreMaskingTablecolumnVO)slist.get(i)).getMaskingrulename());
               map.put("tprimarykey", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnindex());
               map.put("tcolumnname", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnname());
               map.put("tcolumntype", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumntype());
               map.put("tcolumnlength", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnlength());
               map.put("tcolumnscale", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnscale());
               list.add(map);
            }
         }
      } else if (EmaskingTaskType.FILE.getFlag().equals(sourceflag)) {
         List<TCoreFileStructurecolumnVO> slist = this.tCoreMaskingFilesystemDao.queryFileStructurecolumnVO(sourceid);
         if (EmaskingTaskType.DB.getFlag().equals(targetflag)) {
            List<TCoreMaskingTablecolumnVO> tlist = this.tCoreMaskingTableDao.queryMaskingTablecolumnVO(targetid);

            for(int i = 0; i < slist.size(); ++i) {
               Map<String, Object> map = new HashMap();
               map.put("sprimarykey", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnindex());
               map.put("scolumnname", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnname());
               map.put("scolumntype", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumntype());
               map.put("scolumnlength", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnaccuracy());
               map.put("scolumnscale", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumndecimal());
               map.put("rulename", ((TCoreFileStructurecolumnVO)slist.get(i)).getMaskingrulename());
               map.put("tprimarykey", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getPrimarykey());
               map.put("tcolumnname", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumnname());
               map.put("tcolumntype", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumntype());
               map.put("tcolumnlength", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumnlength());
               map.put("tcolumnscale", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumnscale());
               list.add(map);
            }
         } else if (EmaskingTaskType.FILE.getFlag().equals(targetflag)) {
            List<TCoreFileStructurecolumnVO> tlist = this.tCoreMaskingFilesystemDao.queryFileStructurecolumnVO(targetid);

            for(int i = 0; i < slist.size(); ++i) {
               Map<String, Object> map = new HashMap();
               map.put("sprimarykey", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnindex());
               map.put("scolumnname", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnname());
               map.put("scolumntype", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumntype());
               map.put("scolumnlength", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnaccuracy());
               map.put("scolumnscale", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumndecimal());
               map.put("rulename", ((TCoreFileStructurecolumnVO)slist.get(i)).getMaskingrulename());
               map.put("tprimarykey", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumnindex());
               map.put("tcolumnname", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumnname());
               map.put("tcolumntype", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumntype());
               map.put("tcolumnlength", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumnaccuracy());
               map.put("tcolumnscale", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumndecimal());
               list.add(map);
            }
         } else if (EmaskingTaskType.HIVE.getFlag().equals(targetflag)) {
            List<TCoreMaskingHivecolumnVO> tlist = this.tCoreMaskingHiveDao.queryMaskingHivecolumnVO(targetid);

            for(int i = 0; i < slist.size(); ++i) {
               Map<String, Object> map = new HashMap();
               map.put("sprimarykey", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnindex());
               map.put("scolumnname", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnname());
               map.put("scolumntype", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumntype());
               map.put("scolumnlength", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnaccuracy());
               map.put("scolumnscale", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumndecimal());
               map.put("rulename", ((TCoreFileStructurecolumnVO)slist.get(i)).getMaskingrulename());
               map.put("tprimarykey", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnindex());
               map.put("tcolumnname", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnname());
               map.put("tcolumntype", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumntype());
               map.put("tcolumnlength", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnlength());
               map.put("tcolumnscale", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnscale());
               list.add(map);
            }
         }
      } else if (EmaskingTaskType.HIVE.getFlag().equals(sourceflag)) {
         List<TCoreMaskingHivecolumnVO> slist = this.tCoreMaskingHiveDao.queryMaskingHivecolumnVO(sourceid);
         if (EmaskingTaskType.DB.getFlag().equals(targetflag)) {
            List<TCoreMaskingTablecolumnVO> tlist = this.tCoreMaskingTableDao.queryMaskingTablecolumnVO(targetid);

            for(int i = 0; i < slist.size(); ++i) {
               Map<String, Object> map = new HashMap();
               map.put("sprimarykey", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnindex());
               map.put("scolumnname", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnname());
               map.put("scolumntype", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumntype());
               map.put("scolumnlength", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnlength());
               map.put("scolumnscale", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnscale());
               map.put("rulename", ((TCoreMaskingHivecolumnVO)slist.get(i)).getMaskingrulename());
               map.put("tprimarykey", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getPrimarykey());
               map.put("tcolumnname", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumnname());
               map.put("tcolumntype", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumntype());
               map.put("tcolumnlength", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumnlength());
               map.put("tcolumnscale", ((TCoreMaskingTablecolumnVO)tlist.get(i)).getColumnscale());
               list.add(map);
            }
         } else if (EmaskingTaskType.FILE.getFlag().equals(targetflag)) {
            List<TCoreFileStructurecolumnVO> tlist = this.tCoreMaskingFilesystemDao.queryFileStructurecolumnVO(targetid);

            for(int i = 0; i < slist.size(); ++i) {
               Map<String, Object> map = new HashMap();
               map.put("sprimarykey", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnindex());
               map.put("scolumnname", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnname());
               map.put("scolumntype", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumntype());
               map.put("scolumnlength", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnlength());
               map.put("scolumnscale", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnscale());
               map.put("rulename", ((TCoreMaskingHivecolumnVO)slist.get(i)).getMaskingrulename());
               map.put("tprimarykey", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumnindex());
               map.put("tcolumnname", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumnname());
               map.put("tcolumntype", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumntype());
               map.put("tcolumnlength", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumnaccuracy());
               map.put("tcolumnscale", ((TCoreFileStructurecolumnVO)tlist.get(i)).getColumndecimal());
               list.add(map);
            }
         } else if (EmaskingTaskType.HIVE.getFlag().equals(targetflag)) {
            List<TCoreMaskingHivecolumnVO> tlist = this.tCoreMaskingHiveDao.queryMaskingHivecolumnVO(targetid);

            for(int i = 0; i < slist.size(); ++i) {
               Map<String, Object> map = new HashMap();
               map.put("sprimarykey", ((TCoreMaskingHivecolumnVO)slist.get(i)).getPrimarykey());
               map.put("scolumnname", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnname());
               map.put("scolumntype", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumntype());
               map.put("scolumnlength", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnlength());
               map.put("scolumnscale", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnscale());
               map.put("rulename", ((TCoreMaskingHivecolumnVO)slist.get(i)).getMaskingrulename());
               map.put("tprimarykey", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnindex());
               map.put("tcolumnname", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnname());
               map.put("tcolumntype", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumntype());
               map.put("tcolumnlength", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnlength());
               map.put("tcolumnscale", ((TCoreMaskingHivecolumnVO)tlist.get(i)).getColumnscale());
               list.add(map);
            }
         }
      }

      return list;
   }

   public List<Map<String, Object>> queryMultiTable(String sourceid, String sourceflag) {
      List<Map<String, Object>> list = new ArrayList();
      if (EmaskingTaskType.DB.getFlag().equals(sourceflag)) {
         List<TCoreMaskingTablecolumnVO> slist = this.tCoreMaskingTableDao.queryMaskingTablecolumnVO(sourceid);

         for(int i = 0; i < slist.size(); ++i) {
            Map<String, Object> map = new HashMap();
            map.put("sprimarykey", ((TCoreMaskingTablecolumnVO)slist.get(i)).getPrimarykey());
            map.put("scolumnname", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnname());
            map.put("scolumntype", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumntype());
            map.put("scolumnlength", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnlength());
            map.put("scolumnscale", ((TCoreMaskingTablecolumnVO)slist.get(i)).getColumnscale());
            map.put("rulename", ((TCoreMaskingTablecolumnVO)slist.get(i)).getMaskingrulename());
            list.add(map);
         }
      } else if (EmaskingTaskType.FILE.getFlag().equals(sourceflag)) {
         List<TCoreFileStructurecolumnVO> slist = this.tCoreMaskingFilesystemDao.queryFileStructurecolumnVO(sourceid);

         for(int i = 0; i < slist.size(); ++i) {
            Map<String, Object> map = new HashMap();
            map.put("sprimarykey", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnindex());
            map.put("scolumnname", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnname());
            map.put("scolumntype", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumntype());
            map.put("scolumnlength", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumnaccuracy());
            map.put("scolumnscale", ((TCoreFileStructurecolumnVO)slist.get(i)).getColumndecimal());
            map.put("rulename", ((TCoreFileStructurecolumnVO)slist.get(i)).getMaskingrulename());
            list.add(map);
         }
      } else if (EmaskingTaskType.HIVE.getFlag().equals(sourceflag)) {
         List<TCoreMaskingHivecolumnVO> slist = this.tCoreMaskingHiveDao.queryMaskingHivecolumnVO(sourceid);

         for(int i = 0; i < slist.size(); ++i) {
            Map<String, Object> map = new HashMap();
            map.put("sprimarykey", ((TCoreMaskingHivecolumnVO)slist.get(i)).getPrimarykey());
            map.put("scolumnname", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnname());
            map.put("scolumntype", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumntype());
            map.put("scolumnlength", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnlength());
            map.put("scolumnscale", ((TCoreMaskingHivecolumnVO)slist.get(i)).getColumnscale());
            map.put("rulename", ((TCoreMaskingHivecolumnVO)slist.get(i)).getMaskingrulename());
            list.add(map);
         }
      }

      return list;
   }

   public TCoreMaskingFilesystem queryMaskingFilesystemByID(String filesystemid) {
      TCoreMaskingFilesystem tCoreMaskingFilesystem = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.get(filesystemid);
      return tCoreMaskingFilesystem;
   }

   public ResultVO copyTableByFile(String filestructureid, String tdatasystem, String tschema, String ttable) {
      Connection tconn = this.getConnectionByDataSystemId(tdatasystem);
      String targetsystemtype = JdbcTool.getDataBaseType(tconn);
      List<Map<String, String>> mappingInfo = this.tConsoleDatamappingInfoDao.getDatamappingInfo(EdataMappingType.getFlagByName("FILESYSTEM"), EdataMappingType.getFlagByName(targetsystemtype));
      List<TCoreFileStructurecolumn> fscList = this.tCoreFileStructurecolumnDao.queryAll(new Criterion[]{Restrictions.eq("filestructureid", filestructureid)});
      List<ColumnInfoVO> sourceList = new ArrayList();

      for(TCoreFileStructurecolumn fsc : fscList) {
         ColumnInfoVO cv = new ColumnInfoVO();
         cv.setColumnname(fsc.getColumnname());
         cv.setTypename(fsc.getColumntype());
         cv.setColumnsize(fsc.getColumnaccuracy());
         cv.setDecimaldigits(fsc.getColumndecimal().equals("0") ? "" : fsc.getColumndecimal());
         cv.setIsnullable(fsc.getColumnnotnull());
         sourceList.add(cv);
      }

      boolean isCreate = JdbcTool.copyTable(tconn, tschema, ttable, sourceList, mappingInfo);
      JdbcTool.closeConnection(tconn);
      ResultVO rv = new ResultVO("", isCreate);
      return rv;
   }

   public List<TCoreMaskingTable> queryMaskingTable(String taskid, String direction) {
      List<TCoreMaskingTable> list = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", direction)});
      return list;
   }

   public List<TCoreMaskingFilesystemVO> queryMaskingFile(String taskid, String direction) {
      List<TCoreMaskingFilesystemVO> list = this.tCoreMaskingFilesystemDao.queryMaskingFilesystemVO(taskid, direction);

      for(TCoreMaskingFilesystemVO tCoreMaskingFilesystemVO : list) {
         tCoreMaskingFilesystemVO.setDirectory(tCoreMaskingFilesystemVO.getFlag() == null ? tCoreMaskingFilesystemVO.getDirectory() : tCoreMaskingFilesystemVO.getFlag());
         tCoreMaskingFilesystemVO.setWildcard(tCoreMaskingFilesystemVO.getNote() == null ? tCoreMaskingFilesystemVO.getWildcard() : tCoreMaskingFilesystemVO.getNote());
         int extension_length = tCoreMaskingFilesystemVO.getExtension() == null ? 0 : tCoreMaskingFilesystemVO.getExtension().length();
         tCoreMaskingFilesystemVO.setWildcard(tCoreMaskingFilesystemVO.getWildcard().substring(0, tCoreMaskingFilesystemVO.getWildcard().length() - extension_length));
      }

      return list;
   }

   public TCoreMonitorTemporary gettmp(String tmpid) {
      return (TCoreMonitorTemporary)this.tCoreMonitorTemporaryDao.get(tmpid);
   }

   public Map<String, Object> queryMultiDBSourceMapping(String taskid, String[] tablename) {
      Map<String, Object> map = new HashMap();

      for(String str : tablename) {
         List<Map<String, String>> list = this.tCoreMaskingTaskDao.queryMultiDBSourceMapping(taskid, str);
         List<Map<String, String>> qlist = new ArrayList();

         for(int i = 0; i < list.size(); ++i) {
            Map<String, String> qmap = new HashMap();
            qmap.put("columnname", (list.get(i)).get("columnname"));
            qmap.put("columnsize", (list.get(i)).get("columnlength"));
            qmap.put("datatype", (list.get(i)).get("columntype"));
            qmap.put("decimaldigits", (list.get(i)).get("columnscale"));
            qmap.put("isnullable", (list.get(i)).get("judgenull"));
            qmap.put("maskingruleid", (list.get(i)).get("ruleid"));
            qmap.put("maskingrulename", (list.get(i)).get("rulename"));
            qmap.put("nullable", (list.get(i)).get("judgenull"));
            qmap.put("primarykey", (list.get(i)).get("primarykey"));
            qmap.put("regextype", (list.get(i)).get("regextype"));
            qmap.put("remarks", (list.get(i)).get("remarks"));
            qmap.put("typename", (list.get(i)).get("columntype"));
            qlist.add(qmap);
         }

         Map<String, Object> rows = new HashMap();
         rows.put("rows", qlist);
         map.put(str, rows);
      }

      return map;
   }

   public Map<String, Object> queryMultiFSSourceMapping(Map<String, String> map) {
      Map<String, Object> allMap = new HashMap();
      String taskid = (String)map.get("taskid");
      int structureinfosize = Integer.parseInt((String)map.get("structureinfosize"));

      for(int i = 0; i < structureinfosize; ++i) {
         List<Map<String, String>> list = this.tCoreMaskingTaskDao.queryMultiFSSourceMapping(taskid, (String)map.get("structureinfo[" + i + "][structureid]"));
         List<Map<String, String>> qlist = new ArrayList();

         for(int j = 0; j < list.size(); ++j) {
            Map<String, String> qmap = new HashMap();
            qmap.put("columnaccuracy", (list.get(j)).get("columnaccuracy"));
            qmap.put("columndecimal", (list.get(j)).get("columndecimal"));
            qmap.put("columnindex", String.valueOf((list.get(j)).get("columnindex")));
            qmap.put("columnname", (list.get(j)).get("columnname"));
            qmap.put("columnnotnull", (list.get(j)).get("columnnotnull"));
            qmap.put("columntype", (list.get(j)).get("columntype"));
            qmap.put("filestructureid", (list.get(j)).get("filestructureid"));
            qmap.put("id", (list.get(j)).get("id"));
            qmap.put("keytype", (list.get(j)).get("keytype"));
            qmap.put("maskingruleid", (list.get(j)).get("ruleid"));
            qmap.put("maskingrulename", (list.get(j)).get("rulename"));
            qmap.put("regextype", (list.get(j)).get("regextype"));
            qlist.add(qmap);
         }

         Map<String, Object> rows = new HashMap();
         int extension_length = ((Map)list.get(0)).get("extension") == null ? 0 : ((String)((Map)list.get(0)).get("extension")).length();
         rows.put("rows", qlist);
         rows.put("directory", ((Map)list.get(0)).get("directory"));
         rows.put("wildcard", ((String)((Map)list.get(0)).get("wildcard")).substring(0, ((String)((Map)list.get(0)).get("wildcard")).length() - extension_length));
         rows.put("extension", ((Map)list.get(0)).get("extension"));
         rows.put("totablename", ((Map)list.get(0)).get("tablename"));
         allMap.put(map.get("structureinfo[" + i + "][filestructurename]"), rows);
      }

      return allMap;
   }

   public Map<String, Object> queryMultiDbToFsStructure(String taskid) {
      Map<String, Object> map = new HashMap();
      List<Map<String, String>> list = this.tCoreMaskingTaskDao.queryMultiDbToFsStructure(taskid);
      map.put("columnformat", ((Map)list.get(0)).get("columnformat"));
      map.put("codepage", ((Map)list.get(0)).get("codepage"));
      map.put("skiprows", ((Map)list.get(0)).get("skiprows"));
      map.put("splitertype", ((Map)list.get(0)).get("splitertype"));
      if (map.get("splitertype").equals("0")) {
         List<Map<String, String>> splist = this.tCoreMaskingTaskDao.queryStructureSpli((String)((Map)list.get(0)).get("id"));
         map.put("quotecharacter", ((Map)splist.get(0)).get("quotecharacter"));
         map.put("delimiters", ((Map)splist.get(0)).get("delimiters"));
      } else {
         List<Map<String, String>> widthlist = this.tCoreMaskingTaskDao.queryStructureWidth((String)((Map)list.get(0)).get("id"));
         map.put("nullcharacter", ((Map)widthlist.get(0)).get("nullcharacter"));
      }

      return map;
   }

   public List<ColumnInfo> queryTableColumName(String taskid, String sourceid) {
      new ArrayList();
      List<TCoreMaskingTable> table = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", sourceid), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});
      if (table.size() == 0) {
         return null;
      } else {
         TCoreMaskingTable tCoreMaskingTable = (TCoreMaskingTable)table.get(0);
         String id = tCoreMaskingTable.getDatasystemid();
         Connection conn = this.dataSystemService.getConnectionByDataSystemId(id);
         String schemaname = tCoreMaskingTable.getDbschema();
         List<ColumnInfo> columnnamelist = JdbcTool.getAllColumnInfo(conn, schemaname, sourceid);

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return columnnamelist;
      }
   }

   public List<TCoreMaskingTask> queryTaskListByIndex(String engineid, String taskname) {
      PageInfo pageInfo = new PageInfo();
      pageInfo.setCount(new Long(10L));
      List<TCoreMaskingTask> list = this.tCoreMaskingTaskDao.querytask("2");
      if (list.size() == 0) {
         list = this.tCoreMaskingTaskDao.querytask("3");
         if (list.size() == 0) {
            list = this.tCoreMaskingTaskDao.querytask("1");
         }

         return list;
      } else {
         return list;
      }
   }

   public List<TCoreMaskingHive> queryMaskingHive(String taskid, String direction) {
      List<TCoreMaskingHive> list = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", direction)});
      return list;
   }

   public Map<String, Object> queryMultiHiveSourceMapping(String taskid, String[] tablename) {
      Map<String, Object> map = new HashMap();

      for(String str : tablename) {
         List<Map<String, String>> list = this.tCoreMaskingTaskDao.queryMultiHiveSourceMapping(taskid, str);
         List<Map<String, String>> qlist = new ArrayList();

         for(int i = 0; i < list.size(); ++i) {
            Map<String, String> qmap = new HashMap();
            qmap.put("columnname", (list.get(i)).get("columnname"));
            qmap.put("columnsize", (list.get(i)).get("columnlength"));
            qmap.put("datatype", (list.get(i)).get("columntype"));
            qmap.put("decimaldigits", (list.get(i)).get("columnscale"));
            qmap.put("isnullable", (list.get(i)).get("judgenull"));
            qmap.put("maskingruleid", (list.get(i)).get("ruleid"));
            qmap.put("maskingrulename", (list.get(i)).get("rulename"));
            qmap.put("nullable", (list.get(i)).get("judgenull"));
            qmap.put("primarykey", (list.get(i)).get("primarykey"));
            qmap.put("regextype", (list.get(i)).get("regextype"));
            qmap.put("remarks", (list.get(i)).get("remarks"));
            qmap.put("typename", (list.get(i)).get("columntype"));
            qlist.add(qmap);
         }

         Map<String, Object> rows = new HashMap();
         rows.put("rows", qlist);
         map.put(str, rows);
      }

      return map;
   }

   public ResultVO addAndModifyMaskingTask(Map<String, String> map) {
      boolean isTaskId = map.get("taskid") != null;
      if ("MARIADB".equals(map.get("tdsdbtype"))) {
         map.replace("tdsdbtype", "MYSQL");
      }

      if ("MARIADB".equals(map.get("sdsdbtype"))) {
         map.replace("sdsdbtype", "MYSQL");
      }

      try {
         TCoreMaskingTask tCoreMaskingTask = new TCoreMaskingTask();
         if (isTaskId) {
            tCoreMaskingTask.setId((String)map.get("taskid"));

            for(TCoreSchedulerRelation item : this.tCoreSchedulerRelationDao.queryAll(new Criterion[]{Restrictions.eq("taskid", map.get("taskid"))})) {
               item.setTaskname((String)map.get("taskname"));
               this.tCoreSchedulerRelationDao.update(item);
            }
         }

         tCoreMaskingTask.setTaskname((String)map.get("taskname"));
         tCoreMaskingTask.setEngineid((String)map.get("maskingengine"));
         tCoreMaskingTask.setCreatetime(new Date());
         tCoreMaskingTask.setFdname((String)map.get("folder"));
         tCoreMaskingTask.setUserid((String)map.get("userid"));
         tCoreMaskingTask.setNote((String)map.get("tasknote"));
         tCoreMaskingTask.setAddtype((String)map.get("addtype"));
         tCoreMaskingTask.setTasktype((String)map.get("tasktype"));
         tCoreMaskingTask.setIsremovetable((String)map.get("isremovetable"));
         tCoreMaskingTask.setIstruncate((String)map.get("istruncate"));
         tCoreMaskingTask.setIsspload((String)map.get("isspload"));
         if (((String)map.get("sourcetype")).equals("0")) {
            if (((String)map.get("targettype")).equals("0")) {
               tCoreMaskingTask.setFlag(EmaskingTaskType.DB_TO_DB.getFlag());
               tCoreMaskingTask.setInserttype((String)map.get("inserttype"));
               tCoreMaskingTask.setIsindex((String)map.get("isindex"));
               tCoreMaskingTask.setIsprimary((String)map.get("isprimary"));
            }

            if (((String)map.get("targettype")).equals("1")) {
               tCoreMaskingTask.setFlag(EmaskingTaskType.DB_TO_FILE.getFlag());
               tCoreMaskingTask.setIstitle((String)map.get("istitle"));
            }

            if (((String)map.get("targettype")).equals("2")) {
               tCoreMaskingTask.setFlag(EmaskingTaskType.DB_TO_HIVE.getFlag());
               tCoreMaskingTask.setInserttype((String)map.get("inserttype"));
               tCoreMaskingTask.setIsindex((String)map.get("isindex"));
               tCoreMaskingTask.setIsprimary((String)map.get("isprimary"));
            }
         } else if (((String)map.get("sourcetype")).equals("1")) {
            if (((String)map.get("targettype")).equals("0")) {
               tCoreMaskingTask.setFlag(EmaskingTaskType.FILE_TO_DB.getFlag());
               tCoreMaskingTask.setInserttype((String)map.get("inserttype"));
               tCoreMaskingTask.setIsindex((String)map.get("isindex"));
               tCoreMaskingTask.setIsprimary((String)map.get("isprimary"));
            }

            if (((String)map.get("targettype")).equals("1")) {
               tCoreMaskingTask.setFlag(EmaskingTaskType.FILE_TO_FILE.getFlag());
               tCoreMaskingTask.setIstitle((String)map.get("istitle"));
            }

            if (((String)map.get("targettype")).equals("2")) {
               tCoreMaskingTask.setFlag(EmaskingTaskType.FILE_TO_HIVE.getFlag());
               tCoreMaskingTask.setInserttype((String)map.get("inserttype"));
               tCoreMaskingTask.setIsindex((String)map.get("isindex"));
               tCoreMaskingTask.setIsprimary((String)map.get("isprimary"));
            }
         } else if (((String)map.get("sourcetype")).equals("2")) {
            if (((String)map.get("targettype")).equals("0")) {
               tCoreMaskingTask.setFlag(EmaskingTaskType.HIVE_TO_DB.getFlag());
               tCoreMaskingTask.setInserttype((String)map.get("inserttype"));
               tCoreMaskingTask.setIsindex((String)map.get("isindex"));
               tCoreMaskingTask.setIsprimary((String)map.get("isprimary"));
            }

            if (((String)map.get("targettype")).equals("1")) {
               tCoreMaskingTask.setFlag(EmaskingTaskType.HIVE_TO_FILE.getFlag());
               tCoreMaskingTask.setIstitle((String)map.get("istitle"));
            }

            if (((String)map.get("targettype")).equals("2")) {
               tCoreMaskingTask.setFlag(EmaskingTaskType.HIVE_TO_HIVE.getFlag());
               tCoreMaskingTask.setInserttype((String)map.get("inserttype"));
               tCoreMaskingTask.setIsindex((String)map.get("isindex"));
               tCoreMaskingTask.setIsprimary((String)map.get("isprimary"));
            }
         }

         new Properties();
         Properties var27 = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String pass_state = var27.get("masking_task_review").toString();
         if (pass_state == null || pass_state.equals("")) {
            pass_state = "0";
            System.out.println("配置文件未生效");
         }

         tCoreMaskingTask.setIspass(pass_state);
         this.tCoreMaskingTaskDao.saveOrUpdate(tCoreMaskingTask);
         if (isTaskId) {
            String flag = tCoreMaskingTask.getFlag();
            String[] nflag = StringUtils.split(flag, "-");
            String sourcetype = nflag[0];
            String targettype = nflag[1];
            if (sourcetype.equals(EmaskingTaskType.DB.getFlag())) {
               List<TCoreMaskingTable> list = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});

               for(int i = 0; i < list.size(); ++i) {
                  this.tCoreMaskingTablecolumnDao.remove(new Criterion[]{Restrictions.eq("tableid", ((TCoreMaskingTable)list.get(i)).getId())});
               }

               this.tCoreMaskingTableDao.remove(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});
            } else if (sourcetype.equals(EmaskingTaskType.FILE.getFlag())) {
               List<TCoreMaskingFilesystem> list = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});

               for(int i = 0; i < list.size(); ++i) {
                  this.tCoreMaskingFilecolumnDao.remove(new Criterion[]{Restrictions.eq("filesystemid", ((TCoreMaskingFilesystem)list.get(i)).getId())});
               }

               this.tCoreMaskingFilesystemDao.remove(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});
            } else if (sourcetype.equals(EmaskingTaskType.HIVE.getFlag())) {
               List<TCoreMaskingHive> list = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});

               for(int i = 0; i < list.size(); ++i) {
                  this.tCoreMaskingHivecolumnDao.remove(new Criterion[]{Restrictions.eq("tableid", ((TCoreMaskingHive)list.get(i)).getId())});
               }

               this.tCoreMaskingHiveDao.remove(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});
            }

            if (targettype.equals(EmaskingTaskType.DB.getFlag())) {
               List<TCoreMaskingTable> list = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});

               for(int i = 0; i < list.size(); ++i) {
                  this.tCoreMaskingTablecolumnDao.remove(new Criterion[]{Restrictions.eq("tableid", ((TCoreMaskingTable)list.get(i)).getId())});
               }

               this.tCoreMaskingTableDao.remove(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});
            } else if (targettype.equals(EmaskingTaskType.FILE.getFlag())) {
               List<TCoreMaskingFilesystem> list = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});

               for(int i = 0; i < list.size(); ++i) {
                  if (tCoreMaskingTask.getTasktype().equals("multi") && sourcetype.equals(EmaskingTaskType.DB.getFlag())) {
                     TCoreFileStructure tCoreFileStructure = (TCoreFileStructure)this.tCoreFileStructureDao.queryUnique(new Criterion[]{Restrictions.eq("id", ((TCoreMaskingFilesystem)list.get(i)).getStructureid())});
                     if (tCoreFileStructure.getSplitertype().equals("0")) {
                        this.tCoreFileStructurespliterDao.remove(new Criterion[]{Restrictions.eq("filestructureid", tCoreFileStructure.getId())});
                     } else if (tCoreFileStructure.getSplitertype().equals("1")) {
                        this.tCoreFileStructurewidthDao.remove(new Criterion[]{Restrictions.eq("filestructureid", tCoreFileStructure.getId())});
                     }

                     this.tCoreFileStructurecolumnDao.remove(new Criterion[]{Restrictions.eq("filestructureid", tCoreFileStructure.getId())});
                     this.tCoreFileStructureDao.removeById(tCoreFileStructure.getId());
                  }

                  this.tCoreMaskingFilecolumnDao.remove(new Criterion[]{Restrictions.eq("filesystemid", ((TCoreMaskingFilesystem)list.get(i)).getId())});
               }

               this.tCoreMaskingFilesystemDao.remove(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});
            } else if (targettype.equals(EmaskingTaskType.HIVE.getFlag())) {
               List<TCoreMaskingHive> list = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});

               for(int i = 0; i < list.size(); ++i) {
                  this.tCoreMaskingHivecolumnDao.remove(new Criterion[]{Restrictions.eq("tableid", ((TCoreMaskingHive)list.get(i)).getId())});
               }

               this.tCoreMaskingHiveDao.remove(new Criterion[]{Restrictions.eq("taskid", map.get("taskid")), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});
            }
         }

         int masklength = Integer.parseInt((String)map.get("masklength"));
         String uuid = UUID.randomUUID().toString();

         for(int i = 0; i < masklength; ++i) {
            int rulesize = Integer.parseInt((String)map.get("sourceInfoAll[" + i + "][rulesize]"));
            if (!((String)map.get("sourcetype")).equals("0")) {
               if (((String)map.get("sourcetype")).equals("1")) {
                  TCoreMaskingFilesystem tCoreMaskingFilesystem = new TCoreMaskingFilesystem();
                  tCoreMaskingFilesystem.setStructureid((String)map.get("sourceInfoAll[" + i + "][structureid]"));
                  tCoreMaskingFilesystem.setDirectory((String)map.get("sourceInfoAll[" + i + "][directory]"));
                  tCoreMaskingFilesystem.setWildcard((String)map.get("sourceInfoAll[" + i + "][wildcard]") + (String)map.get("sourceInfoAll[" + i + "][extension]"));
                  tCoreMaskingFilesystem.setExtension((String)map.get("sourceInfoAll[" + i + "][extension]"));
                  tCoreMaskingFilesystem.setMappingkey(uuid + i);
                  tCoreMaskingFilesystem.setDatadirection(EmaskingDirection.DATA_SOURCE.getFlag());
                  tCoreMaskingFilesystem.setTaskid(tCoreMaskingTask.getId());
                  tCoreMaskingFilesystem.setLocation((String)map.get("slocation"));
                  tCoreMaskingFilesystem.setFtpid((String)map.get("schooseftp"));
                  tCoreMaskingFilesystem.setSourcefilecode((String)map.get("sourceFileCode"));
                  this.tCoreMaskingFilesystemDao.save(tCoreMaskingFilesystem);

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingFilecolumn tCoreMaskingFilecolumn = new TCoreMaskingFilecolumn();
                     tCoreMaskingFilecolumn.setColumnindex(j);
                     tCoreMaskingFilecolumn.setDatadirection(EmaskingDirection.DATA_SOURCE.getFlag());
                     tCoreMaskingFilecolumn.setFilesystemid(tCoreMaskingFilesystem.getId());
                     tCoreMaskingFilecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingFilecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingFilecolumn.setStructurecolumnid((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][id]"));
                     tCoreMaskingFilecolumn.setRulename((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingrulename]"));
                     tCoreMaskingFilecolumn.setRegextype((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][regextype]"));
                     tCoreMaskingFilecolumn.setRemarks((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][remarks]"));
                     this.tCoreMaskingFilecolumnDao.save(tCoreMaskingFilecolumn);
                  }
               } else if (((String)map.get("sourcetype")).equals("2")) {
                  TCoreMaskingHive tCoreMaskingHive = new TCoreMaskingHive();
                  tCoreMaskingHive.setDatasystemid((String)map.get("shiveid"));
                  tCoreMaskingHive.setDbschema((String)map.get("shiveschema"));
                  tCoreMaskingHive.setTablename((String)map.get("sourceInfoAll[" + i + "][tablename]"));
                  tCoreMaskingHive.setDatadirection(EmaskingDirection.DATA_SOURCE.getFlag());
                  tCoreMaskingHive.setMappingkey(uuid + i);
                  tCoreMaskingHive.setTaskid(tCoreMaskingTask.getId());
                  this.tCoreMaskingHiveDao.save(tCoreMaskingHive);

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingHivecolumn tCoreMaskingHivecolumn = new TCoreMaskingHivecolumn();
                     tCoreMaskingHivecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingHivecolumn.setJudgenull((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][isnullable]"));
                     tCoreMaskingHivecolumn.setPrimarykey((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][primarykey]"));
                     tCoreMaskingHivecolumn.setColumnname((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnname]"));
                     tCoreMaskingHivecolumn.setColumntype((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][typename]"));
                     tCoreMaskingHivecolumn.setColumnlength(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]"));
                     tCoreMaskingHivecolumn.setColumnscale(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]"));
                     tCoreMaskingHivecolumn.setTableid(tCoreMaskingHive.getId());
                     tCoreMaskingHivecolumn.setDatadirection(EmaskingDirection.DATA_SOURCE.getFlag());
                     tCoreMaskingHivecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingHivecolumn.setTaskid(tCoreMaskingTask.getId());
                     tCoreMaskingHivecolumn.setColumnindex(j);
                     tCoreMaskingHivecolumn.setRulename((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingrulename]"));
                     tCoreMaskingHivecolumn.setRegextype((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][regextype]"));
                     tCoreMaskingHivecolumn.setRemarks((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][remarks]"));
                     this.tCoreMaskingHivecolumnDao.save(tCoreMaskingHivecolumn);
                  }
               }
            } else {
               TCoreMaskingTable tCoreMaskingTable = new TCoreMaskingTable();
               tCoreMaskingTable.setDatasystemid((String)map.get("sdsdbid"));
               tCoreMaskingTable.setDbschema((String)map.get("sdsdbschema"));
               tCoreMaskingTable.setTablename((String)map.get("sourceInfoAll[" + i + "][tablename]"));
               tCoreMaskingTable.setDatadirection(EmaskingDirection.DATA_SOURCE.getFlag());
               tCoreMaskingTable.setMappingkey(uuid + i);
               tCoreMaskingTable.setTaskid(tCoreMaskingTask.getId());
               this.tCoreMaskingTableDao.save(tCoreMaskingTable);

               for(int j = 0; j < rulesize; ++j) {
                  TCoreMaskingTablecolumn tCoreMaskingTablecolumn = new TCoreMaskingTablecolumn();
                  tCoreMaskingTablecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                  tCoreMaskingTablecolumn.setJudgenull((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][isnullable]"));
                  tCoreMaskingTablecolumn.setPrimarykey((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][primarykey]"));
                  tCoreMaskingTablecolumn.setColumnname((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnname]"));
                  tCoreMaskingTablecolumn.setColumntype((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][typename]"));
                  tCoreMaskingTablecolumn.setColumnlength(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]"));
                  tCoreMaskingTablecolumn.setColumnscale(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]"));
                  tCoreMaskingTablecolumn.setTableid(tCoreMaskingTable.getId());
                  tCoreMaskingTablecolumn.setDatadirection(EmaskingDirection.DATA_SOURCE.getFlag());
                  tCoreMaskingTablecolumn.setMappingkey(uuid + i + j);
                  tCoreMaskingTablecolumn.setTaskid(tCoreMaskingTask.getId());
                  tCoreMaskingTablecolumn.setColumnindex(j);
                  tCoreMaskingTablecolumn.setRulename((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingrulename]"));
                  tCoreMaskingTablecolumn.setRegextype((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][regextype]"));
                  tCoreMaskingTablecolumn.setRemarks((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][remarks]"));
                  this.tCoreMaskingTablecolumnDao.save(tCoreMaskingTablecolumn);
               }

               if (EdbType.TERADATA.getDbcode().equals(map.get("sdsdbtype"))) {
                  List<String> colNameLst = new ArrayList();
                  Integer totalLen = 0;

                  for(int j = 0; j < rulesize; ++j) {
                     totalLen = totalLen + 3;
                     String colName = (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnname]");
                     String colType = (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][typename]");
                     String colLength = (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]");
                     String colScale = map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]");
                     colName = TeradataTool.teradataTypetoVarchar(colName, colType, colLength);
                     String realColLength = TeradataTool.teradataTypeLength(colType, colLength, colScale);
                     if (StringUtils.isNotBlank(realColLength)) {
                        totalLen = totalLen + Integer.valueOf(realColLength);
                     }

                     colNameLst.add(colName);
                  }

                  String colNamesStr = StringUtils.join(colNameLst.toArray(), "||'|'||");
                  colNamesStr = "(cast(" + colNamesStr + " as char(" + totalLen + ")))";
                  Map<String, String> paramMap = new HashMap();
                  paramMap.put("schema", map.get("sdsdbschema"));
                  paramMap.put("tablename", map.get("sourceInfoAll[" + i + "][tablename]"));
                  paramMap.put("colNamesStr", colNamesStr);
                  TCoreDatasystem sourceSys = (TCoreDatasystem)this.tCoreDatasystemDao.get(map.get("sdsdbid"));
                  paramMap.put("teradataServersIp", sourceSys.getDbip());
                  paramMap.put("teradataServersUser", sourceSys.getUsername());
                  paramMap.put("teradataServerspwd", "1".equals(sourceSys.getFlag()) ? AesTool.decrypt(sourceSys.getPassword(), "ghca") : sourceSys.getPassword());
                  paramMap.put("taskname", tCoreMaskingTask.getTaskname());
                  TeradataTool.createTerdataExportScript(paramMap);
               }
            }
         }

         if (((String)map.get("tasktype")).equals("single")) {
            for(int i = 0; i < masklength; ++i) {
               int rulesize = Integer.parseInt((String)map.get("targetInfoAll[" + i + "][rulesize]"));
               if (((String)map.get("targettype")).equals("0")) {
                  TCoreMaskingTable tCoreMaskingTable = new TCoreMaskingTable();
                  tCoreMaskingTable.setDatasystemid((String)map.get("tdsdbid"));
                  tCoreMaskingTable.setDbschema((String)map.get("tdsdbschema"));
                  tCoreMaskingTable.setTablename((String)map.get("targetInfoAll[" + i + "][tablename]"));
                  tCoreMaskingTable.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingTable.setMappingkey(uuid + i);
                  tCoreMaskingTable.setTaskid(tCoreMaskingTask.getId());
                  this.tCoreMaskingTableDao.save(tCoreMaskingTable);

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingTablecolumn tCoreMaskingTablecolumn = new TCoreMaskingTablecolumn();
                     tCoreMaskingTablecolumn.setRuleid(map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingTablecolumn.setJudgenull((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][isnullable]"));
                     tCoreMaskingTablecolumn.setPrimarykey((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][primarykey]"));
                     tCoreMaskingTablecolumn.setColumnname((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][columnname]"));
                     tCoreMaskingTablecolumn.setColumntype((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][typename]"));
                     tCoreMaskingTablecolumn.setColumnlength(map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][columnsize]") == null ? "" : (String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][columnsize]"));
                     tCoreMaskingTablecolumn.setColumnscale(map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][decimaldigits]") == null ? "" : (String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][decimaldigits]"));
                     tCoreMaskingTablecolumn.setTableid(tCoreMaskingTable.getId());
                     tCoreMaskingTablecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingTablecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingTablecolumn.setTaskid(tCoreMaskingTask.getId());
                     tCoreMaskingTablecolumn.setColumnindex(j);
                     tCoreMaskingTablecolumn.setRemarks((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][remarks]"));
                     this.tCoreMaskingTablecolumnDao.save(tCoreMaskingTablecolumn);
                  }
               } else if (((String)map.get("targettype")).equals("1")) {
                  String filename = (String)map.get("targetInfoAll[" + i + "][wildcard]");
                  String targetpath = (String)map.get("targetInfoAll[" + i + "][directory]");
                  String laststr = StringUtils.substring(targetpath, StringUtils.length(targetpath) - 1);
                  boolean b = StringUtils.equalsAny(laststr, new CharSequence[]{"/", "\\"});
                  if (!b) {
                     targetpath = targetpath + "/";
                  }

                  String filepathname = targetpath + filename;
                  if (((String)map.get("tlocation")).equals("0")) {
                     if (((String)map.get("isremovefile")).equals("true")) {
                        FileTool.removeFile(filepathname);
                     }

                     boolean isFile = FileTool.isFileExit(filepathname);
                     if (!isFile) {
                        FileTool.createFolder(targetpath);
                        FileTool.createFile(filepathname);
                     }
                  } else {
                     TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(map.get("tchooseftp"));
                     if (((String)map.get("isremovefile")).equals("true")) {
                        FtpTool.removeFile(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename);
                     }

                     boolean isFile = FtpTool.isFileExist(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename);
                     if (!isFile) {
                        FtpTool.createFile(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename, "");
                     }
                  }

                  TCoreMaskingFilesystem tCoreMaskingFilesystem = new TCoreMaskingFilesystem();
                  tCoreMaskingFilesystem.setStructureid((String)map.get("targetInfoAll[" + i + "][structureid]"));
                  tCoreMaskingFilesystem.setDirectory((String)map.get("targetInfoAll[" + i + "][directory]"));
                  tCoreMaskingFilesystem.setWildcard((String)map.get("targetInfoAll[" + i + "][wildcard]"));
                  tCoreMaskingFilesystem.setMappingkey(uuid + i);
                  tCoreMaskingFilesystem.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingFilesystem.setTaskid(tCoreMaskingTask.getId());
                  tCoreMaskingFilesystem.setLocation((String)map.get("tlocation"));
                  tCoreMaskingFilesystem.setFtpid((String)map.get("tchooseftp"));
                  if (((String)map.get("sourcetype")).equals("0")) {
                     tCoreMaskingFilesystem.setIstodatabase((String)map.get("istodatabase"));
                     if (map.get("istodatabase") != null && ((String)map.get("istodatabase")).equals("true")) {
                        tCoreMaskingFilesystem.setDatasystemid((String)map.get("todatasystemid"));
                        tCoreMaskingFilesystem.setDbschema((String)map.get("todbschema"));
                     }
                  }

                  this.tCoreMaskingFilesystemDao.save(tCoreMaskingFilesystem);

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingFilecolumn tCoreMaskingFilecolumn = new TCoreMaskingFilecolumn();
                     tCoreMaskingFilecolumn.setColumnindex(j);
                     tCoreMaskingFilecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingFilecolumn.setFilesystemid(tCoreMaskingFilesystem.getId());
                     tCoreMaskingFilecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingFilecolumn.setRuleid(map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingFilecolumn.setStructurecolumnid((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][id]"));
                     tCoreMaskingFilecolumn.setRemarks((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][remarks]"));
                     this.tCoreMaskingFilecolumnDao.save(tCoreMaskingFilecolumn);
                  }
               } else if (((String)map.get("targettype")).equals("2")) {
                  TCoreMaskingHive tCoreMaskingHive = new TCoreMaskingHive();
                  tCoreMaskingHive.setDatasystemid((String)map.get("thiveid"));
                  tCoreMaskingHive.setDbschema((String)map.get("thiveschema"));
                  tCoreMaskingHive.setTablename((String)map.get("targetInfoAll[" + i + "][tablename]"));
                  tCoreMaskingHive.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingHive.setMappingkey(uuid + i);
                  tCoreMaskingHive.setTaskid(tCoreMaskingTask.getId());
                  this.tCoreMaskingHiveDao.save(tCoreMaskingHive);

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingHivecolumn tCoreMaskingHivecolumn = new TCoreMaskingHivecolumn();
                     tCoreMaskingHivecolumn.setRuleid(map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingHivecolumn.setJudgenull((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][isnullable]"));
                     tCoreMaskingHivecolumn.setPrimarykey((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][primarykey]"));
                     tCoreMaskingHivecolumn.setColumnname((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][columnname]"));
                     tCoreMaskingHivecolumn.setColumntype((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][typename]"));
                     tCoreMaskingHivecolumn.setColumnlength(map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][columnsize]") == null ? "" : (String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][columnsize]"));
                     tCoreMaskingHivecolumn.setColumnscale(map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][decimaldigits]") == null ? "" : (String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][decimaldigits]"));
                     tCoreMaskingHivecolumn.setTableid(tCoreMaskingHive.getId());
                     tCoreMaskingHivecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingHivecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingHivecolumn.setTaskid(tCoreMaskingTask.getId());
                     tCoreMaskingHivecolumn.setColumnindex(j);
                     tCoreMaskingHivecolumn.setRemarks((String)map.get("targetInfoAll[" + i + "][mttcolumnlist][" + j + "][remarks]"));
                     this.tCoreMaskingHivecolumnDao.save(tCoreMaskingHivecolumn);
                  }
               }
            }
         } else if (((String)map.get("targettype")).equals("0")) {
            if (((String)map.get("sourcetype")).equals("0")) {
               String tschema = (String)map.get("tdsdbschema");
               String ttbaletype = (String)map.get("tdsdbtype");
               String stbaletype = (String)map.get("sdsdbtype");
               List<Map<String, String>> mappingInfo = this.tConsoleDatamappingInfoDao.getDatamappingInfo(EdataMappingType.getFlagByName(stbaletype), EdataMappingType.getFlagByName(ttbaletype));

               for(int i = 0; i < masklength; ++i) {
                  Connection tconn = this.getConnectionByDataSystemId((String)map.get("tdsdbid"));
                  String stable = (String)map.get("sourceInfoAll[" + i + "][tablename]");
                  String ttable = (String)map.get("prefixname") + stable;
                  List<String> ttablenamelist = JdbcTool.getAllTableName(tconn, tschema);
                  ttablenamelist = StringTool.toUpperCaseList(ttablenamelist);
                  boolean isNamesake = ttablenamelist.contains(ttable.toUpperCase());
                  if (((String)map.get("isremovetable")).equals("true") && isNamesake) {
                     JdbcTool.dropTable(tconn, tschema, ttable);
                     isNamesake = false;
                  }

                  int rulesize = Integer.parseInt((String)map.get("sourceInfoAll[" + i + "][rulesize]"));
                  List<ColumnInfoVO> sourceList = new ArrayList();

                  for(int j = 0; j < rulesize; ++j) {
                     ColumnInfoVO cv = new ColumnInfoVO();
                     cv.setColumnname((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnname]"));
                     cv.setTypename((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][typename]"));
                     cv.setColumnsize((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]"));
                     cv.setDecimaldigits((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]"));
                     cv.setIsnullable((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][isnullable]"));
                     sourceList.add(cv);
                  }

                  String sql = JdbcTool.copyTable_result_sql(tconn, tschema, ttable, sourceList, mappingInfo);
                  if (!isNamesake) {
                     JdbcTool.copyTable(tconn, tschema, ttable, sourceList, mappingInfo);
                  }

                  TCoreMaskingTable tCoreMaskingTable = new TCoreMaskingTable();
                  tCoreMaskingTable.setDatasystemid((String)map.get("tdsdbid"));
                  tCoreMaskingTable.setDbschema(tschema);
                  tCoreMaskingTable.setTablename(ttable);
                  tCoreMaskingTable.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingTable.setMappingkey(uuid + i);
                  tCoreMaskingTable.setTaskid(tCoreMaskingTask.getId());
                  tCoreMaskingTable.setCreate_sql(sql);
                  this.tCoreMaskingTableDao.save(tCoreMaskingTable);
                  List<ColumnInfoVO> target_column = JdbcTool.getColumnInfoVO(tconn, tschema, ttable);
                  if (target_column.isEmpty()) {
                     target_column = JdbcTool.getColumnInfoVO(tconn, tschema, ttable.toUpperCase());
                  }

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingTablecolumn tCoreMaskingTablecolumn = new TCoreMaskingTablecolumn();
                     tCoreMaskingTablecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingTablecolumn.setJudgenull(((ColumnInfoVO)target_column.get(j)).getIsnullable());
                     tCoreMaskingTablecolumn.setPrimarykey(((ColumnInfoVO)target_column.get(j)).getPrimarykey());
                     tCoreMaskingTablecolumn.setColumnname(((ColumnInfoVO)target_column.get(j)).getColumnname());
                     tCoreMaskingTablecolumn.setColumntype(((ColumnInfoVO)target_column.get(j)).getTypename());
                     tCoreMaskingTablecolumn.setColumnlength(((ColumnInfoVO)target_column.get(j)).getColumnsize() == null ? "" : ((ColumnInfoVO)target_column.get(j)).getColumnsize());
                     tCoreMaskingTablecolumn.setColumnscale(((ColumnInfoVO)target_column.get(j)).getDecimaldigits() == null ? "" : ((ColumnInfoVO)target_column.get(j)).getDecimaldigits());
                     tCoreMaskingTablecolumn.setTableid(tCoreMaskingTable.getId());
                     tCoreMaskingTablecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingTablecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingTablecolumn.setTaskid(tCoreMaskingTask.getId());
                     tCoreMaskingTablecolumn.setColumnindex(j);
                     tCoreMaskingTablecolumn.setRulename((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingrulename]"));
                     tCoreMaskingTablecolumn.setRegextype((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][regextype]"));
                     tCoreMaskingTablecolumn.setRemarks((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][remarks]"));
                     this.tCoreMaskingTablecolumnDao.save(tCoreMaskingTablecolumn);
                  }

                  JdbcTool.closeConnection(tconn);
               }
            } else if (((String)map.get("sourcetype")).equals("1")) {
               String tschema = (String)map.get("tdsdbschema");

               for(int i = 0; i < masklength; ++i) {
                  String filename = (String)map.get("prefixname") + (String)map.get("sourceInfoAll[" + i + "][totablename]");
                  Connection tconn = this.getConnectionByDataSystemId((String)map.get("tdsdbid"));
                  List<String> ttablenamelist = JdbcTool.getAllTableName(tconn, tschema);
                  boolean isNamesake = ttablenamelist.contains(filename);
                  if (((String)map.get("isremovetable")).equals("true") && isNamesake) {
                     JdbcTool.dropTable(tconn, (String)map.get("tdsdbschema"), filename);
                     isNamesake = false;
                  }

                  int rulesize = Integer.parseInt((String)map.get("sourceInfoAll[" + i + "][rulesize]"));
                  String sourceStructureid = (String)map.get("sourceInfoAll[" + i + "][structureid]");
                  String targetsystemtype = "";
                  if (((String)map.get("tdsdbtype")).equals("SYBASE_IQ")) {
                     targetsystemtype = "SYBASE_IQ";
                  } else {
                     targetsystemtype = JdbcTool.getDataBaseType(tconn);
                  }

                  List<Map<String, String>> mappingInfo = this.tConsoleDatamappingInfoDao.getDatamappingInfo(EdataMappingType.getFlagByName("FILESYSTEM"), EdataMappingType.getFlagByName(targetsystemtype));
                  List<TCoreFileStructurecolumn> fscList = this.tCoreFileStructurecolumnDao.queryAll(new Criterion[]{Restrictions.eq("filestructureid", sourceStructureid)});
                  List<ColumnInfoVO> sourceList = new ArrayList();

                  for(TCoreFileStructurecolumn fsc : fscList) {
                     ColumnInfoVO cv = new ColumnInfoVO();
                     cv.setColumnname(fsc.getColumnname());
                     cv.setTypename(fsc.getColumntype());
                     cv.setColumnsize(fsc.getColumnaccuracy());
                     cv.setDecimaldigits(fsc.getColumndecimal().equals("0") ? "" : fsc.getColumndecimal());
                     cv.setIsnullable(fsc.getColumnnotnull());
                     cv.setPrimarykey(fsc.getKeytype());
                     sourceList.add(cv);
                  }

                  String sql = JdbcTool.copyTable_result_sql(tconn, tschema, filename, sourceList, mappingInfo);
                  if (!isNamesake) {
                     JdbcTool.copyTable(tconn, tschema, filename, sourceList, mappingInfo);
                  }

                  JdbcTool.closeConnection(tconn);
                  TCoreMaskingTable tCoreMaskingTable = new TCoreMaskingTable();
                  tCoreMaskingTable.setDatasystemid((String)map.get("tdsdbid"));
                  tCoreMaskingTable.setDbschema(tschema);
                  tCoreMaskingTable.setTablename(filename);
                  tCoreMaskingTable.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingTable.setMappingkey(uuid + i);
                  tCoreMaskingTable.setTaskid(tCoreMaskingTask.getId());
                  tCoreMaskingTable.setCreate_sql(sql);
                  this.tCoreMaskingTableDao.save(tCoreMaskingTable);

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingTablecolumn tCoreMaskingTablecolumn = new TCoreMaskingTablecolumn();
                     tCoreMaskingTablecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingTablecolumn.setJudgenull(((ColumnInfoVO)sourceList.get(j)).getIsnullable());
                     tCoreMaskingTablecolumn.setPrimarykey(((ColumnInfoVO)sourceList.get(j)).getPrimarykey().equals("YES") ? "1" : "0");
                     tCoreMaskingTablecolumn.setColumnname(((ColumnInfoVO)sourceList.get(j)).getColumnname());
                     String sourceColType = (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columntype]");

                     for(int k = 0; k < mappingInfo.size(); ++k) {
                        if (sourceColType.equalsIgnoreCase((String)((Map)mappingInfo.get(k)).get("sourcefieldname"))) {
                           tCoreMaskingTablecolumn.setColumntype((String)((Map)mappingInfo.get(k)).get("targetfieldname"));
                           break;
                        }
                     }

                     tCoreMaskingTablecolumn.setColumnlength(((ColumnInfoVO)sourceList.get(j)).getColumnsize() == null ? "" : ((ColumnInfoVO)sourceList.get(j)).getColumnsize());
                     tCoreMaskingTablecolumn.setColumnscale(((ColumnInfoVO)sourceList.get(j)).getDecimaldigits() == null ? "" : ((ColumnInfoVO)sourceList.get(j)).getDecimaldigits());
                     tCoreMaskingTablecolumn.setTableid(tCoreMaskingTable.getId());
                     tCoreMaskingTablecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingTablecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingTablecolumn.setTaskid(tCoreMaskingTask.getId());
                     tCoreMaskingTablecolumn.setColumnindex(j);
                     this.tCoreMaskingTablecolumnDao.save(tCoreMaskingTablecolumn);
                  }
               }
            } else if (((String)map.get("sourcetype")).equals("2")) {
               String tschema = (String)map.get("tdsdbschema");
               String ttbaletype = (String)map.get("tdsdbtype");
               String shivetype = (String)map.get("shivetype");
               List<Map<String, String>> mappingInfo = this.tConsoleDatamappingInfoDao.getDatamappingInfo(EdataMappingType.getFlagByName(shivetype), EdataMappingType.getFlagByName(ttbaletype));

               for(int i = 0; i < masklength; ++i) {
                  Connection tconn = this.getConnectionByDataSystemId((String)map.get("tdsdbid"));
                  String stable = (String)map.get("sourceInfoAll[" + i + "][tablename]");
                  String ttable = (String)map.get("prefixname") + stable;
                  List<String> ttablenamelist = JdbcTool.getAllTableName(tconn, tschema);
                  ttablenamelist = StringTool.toUpperCaseList(ttablenamelist);
                  boolean isNamesake = ttablenamelist.contains(ttable.toUpperCase());
                  if (((String)map.get("isremovetable")).equals("true") && isNamesake) {
                     JdbcTool.dropTable(tconn, tschema, ttable);
                     isNamesake = false;
                  }

                  int rulesize = Integer.parseInt((String)map.get("sourceInfoAll[" + i + "][rulesize]"));
                  List<ColumnInfoVO> sourceList = new ArrayList();

                  for(int j = 0; j < rulesize; ++j) {
                     ColumnInfoVO cv = new ColumnInfoVO();
                     cv.setColumnname((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnname]"));
                     cv.setTypename((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][typename]"));
                     cv.setColumnsize((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]"));
                     cv.setDecimaldigits((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]"));
                     cv.setIsnullable((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][isnullable]"));
                     sourceList.add(cv);
                  }

                  if (!isNamesake) {
                     JdbcTool.copyTable(tconn, tschema, ttable, sourceList, mappingInfo);
                  }

                  TCoreMaskingTable tCoreMaskingTable = new TCoreMaskingTable();
                  tCoreMaskingTable.setDatasystemid((String)map.get("tdsdbid"));
                  tCoreMaskingTable.setDbschema(tschema);
                  tCoreMaskingTable.setTablename(ttable);
                  tCoreMaskingTable.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingTable.setMappingkey(uuid + i);
                  tCoreMaskingTable.setTaskid(tCoreMaskingTask.getId());
                  this.tCoreMaskingTableDao.save(tCoreMaskingTable);
                  List<ColumnInfoVO> target_column = JdbcTool.getColumnInfoVO(tconn, tschema, ttable);
                  if (target_column.isEmpty()) {
                     target_column = JdbcTool.getColumnInfoVO(tconn, tschema, ttable.toUpperCase());
                  }

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingTablecolumn tCoreMaskingTablecolumn = new TCoreMaskingTablecolumn();
                     tCoreMaskingTablecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingTablecolumn.setJudgenull(((ColumnInfoVO)target_column.get(j)).getIsnullable());
                     tCoreMaskingTablecolumn.setPrimarykey(((ColumnInfoVO)target_column.get(j)).getPrimarykey());
                     tCoreMaskingTablecolumn.setColumnname(((ColumnInfoVO)target_column.get(j)).getColumnname());
                     tCoreMaskingTablecolumn.setColumntype(((ColumnInfoVO)target_column.get(j)).getTypename());
                     tCoreMaskingTablecolumn.setColumnlength(((ColumnInfoVO)target_column.get(j)).getColumnsize() == null ? "" : ((ColumnInfoVO)target_column.get(j)).getColumnsize());
                     tCoreMaskingTablecolumn.setColumnscale(((ColumnInfoVO)target_column.get(j)).getDecimaldigits() == null ? "" : ((ColumnInfoVO)target_column.get(j)).getDecimaldigits());
                     tCoreMaskingTablecolumn.setTableid(tCoreMaskingTable.getId());
                     tCoreMaskingTablecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingTablecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingTablecolumn.setTaskid(tCoreMaskingTask.getId());
                     tCoreMaskingTablecolumn.setColumnindex(j);
                     tCoreMaskingTablecolumn.setRulename((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingrulename]"));
                     tCoreMaskingTablecolumn.setRegextype((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][regextype]"));
                     tCoreMaskingTablecolumn.setRemarks((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][remarks]"));
                     this.tCoreMaskingTablecolumnDao.save(tCoreMaskingTablecolumn);
                  }

                  JdbcTool.closeConnection(tconn);
               }
            }
         } else if (((String)map.get("targettype")).equals("1")) {
            if (((String)map.get("sourcetype")).equals("0")) {
               String sourcedbtype = (String)map.get("sdsdbtype");

               for(int i = 0; i < masklength; ++i) {
                  String filename = (String)map.get("prefixname") + (String)map.get("sourceInfoAll[" + i + "][tablename]") + "." + (String)map.get("createstructure[extension]");
                  String targetpath = (String)map.get("targetInfoAll[0][directory]");
                  String laststr = StringUtils.substring(targetpath, StringUtils.length(targetpath) - 1);
                  boolean b = StringUtils.equalsAny(laststr, new CharSequence[]{"/", "\\"});
                  if (!b) {
                     targetpath = targetpath + "/";
                  }

                  String path = "/data/infa_file/";
                  String filepathname = path + targetpath + filename;
                  System.out.println(">>>>>db2file's filepathname:" + filepathname);
                  if (((String)map.get("tlocation")).equals("0")) {
                     if (((String)map.get("isremovetable")).equals("true")) {
                        FileTool.removeFile(filepathname);
                     }

                     boolean isFile = FileTool.isFileExit(filepathname);
                     System.out.println(">>>>>isFileExit:" + isFile);
                     if (!isFile) {
                        System.out.println(">>>>>db2file's createFolder:" + path + targetpath);
                        FileTool.createFolder(path + targetpath);
                        FileTool.createFile(filepathname);
                     }
                  } else {
                     TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(map.get("tchooseftp"));
                     if (((String)map.get("isremovetable")).equals("true")) {
                        FtpTool.removeFile(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename);
                     }

                     boolean isFile = FtpTool.isFileExist(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename);
                     if (!isFile) {
                        FtpTool.createFile(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename, "");
                     }
                  }

                  TCoreFileStructure tCoreFileStructure = new TCoreFileStructure();
                  tCoreFileStructure.setFilestructuregroup((String)map.get("taskname"));
                  tCoreFileStructure.setFilestructurename((String)map.get("taskname") + "_" + filename);
                  tCoreFileStructure.setCodepage((String)map.get("createstructure[codepage]"));
                  tCoreFileStructure.setSkiprows((String)map.get("createstructure[skiprows]"));
                  tCoreFileStructure.setSplitertype((String)map.get("createstructure[splitertype]"));
                  tCoreFileStructure.setFlag("1");
                  this.tCoreFileStructureDao.save(tCoreFileStructure);
                  if (tCoreFileStructure.getSplitertype().equals("0")) {
                     TCoreFileStructurespliter tCoreFileStructurespliter = new TCoreFileStructurespliter();
                     tCoreFileStructurespliter.setDelimiters((String)map.get("createstructure[delimiters]"));
                     tCoreFileStructurespliter.setConsecdelimitersasone("NO");
                     tCoreFileStructurespliter.setMultidelimitersasand("NO");
                     tCoreFileStructurespliter.setQuotecharacter((String)map.get("createstructure[quotecharacter]"));
                     tCoreFileStructurespliter.setRowdelimiter("10");
                     tCoreFileStructurespliter.setEscapecharacter("");
                     tCoreFileStructurespliter.setKeepescapechar("NO");
                     tCoreFileStructurespliter.setFilestructureid(tCoreFileStructure.getId());
                     this.tCoreFileStructurespliterDao.save(tCoreFileStructurespliter);
                  } else {
                     TCoreFileStructurewidth tCoreFileStructurewidth = new TCoreFileStructurewidth();
                     tCoreFileStructurewidth.setNullcharacter((String)map.get("createstructure[nullcharacter]"));
                     tCoreFileStructurewidth.setNullchartype((String)map.get("createstructure[nullchartype]"));
                     tCoreFileStructurewidth.setRepeatable("NO");
                     tCoreFileStructurewidth.setPadbytes("1");
                     tCoreFileStructurewidth.setLinesequential("NO");
                     tCoreFileStructurewidth.setShiftsensitivedata("NO");
                     tCoreFileStructurewidth.setStriptrailingblanks("NO");
                     tCoreFileStructurewidth.setFilestructureid(tCoreFileStructure.getId());
                     this.tCoreFileStructurewidthDao.save(tCoreFileStructurewidth);
                  }

                  TCoreMaskingFilesystem tCoreMaskingFilesystem = new TCoreMaskingFilesystem();
                  tCoreMaskingFilesystem.setStructureid(tCoreFileStructure.getId());
                  tCoreMaskingFilesystem.setDirectory((String)map.get("targetInfoAll[0][directory]"));
                  tCoreMaskingFilesystem.setWildcard(filename);
                  tCoreMaskingFilesystem.setMappingkey(uuid + i);
                  tCoreMaskingFilesystem.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingFilesystem.setTaskid(tCoreMaskingTask.getId());
                  tCoreMaskingFilesystem.setLocation((String)map.get("tlocation"));
                  tCoreMaskingFilesystem.setFtpid((String)map.get("tchooseftp"));
                  tCoreMaskingFilesystem.setIstodatabase((String)map.get("istodatabase"));
                  if (map.get("istodatabase") != null && ((String)map.get("istodatabase")).equals("true")) {
                     tCoreMaskingFilesystem.setDatasystemid((String)map.get("todatasystemid"));
                     tCoreMaskingFilesystem.setDbschema((String)map.get("todbschema"));
                  }

                  tCoreMaskingFilesystem.setColumnformat((String)map.get("createstructure[columnformat]"));
                  this.tCoreMaskingFilesystemDao.save(tCoreMaskingFilesystem);
                  List<Map<String, String>> mappingInfo = this.tConsoleDatamappingInfoDao.getDatamappingInfo(EdataMappingType.getFlagByName(sourcedbtype), EdataMappingType.FILESYSTEM.getFlag());
                  int rulesize = Integer.parseInt((String)map.get("sourceInfoAll[" + i + "][rulesize]"));

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreFileStructurecolumn tCoreFileStructurecolumn = new TCoreFileStructurecolumn();
                     tCoreFileStructurecolumn.setColumnindex(j + 1);
                     tCoreFileStructurecolumn.setColumnname((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnname]"));

                     for(int k = 0; k < mappingInfo.size(); ++k) {
                        String souTypeName = (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][typename]");
                        if ("number(p,s)".equals(souTypeName) && "NUMBER".equals(((Map)mappingInfo.get(k)).get("sourcefieldname"))) {
                           tCoreFileStructurecolumn.setColumntype((String)((Map)mappingInfo.get(k)).get("targetfieldname"));
                           break;
                        }

                        if (((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][typename]")).equalsIgnoreCase((String)((Map)mappingInfo.get(k)).get("sourcefieldname"))) {
                           tCoreFileStructurecolumn.setColumntype((String)((Map)mappingInfo.get(k)).get("targetfieldname"));
                           break;
                        }
                     }

                     if (tCoreFileStructurecolumn.getColumntype().equals(ColumnType.DATETIME.getName())) {
                        tCoreFileStructurecolumn.setColumnformat((String)map.get("createstructure[columnformat]"));
                     }

                     tCoreFileStructurecolumn.setColumnaccuracy((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]"));
                     tCoreFileStructurecolumn.setColumndecimal(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]") == "" ? "0" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]"));
                     tCoreFileStructurecolumn.setKeytype(((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][primarykey]")).equals("0") ? "NO" : "YES");
                     if (tCoreFileStructurecolumn.getKeytype().equals("YES")) {
                        tCoreFileStructurecolumn.setColumnnotnull("YES");
                     } else {
                        tCoreFileStructurecolumn.setColumnnotnull((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][isnullable]"));
                     }

                     tCoreFileStructurecolumn.setFilestructureid(tCoreFileStructure.getId());
                     this.tCoreFileStructurecolumnDao.save(tCoreFileStructurecolumn);
                     TCoreMaskingFilecolumn tCoreMaskingFilecolumn = new TCoreMaskingFilecolumn();
                     tCoreMaskingFilecolumn.setColumnindex(j);
                     tCoreMaskingFilecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingFilecolumn.setFilesystemid(tCoreMaskingFilesystem.getId());
                     tCoreMaskingFilecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingFilecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingFilecolumn.setStructurecolumnid(tCoreFileStructurecolumn.getId());
                     this.tCoreMaskingFilecolumnDao.save(tCoreMaskingFilecolumn);
                  }
               }

               if (map.get("istodatabase") != null && ((String)map.get("istodatabase")).equals("true")) {
                  String srcschema = (String)map.get("sdsdbschema");
                  String tschema = (String)map.get("todbschema");
                  String ttbaletype = (String)map.get("sdsdbtype");
                  String stbaletype = (String)map.get("sdsdbtype");
                  List<Map<String, String>> mappingInfo = this.tConsoleDatamappingInfoDao.getDatamappingInfo(EdataMappingType.getFlagByName(stbaletype), EdataMappingType.getFlagByName(ttbaletype));

                  for(int i = 0; i < masklength; ++i) {
                     Connection srcconn = this.getConnectionByDataSystemId((String)map.get("sdsdbid"));
                     Connection tconn = this.getConnectionByDataSystemId((String)map.get("todatasystemid"));
                     String stable = (String)map.get("sourceInfoAll[" + i + "][tablename]");
                     String ttable = (String)map.get("prefixname") + stable;
                     List<String> ttablenamelist = JdbcTool.getAllTableName(tconn, tschema);
                     ttablenamelist = StringTool.toUpperCaseList(ttablenamelist);
                     boolean isNamesake = ttablenamelist.contains(ttable.toUpperCase());
                     if (isNamesake) {
                        JdbcTool.dropTable(tconn, tschema, ttable);
                        isNamesake = false;
                     }

                     int rulesize = Integer.parseInt((String)map.get("sourceInfoAll[" + i + "][rulesize]"));
                     List<ColumnInfoVO> sourceList = new ArrayList();

                     for(int j = 0; j < rulesize; ++j) {
                        ColumnInfoVO cv = new ColumnInfoVO();
                        cv.setColumnname((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnname]"));
                        cv.setTypename((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][typename]"));
                        cv.setColumnsize((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]"));
                        cv.setDecimaldigits((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]"));
                        cv.setIsnullable((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][isnullable]"));
                        sourceList.add(cv);
                     }

                     if (!isNamesake) {
                        JdbcTool.copyTable(tconn, tschema, ttable, sourceList, mappingInfo);
                     }

                     JdbcTool.closeConnection(srcconn);
                     JdbcTool.closeConnection(tconn);
                  }
               }
            } else if (((String)map.get("sourcetype")).equals("1")) {
               for(int i = 0; i < masklength; ++i) {
                  String filename = (String)map.get("prefixname") + (String)map.get("sourceInfoAll[" + i + "][structurename]") + "." + (String)map.get("createstructure[extension]");
                  String targetpath = (String)map.get("targetInfoAll[0][directory]");
                  String laststr = StringUtils.substring(targetpath, StringUtils.length(targetpath) - 1);
                  boolean b = StringUtils.equalsAny(laststr, new CharSequence[]{"/", "\\"});
                  if (!b) {
                     targetpath = targetpath + "/";
                  }

                  String filepathname = targetpath + filename;
                  if (((String)map.get("tlocation")).equals("0")) {
                     if (((String)map.get("isremovetable")).equals("true")) {
                        FileTool.removeFile(filepathname);
                     }

                     boolean isFile = FileTool.isFileExit(filepathname);
                     if (!isFile) {
                        FileTool.createFolder(targetpath);
                        FileTool.createFile(filepathname);
                     }
                  } else {
                     TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(map.get("tchooseftp"));
                     if (((String)map.get("isremovetable")).equals("true")) {
                        FtpTool.removeFile(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename);
                     }

                     boolean isFile = FtpTool.isFileExist(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename);
                     if (!isFile) {
                        FtpTool.createFile(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename, "");
                     }
                  }

                  int rulesize = Integer.parseInt((String)map.get("sourceInfoAll[" + i + "][rulesize]"));
                  TCoreMaskingFilesystem tCoreMaskingFilesystem = new TCoreMaskingFilesystem();
                  tCoreMaskingFilesystem.setStructureid((String)map.get("sourceInfoAll[" + i + "][structureid]"));
                  tCoreMaskingFilesystem.setDirectory((String)map.get("targetInfoAll[0][directory]"));
                  tCoreMaskingFilesystem.setWildcard(filename);
                  tCoreMaskingFilesystem.setMappingkey(uuid + i);
                  tCoreMaskingFilesystem.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingFilesystem.setTaskid(tCoreMaskingTask.getId());
                  tCoreMaskingFilesystem.setLocation((String)map.get("tlocation"));
                  tCoreMaskingFilesystem.setFtpid((String)map.get("tchooseftp"));
                  this.tCoreMaskingFilesystemDao.save(tCoreMaskingFilesystem);

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingFilecolumn tCoreMaskingFilecolumn = new TCoreMaskingFilecolumn();
                     tCoreMaskingFilecolumn.setColumnindex(j);
                     tCoreMaskingFilecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingFilecolumn.setFilesystemid(tCoreMaskingFilesystem.getId());
                     tCoreMaskingFilecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingFilecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingFilecolumn.setStructurecolumnid((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][id]"));
                     this.tCoreMaskingFilecolumnDao.save(tCoreMaskingFilecolumn);
                  }
               }
            } else if (((String)map.get("sourcetype")).equals("2")) {
               String sourceHiveType = (String)map.get("shivetype");

               for(int i = 0; i < masklength; ++i) {
                  String filename = (String)map.get("prefixname") + (String)map.get("sourceInfoAll[" + i + "][tablename]") + "." + (String)map.get("createstructure[extension]");
                  String targetpath = (String)map.get("targetInfoAll[0][directory]");
                  String laststr = StringUtils.substring(targetpath, StringUtils.length(targetpath) - 1);
                  boolean b = StringUtils.equalsAny(laststr, new CharSequence[]{"/", "\\"});
                  if (!b) {
                     targetpath = targetpath + "/";
                  }

                  String filepathname = targetpath + filename;
                  if (((String)map.get("tlocation")).equals("0")) {
                     if (((String)map.get("isremovetable")).equals("true")) {
                        FileTool.removeFile(filepathname);
                     }

                     boolean isFile = FileTool.isFileExit(filepathname);
                     if (!isFile) {
                        FileTool.createFolder(targetpath);
                        FileTool.createFile(filepathname);
                     }
                  } else {
                     TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(map.get("tchooseftp"));
                     if (((String)map.get("isremovetable")).equals("true")) {
                        FtpTool.removeFile(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename);
                     }

                     boolean isFile = FtpTool.isFileExist(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename);
                     if (!isFile) {
                        FtpTool.createFile(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword(), targetpath, filename, "");
                     }
                  }

                  TCoreFileStructure tCoreFileStructure = new TCoreFileStructure();
                  tCoreFileStructure.setFilestructuregroup((String)map.get("taskname"));
                  tCoreFileStructure.setFilestructurename((String)map.get("taskname") + "_" + filename);
                  tCoreFileStructure.setCodepage((String)map.get("createstructure[codepage]"));
                  tCoreFileStructure.setSkiprows((String)map.get("createstructure[skiprows]"));
                  tCoreFileStructure.setSplitertype((String)map.get("createstructure[splitertype]"));
                  tCoreFileStructure.setFlag("1");
                  this.tCoreFileStructureDao.save(tCoreFileStructure);
                  if (tCoreFileStructure.getSplitertype().equals("0")) {
                     TCoreFileStructurespliter tCoreFileStructurespliter = new TCoreFileStructurespliter();
                     tCoreFileStructurespliter.setDelimiters((String)map.get("createstructure[delimiters]"));
                     tCoreFileStructurespliter.setConsecdelimitersasone("NO");
                     tCoreFileStructurespliter.setMultidelimitersasand("NO");
                     tCoreFileStructurespliter.setQuotecharacter((String)map.get("createstructure[quotecharacter]"));
                     tCoreFileStructurespliter.setRowdelimiter("10");
                     tCoreFileStructurespliter.setEscapecharacter("");
                     tCoreFileStructurespliter.setKeepescapechar("NO");
                     tCoreFileStructurespliter.setFilestructureid(tCoreFileStructure.getId());
                     this.tCoreFileStructurespliterDao.save(tCoreFileStructurespliter);
                  } else {
                     TCoreFileStructurewidth tCoreFileStructurewidth = new TCoreFileStructurewidth();
                     tCoreFileStructurewidth.setNullcharacter((String)map.get("createstructure[nullcharacter]"));
                     tCoreFileStructurewidth.setNullchartype((String)map.get("createstructure[nullchartype]"));
                     tCoreFileStructurewidth.setRepeatable("NO");
                     tCoreFileStructurewidth.setPadbytes("1");
                     tCoreFileStructurewidth.setLinesequential("NO");
                     tCoreFileStructurewidth.setShiftsensitivedata("NO");
                     tCoreFileStructurewidth.setStriptrailingblanks("NO");
                     tCoreFileStructurewidth.setFilestructureid(tCoreFileStructure.getId());
                     this.tCoreFileStructurewidthDao.save(tCoreFileStructurewidth);
                  }

                  TCoreMaskingFilesystem tCoreMaskingFilesystem = new TCoreMaskingFilesystem();
                  tCoreMaskingFilesystem.setStructureid(tCoreFileStructure.getId());
                  tCoreMaskingFilesystem.setDirectory((String)map.get("targetInfoAll[0][directory]"));
                  tCoreMaskingFilesystem.setWildcard(filename);
                  tCoreMaskingFilesystem.setMappingkey(uuid + i);
                  tCoreMaskingFilesystem.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingFilesystem.setTaskid(tCoreMaskingTask.getId());
                  tCoreMaskingFilesystem.setLocation((String)map.get("tlocation"));
                  tCoreMaskingFilesystem.setFtpid((String)map.get("tchooseftp"));
                  tCoreMaskingFilesystem.setIstodatabase((String)map.get("istodatabase"));
                  if (map.get("istodatabase") != null && ((String)map.get("istodatabase")).equals("true")) {
                     tCoreMaskingFilesystem.setDatasystemid((String)map.get("todatasystemid"));
                     tCoreMaskingFilesystem.setDbschema((String)map.get("todbschema"));
                  }

                  tCoreMaskingFilesystem.setColumnformat((String)map.get("createstructure[columnformat]"));
                  this.tCoreMaskingFilesystemDao.save(tCoreMaskingFilesystem);
                  List<Map<String, String>> mappingInfo = this.tConsoleDatamappingInfoDao.getDatamappingInfo(EdataMappingType.getFlagByName(sourceHiveType), EdataMappingType.FILESYSTEM.getFlag());
                  int rulesize = Integer.parseInt((String)map.get("sourceInfoAll[" + i + "][rulesize]"));

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreFileStructurecolumn tCoreFileStructurecolumn = new TCoreFileStructurecolumn();
                     tCoreFileStructurecolumn.setColumnindex(j + 1);
                     tCoreFileStructurecolumn.setColumnname((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnname]"));

                     for(int k = 0; k < mappingInfo.size(); ++k) {
                        if (((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][typename]")).equals(((Map)mappingInfo.get(k)).get("sourcefieldname"))) {
                           tCoreFileStructurecolumn.setColumntype((String)((Map)mappingInfo.get(k)).get("targetfieldname"));
                           break;
                        }
                     }

                     if (tCoreFileStructurecolumn.getColumntype().equals(ColumnType.DATETIME.getName())) {
                        tCoreFileStructurecolumn.setColumnformat((String)map.get("createstructure[columnformat]"));
                     }

                     tCoreFileStructurecolumn.setColumnaccuracy((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]"));
                     tCoreFileStructurecolumn.setColumndecimal(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]") == "" ? "0" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]"));
                     tCoreFileStructurecolumn.setKeytype(((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][primarykey]")).equals("0") ? "NO" : "YES");
                     if (tCoreFileStructurecolumn.getKeytype().equals("YES")) {
                        tCoreFileStructurecolumn.setColumnnotnull("YES");
                     } else {
                        tCoreFileStructurecolumn.setColumnnotnull((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][isnullable]"));
                     }

                     tCoreFileStructurecolumn.setFilestructureid(tCoreFileStructure.getId());
                     this.tCoreFileStructurecolumnDao.save(tCoreFileStructurecolumn);
                     TCoreMaskingFilecolumn tCoreMaskingFilecolumn = new TCoreMaskingFilecolumn();
                     tCoreMaskingFilecolumn.setColumnindex(j);
                     tCoreMaskingFilecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingFilecolumn.setFilesystemid(tCoreMaskingFilesystem.getId());
                     tCoreMaskingFilecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingFilecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingFilecolumn.setStructurecolumnid(tCoreFileStructurecolumn.getId());
                     this.tCoreMaskingFilecolumnDao.save(tCoreMaskingFilecolumn);
                  }
               }
            }
         } else if (((String)map.get("targettype")).equals("2")) {
            if (((String)map.get("sourcetype")).equals("0")) {
               String tschema = (String)map.get("thiveschema");
               String stabletype = (String)map.get("sdsdbtype");
               List<Map<String, String>> mappingInfo = this.tConsoleDatamappingInfoDao.getDatamappingInfo(EdataMappingType.getFlagByName(stabletype), EdataMappingType.FILESYSTEM.getFlag());

               for(int i = 0; i < masklength; ++i) {
                  Connection tconn = this.getConnectionByDataSystemId((String)map.get("thiveid"));
                  String stable = (String)map.get("sourceInfoAll[" + i + "][tablename]");
                  String ttable = (String)map.get("prefixname") + stable;
                  List<String> ttablenamelist = JdbcTool.getAllTableName(tconn, tschema);
                  ttablenamelist = StringTool.toUpperCaseList(ttablenamelist);
                  boolean isNamesake = ttablenamelist.contains(ttable.toUpperCase());
                  if (((String)map.get("isremovetable")).equals("true") && isNamesake) {
                     JdbcTool.dropTable(tconn, tschema, ttable);
                  }

                  TCoreMaskingHive tCoreMaskingHive = new TCoreMaskingHive();
                  tCoreMaskingHive.setDatasystemid((String)map.get("thiveid"));
                  tCoreMaskingHive.setDbschema(tschema);
                  tCoreMaskingHive.setTablename(ttable);
                  tCoreMaskingHive.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingHive.setMappingkey(uuid + i);
                  tCoreMaskingHive.setTaskid(tCoreMaskingTask.getId());
                  this.tCoreMaskingHiveDao.save(tCoreMaskingHive);
                  int rulesize = Integer.parseInt((String)map.get("sourceInfoAll[" + i + "][rulesize]"));

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingHivecolumn tCoreMaskingHivecolumn = new TCoreMaskingHivecolumn();
                     tCoreMaskingHivecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingHivecolumn.setPrimarykey((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][primarykey]"));
                     tCoreMaskingHivecolumn.setColumnname((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnname]"));
                     String sourceColType = (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][typename]");

                     for(int k = 0; k < mappingInfo.size(); ++k) {
                        if (sourceColType.equalsIgnoreCase((String)((Map)mappingInfo.get(k)).get("sourcefieldname"))) {
                           tCoreMaskingHivecolumn.setColumntype((String)((Map)mappingInfo.get(k)).get("targetfieldname"));
                           break;
                        }
                     }

                     tCoreMaskingHivecolumn.setColumnlength(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]"));
                     tCoreMaskingHivecolumn.setColumnscale(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]"));
                     tCoreMaskingHivecolumn.setJudgenull((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][isnullable]"));
                     tCoreMaskingHivecolumn.setTableid(tCoreMaskingHive.getId());
                     tCoreMaskingHivecolumn.setTaskid(tCoreMaskingTask.getId());
                     tCoreMaskingHivecolumn.setColumnindex(j);
                     tCoreMaskingHivecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingHivecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingHivecolumn.setRulename((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingrulename]"));
                     tCoreMaskingHivecolumn.setRegextype((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][regextype]"));
                     tCoreMaskingHivecolumn.setRemarks((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][remarks]"));
                     this.tCoreMaskingHivecolumnDao.save(tCoreMaskingHivecolumn);
                  }

                  JdbcTool.closeConnection(tconn);
               }
            } else if (((String)map.get("sourcetype")).equals("1")) {
               String tschema = (String)map.get("thiveschema");

               for(int i = 0; i < masklength; ++i) {
                  String filename = (String)map.get("prefixname") + (String)map.get("sourceInfoAll[" + i + "][totablename]");
                  Connection tconn = this.getConnectionByDataSystemId((String)map.get("thiveid"));
                  List<String> ttablenamelist = JdbcTool.getAllTableName(tconn, tschema);
                  boolean isNamesake = ttablenamelist.contains(filename);
                  if (((String)map.get("isremovetable")).equals("true") && isNamesake) {
                     JdbcTool.dropTable(tconn, tschema, filename);
                     isNamesake = false;
                  }

                  int rulesize = Integer.parseInt((String)map.get("sourceInfoAll[" + i + "][rulesize]"));
                  String sourceStructureid = (String)map.get("sourceInfoAll[" + i + "][structureid]");
                  List<TCoreFileStructurecolumn> fscList = this.tCoreFileStructurecolumnDao.queryAll(new Criterion[]{Restrictions.eq("filestructureid", sourceStructureid)});
                  TCoreMaskingHive tCoreMaskingHive = new TCoreMaskingHive();
                  tCoreMaskingHive.setDatasystemid((String)map.get("thiveid"));
                  tCoreMaskingHive.setDbschema(tschema);
                  tCoreMaskingHive.setTablename(filename);
                  tCoreMaskingHive.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingHive.setMappingkey(uuid + i);
                  tCoreMaskingHive.setTaskid(tCoreMaskingTask.getId());
                  this.tCoreMaskingHiveDao.save(tCoreMaskingHive);

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingHivecolumn tCoreMaskingHivecolumn = new TCoreMaskingHivecolumn();
                     tCoreMaskingHivecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingHivecolumn.setPrimarykey(((TCoreFileStructurecolumn)fscList.get(j)).getKeytype().equals("YES") ? "1" : "0");
                     tCoreMaskingHivecolumn.setColumnname(((TCoreFileStructurecolumn)fscList.get(j)).getColumnname());
                     tCoreMaskingHivecolumn.setColumntype(((TCoreFileStructurecolumn)fscList.get(j)).getColumntype());
                     tCoreMaskingHivecolumn.setColumnlength(((TCoreFileStructurecolumn)fscList.get(j)).getColumnaccuracy());
                     tCoreMaskingHivecolumn.setColumnscale(((TCoreFileStructurecolumn)fscList.get(j)).getColumndecimal().equals("0") ? "" : ((TCoreFileStructurecolumn)fscList.get(j)).getColumndecimal());
                     tCoreMaskingHivecolumn.setJudgenull(((TCoreFileStructurecolumn)fscList.get(j)).getColumnnotnull());
                     tCoreMaskingHivecolumn.setTableid(tCoreMaskingHive.getId());
                     tCoreMaskingHivecolumn.setTaskid(tCoreMaskingTask.getId());
                     tCoreMaskingHivecolumn.setColumnindex(j);
                     tCoreMaskingHivecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingHivecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingHivecolumn.setRulename((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingrulename]"));
                     tCoreMaskingHivecolumn.setRegextype((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][regextype]"));
                     tCoreMaskingHivecolumn.setRemarks((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][remarks]"));
                     this.tCoreMaskingHivecolumnDao.save(tCoreMaskingHivecolumn);
                  }

                  JdbcTool.closeConnection(tconn);
               }
            } else if (((String)map.get("sourcetype")).equals("2")) {
               String tschema = (String)map.get("thiveschema");
               List<Map<String, String>> mappingInfo = this.tConsoleDatamappingInfoDao.getDatamappingInfo(EdataMappingType.HIVE.getFlag(), EdataMappingType.FILESYSTEM.getFlag());

               for(int i = 0; i < masklength; ++i) {
                  Connection tconn = this.getConnectionByDataSystemId((String)map.get("thiveid"));
                  String stable = (String)map.get("sourceInfoAll[" + i + "][tablename]");
                  String ttable = (String)map.get("prefixname") + stable;
                  List<String> ttablenamelist = JdbcTool.getAllTableName(tconn, tschema);
                  ttablenamelist = StringTool.toUpperCaseList(ttablenamelist);
                  ttablenamelist.contains(ttable.toUpperCase());
                  TCoreMaskingHive tCoreMaskingHive = new TCoreMaskingHive();
                  tCoreMaskingHive.setDatasystemid((String)map.get("thiveid"));
                  tCoreMaskingHive.setDbschema(tschema);
                  tCoreMaskingHive.setTablename(ttable);
                  tCoreMaskingHive.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                  tCoreMaskingHive.setMappingkey(uuid + i);
                  tCoreMaskingHive.setTaskid(tCoreMaskingTask.getId());
                  this.tCoreMaskingHiveDao.save(tCoreMaskingHive);
                  int rulesize = Integer.parseInt((String)map.get("sourceInfoAll[" + i + "][rulesize]"));

                  for(int j = 0; j < rulesize; ++j) {
                     TCoreMaskingHivecolumn tCoreMaskingHivecolumn = new TCoreMaskingHivecolumn();
                     tCoreMaskingHivecolumn.setRuleid(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingruleid]"));
                     tCoreMaskingHivecolumn.setPrimarykey((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][primarykey]"));
                     tCoreMaskingHivecolumn.setColumnname((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnname]"));
                     String sourceColType = (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][typename]");

                     for(int k = 0; k < mappingInfo.size(); ++k) {
                        if (sourceColType.equalsIgnoreCase((String)((Map)mappingInfo.get(k)).get("sourcefieldname"))) {
                           tCoreMaskingHivecolumn.setColumntype((String)((Map)mappingInfo.get(k)).get("targetfieldname"));
                           break;
                        }
                     }

                     tCoreMaskingHivecolumn.setColumnlength(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][columnsize]"));
                     tCoreMaskingHivecolumn.setColumnscale(map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]") == null ? "" : (String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][decimaldigits]"));
                     tCoreMaskingHivecolumn.setJudgenull((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][isnullable]"));
                     tCoreMaskingHivecolumn.setTableid(tCoreMaskingHive.getId());
                     tCoreMaskingHivecolumn.setTaskid(tCoreMaskingTask.getId());
                     tCoreMaskingHivecolumn.setColumnindex(j);
                     tCoreMaskingHivecolumn.setDatadirection(EmaskingDirection.DATA_TARGET.getFlag());
                     tCoreMaskingHivecolumn.setMappingkey(uuid + i + j);
                     tCoreMaskingHivecolumn.setRulename((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][maskingrulename]"));
                     tCoreMaskingHivecolumn.setRegextype((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][regextype]"));
                     tCoreMaskingHivecolumn.setRemarks((String)map.get("sourceInfoAll[" + i + "][mtscolumnlist][" + j + "][remarks]"));
                     this.tCoreMaskingHivecolumnDao.save(tCoreMaskingHivecolumn);
                  }

                  JdbcTool.closeConnection(tconn);
               }
            }
         }

         if (((String)map.get("sourcetype")).equals("1")) {
            this.infoService.createFileTask(tCoreMaskingTask.getId(), (String)map.get("userid"));
         }

         if (EdbType.TERADATA.getDbcode().equals(map.get("sdsdbtype")) && "0".equals(map.get("targettype"))) {
            String taskid = tCoreMaskingTask.getId();
            String taskname = tCoreMaskingTask.getTaskname();
            System.out.println("Teradata task save complete！-- (taskid:" + taskid + "  | taskname:" + taskname + ")( source sysid:" + (String)map.get("sdsdbid") + ")");
         } else {
            this.infoService.createTask(tCoreMaskingTask.getId(), (String)map.get("userid"), (String)map.get("quick"), map);
         }

         TConsoleLog record = new TConsoleLog();
         String username = (String)map.get("username");
         record.setModule("数据脱敏");
         record.setOperationtime(new Date());
         record.setUser(username);
         if (!isTaskId) {
            record.setLogmessage("新增数据脱敏任务");
         } else {
            record.setLogmessage("编辑数据脱敏任务");
         }

         this.operationService.add(record);
         return new ResultVO("创建成功", true);
      } catch (Exception e) {
         e.printStackTrace();
         TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
         return new ResultVO("创建失败", false);
      }
   }

   public List<Map<String, Object>> querySingleDbMapping(String taskid, String sourceflag, String targetflag) {
      List<Map<String, Object>> list = new ArrayList();
      List<Map<String, String>> slist = null;
      List<Map<String, String>> tlist = null;
      if (EmaskingTaskType.DB.getFlag().equals(sourceflag)) {
         slist = this.tCoreMaskingTaskDao.querySingleDbMapping(taskid, EmaskingDirection.DATA_SOURCE.getFlag());
      } else if (EmaskingTaskType.FILE.getFlag().equals(sourceflag)) {
         slist = this.tCoreMaskingTaskDao.querySingleFsMapping(taskid, EmaskingDirection.DATA_SOURCE.getFlag());
      } else if (EmaskingTaskType.HIVE.getFlag().equals(sourceflag)) {
         slist = this.tCoreMaskingTaskDao.querySingleHiveMapping(taskid, EmaskingDirection.DATA_SOURCE.getFlag());
      }

      if (EmaskingTaskType.DB.getFlag().equals(targetflag)) {
         tlist = this.tCoreMaskingTaskDao.querySingleDbMapping(taskid, EmaskingDirection.DATA_TARGET.getFlag());
      } else if (EmaskingTaskType.FILE.getFlag().equals(targetflag)) {
         tlist = this.tCoreMaskingTaskDao.querySingleFsMapping(taskid, EmaskingDirection.DATA_TARGET.getFlag());
      } else if (EmaskingTaskType.HIVE.getFlag().equals(targetflag)) {
         tlist = this.tCoreMaskingTaskDao.querySingleHiveMapping(taskid, EmaskingDirection.DATA_TARGET.getFlag());
      }

      int size = 0;
      if (slist.size() < tlist.size()) {
         size = slist.size();
      } else {
         size = tlist.size();
      }

      for(int i = 0; i < size; ++i) {
         Map<String, Object> map = new HashMap();
         if (EmaskingTaskType.FILE.getFlag().equals(sourceflag)) {
            map.put("sprimarykey", ((String)((Map)slist.get(i)).get("keytype")).equals("YES") ? "1" : "0");
            map.put("scolumnname", ((Map)slist.get(i)).get("columnname"));
            map.put("sdatatype", ((Map)slist.get(i)).get("columntype"));
            map.put("scolumnsize", ((Map)slist.get(i)).get("columnaccuracy"));
            map.put("sdecimaldigits", ((Map)slist.get(i)).get("columndecimal"));
            map.put("sremarks", ((Map)slist.get(i)).get("remarks"));
            map.put("sregextype", ((Map)slist.get(i)).get("regextype"));
            map.put("sisnullable", ((Map)slist.get(i)).get("columnnotnull"));
            map.put("maskingruleid", ((Map)slist.get(i)).get("ruleid"));
            map.put("sid", ((Map)slist.get(i)).get("id"));
            map.put("scolumnindex", ((Map)slist.get(i)).get("columnindex"));
         } else {
            map.put("sprimarykey", ((Map)slist.get(i)).get("primarykey"));
            map.put("scolumnname", ((Map)slist.get(i)).get("columnname"));
            map.put("sdatatype", ((Map)slist.get(i)).get("columntype"));
            map.put("scolumnsize", ((Map)slist.get(i)).get("columnlength"));
            map.put("sdecimaldigits", ((Map)slist.get(i)).get("columnscale"));
            map.put("sremarks", ((Map)slist.get(i)).get("remarks"));
            map.put("sregextype", ((Map)slist.get(i)).get("regextype"));
            map.put("sisnullable", ((Map)slist.get(i)).get("judgenull"));
            map.put("maskingruleid", ((Map)slist.get(i)).get("ruleid"));
         }

         if (EmaskingTaskType.FILE.getFlag().equals(targetflag)) {
            map.put("tprimarykey", ((String)((Map)tlist.get(i)).get("keytype")).equals("YES") ? "1" : "0");
            map.put("tcolumnname", ((Map)tlist.get(i)).get("columnname"));
            map.put("tdatatype", ((Map)tlist.get(i)).get("columntype"));
            map.put("tcolumnsize", ((Map)tlist.get(i)).get("columnaccuracy"));
            map.put("tdecimaldigits", ((Map)tlist.get(i)).get("columndecimal"));
            map.put("tremarks", ((Map)tlist.get(i)).get("remarks"));
            map.put("tisnullable", ((Map)tlist.get(i)).get("columnnotnull"));
            map.put("id", ((Map)tlist.get(i)).get("id"));
            map.put("tcolumnindex", ((Map)tlist.get(i)).get("columnindex"));
         } else {
            map.put("tprimarykey", ((Map)tlist.get(i)).get("primarykey"));
            map.put("tcolumnname", ((Map)tlist.get(i)).get("columnname"));
            map.put("tdatatype", ((Map)tlist.get(i)).get("columntype"));
            map.put("tcolumnsize", ((Map)tlist.get(i)).get("columnlength"));
            map.put("tdecimaldigits", ((Map)tlist.get(i)).get("columnscale"));
            map.put("tremarks", ((Map)tlist.get(i)).get("remarks"));
            map.put("tisnullable", ((Map)tlist.get(i)).get("judgenull"));
         }

         list.add(map);
      }

      return list;
   }

   public void removeRecord(String taskid) {
      TCoreMaskingTaskrecord tCoreMaskingTaskrecord = (TCoreMaskingTaskrecord)this.tCoreMaskingTaskrecordDao.get(taskid);
      if (tCoreMaskingTaskrecord != null) {
         this.tCoreMaskingDetailrecordDao.remove(new Criterion[]{Restrictions.eq("taskrecordid", tCoreMaskingTaskrecord.getId())});
         this.tCoreMaskingTaskrecordDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      }

   }

   public List<TCoreDatasystem> querySFTP() {
      List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.eq("dbtype", "SFTP")});
      return list;
   }

   public List<TCoreMonitorTemporary> queryTCoreMonitorTemporaryList(String taskid) {
      List<TCoreMonitorTemporary> list = this.tCoreMonitorTemporaryDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("taskid", taskid)});
      return list;
   }

   public void update(TCoreMonitorTemporary temporary) {
      this.tCoreMonitorTemporaryDao.saveOrUpdate(temporary);
   }

   public List queryTaskVersionList(String taskId) {
      List list = this.tCoreMonitorTemporaryDao.queryGroup(Order.desc("createtime"), "groupid", new Criterion[]{Restrictions.eq("taskid", taskId)});
      return list;
   }

   public String stopWorkflow(String taskid, String name) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingTaskDao.get(taskid);
      TCoreMaskingselfTask t = null;
      TCoreEngine tengine;
      if (task == null) {
         t = (TCoreMaskingselfTask)this.tCoreMaskingselfTaskDao.get(taskid);
         tengine = (TCoreEngine)this.tCoreEngineDao.get(t.getEngineid());
      } else {
         tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      }

      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String stopWorkflow = "FAIL";

      try {
         String sessionID = LoginWebService.returnStatus(engine);
         new SessionBean();
         SessionBean se = MultiGetSessionStatisticsWebService.returnStatus(sessionID, engine, "wf_" + name, "mp_" + name, task.getFdname());
         stopWorkflow = MultiGetWorkflowLogWebService.stopWorkflow(sessionID, engine, "wf_" + name, task.getFdname(), se.getWf_run_id(), "mp_" + name);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return stopWorkflow;
   }

   public void updateTask(String taskid, String ispass) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingTaskDao.get(taskid);
      task.setIspass(ispass);
      this.tCoreMaskingTaskDao.saveOrUpdate(task);
   }
}
