package com.chenyang.nse.bussiness.service.core.impl;

import cn.hutool.core.util.PageUtil;
import com.alibaba.druid.stat.TableStat;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.DataScopeDao;
import com.chenyang.nse.bussiness.dao.core.SensitiveLevelDao;
import com.chenyang.nse.bussiness.dao.core.TCoreRowSensitiveLevelDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreFieldSensitiveDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreScopeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.scopeproject.TProEditionScopeDao;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.db.IndexInfo;
import com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataScope;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreRowSensitiveLevel;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiveLevel;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreFieldSensitive;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreScopeField;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.RowSensitivelevelVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.SensitivelevelVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ScopeInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.core.DataScopeService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.service.core.RowSensitiveLevelService;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.sql.SqlParseUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exolab.castor.types.DateTime;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class RowSensitiveLevelServiceImpl implements RowSensitiveLevelService {
   @Autowired
   private TProEditionScopeDao tProEditionScopeDao;
   @Autowired
   private DataScopeDao dataScopeDao;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private DataScopeService dataScopeService;
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private TCoreFieldSensitiveDao coreFieldSensitiveDao;
   @Autowired
   private TCoreScopeFieldDao coreScopeFieldDao;
   private static List<String> nosizeList = new ArrayList();
   private static String sensitiveId = "sensitiveId";
   @Autowired
   private TCoreRowSensitiveLevelDao tCoreRowSensitiveLevelDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private SensitiveLevelDao sensitiveLevelDao;
   private Object goods;

   public void saveRowLevelBysql(RowSensitivelevelVO rowSensitivelevelVO) throws Exception {
      List<ColumnInfo> filterColumnList = rowSensitivelevelVO.getFilterColumnList();
      String datasystem_id = rowSensitivelevelVO.getDatasystem_id();
      TCoreDatasystem datasystem = this.queryDataSystem(datasystem_id);
      String dbType = datasystem.getDbtype();
      List<String> priList = rowSensitivelevelVO.getPrimary();
      String table_name = rowSensitivelevelVO.getTable_name();
      this.parseTableName(rowSensitivelevelVO, dbType, table_name);
      List<Map<String, Object>> dataList = rowSensitivelevelVO.getData();
      if (!ObjectUtils.isEmpty(dataList)) {
         dataList.stream().forEach((data) -> {
            if (!ObjectUtils.isEmpty(data.get(sensitiveId))) {
               TCoreRowSensitiveLevel rowSensitiveLevel = new TCoreRowSensitiveLevel();
               rowSensitiveLevel.setSensitive_id((String)data.get(sensitiveId));
               rowSensitiveLevel.setDatasystem_id(rowSensitivelevelVO.getDatasystem_id());
               rowSensitiveLevel.setSchem(rowSensitivelevelVO.getSchema());
               rowSensitiveLevel.setTable_name(rowSensitivelevelVO.getTable_name());
               rowSensitiveLevel.setKey_name(StringUtils.join(rowSensitivelevelVO.getPrimary(), "#"));
               StringBuffer pValue = new StringBuffer("");

               for(int i = 0; i < priList.size(); ++i) {
                  if (i != 0) {
                     pValue.append("#");
                  }

                  for(int j = 0; j < filterColumnList.size(); ++j) {
                     ColumnInfo columnInfo = (ColumnInfo)filterColumnList.get(j);
                     if (columnInfo.getTypename().toLowerCase().contains("number")) {
                        pValue.append(data.get(priList.get(i)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("varchar")) {
                        pValue.append((String)data.get(priList.get(i)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("int")) {
                        pValue.append((Integer)data.get(priList.get(i)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("date")) {
                        pValue.append((Date)data.get(priList.get(i)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("boolean")) {
                        pValue.append((Boolean)data.get(priList.get(i)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("short")) {
                        pValue.append((Integer)data.get(priList.get(i)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("double")) {
                        pValue.append((Double)data.get(priList.get(i)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("time")) {
                        pValue.append((DateTime)data.get(priList.get(i)));
                        break;
                     }

                     if (nosizeList.contains(columnInfo.getTypename().toUpperCase())) {
                        pValue.append("");
                        break;
                     }
                  }
               }

               rowSensitiveLevel.setKey_id(pValue.toString());
               rowSensitiveLevel.setCreate_date(new Date());
               String pKey = StringUtils.join(rowSensitivelevelVO.getPrimary(), "#");
               List<Map<String, Object>> rowSensitiveLevelList = this.tCoreRowSensitiveLevelDao.queryRowSensitiveLevel(pValue.toString(), pKey, rowSensitiveLevel.getTable_name(), rowSensitiveLevel.getSchem(), rowSensitiveLevel.getDatasystem_id());
               if (rowSensitiveLevelList.size() > 0) {
                  rowSensitiveLevel.setId((String)((Map)rowSensitiveLevelList.get(0)).get("id"));
               }

               this.tCoreRowSensitiveLevelDao.saveOrUpdate(rowSensitiveLevel);
            }

         });
      }

   }

   private String parseTableName(RowSensitivelevelVO rowSensitivelevelVO, String dbType, String table_name) throws Exception {
      Collection<TableStat.Column> tablefieldList = SqlParseUtil.execute(dbType, rowSensitivelevelVO.getSql());
      if (StringUtils.isEmpty(table_name)) {
         table_name = ((TableStat.Column)tablefieldList.iterator().next()).getTable();
         rowSensitivelevelVO.setTable_name(table_name);
      }

      return table_name;
   }

   public List<SensitivelevelVO> getSensitivelist(String projectId, String edition_id) {
      List<SensitivelevelVO> getDataScopeGroup = this.sensitiveLevelDao.getDataScopeGroup(edition_id);
      return getDataScopeGroup;
   }

   public RowSensitivelevelVO queryRowLevelBysql(PageInfo pageInfo, RowSensitivelevelVO sensitivelevelVO) throws Exception {
      RowSensitivelevelVO retVO = new RowSensitivelevelVO();
      String datasystem_id = sensitivelevelVO.getDatasystem_id();
      String table_name = "";
      String schema = "";
      String levelFlag = sensitivelevelVO.getLevelFlag();
      String sql = sensitivelevelVO.getSql().toLowerCase();
      retVO.setDatasystem_id(datasystem_id);
      retVO.setSchema(schema);
      retVO.setSql(sql);
      retVO.setPageInfo(pageInfo);
      String primary = "";
      TCoreDatasystem datasystem = this.queryDataSystem(datasystem_id);
      String dbType = datasystem.getDbtype();
      Connection conn = JdbcTool.getConnection(datasystem);
      Collection<TableStat.Column> tablefieldList = SqlParseUtil.execute(dbType, sql);
      table_name = ((TableStat.Column)tablefieldList.iterator().next()).getTable();
      String schema1 = ((TableStat.Column)tablefieldList.iterator().next()).getTable();
      if (schema1.contains(".")) {
         String[] arr = schema1.split("\\.");
         schema = arr[0];
         retVO.setSchema(schema);
      } else {
         if (StringUtils.isEmpty(sensitivelevelVO.getSchema())) {
            retVO.setErrMsg("没有schema");
            retVO.setSchema("");
            return retVO;
         }

         retVO.setSchema(sensitivelevelVO.getSchema());
         schema = sensitivelevelVO.getSchema();
      }

      if (table_name.contains(".")) {
         String[] arr = table_name.split("\\.");
         table_name = arr[1];
         retVO.setTable_name(table_name);
         sensitivelevelVO.setTable_name(table_name);
      } else {
         sql = sql.replace(table_name, schema + "." + table_name);
         retVO.setTable_name(table_name);
         sensitivelevelVO.setTable_name(table_name);
      }

      Set<String> fieldList = new HashSet();
      List<IndexInfo> indexInfo = null;
      if (!dbType.equals(EdbType.HIVE.getDbname())) {
         indexInfo = IndexInfo.getIndexInfoByConnection(conn, schema, table_name);
      }

      List<String> primarykey = null;
      List<String> var46 = PrimaryKeyInfo.getPrimaryKeyList(conn, schema.toUpperCase(), table_name.toUpperCase());
      if (ObjectUtils.isEmpty(var46)) {
         if (!ObjectUtils.isEmpty(indexInfo)) {
            List<String> indexList = new ArrayList();
            indexInfo.forEach((index) -> indexList.add(index.getColumnname()));
            retVO.setPrimary(indexList);
            var46 = indexList;
            fieldList.addAll(indexList);
         } else {
            retVO.setErrMsg("表[" + table_name + "]没有主键和索引,无法行分级授权");
         }
      } else {
         retVO.setPrimary((List)var46);
         fieldList.addAll((Collection)var46);
         if (!sql.contains("*")) {
            sql = sql.replaceFirst("select", "select " + StringUtils.join((Collection)var46, ",") + ",");
         }
      }

      System.out.println("------------------------------------------------");
      System.out.println("sql解析出来的字段名：");
      tablefieldList.stream().forEach((tablefield) -> {
         System.out.printf("%s", tablefield.getName());
         System.out.println("");
         fieldList.add(tablefield.getName());
      });
      List<ColumnInfo> allColumns = JdbcTool.getAllColumnInfo(conn, schema.toUpperCase(), table_name.toUpperCase());
      if (dbType.equals("GREENPLUM")) {
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, table_name);
         allColumns = (List)list.stream().map((ex) -> new ColumnInfo(ex.getTablecat(), ex.getTableschem(), ex.getTablename(), ex.getColumnname(), ex.getDatatype(), ex.getTypename(), ex.getColumnsize(), ex.getBufferlength(), ex.getDecimaldigits(), ex.getNumprecpadix(), ex.getNullable(), ex.getRemarks(), ex.getColumndef(), ex.getSqldatatype(), ex.getSqldatetimesub(), ex.getCharoctetlength(), ex.getOrdinalposition(), ex.getIsnullable(), ex.getScopecatlog(), ex.getScopeschema(), ex.getScopetable(), ex.getSourcedatatype(), ex.getIsautoincrement())).collect(Collectors.toList());
      }

      List<ColumnInfo> filterColumnList = null;
      filterColumnList = this.getColumnInfos(fieldList, allColumns, filterColumnList);
      if (dbType.equals(EdbType.HIVE.getDbname())) {
         filterColumnList.stream().forEach((ex) -> ex.setColumnnamehive("mm." + ex.getColumnname()));
      }

      retVO.setHead(fieldList);
      String countSql = sql.substring(sql.toUpperCase().indexOf("FROM"));
      countSql = "select count(1) " + countSql;

      try {
         PreparedStatement statement = conn.prepareStatement(countSql);
         ResultSet rs = statement.executeQuery();
         rs.next();
         int rownum = rs.getInt(1);
         pageInfo.setCount(new Long((long)rownum));
      } catch (Exception e) {
         System.out.println(e.getMessage());
         e.printStackTrace();
      }

      List<Map<String, Object>> rows = new ArrayList();
      int[] startEnd = PageUtil.transToStartEnd(pageInfo.getPageno(), pageInfo.getPagesize());
      if (datasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         if (ObjectUtils.isEmpty(var46)) {
            sql = "SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (" + sql + " ) TT ) where RN> ? AND RN <= ? ";
         } else {
            sql = "SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (" + sql + " order by " + StringUtils.join((Collection)var46, ",") + " desc ) TT ) where RN> ? AND RN <= ? ";
         }
      } else if (datasystem.getDbtype().equals(EdbType.MYSQL.toString())) {
         if (ObjectUtils.isEmpty(var46)) {
            sql = sql + " limit ?,?";
         } else {
            sql = sql + " order by " + StringUtils.join((Collection)var46, ",") + " desc limit ?,?";
         }
      } else if (datasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         if (ObjectUtils.isEmpty(var46)) {
            sql = " select * FROM (  select *, ROW_NUMBER() OVER(Order by " + (String)fieldList.iterator().next() + " desc ) AS RowId FROM (" + sql + ") as a ) as b where RowId between ? and ?";
         } else {
            sql = " select * FROM (  select *, ROW_NUMBER() OVER(Order by " + StringUtils.join((Collection)var46, ",") + " desc ) AS RowId FROM (" + sql + ") as a ) as b where RowId between ? and ?";
         }
      } else if (datasystem.getDbtype().equals("GREENPLUM")) {
         if (ObjectUtils.isEmpty(var46)) {
            sql = sql + " limit ? OFFSET ?";
         } else {
            sql = sql + " order by " + StringUtils.join((Collection)var46, ",") + " desc limit ? OFFSET ?";
         }
      } else if (datasystem.getDbtype().equals("HIVE")) {
         if (ObjectUtils.isEmpty(var46)) {
            sql = " select * from (select row_number() over (order by " + (String)fieldList.iterator().next() + "  desc) as rownum, " + sql.replaceFirst("select", "") + ") mm where mm.rownum between ? and ?";
         } else {
            sql = " select * from (select row_number() over (order by " + StringUtils.join((Collection)var46, ",") + "  desc) as rownum, " + sql.replaceFirst("select", "") + ") mm where mm.rownum between ? and ?";
         }
      }

      try {
         PreparedStatement statement = conn.prepareStatement(sql);
         if (datasystem.getDbtype().equals("GREENPLUM")) {
            statement.setInt(1, pageInfo.getPageno() * pageInfo.getPagesize());
            statement.setInt(2, (pageInfo.getPageno() - 1) * pageInfo.getPagesize());
         } else {
            statement.setInt(1, (pageInfo.getPageno() - 1) * pageInfo.getPagesize());
            statement.setInt(2, pageInfo.getPageno() * pageInfo.getPagesize());
         }

         ResultSet resultSet;
         Map<String, Object> row;
         for(resultSet = statement.executeQuery(); resultSet.next(); rows.add(row)) {
            row = new HashMap();
            if (!ObjectUtils.isEmpty(var46)) {
               for(int j = 0; j < ((List)var46).size(); ++j) {
                  row.put((var46).get(j), resultSet.getString((String)((List)var46).get(j)));
               }
            }

            for(int j = 0; j < filterColumnList.size(); ++j) {
               ColumnInfo columnInfo = (ColumnInfo)filterColumnList.get(j);
               if (columnInfo.getTypename().toLowerCase().contains("number")) {
                  row.put(columnInfo.getColumnname(), String.valueOf(resultSet.getLong(columnInfo.getColumnname())));
               } else if (columnInfo.getTypename().toLowerCase().contains("varchar")) {
                  row.put(columnInfo.getColumnname(), resultSet.getString(columnInfo.getColumnname()));
               } else if (columnInfo.getTypename().toLowerCase().contains("bigint")) {
                  row.put(columnInfo.getColumnname(), resultSet.getLong(columnInfo.getColumnname()));
               } else if (columnInfo.getTypename().toLowerCase().contains("int")) {
                  row.put(columnInfo.getColumnname(), resultSet.getInt(columnInfo.getColumnname()));
               } else if (columnInfo.getTypename().toLowerCase().contains("date")) {
                  row.put(columnInfo.getColumnname(), resultSet.getDate(columnInfo.getColumnname()));
               } else if (columnInfo.getTypename().toLowerCase().contains("boolean")) {
                  row.put(columnInfo.getColumnname(), resultSet.getBoolean(columnInfo.getColumnname()));
               } else if (columnInfo.getTypename().toLowerCase().contains("short")) {
                  row.put(columnInfo.getColumnname(), resultSet.getShort(columnInfo.getColumnname()));
               } else if (columnInfo.getTypename().toLowerCase().contains("double")) {
                  row.put(columnInfo.getColumnname(), resultSet.getDouble(columnInfo.getColumnname()));
               } else if (columnInfo.getTypename().toLowerCase().contains("time")) {
                  row.put(columnInfo.getColumnname(), resultSet.getTime(columnInfo.getColumnname()));
               } else if (columnInfo.getTypename().toLowerCase().contains("text")) {
                  row.put(columnInfo.getColumnname(), resultSet.getString(columnInfo.getColumnname()));
               } else if (columnInfo.getTypename().toLowerCase().contains("string")) {
                  if (dbType.equals(EdbType.HIVE.getDbname())) {
                     row.put(columnInfo.getColumnname(), resultSet.getString(columnInfo.getColumnnamehive()));
                  } else {
                     row.put(columnInfo.getColumnname(), resultSet.getString(columnInfo.getColumnname()));
                  }
               } else if (nosizeList.contains(columnInfo.getTypename().toUpperCase())) {
                  row.put(columnInfo.getColumnname(), "");
               } else {
                  row.put(columnInfo.getColumnname(), "");
               }
            }

            StringBuffer primaryValue = new StringBuffer();
            if (!ObjectUtils.isEmpty(var46)) {
               for(int j = 0; j < ((List)var46).size(); ++j) {
                  if (j != 0) {
                     primaryValue.append("#");
                  }

                  for(int k = 0; k < filterColumnList.size(); ++k) {
                     ColumnInfo columnInfo = (ColumnInfo)filterColumnList.get(k);
                     if (columnInfo.getTypename().toLowerCase().contains("number")) {
                        primaryValue.append(resultSet.getLong((String)((List)var46).get(j)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("varchar")) {
                        primaryValue.append(resultSet.getString((String)((List)var46).get(j)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("int")) {
                        primaryValue.append(resultSet.getInt((String)((List)var46).get(j)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("date")) {
                        primaryValue.append(resultSet.getDate((String)((List)var46).get(j)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("boolean")) {
                        primaryValue.append(resultSet.getBoolean((String)((List)var46).get(j)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("short")) {
                        primaryValue.append(resultSet.getShort((String)((List)var46).get(j)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("double")) {
                        primaryValue.append(resultSet.getDouble((String)((List)var46).get(j)));
                        break;
                     }

                     if (columnInfo.getTypename().toLowerCase().contains("time")) {
                        primaryValue.append(resultSet.getTime((String)((List)var46).get(j)));
                        break;
                     }
                  }
               }
            }

            List<Map<String, Object>> sensitiveLevelList = this.tCoreRowSensitiveLevelDao.querySensitiveLevel(StringUtils.join((Collection)var46, "#"), primaryValue.toString(), table_name, schema, datasystem_id);
            if (sensitiveLevelList.size() > 0) {
               row.put(sensitiveId, ((Map)sensitiveLevelList.get(0)).get("sensitive_id"));
            } else {
               row.put(sensitiveId, "");
            }
         }

         resultSet.close();
         statement.close();
      } catch (Exception e) {
         retVO.setErrMsg(e.getMessage());
         System.out.println(e.getMessage());
         e.printStackTrace();
      } finally {
         try {
            conn.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      retVO.setData(rows);
      retVO.setFilterColumnList(filterColumnList);
      return retVO;
   }

   private List<ColumnInfo> getColumnInfos(Set<String> fieldList, List<ColumnInfo> allColumns, List<ColumnInfo> filterColumnList) {
      if (fieldList.size() > 0) {
         if (fieldList.contains("*")) {
            fieldList.clear();
            allColumns.forEach((column) -> fieldList.add(column.getColumnname()));
         }

         filterColumnList = (List)allColumns.stream().filter((s) -> fieldList.contains(s.getColumnname())).collect(Collectors.toList());
      }

      return filterColumnList;
   }

   private static boolean hasColumnSize(String columnType) {
      return !nosizeList.contains(columnType) && !columnType.startsWith("TIMESTAMP");
   }

   private TCoreDatasystem queryDataSystem(String datasystemid) {
      List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.eq("id", datasystemid)});
      return list != null && list.size() > 0 ? (TCoreDatasystem)list.get(0) : null;
   }

   private static String getColumnSize(ResultSet resultSet) {
      String result = null;

      try {
         String columnSize = resultSet.getString("COLUMN_SIZE");
         if (columnSize != null && !columnSize.equals("0")) {
            String decimalDigits = resultSet.getString("DECIMAL_DIGITS");
            if (decimalDigits != null && !decimalDigits.equals("0")) {
               decimalDigits = "," + decimalDigits;
            } else {
               decimalDigits = "";
            }

            result = columnSize + decimalDigits;
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return result;
   }

   public List<ScopeInfoVO> queryScope2Sensitive(String scopeid, String sensitiveid, String dataSystemId, String schema, String projectid) {
      System.out.println("查询分类分级");
      TCoreDatasystem datasystem = this.queryDataSystem(dataSystemId);
      String dbType = datasystem.getDbtype();
      Connection conn = JdbcTool.getConnection(datasystem);
      List<String> tables = this.getTablesOfSchema(conn, schema, datasystem.getId());
      List<ScopeInfoVO> allColumns = new ArrayList();
      Map<String, String> editionmap = this.dataScopeService.queryNewTProEditionScope(projectid);
      String scope_category = (String)editionmap.get("scope_category");
      String scope_level = (String)editionmap.get("scope_level");
      Set<String> disTables = new HashSet();
      List<Map<String, Object>> sensitiveTables = this.coreFieldSensitiveDao.queryTCoreFieldSensitive(projectid, scope_level, schema, dataSystemId);
      if (!ObjectUtils.isEmpty(tables) && tables.size() > 10) {
         tables = tables.subList(0, 10);
      }

      if (!ObjectUtils.isEmpty(sensitiveTables) && sensitiveTables.size() > 0) {
         sensitiveTables.stream().forEach((e) -> disTables.add((String)e.get("names")));
      }

      List<Map<String, Object>> scopeTables = this.coreScopeFieldDao.queryTCoreFieldScope(projectid, scope_category, schema, dataSystemId);
      if (!ObjectUtils.isEmpty(scopeTables) && scopeTables.size() > 0) {
         scopeTables.stream().forEach((e) -> disTables.add((String)e.get("names")));
      }

      if (ObjectUtils.isEmpty(disTables)) {
         for(int i = 0; i < tables.size(); ++i) {
            disTables.add(tables.get(i));
         }
      }

      if (!ObjectUtils.isEmpty(disTables) && disTables.size() < 9) {
         for(int j = disTables.size(); j < tables.size(); ++j) {
            disTables.add(tables.get(j));
         }
      }

      for(String tableN : disTables) {
         List<ScopeInfoVO> columns = this.queryColumnInfo(projectid, scope_category, scope_level, dataSystemId, schema, tableN);
         allColumns.addAll(columns);
      }

      if (!StringUtils.isEmpty(scopeid) && scopeid.equals("0")) {
         allColumns = (List)allColumns.stream().filter((e) -> ObjectUtils.isEmpty(e.gettCoreDataScopeList()) || !ObjectUtils.isEmpty(e.gettCoreDataScopeList()) && e.gettCoreDataScopeList().size() == 0).collect(Collectors.toList());
      } else if (!StringUtils.isEmpty(scopeid) && scopeid.equals("1")) {
         allColumns = (List)allColumns.stream().filter((e) -> !ObjectUtils.isEmpty(e.gettCoreDataScopeList()) && e.gettCoreDataScopeList().size() > 0).collect(Collectors.toList());
      }

      if (!StringUtils.isEmpty(sensitiveid) && sensitiveid.equals("0")) {
         allColumns = (List)allColumns.stream().filter((e) -> ObjectUtils.isEmpty(e.gettCoreSensitiveLevel()) || StringUtils.isBlank(e.gettCoreSensitiveLevel().getSensitive_id())).collect(Collectors.toList());
      } else if (!StringUtils.isEmpty(sensitiveid) && sensitiveid.equals("1")) {
         allColumns = (List)allColumns.stream().filter((e) -> !ObjectUtils.isEmpty(e.gettCoreSensitiveLevel()) && StringUtils.isNotBlank(e.gettCoreSensitiveLevel().getSensitive_id())).collect(Collectors.toList());
      }

      return allColumns;
   }

   public List<ScopeInfoVO> queryColumnInfo(String projectid, String scope_category, String scope_level, String datasystemid, String schema, String tableName) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
      if (datasystem == null) {
         return null;
      } else {
         Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tableName);
         List<TCoreScopeField> tCoreScopeFields = this.dataScopeService.queryScopeById(projectid, datasystemid, scope_category);
         List<TCoreFieldSensitive> tCoreFieldSensitives = this.dataScopeService.queryScopeLevelById(projectid, datasystemid, scope_level);
         tCoreScopeFields = (List)tCoreScopeFields.stream().filter((x) -> x.getNames().equals(tableName)).collect(Collectors.toList());
         tCoreFieldSensitives = (List)tCoreFieldSensitives.stream().filter((x) -> x.getNames().equals(tableName)).collect(Collectors.toList());
         List<ScopeInfoVO> list1 = new ArrayList();
         String scopeeditedflag = "0";
         String leveleditedflag = "0";
         if (tCoreScopeFields.size() > 0) {
            scopeeditedflag = "1";
         }

         if (tCoreFieldSensitives.size() > 0) {
            leveleditedflag = "1";
         }

         if (datasystem.getDbtype().equals("SYBASE_IQ")) {
            for(ColumnInfoVO civ : list) {
               if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                  civ.setDecimaldigits("");
               }

               ScopeInfoVO civ1 = new ScopeInfoVO();
               BeanUtils.copyProperties(civ, civ1);
               List<TCoreScopeField> tCoreScopeFieldlist = (List)tCoreScopeFields.stream().filter((x) -> x.getNames().equals(tableName) && x.getTablefield_id().equals(civ.getColumnname())).collect(Collectors.toList());
               List<TCoreDataScope> list2 = new ArrayList();
               tCoreScopeFieldlist.forEach((tCoreScopeField) -> {
                  TCoreDataScope tCoreDataScope = new TCoreDataScope();
                  String scope_id = tCoreScopeField.getScope_id();
                  Map<String, String> scopenamemap = this.dataScopeService.queryScopeById(scope_id);
                  tCoreDataScope.setScope_id(scope_id);
                  tCoreDataScope.setScope_name((String)scopenamemap.get("scope_name"));
                  list2.add(tCoreDataScope);
               });
               civ1.settCoreDataScopeList(list2);
               List<TCoreFieldSensitive> tCoreFieldSensitivelist = (List)tCoreFieldSensitives.stream().filter((x) -> x.getNames().equals(tableName) && x.getTablefield_id().equals(civ.getColumnname())).collect(Collectors.toList());
               String scope_id = "";
               if (tCoreScopeFieldlist.size() > 0) {
                  scope_id = ((TCoreFieldSensitive)tCoreFieldSensitivelist.get(0)).getScope_id();
               }

               TCoreSensitiveLevel tCoreSensitiveLevel = new TCoreSensitiveLevel();
               if (StringUtils.isNotBlank(scope_id)) {
                  tCoreSensitiveLevel.setSensitive_id(scope_id);
                  Map<String, String> scopenamemap = this.dataScopeService.queryScopelevelById(scope_id);
                  tCoreSensitiveLevel.setSensitive_name((String)scopenamemap.get("sensitive_name"));
               }

               civ1.settCoreSensitiveLevel(tCoreSensitiveLevel);
               if (!"1".equals(scopeeditedflag) && !"1".equals(leveleditedflag)) {
                  civ1.setFlag("0");
               } else {
                  civ1.setFlag("1");
               }

               list1.add(civ1);
            }
         } else {
            for(ColumnInfoVO civ : list) {
               ScopeInfoVO civ1 = new ScopeInfoVO();
               BeanUtils.copyProperties(civ, civ1);
               List<TCoreScopeField> tCoreScopeFieldlist = (List)tCoreScopeFields.stream().filter((x) -> x.getNames().equals(tableName) && x.getTablefield_id().equals(civ.getColumnname())).collect(Collectors.toList());
               List<TCoreDataScope> list2 = new ArrayList();
               if (tCoreScopeFieldlist.size() > 0) {
                  scopeeditedflag = "1";
               }

               tCoreScopeFieldlist.forEach((tCoreScopeField) -> {
                  TCoreDataScope tCoreDataScope = new TCoreDataScope();
                  String scope_id = tCoreScopeField.getScope_id();
                  Map<String, String> scopenamemap = this.dataScopeService.queryScopeById(scope_id);
                  tCoreDataScope.setScope_id(scope_id);
                  tCoreDataScope.setScope_name((String)scopenamemap.get("scope_name"));
                  list2.add(tCoreDataScope);
               });
               civ1.settCoreDataScopeList(list2);
               List<TCoreFieldSensitive> tCoreFieldSensitivelist = (List)tCoreFieldSensitives.stream().filter((x) -> x.getNames().equals(tableName) && x.getTablefield_id().equals(civ.getColumnname())).collect(Collectors.toList());
               String scope_id = "";
               if (tCoreFieldSensitivelist.size() > 0) {
                  scope_id = ((TCoreFieldSensitive)tCoreFieldSensitivelist.get(0)).getScope_id();
                  leveleditedflag = "1";
               }

               TCoreSensitiveLevel tCoreSensitiveLevel = new TCoreSensitiveLevel();
               if (StringUtils.isNotBlank(scope_id)) {
                  tCoreSensitiveLevel.setSensitive_id(scope_id);
                  Map<String, String> scopenamemap = this.dataScopeService.queryScopelevelById(scope_id);
                  tCoreSensitiveLevel.setSensitive_name((String)scopenamemap.get("sensitive_name"));
               }

               civ1.settCoreSensitiveLevel(tCoreSensitiveLevel);
               if (!"1".equals(scopeeditedflag) && !"1".equals(leveleditedflag)) {
                  civ1.setFlag("0");
               } else {
                  civ1.setFlag("1");
               }

               list1.add(civ1);
            }
         }

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return list1;
      }
   }

   private static String fetchGroupKey(TCoreScopeField tCoreScopeField) {
      return tCoreScopeField.getDatasystem_id() + "." + tCoreScopeField.getTschemas() + "." + tCoreScopeField.getNames() + "." + tCoreScopeField.getTablefield_id();
   }

   private List<String> getTablesOfSchema(Connection connection, String schema, String dataSystemId) {
      new ArrayList();
      List<DBTableVO> list = this.dataSystemService.queryTablename(dataSystemId, schema);
      List<DBTableVO> list_redis = new ArrayList();
      List<DBTableVO> tableSearchList = new ArrayList();
      HashMap<String, Integer> hash_redis_table = new HashMap();

      for(DBTableVO dbTableVO2 : list) {
         if (hash_redis_table.get(dbTableVO2.getTablename()) == null) {
            dbTableVO2.setStatus("0");
            tableSearchList.add(dbTableVO2);
         }
      }

      list_redis.addAll(tableSearchList);
      List<String> ret = (List)list_redis.stream().map((e) -> new String(e.getTablename())).collect(Collectors.toList());
      return ret;
   }

   static {
      nosizeList.add("BLOB");
      nosizeList.add("CLOB");
      nosizeList.add("LONGBLOB");
      nosizeList.add("LONGTEXT");
      nosizeList.add("IMAGE");
      nosizeList.add("TEXT");
      nosizeList.add("TIME");
   }
}
