package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.AssignmentNameDao;
import com.chenyang.nse.bussiness.dao.core.SearchFieldDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSearchregexDao;
import com.chenyang.nse.bussiness.dao.table.core.SensitiveCategoryLogDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreComplianceDirectoryDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDataScopeDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSensitiveLevelDao;
import com.chenyang.nse.bussiness.dao.table.core.TcoreDiscoverySensitivecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreAssignmentFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreAssignmentNameDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreColumnKeyDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreFieldDirectoryDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreFieldSensitiveDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreScopeDirectoryDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreScopeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreTableFieldDao;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.SensitiveCategoryLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreComplianceDirectory;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataScope;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiveLevel;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreAssignmentField;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreAssignmentName;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreColumnKey;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreFieldDirectory;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreFieldSensitive;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreScopeDirectory;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreScopeField;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreTableField;
import com.chenyang.nse.bussiness.entity.vo.ProgressInfo;
import com.chenyang.nse.bussiness.entity.vo.TreeVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.AssignmentNameVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.TreeGridFiledDataVO;
import com.chenyang.nse.bussiness.service.core.SearchFieldService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MysqlLoadTableTool;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SearchFieldServiceImpl implements SearchFieldService {
   public static final String mysql_datascop_file_path = "/data/";
   @Autowired
   private AssignmentNameDao assignmentNameDao;
   @Autowired
   private SearchFieldDao searchFieldDao;
   @Autowired
   private TCoreAssignmentFieldDao tCoreAssignmentFieldDao;
   @Autowired
   private TcoreDiscoverySensitivecolumnDao tcoreDiscoverySensitivecolumnDao;
   @Autowired
   private TCoreAssignmentNameDao tCoreAssignmentNameDao;
   @Autowired
   private TCoreComplianceDirectoryDao tCoreComplianceDirectoryDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreSensitiveLevelDao tCoreSensitiveLevelDao;
   @Autowired
   private TCoreDataScopeDao tCoreDataScopeDao;
   @Autowired
   private TCoreScopeFieldDao tCoreScopeFieldDao;
   @Autowired
   private TCoreColumnKeyDao tCoreColumnKeyDao;
   @Autowired
   private TCoreFieldDirectoryDao tCoreFieldDirectoryDao;
   @Autowired
   private TCoreTableFieldDao tCoreTableFieldDao;
   @Autowired
   private TCoreFieldSensitiveDao tCoreFieldSensitiveDao;
   @Autowired
   private TConsoleSearchregexDao tConsoleSearchregexDao;
   @Autowired
   private RedisService redisService;
   @Autowired
   private TCoreScopeDirectoryDao tCoreScopeDirectoryDao;
   @Autowired
   private SensitiveCategoryLogDao sensitiveCategoryLogDao;

   public List<TConsoleSearchregex> query(PageInfo pageInfo) {
      List<TConsoleSearchregex> list = this.tConsoleSearchregexDao.queryByPageInfo(pageInfo);
      return list;
   }

   public void getAllTableColumnsByName(Map<String, String> map, String continuestate, String taskname, TCoreDatasystem datasystem, List<String> table, String schema, ProgressInfo progressInfo, String s, String findtaskId, List<String> dataAreaList, List<String> editionScopeList, String editionsearchId, String scopestate, String versions) {
      long tC = 0L;
      String assignmentid = null;
      String assignmentname = null;
      HashMap<String, Object> mapredis = new HashMap();
      List<String> startTableShowId = new ArrayList();
      String feildparam = (String)map.get("feildparam");
      String tableparam = (String)map.get("tableparam");
      String showstate = (String)map.get("showstate");
      new ArrayList();
      List<String> scopelistpin = new ArrayList();
      List<String> versionlistpin = new ArrayList();
      boolean hasVal = false;
      boolean isDataarea = false;
      TCoreColumnKey tck = new TCoreColumnKey();
      StringBuilder sb = new StringBuilder();
      List<String> list_table = JdbcTool.sql_insert_q(new TCoreColumnKey());
      list_table.add("id");
      String sb_sql_table = JdbcTool.sql_insert_z(list_table, "T_CORE_COLUMN_KEY");
      sb.append(sb_sql_table);
      if (!dataAreaList.isEmpty()) {
         isDataarea = true;
      }

      if (!editionScopeList.isEmpty()) {
         for(TCoreScopeField td : this.tCoreScopeFieldDao.queryAll(new Criterion[]{Restrictions.eq("edition_id", editionsearchId), Restrictions.in("scope_id", editionScopeList), Restrictions.in("datasystem_id", new Object[]{datasystem.getId()}), Restrictions.in("tschemas", new Object[]{schema})})) {
            scopelistpin.add(td.getTablefield_id() + "#_#" + td.getNames() + "#_#" + td.getTschemas() + "#_#" + td.getDatasystem_id());
         }
      }

      if (versions != null && !"".equals(versions)) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String filepath = "";
         String ver = versions.split("/")[0];
         if ("AllVersion".equals(ver)) {
            File file = new File(props.getProperty("AllVersion"));
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("AllVersion") + file.listFiles()[0].getName();
            }
         } else if ("ProjectVersion".equals(ver)) {
            File file = new File(props.getProperty("ProjectVersion") + versions.split("/")[1]);
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("ProjectVersion") + versions.split("/")[1] + File.separator + file.listFiles()[0].getName();
            }
         } else if ("TaskVersion".equals(ver)) {
            filepath = props.getProperty("TaskVersion") + versions.split("/")[1] + "/" + versions.split("/")[2];
         }

         if (FileTool.isFileExit(filepath)) {
            InputStreamReader newRead = null;

            try {
               newRead = new InputStreamReader(new FileInputStream(filepath), "GBK");
            } catch (UnsupportedEncodingException e1) {
               e1.printStackTrace();
            } catch (FileNotFoundException e1) {
               e1.printStackTrace();
            }

            BufferedReader newBufferedReader = new BufferedReader(newRead);
            String newInformationLine = "";
            String[] str = null;

            try {
               while((newInformationLine = newBufferedReader.readLine()) != null) {
                  str = newInformationLine.split(",", -1);
                  if (isDataarea && dataAreaList.contains(str[4])) {
                     versionlistpin.add(str[2] + "#_#" + str[1] + "#_#" + str[0] + "#_#");
                  } else if (!isDataarea) {
                     versionlistpin.add(str[2] + "#_#" + str[1] + "#_#" + str[0] + "#_#");
                  }
               }
            } catch (IOException e) {
               e.printStackTrace();
            } finally {
               a(newBufferedReader, newRead);
            }
         }
      }

      try {
         this.iskeberos(datasystem);
         Connection connection = JdbcTool.getConnection(datasystem);
         PreparedStatement ps = null;
         ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
         int listCount = 1;
         new ArrayList();
         HashMap<String, Object> hash_table_all = new HashMap();
         new HashMap();
         HashMap<String, Object> var82 = (HashMap)this.redisService.get(datasystem.getId());
         if (var82 != null) {
            hash_table_all = (HashMap)var82.get(schema);
            if (hash_table_all == null) {
               hash_table_all = new HashMap();
            }
         } else {
            new HashMap();
         }

         List<String> istablelist = new ArrayList();

         for(String tableName : table) {
            if ("".equals(tableparam) || tableName.contains(tableparam)) {
               istablelist.add(tableName);
            }
         }

         Map<String, List<String>> colmap = new HashMap();
         StringBuilder str = new StringBuilder();
         ResultSet rs = null;
         str = this.searchColumnDiffDatasource(str, istablelist, schema, datasystem.getDbtype());
         ps = connection.prepareStatement(str.toString(), 1003, 1007);
         ps.setFetchSize(30000);
         rs = ps.executeQuery();

         while(rs.next()) {
            if (colmap.containsKey(rs.getString("table_name"))) {
               ((List)colmap.get(rs.getString("table_name"))).add(rs.getString("column_name"));
            } else {
               List<String> columnget = new ArrayList();
               columnget.add(rs.getString("column_name"));
               colmap.put(rs.getString("table_name"), columnget);
            }
         }

         connection.close();
         Set<String> tableKeyall = colmap.keySet();
         Iterator var45 = tableKeyall.iterator();

         while(true) {
            String tableKey;
            String key;
            while(true) {
               if (!var45.hasNext()) {
                  this.redisService.pipeline(mapredis, s);
                  if (hasVal) {
                     this.tCoreColumnKeyDao.saveColumnKey(sb.deleteCharAt(sb.length() - 1));
                  }

                  return;
               }

               tableKey = (String)var45.next();
               key = tableKey + "#_#" + schema + "#_#" + datasystem.getId();
               new HashMap();
               HashMap<String, HashMap<String, String>> hash_datascope_all = (HashMap)hash_table_all.get(tableKey);
               if ("2".equals(showstate)) {
                  if (this.checkstatesure(hash_datascope_all, ((List)colmap.get(tableKey)).size())) {
                     continue;
                  }
                  break;
               } else if (!"1".equals(showstate) || this.checkstatenosure(hash_datascope_all)) {
                  break;
               }
            }

            List<TreeGridFiledDataVO> vofalist = new ArrayList();
            if (((List)colmap.get(tableKey)).size() > 0) {
               for(int i = 0; i < ((List)colmap.get(tableKey)).size(); ++i) {
                  String columname = (String)((List)colmap.get(tableKey)).get(i);
                  String keyO = columname + "#_#" + tableKey + "#_#" + schema + "#_#" + datasystem.getId();
                  String keyV = columname + "#_#" + tableKey + "#_#" + schema + "#_#";
                  if (("".equals(feildparam) || columname.contains(feildparam)) && (editionScopeList.isEmpty() || !"3".equals(scopestate) || scopelistpin.contains(keyO)) && (versions == null || "".equals(versions) || versionlistpin.contains(keyV))) {
                     TreeGridFiledDataVO vo = new TreeGridFiledDataVO();
                     vo.setId(keyO);
                     vo.setTaskid(assignmentid);
                     vo.setTaskname(assignmentname);
                     vo.setDatasourceid(datasystem.getId());
                     vo.setDatasourcename(datasystem.getSysname());
                     vo.setSchema(schema);
                     vo.setTable(tableKey);
                     vo.setName(columname);
                     vo.setColumnChecked("0");
                     vo.setRowkind("0");
                     startTableShowId.add(vo.getId());
                     vofalist.add(vo);
                  }
               }
            }

            if (vofalist.size() > 0) {
               hasVal = true;
               tck.setId(UUID.randomUUID().toString());
               tck.setColumn_senssion(s);
               tck.setColumn_key(key);

               try {
                  String value = JdbcTool.sql_insert_h(tck, list_table);
                  sb.append(value);
               } catch (Exception e) {
                  e.printStackTrace();
               }

               mapredis.put(key, vofalist);
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      }
   }

   private static void a(Closeable... closeables) {
      if (closeables != null) {
         try {
            for(Closeable closeable : closeables) {
               if (closeable != null) {
                  closeable.close();
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

   }

   public List<String> getColumnsOfSchema(Connection connection, String dbType, String tableName, String schema) {
      List<String> columnNames = new ArrayList();

      try {
         ResultSet allColumnsResultSet = connection.getMetaData().getColumns((String)null, schema, tableName, "%");

         while(allColumnsResultSet.next()) {
            String columnName = allColumnsResultSet.getString("COLUMN_NAME");
            if (!columnNames.contains(columnName)) {
               columnNames.add(columnName);
            }
         }

         allColumnsResultSet.close();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return columnNames;
   }

   private List<String> getTablesOfSchema(Connection connection, String dbType, String schema) {
      List<String> allTableList = new ArrayList();

      try {
         ResultSet allTablesResultSet = connection.getMetaData().getTables((String)null, schema, "%", new String[]{"TABLE"});

         while(allTablesResultSet.next()) {
            allTableList.add(allTablesResultSet.getString("TABLE_NAME"));
         }

         allTablesResultSet.close();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return allTableList;
   }

   public List<TCoreComplianceDirectory> getComplianceDirectory() {
      List<TCoreComplianceDirectory> list = this.tCoreComplianceDirectoryDao.queryAll();
      return list;
   }

   public List<TCoreSensitiveLevel> getSensitiveLevel() {
      List<TCoreSensitiveLevel> list = this.tCoreSensitiveLevelDao.queryAll();
      return list;
   }

   public List<TCoreDataScope> getDataScope() {
      List<TCoreDataScope> list = this.tCoreDataScopeDao.queryAll();
      return list;
   }

   public List<TreeVO> queryDataScopeTree() {
      new ArrayList();
      new ArrayList();
      List<TCoreDataScope> list = null;
      list = this.tCoreDataScopeDao.queryAll();
      new HashMap();
      new HashMap();
      List<TreeVO> trees = this.buildTree(list, "0");
      return trees;
   }

   private List<TreeVO> buildTree(List<TCoreDataScope> list, String parentId) {
      List<TreeVO> trees = new ArrayList();

      for(TCoreDataScope entity : list) {
         String id = entity.getScope_id();
         String pid = entity.getFa_tid();
         if (parentId.equals(pid)) {
            TreeVO vo = new TreeVO(entity.getScope_id(), entity.getScope_name());
            List<TreeVO> tdsLists = this.buildTree(list, id);
            vo.setChildren(tdsLists);
            trees.add(vo);
         }
      }

      return trees;
   }

   public void searchTablelist(String s, String checksure, String schemaTable, String columnname, String sensitivesearch, String compliancesearch, String datascopesearch, Set<Object> zrange) {
   }

   public List<TCoreScopeDirectory> getScopeDirectory() {
      List<TCoreScopeDirectory> list = this.tCoreScopeDirectoryDao.queryAll();
      return list;
   }

   private boolean isMatch(String match, String str) {
      if (match == null) {
         match = "";
      }

      Pattern pattern = Pattern.compile(match, 2);
      Matcher matcher = pattern.matcher(str);
      return matcher.find();
   }

   public List<AssignmentNameVO> assignmentNameVO(PageInfo pageInfo, String taskname) {
      List<AssignmentNameVO> list = this.assignmentNameDao.assignmentNameVO(pageInfo, taskname);
      return list;
   }

   public void toSaveRedis(String s) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      List<Long> times = new ArrayList();
      JdbcTool.performTime(times);
      String assignmentid = "";
      int count = 0;
      int count_tCoreFieldDirectory = 0;
      int count_tCoreScopeField = 0;
      int count_tCoreFieldSensitive = 0;
      int count1 = 0;
      new ArrayList();
      new ArrayList();
      new StringBuilder();
      new StringBuilder();
      new StringBuilder();
      new StringBuilder();
      List<TCoreColumnKey> keyL = this.tCoreColumnKeyDao.queryAll(new Criterion[]{Restrictions.eq("column_senssion", s)});

      for(TCoreColumnKey kl : keyL) {
         String voKey = kl.getColumn_key();
         List<TreeGridFiledDataVO> list = (List)this.redisService.get(voKey);
         if (list != null) {
            TCoreAssignmentName ass = new TCoreAssignmentName();
            assignmentid = ((TreeGridFiledDataVO)list.get(0)).getTaskid();
            String assignmentname = ((TreeGridFiledDataVO)list.get(0)).getTaskname();
            String getdatasourceid = ((TreeGridFiledDataVO)list.get(0)).getDatasourceid();
            TCoreAssignmentName tt = (TCoreAssignmentName)this.tCoreAssignmentNameDao.queryUnique(new Criterion[]{Restrictions.eq("id", assignmentid)});
            if (tt != null) {
               this.tCoreAssignmentNameDao.remove(new Criterion[]{Restrictions.eq("id", assignmentid)});
               ass.setId(assignmentid);
            }

            ass.setAssignment_name(assignmentname);
            ass.setDatasystem_id(getdatasourceid);
            ass.setCreate_date(new Date());
            ass.setCreate_user("masking");
            this.tCoreAssignmentNameDao.save(ass);
            assignmentid = ass.getId();
            break;
         }
      }

      StringBuilder sb = new StringBuilder();
      List<String> list_table = JdbcTool.sql_insert_q(new TCoreAssignmentField());
      list_table.add("id");
      String sb_sql_table = JdbcTool.sql_insert_z(list_table, "t_core_assignment_field");
      sb.append(sb_sql_table);
      List<String> tablenamelist = new ArrayList(1000);
      List<String> keylist = new ArrayList(1000);
      TCoreAssignmentField obj = new TCoreAssignmentField();

      for(TCoreColumnKey kl : keyL) {
         String voKey = kl.getColumn_key();
         String[] str = voKey.split("#_#");
         String tablename = str[0];
         String schemas = str[1];
         String datasystem = str[2];
         obj.setId(UUID.randomUUID().toString());
         obj.setNames(str[0]);
         tablenamelist.add(tablename);
         keylist.add(voKey);
         if (tablenamelist.size() % 900 == 0) {
            this.tCoreTableFieldDao.remove(new Criterion[]{Restrictions.eq("datasystem_id", datasystem), Restrictions.eq("tschemas", schemas), Restrictions.in("names", tablenamelist)});
            this.tCoreFieldSensitiveDao.remove(new Criterion[]{Restrictions.in("tablefield_id", keylist)});
            this.tCoreScopeFieldDao.remove(new Criterion[]{Restrictions.in("tablefield_id", keylist)});
            this.tCoreFieldDirectoryDao.remove(new Criterion[]{Restrictions.in("tablefield_id", keylist)});
            tablenamelist.clear();
            keylist.clear();
         }

         obj.setTschemas(schemas);
         obj.setDatasystem_id(datasystem);
         obj.setAssignment_id(assignmentid);
         String value = JdbcTool.sql_insert_h(obj, list_table);
         sb.append(value);
      }

      this.tCoreAssignmentFieldDao.savetCoreAssignmentField(sb.deleteCharAt(sb.length() - 1));
      this.tCoreTableFieldDao.remove(new Criterion[]{Restrictions.eq("datasystem_id", obj.getDatasystem_id()), Restrictions.eq("tschemas", obj.getTschemas()), Restrictions.in("names", tablenamelist)});
      this.tCoreFieldSensitiveDao.remove(new Criterion[]{Restrictions.in("flag", keylist)});
      this.tCoreScopeFieldDao.remove(new Criterion[]{Restrictions.in("flag", keylist)});
      this.tCoreFieldDirectoryDao.remove(new Criterion[]{Restrictions.in("flag", keylist)});
      JdbcTool.performTime(times);
      List<String> list_table_TCoreTableField = JdbcTool.sql_insert_q(new TCoreTableField());
      list_table_TCoreTableField.add("id");
      String sb_sql_table_TCoreTableField = JdbcTool.sql_insert_z(list_table_TCoreTableField, "t_core_table_field");
      sb.setLength(0);
      sb.append(sb_sql_table_TCoreTableField);
      StringBuilder sb_TCoreScopeField = new StringBuilder();
      StringBuilder sb_TCoreFieldDirectory = new StringBuilder();
      StringBuilder sb_TCoreFieldSensitive = new StringBuilder();
      List<String> list_table_TCoreScopeField = JdbcTool.sql_insert_q(new TCoreScopeField());
      List<String> list_table_TCoreFieldDirectory = JdbcTool.sql_insert_q(new TCoreFieldDirectory());
      List<String> list_table_TCoreFieldSensitive = JdbcTool.sql_insert_q(new TCoreFieldSensitive());
      list_table_TCoreScopeField.add("id");
      list_table_TCoreFieldDirectory.add("id");
      list_table_TCoreFieldSensitive.add("id");
      list_table_TCoreScopeField.add("flag");
      list_table_TCoreFieldDirectory.add("flag");
      list_table_TCoreFieldSensitive.add("flag");
      String sb_sql_table_TCoreScopeField = JdbcTool.sql_insert_z(list_table_TCoreScopeField, "t_core_scope_field");
      String sb_sql_table_TCoreFieldDirectory = JdbcTool.sql_insert_z(list_table_TCoreFieldDirectory, "t_core_field_directory");
      String sb_sql_table_TCoreFieldSensitive = JdbcTool.sql_insert_z(list_table_TCoreFieldSensitive, "t_core_field_sensitive");
      sb_TCoreScopeField.append(sb_sql_table_TCoreScopeField);
      sb_TCoreFieldDirectory.append(sb_sql_table_TCoreFieldDirectory);
      sb_TCoreFieldSensitive.append(sb_sql_table_TCoreFieldSensitive);

      for(TCoreColumnKey kl : keyL) {
         String voKey = kl.getColumn_key();

         List<TreeGridFiledDataVO> listNew = (List)this.redisService.get(voKey);
         for(TreeGridFiledDataVO vo : listNew) {
            if ("1".equals(vo.getColumnChecked()) && !"1".equals(vo.getRowkind())) {
               ++count;
               TCoreTableField tctf = new TCoreTableField();
               tctf.setId(UUID.randomUUID().toString());
               tctf.setDatasystem_id(vo.getDatasourceid());
               tctf.setTschemas(vo.getSchema());
               tctf.setNames(vo.getTable());
               tctf.setFields(vo.getName());
               sb.append(JdbcTool.sql_insert_h(tctf, list_table_TCoreTableField));
               String sid = tctf.getId();
               TCoreScopeField tcsf = new TCoreScopeField();
               TCoreFieldDirectory tcfd = new TCoreFieldDirectory();
               TCoreFieldSensitive tcfs = new TCoreFieldSensitive();
               if (vo.getDatascopeid() != null) {
                  for(String t : vo.getDatascopeid()) {
                     ++count_tCoreScopeField;
                     tcsf.setId(UUID.randomUUID().toString());
                     tcsf.setScope_id(t);
                     tcsf.setTablefield_id(sid);
                     sb_TCoreScopeField.append(JdbcTool.sql_insert_h(tcsf, list_table_TCoreScopeField));
                  }
               }

               if (vo.getCompliancedirectoryid() != null) {
                  for(String t : vo.getCompliancedirectoryid()) {
                     ++count_tCoreFieldDirectory;
                     tcfd.setScope_id(t);
                     tcfd.setTablefield_id(sid);
                     tcfd.setId(UUID.randomUUID().toString());
                     sb_TCoreFieldDirectory.append(JdbcTool.sql_insert_h(tcfd, list_table_TCoreFieldDirectory));
                  }
               }

               if (vo.getSensitivelevelid() != null) {
                  for(String t : vo.getSensitivelevelid()) {
                     ++count_tCoreFieldSensitive;
                     tcfs.setScope_id(t);
                     tcfs.setTablefield_id(sid);
                     tcfs.setId(UUID.randomUUID().toString());
                     sb_TCoreFieldSensitive.append(JdbcTool.sql_insert_h(tcfs, list_table_TCoreFieldSensitive));
                  }
               }
            } else if (!"1".equals(vo.getColumnChecked()) && !"1".equals(vo.getRowkind())) {
            }
         }
      }

      if (count != 0) {
         this.tCoreTableFieldDao.saveTCoreTableField(sb.deleteCharAt(sb.length() - 1));
      }

      if (count_tCoreFieldSensitive != 0) {
         this.tCoreFieldSensitiveDao.saveTCoreFieldSensitive(sb_TCoreFieldSensitive.deleteCharAt(sb_TCoreFieldSensitive.length() - 1));
      }

      if (count_tCoreScopeField != 0) {
         this.tCoreScopeFieldDao.saveTCoreScopeField(sb_TCoreScopeField.deleteCharAt(sb_TCoreScopeField.length() - 1));
      }

      if (count_tCoreFieldDirectory != 0) {
         this.tCoreFieldDirectoryDao.saveTCoreFieldDirectory(sb_TCoreFieldDirectory.deleteCharAt(sb_TCoreFieldDirectory.length() - 1));
      }

      System.out.println("最后");
      JdbcTool.performTime(times);
   }

   public String getdatasystemid(String taskname) {
      List<TCoreAssignmentField> objList = this.tCoreAssignmentFieldDao.queryAll(new Criterion[]{Restrictions.eq("assignment_id", taskname)});
      if (!objList.isEmpty()) {
         String dasyid = ((TCoreAssignmentField)objList.get(0)).getDatasystem_id();
         return dasyid;
      } else {
         return null;
      }
   }

   public void deleteDiscoverytask(String id) {
      this.tCoreAssignmentNameDao.remove(new Criterion[]{Restrictions.eq("id", id)});
      this.tCoreAssignmentFieldDao.remove(new Criterion[]{Restrictions.eq("assignment_id", id)});
   }

   public List<TCoreTableField> query(List<String> tablename, String schema) {
      return this.tCoreTableFieldDao.queryAll(new Criterion[]{Restrictions.in("names", tablename), Restrictions.eq("tschemas", schema)});
   }

   public List<HashMap<String, String>> getScopeField(Map<String, Object> parameter) {
      List<HashMap<String, String>> list = this.searchFieldDao.getScopeField(parameter);
      return list;
   }

   public void saveColumnType(List<String> parameter, List<String> datascoTidList, boolean isCustomVersion) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      int count_tCoreFieldDirectory = 0;
      int count_tCoreScopeField = 0;
      int count_tCoreFieldSensitive = 0;
      String typename = null;
      String columnsize = null;
      String remarks = null;
      String datasystemid = (String)parameter.get(0);
      String field = (String)parameter.get(1);
      String table = (String)parameter.get(2);
      String schema = (String)parameter.get(3);
      String setuptype = (String)parameter.get(4);
      String version = (String)parameter.get(5);
      String projectId = (String)parameter.get(6);
      String username = (String)parameter.get(7);
      String dataareaid = (String)parameter.get(8);
      if ("1".equals(setuptype)) {
         this.tCoreScopeFieldDao.remove(new Criterion[]{Restrictions.eq("datasystem_id", datasystemid), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table), Restrictions.eq("tablefield_id", field), Restrictions.eq("edition_id", version)});
         StringBuilder sb_TCoreScopeField = new StringBuilder();
         List<String> list_table_TCoreScopeField = JdbcTool.sql_insert_q(new TCoreScopeField());
         list_table_TCoreScopeField.add("id");
         String sb_sql_table_TCoreScopeField = JdbcTool.sql_insert_z(list_table_TCoreScopeField, "t_core_scope_field");
         sb_TCoreScopeField.append(sb_sql_table_TCoreScopeField);
         TCoreScopeField tcsf = new TCoreScopeField();
         if (datascoTidList != null) {
            for(String t : datascoTidList) {
               ++count_tCoreScopeField;
               tcsf.setId(UUID.randomUUID().toString());
               tcsf.setDatasystem_id(datasystemid);
               tcsf.setTschemas(schema);
               tcsf.setTablefield_id(field);
               tcsf.setNames(table);
               tcsf.setScope_id(t);
               tcsf.setEdition_id(version);
               tcsf.setCombination_id(table + "_" + field);
               tcsf.setProjectid(projectId);
               tcsf.setUpdatetime(new Date());
               tcsf.setUpdateuser(username);
               if (isCustomVersion) {
                  tcsf.setFlag("1");
               }

               tcsf.setDataareaid(dataareaid);
               sb_TCoreScopeField.append(JdbcTool.sql_insert_h(tcsf, list_table_TCoreScopeField));
            }
         }

         if (count_tCoreScopeField != 0) {
            this.tCoreScopeFieldDao.saveTCoreScopeField(sb_TCoreScopeField.deleteCharAt(sb_TCoreScopeField.length() - 1));
         }
      } else if ("2".equals(setuptype)) {
         this.tCoreFieldDirectoryDao.remove(new Criterion[]{Restrictions.eq("datasystem_id", datasystemid), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table), Restrictions.eq("tablefield_id", field)});
         StringBuilder sb_TCoreFieldDirectory = new StringBuilder();
         List<String> list_table_TCoreFieldDirectory = JdbcTool.sql_insert_q(new TCoreFieldDirectory());
         list_table_TCoreFieldDirectory.add("id");
         String sb_sql_table_TCoreFieldDirectory = JdbcTool.sql_insert_z(list_table_TCoreFieldDirectory, "t_core_field_directory");
         sb_TCoreFieldDirectory.append(sb_sql_table_TCoreFieldDirectory);
         TCoreFieldDirectory tcfd = new TCoreFieldDirectory();
         if (datascoTidList != null) {
            for(String t : datascoTidList) {
               ++count_tCoreFieldDirectory;
               tcfd.setId(UUID.randomUUID().toString());
               tcfd.setDatasystem_id(datasystemid);
               tcfd.setTschemas(schema);
               tcfd.setTablefield_id(field);
               tcfd.setNames(table);
               tcfd.setScope_id(t);
               tcfd.setCombination_id(table + "_" + field);
               tcfd.setProjectid(projectId);
               tcfd.setUpdatetime(new Date());
               tcfd.setUpdateuser(username);
               if (isCustomVersion) {
                  tcfd.setFlag("1");
               }

               tcfd.setDataareaid(dataareaid);
               sb_TCoreFieldDirectory.append(JdbcTool.sql_insert_h(tcfd, list_table_TCoreFieldDirectory));
            }
         }

         if (count_tCoreFieldDirectory != 0) {
            this.tCoreFieldDirectoryDao.saveTCoreFieldDirectory(sb_TCoreFieldDirectory.deleteCharAt(sb_TCoreFieldDirectory.length() - 1));
         }
      } else if ("3".equals(setuptype)) {
         StringBuilder sb_TCoreFieldSensitive = new StringBuilder();
         List<String> list_table_TCoreFieldSensitive = JdbcTool.sql_insert_q(new TCoreFieldSensitive());
         list_table_TCoreFieldSensitive.add("id");
         String sb_sql_table_TCoreFieldSensitive = JdbcTool.sql_insert_z(list_table_TCoreFieldSensitive, "t_core_field_sensitive");
         sb_TCoreFieldSensitive.append(sb_sql_table_TCoreFieldSensitive);
         this.tCoreFieldSensitiveDao.remove(new Criterion[]{Restrictions.eq("datasystem_id", datasystemid), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table), Restrictions.eq("tablefield_id", field), Restrictions.eq("edition_id", version)});
         TCoreFieldSensitive tcfs = new TCoreFieldSensitive();
         if (datascoTidList != null) {
            for(String t : datascoTidList) {
               ++count_tCoreFieldSensitive;
               tcfs.setId(UUID.randomUUID().toString());
               tcfs.setDatasystem_id(datasystemid);
               tcfs.setTschemas(schema);
               tcfs.setTablefield_id(field);
               tcfs.setNames(table);
               tcfs.setScope_id(t);
               tcfs.setEdition_id(version);
               tcfs.setCombination_id(table + "_" + field);
               tcfs.setProjectid(projectId);
               tcfs.setUpdatetime(new Date());
               tcfs.setUpdateuser(username);
               if (isCustomVersion) {
                  tcfs.setFlag("1");
               }

               tcfs.setDataareaid(dataareaid);
               sb_TCoreFieldSensitive.append(JdbcTool.sql_insert_h(tcfs, list_table_TCoreFieldSensitive));
            }
         }

         if (count_tCoreFieldSensitive != 0) {
            this.tCoreFieldSensitiveDao.saveTCoreFieldSensitive(sb_TCoreFieldSensitive.deleteCharAt(sb_TCoreFieldSensitive.length() - 1));
         }
      }

   }

   public void removeColumnType(String contid, String setuptype) {
      if ("1".equals(setuptype)) {
         this.tCoreScopeFieldDao.remove(new Criterion[]{Restrictions.eq("id", contid)});
      } else if ("2".equals(setuptype)) {
         this.tCoreFieldDirectoryDao.remove(new Criterion[]{Restrictions.eq("id", contid)});
      } else if ("3".equals(setuptype)) {
         this.tCoreFieldSensitiveDao.remove(new Criterion[]{Restrictions.eq("id", contid)});
      }

   }

   public void saveData(List<String> datascope, Map<String, String> map, TCoreDatasystem datasystem, List<String> table, String schema, String edition_id, String findtaskId, List<String> dataAreaList, List<String> editionScopeList, String editionsearchId, String scopestate, String projectId, String version, String datasourceid) {
      try {
         List<String> findlistpin = new ArrayList<>();
         List<String> scopelistpin = new ArrayList<>();
         String mysql_file_path = "/data/fielddata.txt";
         System.out.println(mysql_file_path);
         File fielddatafile = new File(mysql_file_path);
         fielddatafile.createNewFile();
         BufferedWriter out = new BufferedWriter(new FileWriter(fielddatafile));
         String fielddatastr = "";
         String feildparam = map.get("feildparam");
         String tableparam = map.get("tableparam");
         String isDatascope = map.get("isDatascope");
         String tableClassName = isDatascope(isDatascope);
         StringBuilder sb_insert = new StringBuilder();
         StringBuilder sb_delete = new StringBuilder("");
         delesqlInit(sb_delete, tableClassName, datasystem.getId(), schema);
         List<String> list_table = new ArrayList<>();
         if (!"2".equals(isDatascope)) {
            list_table = JdbcTool.sql_insert_q(new TCoreScopeField());
         } else {
            list_table = JdbcTool.sql_insert_q(new TCoreFieldDirectory());
         }
         list_table.add("id");
         String sb_sql_table = JdbcTool.sql_insert_z(list_table, tableClassName);
         sb_insert.append(sb_sql_table);
         if (datascope == null) {
            datascope = new ArrayList<>();
         } else if (datascope.size() == 1 && "null".equals(datascope.get(0))) {
            datascope = new ArrayList<>();
         }
         if (!dataAreaList.isEmpty()) {
            String filepath = "/data/infa_project/";
            File file = null;
            if (version.contains("AllVersion")) {
               file = new File(filepath + "AllVersion");
               if (file.listFiles() != null && (file.listFiles()).length > 0)
                  filepath = filepath + "AllVersion" + File.separator + file.listFiles()[0].getName();
            } else if (version.contains("ProjectVersion")) {
               file = new File(filepath + version);
               if (file.listFiles() != null && (file.listFiles()).length > 0)
                  filepath = filepath + version + File.separator + file.listFiles()[0].getName();
            } else {
               filepath = filepath + version;
            }
            InputStreamReader newRead = null;
            try {
               newRead = new InputStreamReader(new FileInputStream(filepath), "GBK");
            } catch (UnsupportedEncodingException e) {
               e.printStackTrace();
            } catch (FileNotFoundException e) {
               e.printStackTrace();
            }
            BufferedReader newBufferedReader = new BufferedReader(newRead);
            String newInformationLine = "";
            String[] arrayOfString = null;
            try {
               while ((newInformationLine = newBufferedReader.readLine()) != null) {
                  arrayOfString = newInformationLine.split(",", -1);
                  if (dataAreaList.contains(arrayOfString[4]))
                     findlistpin.add(arrayOfString[2] + "#_#" + arrayOfString[1] + "#_#" + arrayOfString[0] + "#_#" + datasourceid);
                  arrayOfString = null;
               }
            } catch (IOException e) {
               e.printStackTrace();
            } finally {
               try {
                  newRead.close();
               } catch (IOException e) {
                  e.printStackTrace();
               }
            }
         }
         if (!editionScopeList.isEmpty()) {
            List<TCoreScopeField> scopelist = this.tCoreScopeFieldDao.queryAll(new Criterion[] { (Criterion)Restrictions.eq("edition_id", editionsearchId), Restrictions.in("scope_id", editionScopeList), Restrictions.in("datasystem_id", new Object[] { datasystem.getId() }), Restrictions.in("tschemas", new Object[] { schema }) });
            for (TCoreScopeField td : scopelist)
               scopelistpin.add(td.getTablefield_id() + "#_#" + td.getNames() + "#_#" + td.getTschemas() + "#_#" + td.getDatasystem_id());
         }
         iskeberos(datasystem);
         Connection connection = JdbcTool.getConnection(datasystem);
         PreparedStatement ps = null;
         int listCount = 1;
         HashMap<String, Object> hash_table_all = new HashMap<>();
         HashMap<String, Object> hash_schema_all = new HashMap<>();
         hash_schema_all = (HashMap<String, Object>)this.redisService.get(datasystem.getId());
         if (hash_schema_all != null) {
            hash_table_all = (HashMap<String, Object>)hash_schema_all.get(schema);
            if (hash_table_all == null)
               hash_table_all = new HashMap<>();
         } else {
            hash_schema_all = new HashMap<>();
         }
         int count = 0;
         List<String> istablelist = new ArrayList<>();
         for (String tableName : table) {
            if (!"".equals(tableparam) && !StringTool.columnnameLikeMethod(tableName, tableparam).booleanValue())
               continue;
            istablelist.add(tableName);
         }
         Map<String, List<String>> colmap = new HashMap<>();
         StringBuilder str = new StringBuilder();
         ResultSet rs = null;
         str = searchColumnDiffDatasource(str, istablelist, schema, datasystem.getDbtype());
         ps = connection.prepareStatement(str.toString(), 1003, 1007);
         ps.setFetchSize(30000);
         rs = ps.executeQuery();
         while (rs.next()) {
            if (colmap.containsKey(rs.getString("table_name"))) {
               ((List<String>)colmap.get(rs.getString("table_name"))).add(rs.getString("column_name"));
               continue;
            }
            List<String> columnget = new ArrayList<>();
            columnget.add(rs.getString("column_name"));
            colmap.put(rs.getString("table_name"), columnget);
         }
         connection.close();
         Set<String> tableKeyall = colmap.keySet();
         long aa = System.currentTimeMillis();
         for (String tableKey : tableKeyall) {
            String key = tableKey + "#_#" + schema + "#_#" + datasystem.getId();
            List<TreeGridFiledDataVO> vofalist = new ArrayList<>();
            HashMap<String, String> hash_column_all = new HashMap<>();
            HashMap<String, HashMap<String, String>> hash_datascope_all = new HashMap<>();
            hash_datascope_all = (HashMap<String, HashMap<String, String>>)hash_table_all.get(tableKey);
            if (hash_datascope_all == null)
               hash_datascope_all = new HashMap<>();
            hash_column_all = hash_datascope_all.get(tableClassName);
            if (hash_column_all == null)
               hash_column_all = new HashMap<>();
            if (((List)colmap.get(tableKey)).size() > 0)
               for (int i = 0; i < ((List)colmap.get(tableKey)).size(); i++) {
                  String columname = ((List<String>)colmap.get(tableKey)).get(i);
                  String keyO = columname + "#_#" + tableKey + "#_#" + schema + "#_#" + datasystem.getId();
                  if (!"".equals(feildparam) && !StringTool.columnnameLikeMethod(columname, feildparam).booleanValue())
                     continue;
                  if (!dataAreaList.isEmpty())
                     if ("1".equals(scopestate) || "3".equals(scopestate))
                        if (!findlistpin.contains(keyO))
                           continue;
                  if (!editionScopeList.isEmpty())
                     if ("3".equals(scopestate))
                        if (!scopelistpin.contains(keyO))
                           continue;
                  count++;
                  if (datascope.size() == 0) {
                     hash_column_all.remove(columname);
                  } else {
                     hash_column_all.put(columname, "1");
                  }
                  for (int j = 0; j < datascope.size(); j++) {
                     count++;
                     fielddatastr = UUID.randomUUID().toString() + "\t\t\t\t" + tableKey + "_" + columname + "\t" + datasystem.getId();
                     if (!"2".equals(isDatascope))
                        fielddatastr = fielddatastr + "\t" + edition_id;
                     fielddatastr = fielddatastr + "\t" + tableKey + "\t\t" + (String)datascope.get(j) + "\t" + columname + "\t" + schema + "\t\t" + projectId + "\t\n";
                     out.write(fielddatastr);
                     fielddatastr = "";
                  }
                  sb_delete.append("'" + tableKey + "_" + columname + "',");
                  if (count % 4000 == 0) {
                     sb_delete.deleteCharAt(sb_delete.length() - 1);
                     if (!"2".equals(isDatascope)) {
                        sb_delete.append(") and edition_id = '");
                        sb_delete.append(edition_id);
                        sb_delete.append("' ");
                     } else {
                        sb_delete.append(")");
                     }
                     this.tCoreDataScopeDao.deleteDataScope(sb_delete);
                     sb_delete.setLength(0);
                     delesqlInit(sb_delete, tableClassName, datasystem.getId(), schema);
                  }
                  continue;
               }
            hash_datascope_all.put(tableClassName, hash_column_all);
            hash_table_all.put(tableKey, hash_datascope_all);
         }
         hash_schema_all.put(schema, hash_table_all);
         this.redisService.set(datasystem.getId(), hash_schema_all);
         if (sb_delete.length() != 0) {
            sb_delete.deleteCharAt(sb_delete.length() - 1);
            if (!"2".equals(isDatascope)) {
               sb_delete.append(") and edition_id = '");
               sb_delete.append(edition_id);
               sb_delete.append("' ");
            } else {
               sb_delete.append(")");
            }
            this.tCoreDataScopeDao.deleteDataScope(sb_delete);
         }
         if (sb_insert.length() != 0 && datascope.size() != 0) {
            out.flush();
            out.close();
            if (!FileTool.isFileExit(mysql_file_path))
               FileTool.createFolder(mysql_file_path);
            Map<String, String> mysqlloadparam = new HashMap<>();
            Properties props = new Properties();
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
            String lsdriver = props.getProperty("jdbc.driver");
            String lsqlurl = props.getProperty("jdbc.url");
            String luser = props.getProperty("jdbc.user");
            String lpassword = props.getProperty("jdbc.password");
            String database = lsqlurl.substring(lsqlurl.lastIndexOf('/') + 1, lsqlurl.indexOf('?'));
            String hostname = lsqlurl.substring(lsqlurl.indexOf('/') + 2, lsqlurl.lastIndexOf(':'));
            mysqlloadparam.put("username", luser);
            mysqlloadparam.put("password", lpassword);
            mysqlloadparam.put("hostname", hostname);
            mysqlloadparam.put("filepath", mysql_file_path);
            mysqlloadparam.put("path", "/data/");
            mysqlloadparam.put("database", database);
            mysqlloadparam.put("tablename", tableClassName);
            mysqlloadparam.put("delimiter", "\\t");
            String formatSet = "";
            if (!"2".equals(isDatascope)) {
               formatSet = "(id,flag,note,columnsize,combination_id,datasystem_id,edition_id,names,remarks,scope_id,tablefield_id,tschemas,typename,projectid)";
            } else {
               formatSet = "(id,flag,note,columnsize,combination_id,datasystem_id,names,remarks,scope_id,tablefield_id,tschemas,typename,projectid)";
            }
            mysqlloadparam.put("formatSet", formatSet);
            MysqlLoadTableTool.executeLoadTable_new(mysqlloadparam);
         }
      } catch (Exception e1) {
         e1.printStackTrace();
      }
   }

   public String isDatascope(String isDatascope) {
      String tableClass = "";
      switch (isDatascope) {
         case "1":
            tableClass = "t_core_scope_field";
            break;
         case "2":
            tableClass = "t_core_field_directory";
            break;
         case "3":
            tableClass = "t_core_field_sensitive";
      }

      return tableClass;
   }

   public void addScopeLog(List<String> parameter, List<String> datascoTidList, String scope_category, List<String> datascoLevelTidList, List<String> dataLevelColumList) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      int count_tCoreScopeField = 0;
      String typename = null;
      String columnsize = null;
      String remarks = null;
      String datasystemid = (String)parameter.get(0);
      String field = (String)parameter.get(1);
      String table = (String)parameter.get(2);
      String schema = (String)parameter.get(3);
      String setuptype = (String)parameter.get(4);
      String version = (String)parameter.get(5);
      String projectId = (String)parameter.get(6);
      if ("1".equals(setuptype)) {
         SensitiveCategoryLog tcsf = new SensitiveCategoryLog();
         if (datascoTidList.size() > 0 || datascoLevelTidList.size() > 0) {
            ++count_tCoreScopeField;
            tcsf.setId(UUID.randomUUID().toString());
            tcsf.setModule("分类分级管理");
            tcsf.setOperationtime(new Date());
            tcsf.setScope_category(datascoTidList.size() > 0 ? (String)datascoTidList.get(0) : null);
            tcsf.setScope_level(datascoLevelTidList.size() > 0 ? (String)datascoLevelTidList.get(0) : null);
            tcsf.setTablename(table);
            tcsf.setColumnname(field);
            tcsf.setSchemaname(schema);
            tcsf.setDatasystemid(datasystemid);
            tcsf.setOperationUser(CommonUtils.loginUsername());
            tcsf.setProjectid(projectId);
         }

         if (count_tCoreScopeField != 0) {
            this.sensitiveCategoryLogDao.save(tcsf);
         }
      }

   }

   public List<HashMap<String, String>> isSureColumn(String datasystem_id, String schema, String table, String name, String projectId) {
      return this.searchFieldDao.isSureColumnUnion(datasystem_id, schema, table, projectId);
   }

   public void toSureRedisColumn(List<String> parameter, List<String> datascoTidList) {
      String datasystemid = (String)parameter.get(0);
      String field = (String)parameter.get(1);
      String table = (String)parameter.get(2);
      String schema = (String)parameter.get(3);
      String setuptype = (String)parameter.get(4);
      String version = (String)parameter.get(5);
      TCoreDatasystem sys = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", datasystemid)});
      boolean hasdatascope = this.isSureColumnp(datasystemid, schema, table, field, version);
      this.redisSysToColOption(hasdatascope, field, table, schema, sys, setuptype);
   }

   private boolean isSureColumnp(String datasystem_id, String schema, String table, String name, String version) {
      List<TCoreScopeField> s1 = this.tCoreScopeFieldDao.queryAll(new Criterion[]{Restrictions.eq("edition_id", version), Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table)});
      List<TCoreFieldDirectory> s2 = this.tCoreFieldDirectoryDao.queryAll(new Criterion[]{Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table)});
      List<TCoreFieldSensitive> s3 = this.tCoreFieldSensitiveDao.queryAll(new Criterion[]{Restrictions.eq("edition_id", version), Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschemas", schema), Restrictions.eq("names", table)});
      return !s1.isEmpty() || !s2.isEmpty() || !s3.isEmpty();
   }

   private void redisSysToColOption(boolean hasdatascope, String columnNames, String tableName, String schema, TCoreDatasystem datasystem, String setuptype) {
      String tableClass = "";
      switch (setuptype) {
         case "1":
            tableClass = "t_core_scope_field";
            break;
         case "2":
            tableClass = "t_core_field_directory";
            break;
         case "3":
            tableClass = "t_core_field_sensitive";
      }

      HashMap<String, Object> hash_table_all = new HashMap();
      new HashMap();
      this.iskeberos(datasystem);
      Connection connection = JdbcTool.getConnection(datasystem);
      HashMap<String, Object> var18 = (HashMap)this.redisService.get(datasystem.getId());
      if (var18 != null) {
         hash_table_all = (HashMap)var18.get(schema);
         if (hash_table_all == null) {
            hash_table_all = new HashMap();
         }
      } else {
         var18 = new HashMap();
      }

      (new StringBuilder()).append(tableName).append("#_#").append(schema).append("#_#").append(datasystem.getId()).toString();
      List<ColumnInfo> columnamelist = JdbcTool.getAllColumnInfo(connection, schema, tableName);
      new ArrayList();
      new HashMap();
      new HashMap();
      HashMap<String, HashMap<String, String>> hash_datascope_all = (HashMap)hash_table_all.get(tableName);
      if (hash_datascope_all == null) {
         hash_datascope_all = new HashMap();
      }

      HashMap<String, String> hash_column_all = (HashMap)hash_datascope_all.get(tableClass);
      if (hash_column_all == null) {
         hash_column_all = new HashMap();
      }

      if (columnamelist.size() > 0) {
         for(int i = 0; i < columnamelist.size(); ++i) {
            String columname = ((ColumnInfo)columnamelist.get(i)).getColumnname();
            if (!hasdatascope) {
               hash_column_all.remove(columname);
            } else {
               hash_column_all.put(columname, "1");
            }
         }
      }

      hash_datascope_all.put(tableClass, hash_column_all);
      hash_table_all.put(tableName, hash_datascope_all);
      var18.put(schema, hash_table_all);
      this.redisService.set(datasystem.getId(), var18);
   }

   public void delesqlInit(StringBuilder sb_delete, String tableClassName, String datasystemid, String schema) {
      sb_delete.append("delete from " + tableClassName + "  where  datasystem_id = ");
      sb_delete.append(" '");
      sb_delete.append(datasystemid);
      sb_delete.append("' and tschemas=");
      sb_delete.append(" '");
      sb_delete.append(schema);
      sb_delete.append("' ");
      sb_delete.append("and combination_id in(");
   }

   public boolean checkstatenosure(HashMap<String, HashMap<String, String>> hash) {
      boolean flag = false;
      if (hash == null) {
         flag = false;
      } else {
         for(int i = 1; i < 4; ++i) {
            String key = this.isDatascope(i + "");
            if (hash.get(key) != null && ((HashMap)hash.get(key)).size() > 0) {
               flag = true;
               break;
            }
         }
      }

      return flag;
   }

   public boolean checkstatesure(HashMap<String, HashMap<String, String>> hash, int coulmncount) {
      boolean flag = true;
      if (hash == null) {
         flag = false;
      } else {
         for(int i = 1; i < 4; ++i) {
            String key = this.isDatascope(i + "");
            if (hash.get(key) != null) {
               if (((HashMap)hash.get(key)).size() == coulmncount) {
                  flag = true;
                  break;
               }

               flag = false;
            } else {
               flag = false;
            }
         }
      }

      return flag;
   }

   public String getScopecount(String dataSystemId, String tableName, String schemaName, String filedName) {
      StringBuilder sql = new StringBuilder();
      String count = "0";
      if (null != filedName && !"".equals(filedName)) {
         sql.append("select count(0) as count from (select datasystem_id,tschemas,names,tablefield_id,scope_id,count(*) from t_core_scope_field group by datasystem_id,tschemas,names,tablefield_id,scope_id having ");
         sql.append("datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "' and tablefield_id='" + filedName + "'");
         sql.append(" ) a group by a.datasystem_id,a.tschemas,a.names,a.tablefield_id");
      } else {
         sql.append("select count(0) as count from (select datasystem_id,tschemas,names,scope_id,count(*) from t_core_scope_field group by datasystem_id,tschemas,names,scope_id having ");
         sql.append("datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "'");
         sql.append(" ) a group by a.datasystem_id,a.tschemas,a.names");
      }

      List list = this.tCoreScopeFieldDao.getTCoreScopeCount(sql);
      if (list.size() > 0) {
         count = list.get(0).toString();
      }

      return count;
   }

   public List<String> getScopeInfo(String dataSystemId, String tableName, String schemaName, String filedName) {
      StringBuilder sql = new StringBuilder();
      if (null != filedName && !"".equals(filedName)) {
         sql.append("select distinct b.scope_name from t_core_scope_field a left join t_core_data_scope b  on a.scope_id= b.id ");
         sql.append("where datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "' and tablefield_id='" + filedName + "'");
      } else {
         sql.append("select distinct b.scope_name from t_core_scope_field a left join t_core_data_scope b  on a.scope_id= b.id ");
         sql.append("where datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "'");
      }

      List list = this.tCoreScopeFieldDao.getTCoreScopeInfo(sql);
      return list;
   }

   public String getSensitivecount(String dataSystemId, String tableName, String schemaName, String filedName) {
      StringBuilder sql = new StringBuilder();
      String count = "0";
      if (null != filedName && !"".equals(filedName)) {
         sql.append("select count(0) as count from (select datasystem_id,tschemas,names,tablefield_id,scope_id,count(*) from t_core_field_sensitive group by datasystem_id,tschemas,names,tablefield_id,scope_id having ");
         sql.append("datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "' and tablefield_id='" + filedName + "'");
         sql.append(" ) a group by a.datasystem_id,a.tschemas,a.names,a.tablefield_id");
      } else {
         sql.append("select count(0) as count from (select datasystem_id,tschemas,names,scope_id,count(*) from t_core_field_sensitive group by datasystem_id,tschemas,names,scope_id having ");
         sql.append("datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "'");
         sql.append(" ) a group by a.datasystem_id,a.tschemas,a.names");
      }

      List list = this.tCoreFieldSensitiveDao.getTCoreFieldSensitiveCount(sql);
      if (list.size() > 0) {
         count = list.get(0).toString();
      }

      return count;
   }

   public List<String> getSensitiveInfo(String dataSystemId, String tableName, String schemaName, String filedName) {
      StringBuilder sql = new StringBuilder();
      if (null != filedName && !"".equals(filedName)) {
         sql.append("select distinct b.sensitive_name from t_core_field_sensitive a left join t_core_sensitive_level b  on a.scope_id= b.id ");
         sql.append("where datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "' and tablefield_id='" + filedName + "'");
      } else {
         sql.append("select distinct b.sensitive_name from t_core_field_sensitive a left join t_core_sensitive_level b  on a.scope_id= b.id ");
         sql.append("where datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "'");
      }

      List list = this.tCoreFieldSensitiveDao.getTCoreFieldSensitiveInfo(sql);
      return list;
   }

   public String getCompliancecount(String dataSystemId, String tableName, String schemaName, String filedName) {
      StringBuilder sql = new StringBuilder();
      String count = "0";
      if (null != filedName && !"".equals(filedName)) {
         sql.append("select count(0) as count from (select datasystem_id,tschemas,names,tablefield_id,scope_id,count(*) from t_core_field_directory group by datasystem_id,tschemas,names,tablefield_id,scope_id having ");
         sql.append("datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "' and tablefield_id='" + filedName + "'");
         sql.append(" ) a group by a.datasystem_id,a.tschemas,a.names,a.tablefield_id");
      } else {
         sql.append("select count(0) as count from (select datasystem_id,tschemas,names,scope_id,count(*) from t_core_field_directory group by datasystem_id,tschemas,names,scope_id having ");
         sql.append("datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "'");
         sql.append(" ) a group by a.datasystem_id,a.tschemas,a.names");
      }

      List list = this.tCoreFieldDirectoryDao.getTCoreFieldDirectoryCount(sql);
      if (list.size() > 0) {
         count = list.get(0).toString();
      }

      return count;
   }

   public List<String> getComplianceInfo(String dataSystemId, String tableName, String schemaName, String filedName) {
      StringBuilder sql = new StringBuilder();
      if (null != filedName && !"".equals(filedName)) {
         sql.append("select distinct b.directory_name from t_core_field_directory a left join t_core_compliance_directory b  on a.scope_id= b.id ");
         sql.append("where datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "' and tablefield_id='" + filedName + "'");
      } else {
         sql.append("select distinct b.directory_name from t_core_field_directory a left join t_core_compliance_directory b  on a.scope_id= b.id ");
         sql.append("where datasystem_id='" + dataSystemId + "' and tschemas='" + schemaName + "' and names='" + tableName + "'");
      }

      List list = this.tCoreScopeFieldDao.getTCoreScopeInfo(sql);
      return list;
   }

   public List<TCoreColumnKey> getColumnKey(String s) {
      List<TCoreColumnKey> list = this.tCoreColumnKeyDao.queryAll(new Criterion[]{Restrictions.eq("column_senssion", s)});
      return list;
   }

   public void clearColumnKey(String s) {
      this.tCoreColumnKeyDao.remove(new Criterion[]{Restrictions.eq("column_senssion", s)});
   }

   public List<TCoreColumnKey> getColumnKeyByPage(String s, int rows, int page) {
      PageInfo pageInfo = new PageInfo();
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TCoreColumnKey> list = this.tCoreColumnKeyDao.queryByPageInfo(pageInfo, Order.desc("column_key"), new Criterion[]{Restrictions.eq("column_senssion", s)});
      return list;
   }

   private StringBuilder searchColumnDiffDatasource(StringBuilder str, List<String> istablelist, String schema, String dbtype) {
      if ("MYSQL".equals(dbtype)) {
         str.append("select table_name,column_name from information_schema.columns where (1=2");

         for(String s1 : istablelist) {
            str.append(" or table_name ='" + s1 + "'");
         }

         str.append(")  and table_schema=");
         str.append("'" + schema + "'");
      } else if ("MSSQLSERVER".equals(dbtype)) {
         str.append("SELECT d.name table_name, a.name column_name FROM syscolumns a LEFT JOIN systypes b ON a.usertype = b.usertype INNER JOIN sysobjects d ON a.id = d.id AND d.name <> 'dtproperties' LEFT JOIN syscomments e ON a.cdefault = e.id WHERE  (1=2");

         for(String s1 : istablelist) {
            str.append(" or d.name ='" + s1 + "'");
         }

         str.append(")");
      } else if ("INFORMIX".equals(dbtype)) {
         str.append("select a.tabname table_name,b.colname column_name from systables a left join syscolumns b on a.tabid=b.tabid where  (1=2");

         for(String s1 : istablelist) {
            str.append(" or a.tabname ='" + s1 + "'");
         }

         str.append(")");
      } else if (!"SYBASE_IQ".equals(dbtype)) {
         if ("SYBASE".equals(dbtype)) {
            str.append("SELECT d.name table_name, a.name column_name FROM syscolumns a LEFT JOIN systypes b ON a.usertype = b.usertype INNER JOIN sysobjects d ON a.id = d.id AND d.name <> 'dtproperties' LEFT JOIN syscomments e ON a.cdefault = e.id WHERE  (1=2");

            for(String s1 : istablelist) {
               str.append(" or d.name ='" + s1 + "'");
            }

            str.append(")");
         } else if ("ORACLE".equals(dbtype)) {
            str.append("select table_name,column_name from all_tab_columns where (1=2");

            for(String s1 : istablelist) {
               str.append(" or table_name ='" + s1 + "'");
            }

            str.append(")  and OWNER=");
            str.append("Upper('" + schema + "')");
         } else if ("DB2".equals(dbtype)) {
            str.append("select table_name,column_name from sysibm.columns where (1=2");

            for(String s1 : istablelist) {
               str.append(" or table_name ='" + s1 + "'");
            }

            str.append(")  and table_schema =");
            str.append("'" + schema + "'");
         } else if ("TERADATA".equals(dbtype)) {
            str.append("select TableName table_name,ColumnName column_name from dbc.columns where (1=2");

            for(String s1 : istablelist) {
               str.append(" or TableName ='" + s1 + "'");
            }

            str.append(")  and DatabaseName =");
            str.append("'" + schema + "'");
         } else if ("OCEANBASE".equals(dbtype)) {
            str.append("select * from user_tab_columns WHERE TABLE_NAME IN ('");

            for(String s1 : istablelist) {
               str.append(s1 + "','");
            }

            str = str.delete(str.length() - 2, str.length());
            str.append(")");
         }
      }

      return str;
   }

   public void removeSingle(String setuptype, String ttid) {
      if ("1".equals(setuptype)) {
         this.tCoreScopeFieldDao.remove(new Criterion[]{Restrictions.eq("id", ttid)});
      } else if ("2".equals(setuptype)) {
         this.tCoreFieldDirectoryDao.remove(new Criterion[]{Restrictions.eq("id", ttid)});
      } else if ("3".equals(setuptype)) {
         this.tCoreFieldSensitiveDao.remove(new Criterion[]{Restrictions.eq("id", ttid)});
      }

   }

   public void iskeberos(TCoreDatasystem datasystem) {
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
      }

   }
}
